/*
 * Decompiled with CFR 0.152.
 */
package com.mr208.wired.Handler;

import java.io.File;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigHandler {
    public static Configuration config;
    static final String Aug = "Augment";

    public static void preInit(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            ConfigHandler.loadConfig();
        }
        MinecraftForge.EVENT_BUS.register((Object)new ConfigHandler());
    }

    public static void loadConfig() {
        Compat.TheOneProbe.hudjackProbe = config.getBoolean("hudjackProbe", "Compatability.The One Probe", false, "Enable the Hudjack and Hudlens augments to act as a Probe if the mod is present");
        Compat.IC2.EU_PER_ENERGY = config.getInt("EUPerEnergy", "Compatability.IC2", 1, 0, Integer.MAX_VALUE, "EU per 80 Energy");
        AlloyedFist.ENABLED = config.getBoolean("enabled", "Augment.Alloyed Fist", true, "Enables the Alloyed Fist");
        AlloyedFist.TOLERANCE = config.getInt("tolerance", "Augment.Alloyed Fist", 1, 0, 50, "Tolerance cost of the Augment");
        AlloyedFist.RARITY = config.getInt("rarity", "Augment.Alloyed Fist", 5, 0, 100, "Rarity. 0 never spawns. 100 always spawns");
        ECD.ENABLED = config.getBoolean("enabled", "Augment.Ender Convergence Device", true, "Enables the Ender Convergence Device");
        ECD.TOLERANCE = config.getInt("tolerance", "Augment.Ender Convergence Device", 2, 0, 50, "Tolerance cost of the Augment");
        ECD.ENERGY = config.getInt("energyPerEffect", "Augment.Ender Convergence Device", 20, 0, 1000, "Energy Cost of the Augment per ItemStack Teleported");
        ECD.RANGE = config.getInt("RANGE", "Augment.Ender Convergence Device", 16, 0, 32, "Radius in which the ECD will look for items.");
        ECD.MAX = config.getInt("MAXIMUM", "Augment.Ender Convergence Device", 50, 1, 200, "Maxmimum number of items to attempt to teleport at once");
        ECD.BLACKLIST = config.getStringList("blacklist", "Augment.Ender Convergence Device", new String[]{"appliedenergistics2:item.ItemCrystalSeed", "Botania:livingrock", "Botania:manaTablet"}, "These items will never be picked up by the ECD.");
        ECD.RARITY = config.getInt("rarity", "Augment.Ender Convergence Device", 10, 0, 100, "Rarity. 0 never spawns. 100 always spawns");
        Cyberbrain.ENABLED = config.getBoolean("enabled", "Augment.Cyberbrain", true, "Enables the Cyberbrain Augment");
        Cyberbrain.TOLERANCE = config.getInt("tolerance", "Augment.Cyberbrain", 5, 0, 50, "Tolerance Cost of the Augment");
        Cyberbrain.ENERGY = config.getInt("energyDrain", "Augment.Cyberbrain", 10, 0, 50, "Energy Cost of the Augment per Second");
        Cyberbrain.RARITY = config.getInt("rarity", "Augment.Cyberbrain", 10, 0, 100, "Rarity. 0 never spawns. 100 always spawns");
        Cyberstomach.ENABLED = config.getBoolean("enabled", "Augment.Cyberstomach", true, "Enables the Cyberstomach Augment");
        Cyberstomach.TOLERANCE = config.getInt("tolerance", "Augment.Cyberstomach", 10, 0, 50, "Tolerance Cost of the Augment");
        Cyberstomach.ENERGY = config.getInt("energyDrain", "Augment.Cyberstomach", 5, 0, 50, "Energy Cost of the Augment per Second");
        Cyberstomach.RARITY = config.getInt("rarity", "Augment.Cyberstomach", 10, 0, 100, "Rarity. 0 never spawns. 100 always spawns");
        Cyberstomach.CyborgFood.PowerBar.ENABLED = config.getBoolean("enabledBar", "Augment.Cyberstomach.Cyborg Food.Power Bar", true, "Enables the Power Bar");
        Cyberstomach.CyborgFood.PowerBar.ENERGY = config.getInt("energyBar", "Augment.Cyberstomach.Cyborg Food.Power Bar", 300, 0, 1000, "Energy Regained when Consumed");
        Cyberstomach.CyborgFood.PowerBar.HUNGER = config.getInt("hunger", "Augment.Cyberstomach.Cyborg Food.Power Bar", 8, 0, 20, "");
        Cyberstomach.CyborgFood.PowerBar.SATURATION = config.getFloat("saturation", "Augment.Cyberstomach.Cyborg Food.Power Bar", 0.4f, 0.0f, 1.0f, "");
        Cyberstomach.CyborgFood.SilverGorgon.ENABLED = config.getBoolean("enabledDrink", "Augment.Cyberstomach.Cyborg Food.Silver Gorgon", true, "Enables the Energy Drink");
        Cyberstomach.CyborgFood.SilverGorgon.ENERGY = config.getInt("energyDrink", "Augment.Cyberstomach.Cyborg Food.Silver Gorgon", 500, 0, 1000, "Energy Regained when Consumed");
        Cyberstomach.CyborgFood.SilverGorgon.HUNGER = config.getInt("hunger", "Augment.Cyberstomach.Cyborg Food.Silver Gorgon", 3, 0, 20, "");
        Cyberstomach.CyborgFood.SilverGorgon.SATURATION = config.getFloat("saturation", "Augment.Cyberstomach.Cyborg Food.Silver Gorgon", 0.6f, 0.0f, 1.0f, "");
        Cyberstomach.CyborgFood.LOOT = config.getBoolean("chestLoot", "Augment.Cyberstomach.Cyborg Food", true, "Spawn CyborgFood as loot");
        TOC.ENABLED = config.getBoolean("enabled", "Augment.Thermo-Optical Camouflage", true, "Enables the Thermo-Optical Camouflage Augment");
        TOC.TOLERANCE = config.getInt("tolerance", "Augment.Thermo-Optical Camouflage", 15, 0, 50, "Tolerance Cost of the Augment");
        TOC.ENERGY = config.getInt("energyDrain", "Augment.Thermo-Optical Camouflage", 150, 0, 1000, "Energy Cost of the Augment every 4 Seconds");
        TOC.RARITY = config.getInt("rarity", "Augment.Thermo-Optical Camouflage", 1, 0, 100, "Rarity. 0 never spawns. 100 always spawns");
        KinteticDampener.ENABLED = config.getBoolean("enabled", "Augment.Kinetic Dampener", true, "Enables the Kinetic Dampener");
        KinteticDampener.TOLERANCE = config.getInt("tolerance", "Augment.Kinetic Dampener", 10, 0, 50, "Tolerance Cost of the Augment");
        KinteticDampener.ENERGY = config.getInt("energyDrain", "Augment.Kinetic Dampener", 75, 0, 1000, "Energy Cost of the augment per Projectile Deflected");
        KinteticDampener.RARITY = config.getInt("rarity", "Augment.Kinetic Dampener", 1, 0, 100, "Rarity. 0 never spawns. 100 always spawns");
        DERPS.ENABLED = config.getBoolean("enabled", "Augment.DERPS", true, "Enable the Delayed Ender Repositioning System");
        DERPS.TOLERANCE = config.getInt("tolerance", "Augment.DERPS", 10, 0, 50, "Tolerance Cost of the Augment");
        DERPS.ENERGY = config.getInt("energyDrain", "Augment.DERPS", 40, 0, 1000, "Energy Cost of the Augment per Block of the fall negated");
        DERPS.RARITY = config.getInt("rarity", "Augment.DERPS", 15, 0, 100, "Rarity. 0 never spawns. 100 always spawns");
        Lancets.ENABLED = config.getBoolean("enabled", "Augment.Nanofilament Lancets", true, "Enables the Sap Tap when IC2 is Loaded");
        Lancets.TOLERANCE = config.getInt("tolerance", "Augment.Nanofilament Lancets", 3, 0, 50, "Tolerance Cost of the Augment");
        Lancets.ENERGY = config.getInt("energyDrain", "Augment.Nanofilament Lancets", 40, 0, 1000, "Energy Cost per Tap-Action");
        Lancets.RARITY = config.getInt("rarity", "Augment.Nanofilament Lancets", 15, 0, 100, "Rarity. 0 never spawns. 100 always spawns");
        OreScanner.ENABLED = config.getBoolean("enabled", "Augment.Ore Scanner", true, "Enables the Ore Scanner when Scannable is Loaded");
        OreScanner.TOLERANCE = config.getInt("tolerance", "Augment.Ore Scanner", 2, 0, 50, "Tolerance Cost of the Augment");
        OreScanner.ENERGY = config.getInt("energyDrain", "Augment.Ore Scanner", 200, 0, 10000, "Energy Cost per Pulse");
        OreScanner.CHARGETIME = config.getInt("chargeTime", "Augment.Ore Scanner", 90, 0, 600, "Cooldown in Seconds");
        OreScanner.RARITY = config.getInt("rarity", "Augment.Ore Scanner", 5, 0, 100, "Rarity. 0 never spawns. 100 always spawns");
        Equipment.Clothing.ENABLED = config.getBoolean("enabled", "Equipment.Clothing", true, "Enables Genera Clothing Items");
        Equipment.Clothing.DROP_CHANCE = config.getFloat("dropChance", "Equipment.Clothing", 10.0f, 0.0f, 100.0f, "Chance for this Item to drop from a Cybermob");
        Equipment.Clothing.SPAWN_CHANCE = config.getFloat("spawnChance", "Equipment.Clothing", 5.0f, 0.0f, 100.0f, "Chance for Cybermobs to spawn with this Item");
        Equipment.TechVisor.ENABLED = config.getBoolean("enabled", "Equipment.Tech-Visor", true, "Enables the Tech-Visor");
        Equipment.TechVisor.DROP_CHANCE = config.getFloat("dropChance", "Equipment.Tech-Visor", 10.0f, 0.0f, 100.0f, "Chance for this item to drop from a Cybermob");
        Equipment.TechVisor.SPAWN_CHANCE = config.getFloat("spawnChance", "Equipment.Tech-Visor", 5.0f, 0.0f, 100.0f, "chance for Cybermobs to spawn with this item");
        Equipment.Shields.ENABLED = config.getBoolean("enabled", "Equipment.Riot Shields", true, "Enable the Ballistic Shields");
        Equipment.Shields.LOOT = config.getBoolean("chestLoot", "Equipment.Riot Shields", true, "Allow this item to spawn as chest loot");
        Equipment.Shields.DROP_CHANCE = config.getFloat("dropChance", "Equipment.Riot Shields", 15.0f, 0.0f, 100.0f, "Chance for this Item to drop from a Cybermob");
        Equipment.Shields.SPAWN_CHANCE = config.getFloat("spawnChance", "Equipment.Riot Shields", 20.0f, 0.0f, 100.0f, "Chance for Cybermobs to spawn with this item");
        Equipment.Batons.ENABLED = config.getBoolean("enabled", "Equipment.Batons", true, "Enable Baton weapons");
        Equipment.Batons.LOOT = config.getBoolean("chestLoot", "Equipment.Batons", true, "Allow this item to spawn as chest loot");
        Equipment.Batons.DROP_CHANCE = config.getFloat("dropChance", "Equipment.Batons", 15.0f, 0.0f, 100.0f, "Chance for Item to Drop from Mobs");
        Equipment.Batons.SPAWN_CHANCE = config.getFloat("spawnChance", "Equipment.Batons", 20.0f, 0.0f, 100.0f, "Chance for Mob to Spawn with the Item");
        CyberMobs.CyberSkeleton.ENABLED = config.getBoolean("enabled", "Cyber Mobs.Cyberskeleton", true, "Enables Cyberskeletons Spawning");
        CyberMobs.CyberSkeleton.SPAWN_CHANCE = config.getFloat("spawnChance", "Cyber Mobs.Cyberskeleton", 10.0f, 0.0f, 100.0f, "Chance for a skeleton to be a Cyberskeleton");
        CyberMobs.GreyGoo.ENABLED = config.getBoolean("enable", "Cyber Mobs.Grey Goo", true, "Enables Grey Goo Spawning");
        CyberMobs.GreyGoo.SPAWN_CHANCE = config.getFloat("spawnChance", "Cyber Mobs.Grey Goo", 2.0f, 0.0f, 100.0f, "Chance out of 100 for a Grey Goo to Spawn on the death of a Cybermob");
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("wired")) {
            ConfigHandler.loadConfig();
        }
    }

    public static class Compat {
        static final String CATEGORY = "Compatability";

        public static class TheOneProbe {
            static final String CATEGORY = "Compatability.The One Probe";
            public static boolean hudjackProbe = true;
        }

        public static class IC2 {
            static final String CATEGORY = "Compatability.IC2";
            public static int EU_PER_ENERGY = 0;
        }
    }

    public static class CyberMobs {
        static final String CATEGORY = "Cyber Mobs";

        public static class CyberSkeleton {
            static final String CATEGORY = "Cyber Mobs.Cyberskeleton";
            public static boolean ENABLED = false;
            public static float SPAWN_CHANCE = 0.0f;
        }

        public static class GreyGoo {
            static final String CATEGORY = "Cyber Mobs.Grey Goo";
            public static boolean ENABLED = false;
            public static float SPAWN_CHANCE = 0.0f;
        }
    }

    public static class OreScanner {
        static final String CATEGORY = "Augment.Ore Scanner";
        public static boolean ENABLED = false;
        public static int TOLERANCE;
        public static int ENERGY;
        public static int RARITY;
        public static int CHARGETIME;
    }

    public static class DERPS {
        static final String CATEGORY = "Augment.DERPS";
        public static boolean ENABLED = false;
        public static int TOLERANCE = 0;
        public static int ENERGY = 0;
        public static int RARITY = 0;
    }

    public static class AlloyedFist {
        static final String CATEGORY = "Augment.Alloyed Fist";
        public static boolean ENABLED = false;
        public static int TOLERANCE = 0;
        public static int ENERGY = 0;
        public static int RARITY = 0;
    }

    public static class TOC {
        static final String CATEGORY = "Augment.Thermo-Optical Camouflage";
        public static boolean ENABLED = false;
        public static int TOLERANCE = 0;
        public static int ENERGY = 0;
        public static int RARITY = 0;
    }

    public static class Lancets {
        static final String CATEGORY = "Augment.Nanofilament Lancets";
        public static boolean ENABLED = false;
        public static int TOLERANCE = 0;
        public static int ENERGY = 0;
        public static int RARITY = 0;
    }

    public static class KinteticDampener {
        static final String CATEGORY = "Augment.Kinetic Dampener";
        public static boolean ENABLED = false;
        public static int TOLERANCE = 0;
        public static int ENERGY = 0;
        public static int RARITY = 0;
    }

    public static class ECD {
        static final String CATEGORY = "Augment.Ender Convergence Device";
        public static boolean ENABLED = false;
        public static int TOLERANCE = 0;
        public static int ENERGY = 0;
        public static int RARITY = 0;
        public static int RANGE = 0;
        public static int MAX = 0;
        public static String[] BLACKLIST;
    }

    public static class Cyberbrain {
        static final String CATEGORY = "Augment.Cyberbrain";
        public static boolean ENABLED = false;
        public static int TOLERANCE = 0;
        public static int ENERGY = 0;
        public static int RARITY = 0;
    }

    public static class Cyberstomach {
        static final String CATEGORY = "Augment.Cyberstomach";
        public static boolean ENABLED = false;
        public static int TOLERANCE = 0;
        public static int ENERGY = 0;
        public static int RARITY = 0;

        public static class CyborgFood {
            static final String CATEGORY = "Augment.Cyberstomach.Cyborg Food";
            public static boolean LOOT = true;

            public static class SilverGorgon {
                static final String CATEGORY = "Augment.Cyberstomach.Cyborg Food.Silver Gorgon";
                public static boolean ENABLED = false;
                public static int ENERGY = 0;
                public static float SATURATION = 0.0f;
                public static int HUNGER = 0;

                public static boolean canBeLoot() {
                    return ENABLED && LOOT;
                }
            }

            public static class PowerBar {
                static final String CATEGORY = "Augment.Cyberstomach.Cyborg Food.Power Bar";
                public static boolean ENABLED = false;
                public static int ENERGY = 0;
                public static float SATURATION = 0.0f;
                public static int HUNGER = 0;

                public static boolean canBeLoot() {
                    return ENABLED && LOOT;
                }
            }
        }
    }

    public static class Equipment {
        static final String CATEGORY = "Equipment";

        public static class Batons {
            static final String CATEGORY = "Equipment.Batons";
            public static boolean ENABLED = false;
            public static boolean LOOT = true;
            public static float SPAWN_CHANCE = 0.0f;
            public static float DROP_CHANCE = 0.0f;

            public static boolean canBeLoot() {
                return ENABLED && LOOT;
            }
        }

        public static class Shields {
            static final String CATEGORY = "Equipment.Riot Shields";
            public static boolean ENABLED = false;
            public static boolean LOOT = true;
            public static float SPAWN_CHANCE = 0.0f;
            public static float DROP_CHANCE = 0.0f;

            public static boolean canBeLoot() {
                return ENABLED && LOOT;
            }
        }

        public static class TechVisor {
            static final String CATEGORY = "Equipment.Tech-Visor";
            public static boolean ENABLED = false;
            public static float SPAWN_CHANCE = 0.0f;
            public static float DROP_CHANCE = 0.0f;
        }

        public static class Clothing {
            static final String CATEGORY = "Equipment.Clothing";
            public static boolean ENABLED = false;
            public static float SPAWN_CHANCE = 0.0f;
            public static float DROP_CHANCE = 0.0f;
        }
    }
}

