/*
 * Decompiled with CFR 0.152.
 */
package com.mr208.wired.Common.Item.Equipment;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mr208.wired.Client.IWiredToolTipItem;
import com.mr208.wired.Common.Effect.WiredEffects;
import com.mr208.wired.Common.Effect.WiredEntityDamageSource;
import com.mr208.wired.Common.Effect.WiredSources;
import com.mr208.wired.Common.Item.Equipment.WiredToolMaterial;
import com.mr208.wired.Common.Item.WiredItems;
import com.mr208.wired.Wired;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBaton
extends ItemSword
implements IWiredToolTipItem {
    private final Item.ToolMaterial material;
    private final float attackDamage;
    private final boolean isStunBaton;

    public ItemBaton(WiredToolMaterial wiredToolMaterial) {
        super(wiredToolMaterial.getToolMaterial());
        this.material = wiredToolMaterial.getToolMaterial();
        this.isStunBaton = wiredToolMaterial == WiredItems.shockMaterial;
        this.attackDamage = 2.0f + this.material.func_78000_c();
        this.setRegistryName("baton." + wiredToolMaterial.getMaterialName());
        this.func_77655_b("wired.baton." + wiredToolMaterial.getMaterialName());
        GameRegistry.register((IForgeRegistryEntry)this);
        this.func_77637_a(Wired.creativeTab);
        WiredItems.wiredItems.add((Item)this);
    }

    public float func_150893_a(ItemStack weapon, IBlockState blockState) {
        Material material = blockState.func_185904_a();
        return material != Material.field_151588_w && material != Material.field_151592_s ? 1.0f : 15.0f;
    }

    public boolean func_77644_a(ItemStack weapon, EntityLivingBase target, EntityLivingBase attacker) {
        if (this.isStunBaton) {
            target.field_70172_ad = 0;
            target.func_70097_a((DamageSource)new WiredEntityDamageSource(WiredSources.NEURAL_SHOCK, (Entity)attacker), this.attackDamage);
            PotionEffect activeShockEffect = target.func_70660_b(WiredEffects.shockEffect);
            int amp = 1;
            if (activeShockEffect != null) {
                amp += activeShockEffect.func_76458_c();
            }
            target.func_70690_d(new PotionEffect(WiredEffects.shockEffect, 81, amp));
            weapon.func_77972_a(1, attacker);
            return false;
        }
        return super.func_77644_a(weapon, target, attacker);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot entityEquipmentSlot, ItemStack itemStack) {
        HashMultimap multimap = HashMultimap.create();
        if (entityEquipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.100000095367432, 0));
        }
        return multimap;
    }

    @Override
    public List<String> getInfo(ItemStack stack) {
        String[] toReturnArray = I18n.func_135052_a((String)(this.func_77658_a() + ".tooltip"), (Object[])new Object[0]).split("\\\\n");
        ArrayList<String> toReturn = new ArrayList<String>(Arrays.asList(toReturnArray));
        return toReturn;
    }
}

