/*
 * Decompiled with CFR 0.152.
 */
package com.mr208.wired.Common.Item.Augs;

import com.mr208.wired.Common.Item.Augs.ItemWiredAugs;
import com.mr208.wired.Handler.ConfigHandler;
import com.mr208.wired.Handler.NetworkHandler;
import com.mr208.wired.Handler.Packets.PacketEntityMovement;
import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.common.CyberwareContent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class AugKineticDampener
extends ItemWiredAugs {
    protected static int ESSENCE_COST;
    protected static int ENERGY_PER_EFFECT;
    protected static int RARITY;

    public AugKineticDampener(String name, ICyberware.EnumSlot slot) {
        super(name, slot);
        RARITY = ConfigHandler.KinteticDampener.RARITY;
        ENERGY_PER_EFFECT = ConfigHandler.KinteticDampener.ENERGY;
        ESSENCE_COST = ConfigHandler.KinteticDampener.TOLERANCE;
        this.setEssenceCost(new int[]{ESSENCE_COST});
        this.setWeights(new int[]{RARITY});
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public ItemStack[][] required(ItemStack stack) {
        return new ItemStack[][]{{new ItemStack((Item)CyberwareContent.cyberlimbs, 1, 0), new ItemStack((Item)CyberwareContent.cyberlimbs, 1, 1)}};
    }

    @Override
    public boolean hasMenu(ItemStack augment) {
        return true;
    }

    @SubscribeEvent
    public void onProjectileHit(LivingAttackEvent event) {
        ICyberwareUserData cyberwareUserData;
        if (!event.getSource().func_76352_a() || event.getSource().func_76363_c()) {
            return;
        }
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        World world = player.func_130014_f_();
        ItemStack test = new ItemStack((Item)this);
        if (CyberwareAPI.isCyberwareInstalled((Entity)player, (ItemStack)test) && this.isAugmentEnabled(player, test) && (cyberwareUserData = CyberwareAPI.getCapability((Entity)player)).usePower(test, ENERGY_PER_EFFECT, false)) {
            Entity projectile = event.getSource().func_76364_f();
            Vec3d vectorMotion = new Vec3d(projectile.field_70159_w, projectile.field_70181_x, projectile.field_70179_y);
            Vec3d vectorLook = player.func_70040_Z();
            double difference = -vectorLook.func_72430_b(vectorMotion.func_72432_b());
            if (difference < 0.1) {
                return;
            }
            cyberwareUserData.updateCapacity();
            if (!player.field_70170_p.field_72995_K) {
                CyberwareAPI.updateData((Entity)player);
            }
            event.setCanceled(true);
            if (this.getQuality(CyberwareAPI.getCyberware((Entity)player, (ItemStack)new ItemStack((Item)this))).equals(CyberwareAPI.QUALITY_MANUFACTURED)) {
                player.func_184185_a(SoundEvents.field_187767_eL, 1.0f, 2.5f);
                double returnSpeed = projectile.field_70159_w * projectile.field_70159_w + projectile.field_70181_x * projectile.field_70181_x + projectile.field_70179_y * projectile.field_70179_y;
                returnSpeed = Math.sqrt(returnSpeed);
                projectile.field_70159_w = vectorLook.field_72450_a * (returnSpeed += 0.5);
                projectile.field_70181_x = vectorLook.field_72448_b * returnSpeed;
                projectile.field_70179_y = vectorLook.field_72449_c * returnSpeed;
                projectile.field_70177_z = (float)(Math.atan2(projectile.field_70159_w, projectile.field_70179_y) * 180.0 / Math.PI);
                projectile.field_70125_A = (float)(Math.atan2(projectile.field_70181_x, returnSpeed) * 180.0 / Math.PI);
                NetworkHandler.INSTANCE.sendToAll((IMessage)new PacketEntityMovement(projectile));
                if (projectile instanceof EntityArrow) {
                    ((EntityArrow)projectile).field_70250_c = player;
                    projectile.field_70159_w /= (double)-0.1f;
                    projectile.field_70181_x /= (double)-0.1f;
                    projectile.field_70179_y /= (double)-0.1f;
                }
            }
        }
    }

    public int getPowerConsumption(ItemStack stack) {
        return stack.func_77969_a(new ItemStack((Item)this)) ? ENERGY_PER_EFFECT : 0;
    }

    public boolean hasCustomPowerMessage(ItemStack stack) {
        return stack.func_77969_a(new ItemStack((Item)this));
    }
}

