/*
 * Decompiled with CFR 0.152.
 */
package com.mr208.wired.Common.Item.Augs;

import com.mr208.wired.Common.Item.Augs.ItemWiredAugs;
import com.mr208.wired.Handler.ConfigHandler;
import com.mr208.wired.Wired;
import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.CyberwareUpdateEvent;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.ICyberware;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class AugECD
extends ItemWiredAugs {
    protected static int ESSENCE_COST;
    protected static int ENERGY_PER_EFFECT;
    protected static int RARITY;
    protected static int RANGE;
    protected static List<Item> BLACKLIST;
    protected static int MAXIMUM;
    private int maxRetry = -1;
    private final String classSolegnolia = "vazkii.botania.common.block.subtile.functional.SubTileSolegnolia";
    private final String funcHasSolegnoliaAround = "hasSolegnoliaAround";
    private Method hasSolegnoliaAround = null;

    public AugECD(String name, ICyberware.EnumSlot slot) {
        super(name, slot);
        RARITY = ConfigHandler.ECD.RARITY;
        ENERGY_PER_EFFECT = ConfigHandler.ECD.RARITY;
        ESSENCE_COST = ConfigHandler.ECD.TOLERANCE;
        this.setEssenceCost(new int[]{ESSENCE_COST});
        this.setWeights(new int[]{RARITY});
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int getPowerConsumption(ItemStack stack) {
        return stack.func_77969_a(new ItemStack((Item)this)) ? ENERGY_PER_EFFECT : 0;
    }

    public boolean hasCustomPowerMessage(ItemStack stack) {
        return stack.func_77969_a(new ItemStack((Item)this));
    }

    @Override
    public boolean hasMenu(ItemStack augment) {
        return true;
    }

    @SubscribeEvent
    public void onLivingUpdate(CyberwareUpdateEvent event) {
        if (event.getEntityLiving().field_70173_aa % 100 != 0 || event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        if (event.getEntityLiving() instanceof EntityPlayer && CyberwareAPI.isCyberwareInstalled((Entity)event.getEntityLiving(), (ItemStack)new ItemStack((Item)this)) && this.isAugmentEnabled((EntityPlayer)event.getEntityLiving(), new ItemStack((Item)this))) {
            EntityLivingBase entityLivingBase;
            if (BLACKLIST == null) {
                this.loadBlacklist();
            }
            if (!((entityLivingBase = event.getEntityLiving()) instanceof EntityPlayer)) {
                return;
            }
            int cooldown = this.getECDCooldown(entityLivingBase);
            double x = entityLivingBase.field_70165_t;
            double y = entityLivingBase.field_70163_u;
            double z = entityLivingBase.field_70161_v;
            List itemsInRange = entityLivingBase.field_70170_p.func_72872_a(EntityItem.class, new AxisAlignedBB(x - (double)RANGE, y - (double)RANGE, z - (double)RANGE, x + (double)RANGE, y + (double)RANGE, z + (double)RANGE));
            ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapability((Entity)entityLivingBase);
            boolean worked = false;
            int max = 0;
            if (itemsInRange.size() > 0) {
                EnderTeleportEvent teleportEvent = new EnderTeleportEvent(entityLivingBase, x, y, z, 0.0f);
                if (MinecraftForge.EVENT_BUS.post((Event)teleportEvent)) {
                    return;
                }
                for (EntityItem item : itemsInRange) {
                    if (this.canItemBeTeleported(item)) {
                        if (max > MAXIMUM || !cyberwareUserData.usePower(new ItemStack((Item)this), ENERGY_PER_EFFECT)) break;
                        double xDist = x - item.field_70165_t;
                        double yDist = y - item.field_70163_u;
                        double zDist = z - item.field_70161_v;
                        double dist = xDist * xDist + yDist * yDist + zDist * zDist;
                        if (dist < 1.5) {
                            item.func_70100_b_((EntityPlayer)entityLivingBase);
                            worked = true;
                        } else {
                            item.func_70634_a(x, y + 0.75, z);
                            worked = true;
                        }
                        ++max;
                    }
                    if (worked) {
                        entityLivingBase.field_70170_p.func_184133_a(null, entityLivingBase.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 0.25f, 1.0f);
                    }
                    CyberwareAPI.updateData((Entity)entityLivingBase);
                }
                this.setECDCooldown(entityLivingBase, 100);
            } else {
                this.setECDCooldown(entityLivingBase, cooldown - 1);
            }
        }
    }

    private boolean canItemBeTeleported(EntityItem item) {
        NBTTagCompound nbtTagCompound;
        if (item.field_70128_L) {
            return false;
        }
        if (!BLACKLIST.isEmpty()) {
            for (Item blItem : BLACKLIST) {
                if (!blItem.equals(item.func_92059_d().func_77973_b())) continue;
                return false;
            }
        }
        if (Wired.isImmersiveEngineeringLoaded && (nbtTagCompound = item.getEntityData()).func_74767_n("PreventRemoteMovement")) {
            return false;
        }
        if (Wired.isBotaniaLoaded) {
            return !this.isNearSolegnolia(item);
        }
        return true;
    }

    private int getECDCooldown(EntityLivingBase entityLivingBase) {
        return CyberwareAPI.getCyberwareNBT((ItemStack)CyberwareAPI.getCyberware((Entity)entityLivingBase, (ItemStack)new ItemStack((Item)this))).func_74762_e("COOLDOWN");
    }

    private void setECDCooldown(EntityLivingBase entityLivingBase, int cooldown) {
        NBTTagCompound nbtTagCompound = this.getECDTag(entityLivingBase);
        nbtTagCompound.func_74768_a("COOLDOWN", cooldown);
        ItemStack cyberware = CyberwareAPI.getCyberware((Entity)entityLivingBase, (ItemStack)new ItemStack((Item)this));
        cyberware.func_77978_p().func_74782_a("cyberwareFunctionData", (NBTBase)nbtTagCompound);
    }

    private NBTTagCompound getECDTag(EntityLivingBase entityLivingBase) {
        ItemStack installedItemStack = CyberwareAPI.getCyberware((Entity)entityLivingBase, (ItemStack)new ItemStack((Item)this));
        return CyberwareAPI.getCyberwareNBT((ItemStack)installedItemStack);
    }

    private void loadBlacklist() {
        BLACKLIST = new ArrayList<Item>();
        for (String item : ConfigHandler.ECD.BLACKLIST) {
            Item blItem;
            String[] blacklistItem = item.split(":");
            if (blacklistItem.length != 2 || (blItem = GameRegistry.findItem((String)blacklistItem[0], (String)blacklistItem[1])) == null) continue;
            BLACKLIST.add(blItem);
        }
    }

    private boolean isNearSolegnolia(EntityItem entityItem) {
        block7: {
            if (this.maxRetry < 0) {
                this.maxRetry = 0;
                try {
                    Class<?> solegnolia = Class.forName("vazkii.botania.common.block.subtile.functional.SubTileSolegnolia");
                    this.hasSolegnoliaAround = solegnolia.getMethod("hasSolegnoliaAround", Entity.class);
                }
                catch (Throwable solegnolia) {
                    // empty catch block
                }
            }
            if (this.hasSolegnoliaAround != null) {
                try {
                    boolean stopTeleport = (Boolean)this.hasSolegnoliaAround.invoke(null, entityItem);
                    if (this.maxRetry > 0) {
                        --this.maxRetry;
                    }
                    return stopTeleport;
                }
                catch (Throwable throwable) {
                    if (this.maxRetry++ <= 10) break block7;
                    this.hasSolegnoliaAround = null;
                }
            }
        }
        return false;
    }

    static {
        RANGE = ConfigHandler.ECD.RANGE;
        MAXIMUM = ConfigHandler.ECD.MAX;
    }
}

