/*
 * Decompiled with CFR 0.152.
 */
package com.mr208.wired.Common.Entity;

import com.mr208.wired.Common.Entity.ICyberEntity;
import com.mr208.wired.Common.Item.WiredItems;
import com.mr208.wired.Handler.ConfigHandler;
import com.mr208.wired.Handler.EventsHandler;
import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.CyberwareUserDataImpl;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.common.CyberwareConfig;
import flaxbeard.cyberware.common.CyberwareContent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class EntityCyberSkeleton
extends EntitySkeleton
implements ICyberEntity {
    private static final DataParameter<Integer> CYBER_VARIANT = EntityDataManager.func_187226_a(EntityCyberSkeleton.class, (DataSerializer)DataSerializers.field_187192_b);
    public boolean hasWare = false;
    private CyberwareUserDataImpl cyberware = new CyberwareUserDataImpl();

    public EntityCyberSkeleton(World worldIn) {
        super(worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CYBER_VARIANT, (Object)0);
    }

    public void func_70636_d() {
        if (!this.hasWare && !this.field_70170_p.field_72995_K) {
            EventsHandler.addRandomCyberware(this);
            this.func_70606_j(this.func_110138_aP());
            this.hasWare = true;
        }
        super.func_70636_d();
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        compound = super.func_189511_e(compound);
        compound.func_74757_a("hasRandomWare", this.hasWare);
        if (this.hasWare) {
            NBTTagCompound comp = this.cyberware.serializeNBT();
            compound.func_74782_a("ware", (NBTBase)comp);
        }
        return compound;
    }

    public void func_70020_e(NBTTagCompound compound) {
        super.func_70020_e(compound);
        this.hasWare = compound.func_74767_n("hasRandomWare");
        if (compound.func_74764_b("ware")) {
            this.cyberware.deserializeNBT(compound.func_74775_l("ware"));
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CyberwareAPI.CYBERWARE_CAPABILITY) {
            return (T)this.cyberware;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CyberwareAPI.CYBERWARE_CAPABILITY || super.hasCapability(capability, facing);
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
        super.func_82160_b(wasRecentlyHit, lootingModifier);
        if (CyberwareConfig.KATANA && this.func_184582_a(EntityEquipmentSlot.MAINHAND) != null && this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() == CyberwareContent.katana) {
            ItemStack itemStack = this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77946_l();
            if (itemStack.func_77984_f()) {
                int i = Math.max(itemStack.func_77958_k() - 25, 1);
                int j = itemStack.func_77958_k() - this.field_70146_Z.nextInt(this.field_70146_Z.nextInt(i) + 1);
                if (j > i) {
                    j = i;
                }
                if (j < i) {
                    j = 1;
                }
                itemStack.func_77964_b(j);
            }
            this.func_70099_a(itemStack, 0.0f);
        }
        if (this.hasWare) {
            float rarity = Math.min(100.0f, CyberwareConfig.DROP_RARITY + (float)lootingModifier * 5.0f);
            if (this.field_70170_p.field_73012_v.nextFloat() < rarity / 100.0f) {
                int count;
                ArrayList<ItemStack> allWares = new ArrayList<ItemStack>();
                for (ICyberware.EnumSlot slot : ICyberware.EnumSlot.values()) {
                    ItemStack[] stuff = this.cyberware.getInstalledCyberware(slot);
                    allWares.addAll(Arrays.asList(stuff));
                }
                allWares.removeAll(Collections.singleton(null));
                ItemStack drop = null;
                for (count = 0; count < 50 && (drop == null || drop.func_77973_b() == CyberwareContent.creativeBattery || drop.func_77973_b() == CyberwareContent.bodyPart); ++count) {
                    int random = this.field_70170_p.field_73012_v.nextInt(allWares.size());
                    drop = ItemStack.func_77944_b((ItemStack)((ItemStack)allWares.get(random)));
                    drop = CyberwareAPI.sanitize((ItemStack)drop);
                    drop = CyberwareAPI.getCyberware((ItemStack)drop).setQuality(drop, CyberwareAPI.QUALITY_SCAVENGED);
                    drop.field_77994_a = 1;
                }
                if (count < 50) {
                    this.func_70099_a(drop, 0.0f);
                }
            }
        }
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        float chance = this.field_70170_p.field_73012_v.nextFloat();
        if (chance > 0.0f && chance <= 0.25f) {
            if (CyberwareConfig.KATANA && this.func_184582_a(EntityEquipmentSlot.MAINHAND) == null) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, this.setRandomDamage(new ItemStack(CyberwareContent.katana).func_77946_l()));
                this.func_184642_a(EntityEquipmentSlot.MAINHAND, 0.1f);
            }
        } else if (chance > 0.0f && chance <= 0.95f) {
            if (ConfigHandler.Equipment.Batons.ENABLED && this.func_184582_a(EntityEquipmentSlot.MAINHAND) == null) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, this.setRandomDamage(new ItemStack((Item)WiredItems.batonReinforced).func_77946_l()));
                this.func_184642_a(EntityEquipmentSlot.MAINHAND, ConfigHandler.Equipment.Batons.DROP_CHANCE);
            }
        } else if (chance > 0.95f && ConfigHandler.Equipment.Batons.ENABLED && this.func_184582_a(EntityEquipmentSlot.MAINHAND) == null) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, this.setRandomDamage(new ItemStack((Item)WiredItems.batonShock).func_77946_l()));
            this.func_184642_a(EntityEquipmentSlot.MAINHAND, ConfigHandler.Equipment.Batons.DROP_CHANCE);
        }
        if (this.func_184582_a(EntityEquipmentSlot.MAINHAND) == null) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, this.setRandomDamage(new ItemStack(Items.field_151036_c).func_77946_l()));
        }
        if ((chance = this.field_70170_p.field_73012_v.nextFloat()) > 0.0f && chance <= 0.34f && this.func_184586_b(EnumHand.OFF_HAND) == null) {
            if (ConfigHandler.Equipment.Shields.ENABLED) {
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack((Item)WiredItems.shieldRiot).func_77946_l());
                this.func_184642_a(EntityEquipmentSlot.OFFHAND, ConfigHandler.Equipment.Shields.DROP_CHANCE);
            } else {
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Items.field_185159_cQ).func_77946_l());
                this.func_184642_a(EntityEquipmentSlot.OFFHAND, 0.25f);
            }
        }
    }

    @Override
    public boolean getHasWare(EntityLivingBase entityLivingBase) {
        return this.hasWare;
    }

    @Override
    public void setHasWare(boolean bool) {
        this.hasWare = bool;
    }

    protected ItemStack setRandomDamage(ItemStack stack) {
        int damage = (int)((float)stack.func_77958_k() * this.field_70146_Z.nextFloat());
        ItemStack newStack = stack.func_77946_l();
        newStack.func_77964_b(damage);
        return newStack;
    }
}

