/*
 * Decompiled with CFR 0.152.
 */
package com.mr208.wired.Common.Block;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mr208.wired.Common.Block.WiredBlocks;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

public class BlockECGlass
extends Block {
    private List<BlockPos> ECGlassToTurnOff = Lists.newArrayList();
    private List<BlockPos> ECGlassToTurnOn = Lists.newArrayList();
    private final Set<BlockPos> ECGlassUpdated = Sets.newLinkedHashSet();
    private boolean ECGlassProvidesPower = true;
    private static final EnumFacing[] facingsHorizontal = new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.SOUTH};
    private static final EnumFacing[] facingsVertical = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP};
    private static final EnumFacing[] facings = (EnumFacing[])ArrayUtils.addAll((Object[])facingsVertical, (Object[])facingsHorizontal);
    private static final Vec3i[] surroundingBlockOffset;
    public static final PropertyInteger POWER;
    private boolean canProvidePower = false;

    public BlockECGlass(String name) {
        super(Material.field_151592_s);
        this.setRegistryName(name);
        this.func_149663_c("wired." + name);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(0)));
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock((Block)this), (ResourceLocation)this.getRegistryName());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWER});
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)POWER);
    }

    public IBlockState func_176203_a(int meta) {
        return this.field_176227_L.func_177621_b().func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(meta));
    }

    public boolean func_149662_c(IBlockState state) {
        switch ((Integer)state.func_177229_b((IProperty)POWER)) {
            case 0: {
                return false;
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149751_l(IBlockState state) {
        switch ((Integer)state.func_177229_b((IProperty)POWER)) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    public int func_149717_k(IBlockState state) {
        switch ((Integer)state.func_177229_b((IProperty)POWER)) {
            case 0: {
                return 0;
            }
        }
        return 15;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        switch ((Integer)state.func_177229_b((IProperty)POWER)) {
            case 0: {
                return false;
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        IBlockState iBlockState2;
        IBlockState iBlockState1 = blockAccess.func_180495_p(pos.func_177972_a(side));
        return iBlockState1 != (iBlockState2 = blockAccess.func_180495_p(pos));
    }

    public boolean func_149744_f(IBlockState state) {
        return this.canProvidePower;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return !this.ECGlassProvidesPower ? 0 : blockState.func_185911_a(blockAccess, pos, side);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (!this.ECGlassProvidesPower) {
            return 0;
        }
        if (side == EnumFacing.UP || this.getSidesToPower((World)blockAccess, pos).contains(side)) {
            return (Integer)blockState.func_177229_b((IProperty)POWER);
        }
        return 0;
    }

    private boolean isPowerSourceAt(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        BlockPos blockpos = pos.func_177972_a(side);
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        boolean flag = iblockstate.func_185915_l();
        boolean flag1 = worldIn.func_180495_p(pos.func_177984_a()).func_185915_l();
        return !flag1 && flag && BlockECGlass.canConnectUpwardsTo(worldIn, blockpos.func_177984_a()) ? true : (BlockECGlass.canConnectTo(iblockstate, side) ? true : (iblockstate.func_177230_c() == Blocks.field_150416_aS && iblockstate.func_177229_b((IProperty)BlockRedstoneDiode.field_185512_D) == side ? true : !flag && BlockECGlass.canConnectUpwardsTo(worldIn, blockpos.func_177977_b())));
    }

    protected static boolean canConnectUpwardsTo(IBlockAccess worldIn, BlockPos pos) {
        return BlockECGlass.canConnectTo(worldIn.func_180495_p(pos), null);
    }

    protected static boolean canConnectTo(IBlockState blockState, @Nullable EnumFacing side) {
        Block block = blockState.func_177230_c();
        if (block == WiredBlocks.glassEC) {
            return true;
        }
        if (block == Blocks.field_150488_af) {
            return false;
        }
        return blockState.func_185897_m() && side != null;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            this.updateSurroundingRedstone(worldIn, pos);
            for (Vec3i vec : surroundingBlockOffset) {
                worldIn.func_180496_d(pos.func_177971_a(vec), (Block)this);
            }
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        if (!worldIn.field_72995_K) {
            this.updateSurroundingRedstone(worldIn, pos);
            for (Vec3i vec : surroundingBlockOffset) {
                worldIn.func_180496_d(pos.func_177971_a(vec), (Block)this);
            }
        }
    }

    private void notifyWireNeighborsOfStateChange(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            worldIn.func_175685_c(pos, (Block)this);
            for (EnumFacing enumfacing : EnumFacing.values()) {
                worldIn.func_175685_c(pos.func_177972_a(enumfacing), (Block)this);
            }
        }
    }

    private void updateSurroundingRedstone(World worldIn, BlockPos pos) {
        this.calculateCurrentChanges(worldIn, pos);
        LinkedHashSet glassNeedingUpdate = Sets.newLinkedHashSet();
        for (BlockPos pos1 : this.ECGlassUpdated) {
            this.addBlocksNeedingUpdate(worldIn, pos1, glassNeedingUpdate);
        }
        Iterator iterator = Lists.newLinkedList(this.ECGlassUpdated).descendingIterator();
        while (iterator.hasNext()) {
            this.addAllSurroundingBlocks((BlockPos)iterator.next(), glassNeedingUpdate);
        }
        glassNeedingUpdate.removeAll(this.ECGlassUpdated);
        this.ECGlassUpdated.clear();
        for (BlockPos pos1 : glassNeedingUpdate) {
            worldIn.func_180496_d(pos1, (Block)this);
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return true;
    }

    private void calculateCurrentChanges(World worldIn, BlockPos position) {
        int newPower;
        int wirePower;
        int blockPower;
        int oldPower;
        IBlockState state;
        if (worldIn.func_180495_p(position).func_177230_c() == this) {
            this.ECGlassToTurnOff.add(position);
        } else {
            this.checkSurroundingWires(worldIn, position);
        }
        while (!this.ECGlassToTurnOff.isEmpty()) {
            BlockPos pos = this.ECGlassToTurnOff.remove(0);
            state = worldIn.func_180495_p(pos);
            oldPower = (Integer)state.func_177229_b((IProperty)POWER);
            this.ECGlassProvidesPower = false;
            blockPower = worldIn.func_175687_A(pos);
            this.ECGlassProvidesPower = true;
            wirePower = this.getSurroundingWirePower(worldIn, pos);
            if ((newPower = Math.max(blockPower, --wirePower)) < oldPower) {
                if (blockPower > 0 && !this.ECGlassToTurnOn.contains(pos)) {
                    this.ECGlassToTurnOn.add(pos);
                }
                this.setWireState(worldIn, pos, state, 0);
            } else if (newPower > oldPower) {
                this.setWireState(worldIn, pos, state, newPower);
            }
            this.checkSurroundingWires(worldIn, pos);
        }
        while (!this.ECGlassToTurnOn.isEmpty()) {
            BlockPos blockPos = this.ECGlassToTurnOn.remove(0);
            state = worldIn.func_180495_p(blockPos);
            oldPower = (Integer)state.func_177229_b((IProperty)POWER);
            this.ECGlassProvidesPower = false;
            blockPower = worldIn.func_175687_A(blockPos);
            this.ECGlassProvidesPower = true;
            wirePower = this.getSurroundingWirePower(worldIn, blockPos);
            if ((newPower = Math.max(blockPower, --wirePower)) > oldPower) {
                this.setWireState(worldIn, blockPos, state, newPower);
            }
            this.checkSurroundingWires(worldIn, position);
        }
        this.ECGlassToTurnOff.clear();
        this.ECGlassToTurnOn.clear();
    }

    private void addWireToList(World worldIn, BlockPos pos, int otherPower) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c() == this) {
            int power = (Integer)state.func_177229_b((IProperty)POWER);
            if (power < otherPower - 1 && !this.ECGlassToTurnOn.contains(pos)) {
                this.ECGlassToTurnOn.add(pos);
            }
            if (power > otherPower && !this.ECGlassToTurnOff.contains(pos)) {
                this.ECGlassToTurnOff.add(pos);
            }
        }
    }

    private void checkSurroundingWires(World worldIn, BlockPos pos) {
        BlockPos offsetPos;
        IBlockState state = worldIn.func_180495_p(pos);
        int ownPower = 0;
        if (state.func_177230_c() == this) {
            ownPower = (Integer)state.func_177229_b((IProperty)POWER);
        }
        for (EnumFacing facingHorz : facingsHorizontal) {
            offsetPos = pos.func_177972_a(facingHorz);
            if (!facingHorz.func_176740_k().func_176722_c()) continue;
            this.addWireToList(worldIn, offsetPos, ownPower);
        }
        for (EnumFacing facingVert : facingsVertical) {
            offsetPos = pos.func_177972_a(facingVert);
            for (EnumFacing facingHorz2 : facingsHorizontal) {
                this.addWireToList(worldIn, offsetPos.func_177972_a(facingHorz2), ownPower);
            }
        }
    }

    private int getSurroundingWirePower(World worldIn, BlockPos pos) {
        int wirePower = 0;
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos offsetPos = pos.func_177972_a(enumfacing);
            wirePower = this.getMaxCurrentStrength(worldIn, offsetPos, wirePower);
            if (worldIn.func_180495_p(offsetPos).func_185915_l() && !worldIn.func_180495_p(pos.func_177984_a()).func_185915_l()) {
                wirePower = this.getMaxCurrentStrength(worldIn, offsetPos.func_177984_a(), wirePower);
                continue;
            }
            if (worldIn.func_180495_p(offsetPos).func_185915_l()) continue;
            wirePower = this.getMaxCurrentStrength(worldIn, offsetPos.func_177977_b(), wirePower);
        }
        return wirePower;
    }

    private void addBlocksNeedingUpdate(World worldIn, BlockPos pos, Set<BlockPos> set) {
        BlockPos offsetPos;
        List<EnumFacing> connectedSides = this.getSidesToPower(worldIn, pos);
        for (EnumFacing facing : facings) {
            offsetPos = pos.func_177972_a(facing);
            if (!connectedSides.contains(facing.func_176734_d()) && facing != EnumFacing.DOWN && (!facing.func_176740_k().func_176722_c() || !BlockECGlass.canConnectTo(worldIn.func_180495_p(offsetPos), facing)) || !this.canBlockBePoweredFromSide(worldIn.func_180495_p(offsetPos), facing, true)) continue;
            set.add(offsetPos);
        }
        for (EnumFacing facing : facings) {
            offsetPos = pos.func_177972_a(facing);
            if (!connectedSides.contains(facing.func_176734_d()) && facing != EnumFacing.DOWN || !worldIn.func_180495_p(offsetPos).func_185915_l() && worldIn.func_180495_p(offsetPos).func_177230_c() != this) continue;
            for (EnumFacing facing1 : facings) {
                if (!this.canBlockBePoweredFromSide(worldIn.func_180495_p(offsetPos.func_177972_a(facing1)), facing1, false)) continue;
                set.add(offsetPos.func_177972_a(facing1));
            }
        }
    }

    private boolean canBlockBePoweredFromSide(IBlockState state, EnumFacing side, boolean isWire) {
        if (state.func_177230_c() instanceof BlockPistonBase && state.func_177229_b((IProperty)BlockPistonBase.field_176387_N) == side.func_176734_d()) {
            return false;
        }
        if (state.func_177230_c() instanceof BlockRedstoneDiode && state.func_177229_b((IProperty)BlockRedstoneDiode.field_185512_D) != side.func_176734_d()) {
            return isWire && state.func_177230_c() instanceof BlockRedstoneComparator && ((EnumFacing)state.func_177229_b((IProperty)BlockRedstoneComparator.field_185512_D)).func_176740_k() != side.func_176740_k() && side.func_176740_k().func_176722_c();
        }
        return !(state.func_177230_c() instanceof BlockRedstoneTorch) || !isWire && state.func_177229_b((IProperty)BlockRedstoneTorch.field_176596_a) == side;
    }

    private List<EnumFacing> getSidesToPower(World worldIn, BlockPos pos) {
        boolean eastwest;
        ArrayList retval = Lists.newArrayList();
        for (EnumFacing facing : facingsHorizontal) {
            if (!this.isPowerSourceAt((IBlockAccess)worldIn, pos, facing)) continue;
            retval.add(facing);
        }
        if (retval.isEmpty()) {
            return Lists.newArrayList((Object[])facingsHorizontal);
        }
        boolean northsouth = retval.contains(EnumFacing.NORTH) || retval.contains(EnumFacing.SOUTH);
        boolean bl = eastwest = retval.contains(EnumFacing.EAST) || retval.contains(EnumFacing.WEST);
        if (northsouth) {
            retval.remove(EnumFacing.EAST);
            retval.remove(EnumFacing.WEST);
        }
        if (eastwest) {
            retval.remove(EnumFacing.NORTH);
            retval.remove(EnumFacing.SOUTH);
        }
        return retval;
    }

    private void addAllSurroundingBlocks(BlockPos pos, Set<BlockPos> set) {
        for (Vec3i vect : surroundingBlockOffset) {
            set.add(pos.func_177971_a(vect));
        }
    }

    private void setWireState(World worldIn, BlockPos pos, IBlockState state, int power) {
        state = state.func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(power));
        worldIn.func_180501_a(pos, state, 2);
        this.ECGlassUpdated.add(pos);
    }

    private int getMaxCurrentStrength(World worldIn, BlockPos pos, int strength) {
        if (worldIn.func_180495_p(pos).func_177230_c() != this) {
            return strength;
        }
        int i = (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)POWER);
        return i > strength ? i : strength;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        if (!worldIn.field_72995_K) {
            if (this.func_176196_c(worldIn, pos)) {
                this.updateSurroundingRedstone(worldIn, pos);
            } else {
                this.func_176226_b(worldIn, pos, state, 0);
                worldIn.func_175698_g(pos);
            }
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        if (blockState.func_177230_c() == this) {
            return (Integer)blockState.func_177229_b((IProperty)POWER);
        }
        return 0;
    }

    static {
        LinkedHashSet set = Sets.newLinkedHashSet();
        for (EnumFacing facing : facings) {
            set.add(facing.func_176730_m());
        }
        for (EnumFacing facing1 : facings) {
            Vec3i v1 = facing1.func_176730_m();
            for (EnumFacing facing2 : facings) {
                Vec3i v2 = facing2.func_176730_m();
                set.add(new Vec3i(v1.func_177958_n() + v2.func_177958_n(), v1.func_177956_o() + v2.func_177956_o(), v1.func_177952_p() + v2.func_177952_p()));
            }
        }
        set.remove(new Vec3i(0, 0, 0));
        surroundingBlockOffset = set.toArray(new Vec3i[set.size()]);
        POWER = PropertyInteger.func_177719_a((String)"power", (int)0, (int)15);
    }
}

