/*
 * Decompiled with CFR 0.152.
 */
package com.mr208.wired.Client.Hud;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.hud.HudElementBase;
import flaxbeard.cyberware.api.hud.IHudElement;
import flaxbeard.cyberware.api.item.EnableDisableHelper;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.client.ClientUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class HudElementWired
extends HudElementBase {
    private static final ResourceLocation HUD_TEXTURE = new ResourceLocation("wired", "textures/gui/hud.png");
    private IconType iconType;
    private ICyberware augment;
    private int texX;
    private int texY;
    protected float cachedPercent = -1.0f;

    public HudElementWired(String name, ICyberware augment, int defX, int defY, int texX, int texY, IconType iconType) {
        super("wired:" + name);
        this.setDefaultX(defX);
        this.setDefaultY(defY);
        this.setHeight(16);
        this.setWidth(16);
        this.texX = texX;
        this.texY = texY;
        this.augment = augment;
        this.iconType = iconType;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderElement(int x, int y, EntityPlayer entityPlayer, ScaledResolution scaledResolution, boolean hudjackAvilable, boolean isConfigOpen, float partialTicks) {
        if (hudjackAvilable) {
            boolean flipHoriz = this.getHorizontalAnchor() == IHudElement.EnumAnchorHorizontal.RIGHT;
            float curentTime = (float)entityPlayer.field_70173_aa + partialTicks;
            GL11.glPushMatrix();
            GlStateManager.func_179147_l();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(HUD_TEXTURE);
            ICyberwareUserData data = CyberwareAPI.getCapability((Entity)entityPlayer);
            boolean augEnabled = this.isActive(entityPlayer, this.augment);
            float[] color = CyberwareAPI.getHUDColor();
            int colorHex = CyberwareAPI.getHUDColorHex();
            int amount = 16;
            if (this.cachedPercent != -1.0f) {
                amount = Math.round(16.0f * this.cachedPercent);
            }
            int moveX = flipHoriz ? x + this.getWidth() - 32 : x;
            GlStateManager.func_179094_E();
            if (!this.isHidden() || !augEnabled && this.iconType == IconType.REFILL) {
                ClientUtils.drawTexturedModalRect((int)moveX, (int)y, (int)(this.texX * 16), (int)(this.texY * 16), (int)16, (int)16);
                if (this.iconType == IconType.REFILL) {
                    ClientUtils.drawTexturedModalRect((int)moveX, (int)y, (int)(16 + this.texX * 16), (int)(this.texY * 16), (int)16, (int)amount);
                } else if (this.iconType == IconType.TOGGLE && !augEnabled) {
                    ClientUtils.drawTexturedModalRect((int)moveX, (int)y, (int)(16 + this.texX * 16), (int)(this.texY * 16), (int)16, (int)16);
                }
            }
            GlStateManager.func_179121_F();
        }
        GL11.glPopMatrix();
    }

    public boolean isActive(EntityPlayer player, ICyberware augment) {
        if (CyberwareAPI.hasCapability((Entity)player)) {
            ICyberwareUserData data = CyberwareAPI.getCapability((Entity)player);
            if (CyberwareAPI.isCyberwareInstalled((Entity)player, (ItemStack)new ItemStack((Item)augment))) {
                ItemStack aug = data.getCyberware(new ItemStack((Item)augment));
                return EnableDisableHelper.isEnabled((ItemStack)aug);
            }
        }
        return false;
    }

    public ICyberware getAugment() {
        return this.augment;
    }

    public static enum IconType {
        TOGGLE,
        REFILL;

    }
}

