/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocator.tile;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.gui.IGuiPacketSender;
import codechicken.lib.inventory.InventoryRange;
import codechicken.lib.inventory.InventorySimple;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.math.MathHelper;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.util.ItemUtils;
import codechicken.lib.util.ServerUtils;
import codechicken.translocator.container.ContainerItemTranslocator;
import codechicken.translocator.handler.ConfigurationHandler;
import codechicken.translocator.network.TranslocatorSPH;
import codechicken.translocator.tile.TileTranslocator;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class TileItemTranslocator
extends TileTranslocator {
    public LinkedList<MovingItem> movingItems = new LinkedList();

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("items")) {
            for (TileTranslocator.Attachment a : this.attachments) {
                if (a == null) continue;
                InventoryUtils.readItemStacksFromTag((ItemStack[])((ItemAttachment)a).filters, (NBTTagList)tag.func_150295_c("items", 10));
            }
        }
    }

    @Override
    public void createAttachment(int side) {
        this.attachments[side] = new ItemAttachment(side);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            Iterator iterator = this.movingItems.iterator();
            while (iterator.hasNext()) {
                if (!((MovingItem)iterator.next()).update()) continue;
                iterator.remove();
            }
        } else {
            int i;
            int i2;
            BlockPos pos = new BlockPos((Vec3i)this.func_174877_v());
            InventoryRange[] attached = new InventoryRange[6];
            for (i2 = 0; i2 < 6; ++i2) {
                TileTranslocator.Attachment a = this.attachments[i2];
                if (a == null) continue;
                BlockPos invpos = pos.func_177972_a(EnumFacing.field_82609_l[i2]);
                IInventory inv = InventoryUtils.getInventory((World)this.field_145850_b, (BlockPos)invpos);
                if (inv == null) {
                    this.harvestPart(i2, true);
                    continue;
                }
                attached[i2] = new InventoryRange(inv, i2 ^ 1);
            }
            for (i2 = 0; i2 < 6; ++i2) {
                ItemAttachment ia = (ItemAttachment)this.attachments[i2];
                if (ia == null || !ia.a_eject) continue;
                int largestQuantity = 0;
                int largestSlot = 0;
                InventoryRange access = attached[i2];
                for (int slot : access.slots) {
                    int quantity;
                    ItemStack stack = access.inv.func_70301_a(slot);
                    if (stack == null || !access.canExtractItem(slot, stack) || stack.field_77994_a == 0) continue;
                    int n = quantity = ia.fast ? stack.field_77994_a : 1;
                    if (quantity <= largestQuantity || (quantity = Math.min(quantity, this.extractAmount(stack, ia, access))) <= largestQuantity || (quantity = Math.min(quantity, this.insertAmount(stack, attached))) <= largestQuantity) continue;
                    largestSlot = slot;
                    largestQuantity = quantity;
                }
                if (largestQuantity <= 0) continue;
                ItemStack move = InventoryUtils.copyStack((ItemStack)access.inv.func_70301_a(largestSlot), (int)largestQuantity);
                this.spreadOutput(move, i2, false, attached);
                this.spreadOutput(move, i2, true, attached);
                InventoryUtils.decrStackSize((IInventory)access.inv, (int)largestSlot, (int)(largestQuantity - move.field_77994_a));
            }
            boolean allSatisfied = true;
            for (i = 0; i < 6; ++i) {
                ItemAttachment ia = (ItemAttachment)this.attachments[i];
                if (ia == null || ia.a_eject) continue;
                boolean b = this.isSatsified(ia, attached[i]);
                ia.setPowering(b);
                if (b) continue;
                allSatisfied = false;
            }
            for (i = 0; i < 6; ++i) {
                ItemAttachment ia = (ItemAttachment)this.attachments[i];
                if (ia == null || !ia.signal || !ia.a_eject) continue;
                ia.setPowering(allSatisfied || !this.canTransferFilter(ia, attached[i], attached));
            }
        }
    }

    private boolean matches(ItemStack stack, ItemStack filter) {
        return stack.func_77973_b() == filter.func_77973_b() && (!filter.func_77981_g() || filter.func_77952_i() == stack.func_77952_i()) && ItemStack.func_77970_a((ItemStack)filter, (ItemStack)stack);
    }

    private boolean canTransferFilter(ItemAttachment ia, InventoryRange access, InventoryRange[] attached) {
        boolean filterSet = false;
        for (ItemStack filter : ia.filters) {
            if (filter == null) continue;
            filterSet = true;
            if (ia.regulate && this.countMatchingStacks(access, filter, false) <= this.filterCount(ia, filter) || this.insertAmount(filter, attached) <= 0) continue;
            return true;
        }
        return !filterSet;
    }

    private boolean isSatsified(ItemAttachment ia, InventoryRange access) {
        boolean filterSet = false;
        for (ItemStack filter : ia.filters) {
            if (filter == null) continue;
            filterSet = true;
            if (!(ia.regulate ? this.countMatchingStacks(access, filter, !ia.a_eject) < this.filterCount(ia, filter) : InventoryUtils.getInsertibleQuantity((InventoryRange)access, (ItemStack)filter) > 0)) continue;
            return false;
        }
        return filterSet || !this.hasEmptySpace(access);
    }

    private boolean hasEmptySpace(InventoryRange inv) {
        for (int slot : inv.slots) {
            ItemStack stack = inv.inv.func_70301_a(slot);
            if (!inv.canInsertItem(slot, new ItemStack(Items.field_151045_i)) || stack != null && (!stack.func_77985_e() || stack.field_77994_a >= Math.min(stack.func_77976_d(), inv.inv.func_70297_j_()))) continue;
            return true;
        }
        return false;
    }

    private int filterCount(ItemAttachment ia, ItemStack stack) {
        boolean filterSet = false;
        int match = 0;
        for (ItemStack filter : ia.filters) {
            if (filter == null) continue;
            filterSet = true;
            if (!this.matches(stack, filter)) continue;
            match += filter.field_77994_a;
        }
        return filterSet ? match : -1;
    }

    private void spreadOutput(ItemStack move, int src, boolean rspass, InventoryRange[] attached) {
        if (move.field_77994_a == 0) {
            return;
        }
        int outputCount = 0;
        int[] outputQuantities = new int[6];
        for (int i = 0; i < 6; ++i) {
            ItemAttachment ia = (ItemAttachment)this.attachments[i];
            if (ia == null || ia.a_eject || ia.redstone != rspass) continue;
            outputQuantities[i] = this.insertAmount(move, ia, attached[i]);
            if (outputQuantities[i] <= 0) continue;
            ++outputCount;
        }
        for (int dst = 0; dst < 6 && move.field_77994_a > 0; ++dst) {
            int qty = outputQuantities[dst];
            if (qty <= 0) continue;
            qty = Math.min(qty, move.field_77994_a / outputCount + this.field_145850_b.field_73012_v.nextInt(move.field_77994_a % outputCount + 1));
            --outputCount;
            if (qty == 0) continue;
            InventoryRange range = attached[dst];
            ItemStack add = InventoryUtils.copyStack((ItemStack)move, (int)qty);
            InventoryUtils.insertItem((InventoryRange)range, (ItemStack)add, (boolean)false);
            move.field_77994_a -= qty;
            this.sendTransferPacket(src, dst, add);
        }
    }

    private int countMatchingStacks(InventoryRange inv, ItemStack filter, boolean insertable) {
        int c = 0;
        for (int slot : inv.slots) {
            ItemStack stack = inv.inv.func_70301_a(slot);
            if (stack == null || !this.matches(filter, stack) || !(insertable ? inv.canInsertItem(slot, stack) : inv.canExtractItem(slot, stack))) continue;
            c += stack.field_77994_a;
        }
        return c;
    }

    private void sendTransferPacket(int i, int j, ItemStack add) {
        PacketCustom packet = new PacketCustom(TranslocatorSPH.channel, 2);
        packet.writePos(this.func_174877_v());
        packet.writeByte(i << 4 | j);
        packet.writeItemStack(add);
        packet.sendToChunk(this.field_145850_b, this.func_174877_v().func_177958_n() >> 4, this.func_174877_v().func_177952_p() >> 4);
    }

    private int insertAmount(ItemStack stack, InventoryRange[] attached) {
        int insertAmount = 0;
        for (int i = 0; i < 6; ++i) {
            ItemAttachment ia = (ItemAttachment)this.attachments[i];
            if (ia == null || ia.a_eject) continue;
            insertAmount += this.insertAmount(stack, ia, attached[i]);
        }
        return insertAmount;
    }

    private int insertAmount(ItemStack stack, ItemAttachment ia, InventoryRange range) {
        int filter = this.filterCount(ia, stack);
        if (filter == 0) {
            return 0;
        }
        int fit = InventoryUtils.getInsertibleQuantity((InventoryRange)range, (ItemStack)stack);
        if (fit == 0) {
            return 0;
        }
        if (ia.regulate && filter > 0) {
            fit = Math.min(fit, filter - this.countMatchingStacks(range, stack, true));
        }
        return fit > 0 ? fit : 0;
    }

    private int extractAmount(ItemStack stack, ItemAttachment ia, InventoryRange range) {
        int qty;
        int filter = this.filterCount(ia, stack);
        if (filter == 0) {
            return ia.regulate ? stack.func_77976_d() : 0;
        }
        int n = qty = filter < 0 ? stack.func_77976_d() : filter;
        if (ia.regulate && filter > 0) {
            qty = Math.min(qty, this.countMatchingStacks(range, stack, false) - filter);
        }
        return qty > 0 ? qty : 0;
    }

    @Override
    public void handlePacket(PacketCustom packet) {
        if (packet.getType() == 2) {
            this.movingItems.add(new MovingItem(packet));
        } else {
            super.handlePacket(packet);
        }
    }

    @Override
    public int strongPowerLevel(EnumFacing facing) {
        ItemAttachment ia = (ItemAttachment)this.attachments[facing.ordinal() ^ 1];
        if (ia != null && ia.a_powering) {
            return 15;
        }
        return 0;
    }

    public class MovingItem {
        public int src;
        public int dst;
        public ItemStack stack;
        public double a_progress;
        public double b_progress;

        public MovingItem(PacketCustom packet) {
            short b = packet.readUByte();
            this.src = b >> 4;
            this.dst = b & 0xF;
            this.stack = packet.readItemStack();
        }

        public boolean update() {
            if (this.a_progress >= 1.0) {
                return true;
            }
            this.b_progress = this.a_progress;
            this.a_progress = MathHelper.approachLinear((double)this.a_progress, (double)1.0, (double)0.2);
            return false;
        }
    }

    public class ItemAttachment
    extends TileTranslocator.Attachment {
        boolean regulate;
        boolean a_powering;
        boolean signal;
        ItemStack[] filters;

        public ItemAttachment(int side) {
            super(TileItemTranslocator.this, side);
            this.regulate = false;
            this.a_powering = false;
            this.signal = false;
            this.filters = new ItemStack[9];
        }

        public void setPowering(boolean b) {
            if ((this.signal || !b) && b != this.a_powering) {
                this.a_powering = b;
                BlockPos pos = new BlockPos((Vec3i)TileItemTranslocator.this.func_174877_v());
                TileItemTranslocator.this.field_145850_b.func_175685_c(pos, (Block)Blocks.field_150488_af);
                pos.func_177972_a(EnumFacing.field_82609_l[this.side]);
                TileItemTranslocator.this.field_145850_b.func_175685_c(pos, (Block)Blocks.field_150488_af);
                this.markUpdate();
            }
        }

        @Override
        public boolean activate(EntityPlayer player, int subPart) {
            ItemStack held = player.field_71071_by.func_70448_g();
            if (held == null) {
                return super.activate(player, subPart);
            }
            if (ItemUtils.areStacksSameType((ItemStack)held, (ItemStack)ConfigurationHandler.nugget) && !this.regulate) {
                this.regulate = true;
                if (!player.field_71075_bZ.field_75098_d) {
                    --held.field_77994_a;
                }
                this.markUpdate();
                return true;
            }
            if (held.func_77973_b() == Items.field_151042_j && !this.signal) {
                this.signal = true;
                if (!player.field_71075_bZ.field_75098_d) {
                    --held.field_77994_a;
                }
                this.markUpdate();
                return true;
            }
            return super.activate(player, subPart);
        }

        @Override
        public void stripModifiers() {
            super.stripModifiers();
            if (this.regulate) {
                this.regulate = false;
                TileItemTranslocator.this.dropItem(ItemUtils.copyStack((ItemStack)ConfigurationHandler.nugget, (int)1));
            }
            if (this.signal) {
                this.setPowering(false);
                this.signal = false;
                TileItemTranslocator.this.dropItem(new ItemStack(Items.field_151042_j));
            }
        }

        @Override
        public Collection<ItemStack> getDrops(IBlockState state) {
            Collection<ItemStack> stuff = super.getDrops(state);
            if (this.regulate) {
                stuff.add(ItemUtils.copyStack((ItemStack)ConfigurationHandler.nugget, (int)1));
            }
            if (this.signal) {
                stuff.add(new ItemStack(Items.field_151042_j));
            }
            return stuff;
        }

        @Override
        public int getIconIndex() {
            int i = super.getIconIndex();
            if (this.regulate) {
                i |= 8;
            }
            if (this.signal) {
                i |= this.a_powering ? 32 : 16;
            }
            return i;
        }

        @Override
        public void openGui(EntityPlayer player) {
            this.openItemGui(player, this.filters, this.regulate ? "translocator.regulate" : "translocator.filter");
        }

        private void openItemGui(EntityPlayer player, ItemStack[] filters, final String string) {
            ServerUtils.openSMPContainer((EntityPlayerMP)((EntityPlayerMP)player), (Container)new ContainerItemTranslocator(new InventorySimple(filters, this.filterStackLimit()){

                public void func_70296_d() {
                    ItemAttachment.this.markUpdate();
                }
            }, player.field_71071_by), (IGuiPacketSender)new IGuiPacketSender(){

                public void sendPacket(EntityPlayerMP player, int windowId) {
                    PacketCustom packet = new PacketCustom(TranslocatorSPH.channel, 4);
                    packet.writeByte(windowId);
                    packet.writeShort(ItemAttachment.this.filterStackLimit());
                    packet.writeString(string);
                    packet.sendToPlayer((EntityPlayer)player);
                }
            });
        }

        private int filterStackLimit() {
            if (this.regulate) {
                return 65535;
            }
            if (this.fast) {
                return 64;
            }
            return 1;
        }

        @Override
        public void read(NBTTagCompound tag) {
            super.read(tag);
            this.regulate = tag.func_74767_n("regulate");
            this.signal = tag.func_74767_n("signal");
            this.a_powering = tag.func_74767_n("powering");
            InventoryUtils.readItemStacksFromTag((ItemStack[])this.filters, (NBTTagList)tag.func_150295_c("filters", 10));
        }

        @Override
        public NBTTagCompound write(NBTTagCompound tag) {
            tag.func_74757_a("regulate", this.regulate);
            tag.func_74757_a("signal", this.signal);
            tag.func_74757_a("powering", this.a_powering);
            tag.func_74782_a("filters", (NBTBase)InventoryUtils.writeItemStacksToTag((ItemStack[])this.filters, (int)65536));
            return super.write(tag);
        }

        @Override
        public void read(MCDataInput packet, boolean described) {
            super.read(packet, described);
            this.regulate = packet.readBoolean();
            this.signal = packet.readBoolean();
            this.a_powering = packet.readBoolean();
        }

        @Override
        public void write(MCDataOutput packet) {
            super.write(packet);
            packet.writeBoolean(this.regulate);
            packet.writeBoolean(this.signal);
            packet.writeBoolean(this.a_powering);
        }
    }
}

