/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocator.tile;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.packet.ICustomPacketTile;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.raytracer.ICuboidProvider;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.translocator.network.TranslocatorSPH;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileCraftingGrid
extends TileEntity
implements ICustomPacketTile,
ITickable,
ICuboidProvider {
    public ItemStack[] items = new ItemStack[9];
    public ItemStack result = null;
    public int rotation = 0;
    public int timeout = 400;

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("items", (NBTBase)InventoryUtils.writeItemStacksToTag((ItemStack[])this.items));
        tag.func_74768_a("timeout", this.timeout);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        InventoryUtils.readItemStacksFromTag((ItemStack[])this.items, (NBTTagList)tag.func_150295_c("items", 10));
        this.timeout = tag.func_74762_e("timeout");
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            --this.timeout;
            if (this.timeout == 0) {
                this.dropItems();
                this.field_145850_b.func_175698_g(this.func_174877_v());
            }
        }
    }

    public void dropItems() {
        Vector3 drop = Vector3.fromTileCenter((TileEntity)this);
        for (ItemStack item : this.items) {
            if (item == null) continue;
            InventoryUtils.dropItem((ItemStack)item, (World)this.field_145850_b, (Vector3)drop);
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        PacketCustom packet = new PacketCustom(TranslocatorSPH.channel, 3);
        this.writeToPacket((MCDataOutput)packet);
        return packet.toTilePacket(this.func_174877_v());
    }

    public NBTTagCompound func_189517_E_() {
        PacketCustom packet = new PacketCustom(TranslocatorSPH.channel, 3);
        this.writeToPacket((MCDataOutput)packet);
        return packet.toNBTTag(super.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromPacket((MCDataInput)PacketCustom.fromTilePacket((SPacketUpdateTileEntity)pkt));
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.readFromPacket((MCDataInput)PacketCustom.fromNBTTag((NBTTagCompound)tag));
    }

    public void writeToPacket(MCDataOutput packet) {
        packet.writeByte(this.rotation);
        for (ItemStack item : this.items) {
            packet.writeItemStack(item);
        }
    }

    public void readFromPacket(MCDataInput packet) {
        this.rotation = packet.readUByte();
        for (int i = 0; i < 9; ++i) {
            this.items[i] = packet.readItemStack();
        }
        this.updateResult();
    }

    public void activate(int subHit, EntityPlayer player) {
        ItemStack held = player.field_71071_by.func_70448_g();
        if (held == null) {
            if (this.items[subHit] != null) {
                this.giveOrDropItem(this.items[subHit], player);
            }
            this.items[subHit] = null;
        } else if (!InventoryUtils.areStacksIdentical((ItemStack)held, (ItemStack)this.items[subHit])) {
            ItemStack old = this.items[subHit];
            this.items[subHit] = InventoryUtils.copyStack((ItemStack)held, (int)1);
            player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
            if (old != null) {
                this.giveOrDropItem(old, player);
            }
        }
        this.timeout = 2400;
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
        this.func_70296_d();
    }

    private void updateResult() {
        InventoryCrafting craftMatrix = this.getCraftMatrix();
        for (int i = 0; i < 4; ++i) {
            ItemStack mresult = CraftingManager.func_77594_a().func_82787_a(craftMatrix, this.field_145850_b);
            if (mresult != null) {
                this.result = mresult;
                return;
            }
            this.rotateItems(craftMatrix);
        }
        this.result = null;
    }

    private void giveOrDropItem(ItemStack stack, EntityPlayer player) {
        if (player.field_71071_by.func_70441_a(stack)) {
            player.field_71069_bz.func_75142_b();
        } else {
            InventoryUtils.dropItem((ItemStack)stack, (World)this.field_145850_b, (Vector3)Vector3.fromTileCenter((TileEntity)this));
        }
    }

    public void craft(EntityPlayer player) {
        InventoryCrafting craftMatrix = this.getCraftMatrix();
        for (int i = 0; i < 4; ++i) {
            ItemStack mresult = CraftingManager.func_77594_a().func_82787_a(craftMatrix, this.field_145850_b);
            if (mresult != null) {
                this.doCraft(mresult, craftMatrix, player);
                break;
            }
            this.rotateItems(craftMatrix);
        }
        player.func_184609_a(EnumHand.MAIN_HAND);
        this.dropItems();
        this.field_145850_b.func_175698_g(this.func_174877_v());
    }

    private InventoryCrafting getCraftMatrix() {
        InventoryCrafting craftMatrix = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer entityplayer) {
                return true;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            craftMatrix.func_70299_a(i, this.items[i]);
        }
        return craftMatrix;
    }

    private void doCraft(ItemStack mresult, InventoryCrafting craftMatrix, EntityPlayer player) {
        this.giveOrDropItem(mresult, player);
        FMLCommonHandler.instance().firePlayerCraftingEvent(player, mresult, (IInventory)craftMatrix);
        mresult.func_77980_a(this.field_145850_b, player, mresult.field_77994_a);
        for (int slot = 0; slot < 9; ++slot) {
            ItemStack container;
            ItemStack stack = craftMatrix.func_70301_a(slot);
            if (stack == null) continue;
            craftMatrix.func_70298_a(slot, 1);
            if (!stack.func_77973_b().hasContainerItem(stack) || (container = stack.func_77973_b().getContainerItem(stack)) == null) continue;
            if (container.func_77984_f() && container.func_77952_i() > container.func_77958_k()) {
                container = null;
            }
            craftMatrix.func_70299_a(slot, container);
        }
        for (int i = 0; i < 9; ++i) {
            this.items[i] = craftMatrix.func_70301_a(i);
        }
    }

    private void rotateItems(InventoryCrafting inv) {
        int i;
        int[] slots = new int[]{0, 1, 2, 5, 8, 7, 6, 3};
        ItemStack[] arrangement = new ItemStack[9];
        arrangement[4] = inv.func_70301_a(4);
        for (i = 0; i < 8; ++i) {
            arrangement[slots[(i + 2) % 8]] = inv.func_70301_a(slots[i]);
        }
        for (i = 0; i < 9; ++i) {
            inv.func_70299_a(i, arrangement[i]);
        }
    }

    public void onPlaced(EntityLivingBase entity) {
        this.rotation = (int)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5) & 3;
    }

    public List<IndexedCuboid6> getIndexedCuboids() {
        LinkedList<IndexedCuboid6> parts = new LinkedList<IndexedCuboid6>();
        parts.add(new IndexedCuboid6((Object)0, new Cuboid6(0.0, 0.0, 0.0, 1.0, 0.005, 1.0)));
        for (int i = 0; i < 9; ++i) {
            Cuboid6 box = new Cuboid6(0.0625, 0.0, 0.0625, 0.3125, 0.01, 0.3125).apply((Transformation)new Translation((double)(i % 3 * 5) / 16.0, 0.0, (double)(i / 3 * 5) / 16.0).with(Rotation.quarterRotations[this.rotation].at(Vector3.center)));
            parts.add(new IndexedCuboid6((Object)(i + 1), box));
        }
        return parts;
    }
}

