/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocator.block;

import codechicken.lib.block.property.PropertyString;
import codechicken.lib.math.MathHelper;
import codechicken.lib.raytracer.ICuboidProvider;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.translocator.reference.VariantReference;
import codechicken.translocator.tile.TileItemTranslocator;
import codechicken.translocator.tile.TileLiquidTranslocator;
import codechicken.translocator.tile.TileTranslocator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class BlockTranslocator
extends Block {
    private static final PropertyString VARIANTS = new PropertyString("type", VariantReference.translocatorNamesList);

    public BlockTranslocator() {
        super(Material.field_151573_f);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
    }

    public boolean hasTileEntity(IBlockState state) {
        return this.func_176201_c(state) < 2;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        switch (this.func_176201_c(state)) {
            case 0: {
                return new TileItemTranslocator();
            }
            case 1: {
                return new TileLiquidTranslocator();
            }
        }
        return null;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public static boolean canExistOnSide(World world, BlockPos pos, EnumFacing side, int meta) {
        TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(side));
        switch (meta) {
            case 0: {
                return tileEntity instanceof IInventory;
            }
            case 1: {
                return tileEntity != null && tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d());
            }
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn) {
        TileTranslocator ttrans = (TileTranslocator)world.func_175625_s(pos);
        int meta = this.func_176201_c(state);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (ttrans.attachments[facing.ordinal()] != null && !BlockTranslocator.canExistOnSide(world, pos, facing, meta) && ttrans.harvestPart(facing.ordinal(), true)) break;
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        RayTraceResult hit = RayTracer.retraceBlock((World)world, (EntityPlayer)player, (BlockPos)pos);
        if (hit == null) {
            return false;
        }
        TileTranslocator ttrans = (TileTranslocator)world.func_175625_s(pos);
        return ttrans.harvestPart(hit.subHit % 6, !player.field_71075_bZ.field_75098_d);
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return 0;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ai = new ArrayList<ItemStack>();
        TileTranslocator ttrans = (TileTranslocator)world.func_175625_s(pos);
        if (ttrans != null) {
            for (TileTranslocator.Attachment a : ttrans.attachments) {
                if (a == null) continue;
                ai.addAll(a.getDrops(state));
            }
        }
        return ai;
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World world, BlockPos pos, Vec3d start, Vec3d end) {
        ICuboidProvider provider = (ICuboidProvider)world.func_175625_s(pos);
        if (provider != null) {
            return RayTracer.rayTraceCuboidsClosest((Vec3d)start, (Vec3d)end, (List)provider.getIndexedCuboids(), (BlockPos)pos);
        }
        return super.func_180636_a(blockState, world, pos, start, end);
    }

    public List<IndexedCuboid6> getParts(World world, BlockPos pos) {
        TileTranslocator tile = (TileTranslocator)world.func_175625_s(pos);
        if (tile == null) {
            return null;
        }
        LinkedList<IndexedCuboid6> cuboids = new LinkedList<IndexedCuboid6>();
        tile.addTraceableCuboids(cuboids);
        return cuboids;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn) {
        ICuboidProvider provider = (ICuboidProvider)world.func_175625_s(pos);
        if (provider != null) {
            for (IndexedCuboid6 cb : provider.getIndexedCuboids()) {
                AxisAlignedBB aabb = cb.aabb();
                if (!aabb.func_72326_a(entityBox)) continue;
                collidingBoxes.add(aabb);
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        RayTraceResult hit = RayTracer.retraceBlock((World)world, (EntityPlayer)player, (BlockPos)pos);
        TileTranslocator ttrans = (TileTranslocator)world.func_175625_s(pos);
        if (hit != null && ttrans != null) {
            if (hit.subHit < 6) {
                Vector3 vhit = new Vector3(hit.field_72307_f);
                vhit.add((double)(-pos.func_177958_n()) - 0.5, (double)(-pos.func_177956_o()) - 0.5, (double)(-pos.func_177952_p()) - 0.5);
                vhit.apply((Transformation)Rotation.sideRotations[hit.subHit % 6].inverse());
                if (MathHelper.between((double)-0.125, (double)vhit.x, (double)0.125) && MathHelper.between((double)-0.125, (double)vhit.z, (double)0.125)) {
                    hit.subHit += 6;
                }
            }
            return ttrans.attachments[hit.subHit % 6].activate(player, hit.subHit / 6);
        }
        return false;
    }

    public void func_149666_a(Item item, CreativeTabs creativeTab, List<ItemStack> list) {
        list.add(new ItemStack((Block)this, 1, 0));
        list.add(new ItemStack((Block)this, 1, 1));
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileTranslocator ttrans = (TileTranslocator)world.func_175625_s(pos);
        return ttrans != null && ttrans.connectRedstone();
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileTranslocator ttrans = (TileTranslocator)world.func_175625_s(pos);
        return ttrans.strongPowerLevel(side);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANTS});
    }

    public int func_176201_c(IBlockState state) {
        return VariantReference.translocatorNamesList.indexOf((Object)String.valueOf(state.func_177229_b((IProperty)VARIANTS)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176194_O().func_177621_b().func_177226_a((IProperty)VARIANTS, (Comparable)VariantReference.translocatorNamesList.get(meta));
    }
}

