/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.item;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.CyberwareUpdateEvent;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.EnableDisableHelper;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.api.item.IMenuItem;
import flaxbeard.cyberware.common.item.ItemCyberware;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ItemLowerOrgansUpgrade
extends ItemCyberware
implements IMenuItem {
    private static Map<Integer, Collection<PotionEffect>> potions = new HashMap<Integer, Collection<PotionEffect>>();
    private static final float[] f = new float[]{1.0f, 0.0f, 0.0f};

    public ItemLowerOrgansUpgrade(String name, ICyberware.EnumSlot slot, String[] subnames) {
        super(name, slot, subnames);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void handleEatFoodTick(LivingEntityUseItemEvent.Tick event) {
        EntityLivingBase e = event.getEntityLiving();
        ItemStack stack = event.getItem();
        if (e instanceof EntityPlayer && CyberwareAPI.hasCapability((Entity)e) && stack != null && (stack.func_77973_b().func_77661_b(stack) == EnumAction.EAT || stack.func_77973_b().func_77661_b(stack) == EnumAction.DRINK)) {
            EntityPlayer p = (EntityPlayer)e;
            ICyberwareUserData cyberware = CyberwareAPI.getCapability((Entity)e);
            if (CyberwareAPI.isCyberwareInstalled((Entity)p, new ItemStack((Item)this, 1, 0))) {
                potions.put(p.func_145782_y(), new ArrayList(p.func_70651_bq()));
            }
        }
    }

    @SubscribeEvent
    public void handleEatFoodEnd(LivingEntityUseItemEvent.Finish event) {
        EntityLivingBase e = event.getEntityLiving();
        ItemStack stack = event.getItem();
        if (e instanceof EntityPlayer && CyberwareAPI.hasCapability((Entity)e) && stack != null && (stack.func_77973_b().func_77661_b(stack) == EnumAction.EAT || stack.func_77973_b().func_77661_b(stack) == EnumAction.DRINK)) {
            EntityPlayer p = (EntityPlayer)e;
            ICyberwareUserData cyberware = CyberwareAPI.getCapability((Entity)e);
            if (CyberwareAPI.isCyberwareInstalled((Entity)p, new ItemStack((Item)this, 1, 0))) {
                ArrayList toRemove = new ArrayList(p.func_70651_bq());
                for (PotionEffect pE : toRemove) {
                    if (!pE.func_188419_a().func_76398_f()) continue;
                    p.func_184589_d(pE.func_188419_a());
                }
                ArrayList toAdd = potions.keySet().contains(p.func_145782_y()) ? potions.get(p.func_145782_y()) : new ArrayList();
                block1: for (PotionEffect add : toAdd) {
                    for (PotionEffect removed : toRemove) {
                        if (removed.func_188419_a() != add.func_188419_a()) continue;
                        p.func_70690_d(add);
                        continue block1;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void power(CyberwareUpdateEvent event) {
        ItemStack test2;
        ItemStack test;
        EntityLivingBase e = event.getEntityLiving();
        if (CyberwareAPI.isCyberwareInstalled((Entity)e, test = new ItemStack((Item)this, 1, 1)) && EnableDisableHelper.isEnabled(CyberwareAPI.getCyberware((Entity)e, test))) {
            ItemStack stack = CyberwareAPI.getCyberware((Entity)e, test);
            ICyberwareUserData cyberware = CyberwareAPI.getCapability((Entity)e);
            if (e.field_70173_aa % 20 == 0 && !cyberware.isAtCapacity(test, this.getPowerProduction(stack))) {
                if (e instanceof EntityPlayer) {
                    EntityPlayer p = (EntityPlayer)e;
                    if (p.func_71024_bL().func_75116_a() > 0 || p.func_184812_l_()) {
                        int toRemove = this.getTicksTilRemove(stack);
                        if (!p.func_184812_l_() && toRemove <= 0) {
                            p.func_71024_bL().func_75114_a(p.func_71024_bL().func_75116_a() - 1);
                            toRemove = 54;
                        } else if (toRemove > 0) {
                            --toRemove;
                        }
                        CyberwareAPI.getCyberwareNBT(stack).func_74768_a("toRemove", toRemove);
                        cyberware.addPower(this.getPowerProduction(test), test);
                    }
                } else {
                    cyberware.addPower(this.getPowerProduction(test) / 10, test);
                }
            }
        }
        if (CyberwareAPI.isCyberwareInstalled((Entity)e, test2 = new ItemStack((Item)this, 1, 3))) {
            ItemStack stack = CyberwareAPI.getCyberware((Entity)e, test2);
            ICyberwareUserData cyberware = CyberwareAPI.getCapability((Entity)e);
            boolean wasBelow = this.wasBelow(stack);
            boolean isBelow = false;
            if (e.func_110138_aP() > 8.0f && e.func_110143_aJ() < 8.0f) {
                isBelow = true;
                if (!wasBelow && cyberware.usePower(stack, this.getPowerConsumption(stack), false)) {
                    e.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 600, 0, true, false));
                    e.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 600, 0, true, false));
                }
            }
            CyberwareAPI.getCyberwareNBT(stack).func_74757_a("wasBelow", isBelow);
        }
    }

    private int getTicksTilRemove(ItemStack stack) {
        NBTTagCompound data = CyberwareAPI.getCyberwareNBT(stack);
        if (!data.func_74764_b("toRemove")) {
            data.func_74768_a("toRemove", 54);
        }
        return data.func_74762_e("toRemove");
    }

    private boolean wasBelow(ItemStack stack) {
        NBTTagCompound data = CyberwareAPI.getCyberwareNBT(stack);
        if (!data.func_74764_b("toRemove")) {
            data.func_74757_a("wasBelow", false);
        }
        return data.func_74767_n("wasBelow");
    }

    @Override
    public int getCapacity(ItemStack wareStack) {
        return wareStack.func_77952_i() == 1 ? 25 : (wareStack.func_77952_i() == 2 ? 3000 * wareStack.field_77994_a : 0);
    }

    @Override
    public int installedStackSize(ItemStack stack) {
        return stack.func_77952_i() == 2 ? 4 : 1;
    }

    @Override
    public int getPowerProduction(ItemStack stack) {
        return stack.func_77952_i() == 1 ? 25 : 0;
    }

    @Override
    public int getPowerConsumption(ItemStack stack) {
        return stack.func_77952_i() == 3 ? 150 : 0;
    }

    @Override
    protected int getUnmodifiedEssenceCost(ItemStack stack) {
        if (stack.func_77952_i() == 2) {
            switch (stack.field_77994_a) {
                case 1: {
                    return 5;
                }
                case 2: {
                    return 7;
                }
                case 3: {
                    return 9;
                }
                case 4: {
                    return 11;
                }
            }
        }
        return super.getUnmodifiedEssenceCost(stack);
    }

    @Override
    public boolean hasMenu(ItemStack stack) {
        return stack.func_77952_i() == 1;
    }

    @Override
    public void use(Entity e, ItemStack stack) {
        EnableDisableHelper.toggle(stack);
    }

    @Override
    public String getUnlocalizedLabel(ItemStack stack) {
        if (stack.func_77952_i() == 4) {
            return "cyberware.gui.active.zoom";
        }
        return EnableDisableHelper.getUnlocalizedLabel(stack);
    }

    @Override
    public float[] getColor(ItemStack stack) {
        return (float[])(EnableDisableHelper.isEnabled(stack) ? f : null);
    }
}

