/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.item;

import com.mojang.realmsclient.gui.ChatFormatting;
import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.api.item.ICyberwareTabItem;
import flaxbeard.cyberware.api.item.IDeconstructable;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.item.ItemCyberwareBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCyberware
extends ItemCyberwareBase
implements ICyberware,
ICyberwareTabItem,
IDeconstructable {
    private ICyberware.EnumSlot[] slots;
    private int[] essence;
    private ItemStack[][] components;

    public ItemCyberware(String name, ICyberware.EnumSlot[] slots, String[] subnames) {
        super(name, subnames);
        this.slots = slots;
        this.essence = new int[subnames.length + 1];
        this.components = new ItemStack[0][0];
    }

    public ItemCyberware(String name, ICyberware.EnumSlot slot, String[] subnames) {
        this(name, new ICyberware.EnumSlot[]{slot}, subnames);
    }

    public ItemCyberware(String name, ICyberware.EnumSlot slot) {
        this(name, slot, new String[0]);
    }

    public ItemCyberware setWeights(int ... weight) {
        for (int meta = 0; meta < weight.length; ++meta) {
            int installedStackSize;
            ItemStack stack = new ItemStack((Item)this, 1, meta);
            stack.field_77994_a = installedStackSize = this.installedStackSize(stack);
            this.setQuality(stack, CyberwareAPI.QUALITY_SCAVENGED);
            CyberwareContent.zombieItems.add(new CyberwareContent.ZombieItem(weight[meta], stack));
        }
        return this;
    }

    public ItemCyberware setEssenceCost(int ... essence) {
        this.essence = essence;
        return this;
    }

    public ItemCyberware setComponents(ItemStack[] ... components) {
        this.components = components;
        return this;
    }

    @Override
    public int getEssenceCost(ItemStack stack) {
        int cost = this.getUnmodifiedEssenceCost(stack);
        if (this.getQuality(stack) == CyberwareAPI.QUALITY_SCAVENGED) {
            float half = (float)cost / 2.0f;
            cost = cost > 0 ? (cost += (int)Math.ceil(half)) : (cost -= (int)Math.ceil(half));
        }
        return cost;
    }

    protected int getUnmodifiedEssenceCost(ItemStack stack) {
        return this.essence[Math.min(this.subnames.length, stack.func_77952_i())];
    }

    @Override
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        if (this.subnames.length == 0) {
            list.add(new ItemStack((Item)this));
        }
        for (int i = 0; i < this.subnames.length; ++i) {
            list.add(new ItemStack((Item)this, 1, i));
        }
    }

    @Override
    public ICyberware.EnumSlot getSlot(ItemStack stack) {
        return this.slots[Math.min(this.slots.length - 1, stack.func_77952_i())];
    }

    @Override
    public int installedStackSize(ItemStack stack) {
        return 1;
    }

    @Override
    public boolean isIncompatible(ItemStack stack, ItemStack other) {
        return false;
    }

    @Override
    public boolean isEssential(ItemStack stack) {
        return false;
    }

    @Override
    public List<String> getInfo(ItemStack stack) {
        ArrayList<String> ret = new ArrayList<String>();
        List<String> desc = this.getDesciption(stack);
        if (desc != null && desc.size() > 0) {
            ret.addAll(desc);
        }
        return ret;
    }

    public List<String> getStackDesc(ItemStack stack) {
        String[] toReturnArray = I18n.func_135052_a((String)("cyberware.tooltip." + this.getRegistryName().toString().substring(10) + (this.subnames.length > 0 ? "." + stack.func_77952_i() : "")), (Object[])new Object[0]).split("\\\\n");
        ArrayList<String> toReturn = new ArrayList<String>(Arrays.asList(toReturnArray));
        if (toReturn.size() > 0 && ((String)toReturn.get(0)).length() == 0) {
            toReturn.remove(0);
        }
        return toReturn;
    }

    public List<String> getDesciption(ItemStack stack) {
        List<String> toReturn = this.getStackDesc(stack);
        if (this.installedStackSize(stack) > 1) {
            toReturn.add(ChatFormatting.BLUE + I18n.func_135052_a((String)"cyberware.tooltip.maxInstall", (Object[])new Object[]{this.installedStackSize(stack)}));
        }
        boolean hasPowerConsumption = false;
        String toAddPowerConsumption = "";
        for (int i = 0; i < this.installedStackSize(stack); ++i) {
            ItemStack temp = stack.func_77946_l();
            temp.field_77994_a = i + 1;
            int cost = this.getPowerConsumption(temp);
            if (cost > 0) {
                hasPowerConsumption = true;
            }
            if (i != 0) {
                toAddPowerConsumption = toAddPowerConsumption + I18n.func_135052_a((String)"cyberware.tooltip.joiner", (Object[])new Object[0]);
            }
            toAddPowerConsumption = toAddPowerConsumption + " " + cost;
        }
        if (hasPowerConsumption) {
            String toTranslate = this.hasCustomPowerMessage(stack) ? "cyberware.tooltip." + this.getRegistryName().toString().substring(10) + (this.subnames.length > 0 ? "." + stack.func_77952_i() : "") + ".powerConsumption" : "cyberware.tooltip.powerConsumption";
            toReturn.add(ChatFormatting.GREEN + I18n.func_135052_a((String)toTranslate, (Object[])new Object[]{toAddPowerConsumption}));
        }
        boolean hasPowerProduction = false;
        String toAddPowerProduction = "";
        for (int i = 0; i < this.installedStackSize(stack); ++i) {
            ItemStack temp = stack.func_77946_l();
            temp.field_77994_a = i + 1;
            int cost = this.getPowerProduction(temp);
            if (cost > 0) {
                hasPowerProduction = true;
            }
            if (i != 0) {
                toAddPowerProduction = toAddPowerProduction + I18n.func_135052_a((String)"cyberware.tooltip.joiner", (Object[])new Object[0]);
            }
            toAddPowerProduction = toAddPowerProduction + " " + cost;
        }
        if (hasPowerProduction) {
            String toTranslate = this.hasCustomPowerMessage(stack) ? "cyberware.tooltip." + this.getRegistryName().toString().substring(10) + (this.subnames.length > 0 ? "." + stack.func_77952_i() : "") + ".powerProduction" : "cyberware.tooltip.powerProduction";
            toReturn.add(ChatFormatting.GREEN + I18n.func_135052_a((String)toTranslate, (Object[])new Object[]{toAddPowerProduction}));
        }
        if (this.getCapacity(stack) > 0) {
            String toTranslate = this.hasCustomCapacityMessage(stack) ? "cyberware.tooltip." + this.getRegistryName().toString().substring(10) + (this.subnames.length > 0 ? "." + stack.func_77952_i() : "") + ".capacity" : "cyberware.tooltip.capacity";
            toReturn.add(ChatFormatting.GREEN + I18n.func_135052_a((String)toTranslate, (Object[])new Object[]{this.getCapacity(stack)}));
        }
        boolean hasEssenceCost = false;
        boolean essenceCostNegative = true;
        String toAddEssence = "";
        for (int i = 0; i < this.installedStackSize(stack); ++i) {
            ItemStack temp = stack.func_77946_l();
            temp.field_77994_a = i + 1;
            int cost = this.getEssenceCost(temp);
            if (cost != 0) {
                hasEssenceCost = true;
            }
            if (cost < 0) {
                essenceCostNegative = false;
            }
            if (i != 0) {
                toAddEssence = toAddEssence + I18n.func_135052_a((String)"cyberware.tooltip.joiner", (Object[])new Object[0]);
            }
            toAddEssence = toAddEssence + " " + Math.abs(cost);
        }
        if (hasEssenceCost) {
            toReturn.add(ChatFormatting.DARK_PURPLE + I18n.func_135052_a((String)(essenceCostNegative ? "cyberware.tooltip.essence" : "cyberware.tooltip.essenceAdd"), (Object[])new Object[]{toAddEssence}));
        }
        return toReturn;
    }

    public int getPowerConsumption(ItemStack stack) {
        return 0;
    }

    public int getPowerProduction(ItemStack stack) {
        return 0;
    }

    public boolean hasCustomPowerMessage(ItemStack stack) {
        return false;
    }

    public boolean hasCustomCapacityMessage(ItemStack stack) {
        return false;
    }

    @Override
    public ItemStack[][] required(ItemStack stack) {
        return new ItemStack[0][0];
    }

    @Override
    public ICyberwareTabItem.EnumCategory getCategory(ItemStack stack) {
        return ICyberwareTabItem.EnumCategory.values()[this.getSlot(stack).ordinal()];
    }

    @Override
    public int getCapacity(ItemStack wareStack) {
        return 0;
    }

    @Override
    public void onAdded(EntityLivingBase entity, ItemStack stack) {
    }

    @Override
    public void onRemoved(EntityLivingBase entity, ItemStack stack) {
    }

    @Override
    public boolean canDestroy(ItemStack stack) {
        return stack.func_77952_i() < this.components.length;
    }

    @Override
    public ItemStack[] getComponents(ItemStack stack) {
        return this.components[Math.min(this.components.length - 1, stack.func_77952_i())];
    }

    @Override
    public ICyberware.Quality getQuality(ItemStack stack) {
        ICyberware.Quality q = CyberwareAPI.getQualityTag(stack);
        if (q == null) {
            return CyberwareAPI.QUALITY_MANUFACTURED;
        }
        return q;
    }

    @Override
    public ItemStack setQuality(ItemStack stack, ICyberware.Quality quality) {
        if (quality == CyberwareAPI.QUALITY_MANUFACTURED) {
            if (stack != null && stack.func_77942_o()) {
                stack.func_77978_p().func_82580_o("cyberwareQuality");
                if (stack.func_77978_p().func_82582_d()) {
                    stack.func_77982_d(null);
                }
            }
            return stack;
        }
        return this.canHoldQuality(stack, quality) ? CyberwareAPI.writeQualityTag(stack, quality) : stack;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        ICyberware.Quality q = this.getQuality(stack);
        if (q != null && q.getNameModifier() != null) {
            return I18n.func_135052_a((String)q.getNameModifier(), (Object[])new Object[]{("" + I18n.func_135052_a((String)(this.func_77657_g(stack) + ".name"), (Object[])new Object[0])).trim()}).trim();
        }
        return ("" + I18n.func_135052_a((String)(this.func_77657_g(stack) + ".name"), (Object[])new Object[0])).trim();
    }

    @Override
    public boolean canHoldQuality(ItemStack stack, ICyberware.Quality quality) {
        return true;
    }
}

