/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.entity;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.CyberwareUserDataImpl;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.common.CyberwareConfig;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.handler.CyberwareDataHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class EntityCyberZombie
extends EntityZombie {
    private static final DataParameter<Integer> CYBER_VARIANT = EntityDataManager.func_187226_a(EntityCyberZombie.class, (DataSerializer)DataSerializers.field_187192_b);
    public boolean hasWare = false;
    private CyberwareUserDataImpl cyberware = new CyberwareUserDataImpl();

    public EntityCyberZombie(World worldIn) {
        super(worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CYBER_VARIANT, (Object)0);
    }

    public boolean func_82231_m() {
        return false;
    }

    public void func_70636_d() {
        if (!this.hasWare && !this.field_70170_p.field_72995_K) {
            if (!this.isBrute() && this.field_70170_p.field_73012_v.nextFloat() < 0.05f) {
                this.setBrute();
            }
            CyberwareDataHandler.addRandomCyberware(this, this.isBrute());
            if (this.isBrute()) {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("Brute Bonus", 6.0, 0));
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(new AttributeModifier("Brute Bonus", 1.0, 0));
            }
            this.func_70606_j(this.func_110138_aP());
            this.hasWare = true;
        }
        if (this.isBrute() && this.field_70131_O != 2.3400002f) {
            this.setSizeNormal(0.72f, 2.3400002f);
        }
        super.func_70636_d();
    }

    protected void setSizeNormal(float width, float height) {
        if (width != this.field_70130_N || height != this.field_70131_O) {
            float f = this.field_70130_N;
            this.field_70130_N = width;
            this.field_70131_O = height;
            AxisAlignedBB axisalignedbb = this.func_174813_aQ();
            this.func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + (double)this.field_70130_N, axisalignedbb.field_72338_b + (double)this.field_70131_O, axisalignedbb.field_72339_c + (double)this.field_70130_N));
            if (this.field_70130_N > f && !this.field_70148_d && !this.field_70170_p.field_72995_K) {
                this.func_70091_d(f - this.field_70130_N, 0.0, f - this.field_70130_N);
            }
        }
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        compound = super.func_189511_e(compound);
        compound.func_74757_a("hasRandomWare", this.hasWare);
        compound.func_74757_a("brute", this.isBrute());
        if (this.hasWare) {
            NBTTagCompound comp = this.cyberware.serializeNBT();
            compound.func_74782_a("ware", (NBTBase)comp);
        }
        return compound;
    }

    public void func_70020_e(NBTTagCompound compound) {
        super.func_70020_e(compound);
        boolean brute = compound.func_74767_n("brute");
        if (brute) {
            this.setBrute();
        }
        this.hasWare = compound.func_74767_n("hasRandomWare");
        if (compound.func_74764_b("ware")) {
            this.cyberware.deserializeNBT(compound.func_74775_l("ware"));
        }
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CyberwareAPI.CYBERWARE_CAPABILITY) {
            return (T)this.cyberware;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CyberwareAPI.CYBERWARE_CAPABILITY || super.hasCapability(capability, facing);
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
        super.func_82160_b(wasRecentlyHit, lootingModifier);
        if (CyberwareConfig.KATANA && !CyberwareConfig.NO_CLOTHES && this.func_184582_a(EntityEquipmentSlot.MAINHAND) != null && this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() == CyberwareContent.katana) {
            ItemStack itemstack = this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77946_l();
            if (itemstack.func_77984_f()) {
                int i = Math.max(itemstack.func_77958_k() - 25, 1);
                int j = itemstack.func_77958_k() - this.field_70146_Z.nextInt(this.field_70146_Z.nextInt(i) + 1);
                if (j > i) {
                    j = i;
                }
                if (j < 1) {
                    j = 1;
                }
                itemstack.func_77964_b(j);
            }
            this.func_70099_a(itemstack, 0.0f);
        }
        if (this.hasWare) {
            float rarity = Math.min(100.0f, CyberwareConfig.DROP_RARITY + (float)lootingModifier * 5.0f);
            if (this.field_70170_p.field_73012_v.nextFloat() < rarity / 100.0f) {
                int count;
                ArrayList<ItemStack> allWares = new ArrayList<ItemStack>();
                for (ICyberware.EnumSlot slot : ICyberware.EnumSlot.values()) {
                    ItemStack[] stuff = this.cyberware.getInstalledCyberware(slot);
                    allWares.addAll(Arrays.asList(stuff));
                }
                allWares.removeAll(Collections.singleton(null));
                ItemStack drop = null;
                for (count = 0; count < 50 && (drop == null || drop.func_77973_b() == CyberwareContent.creativeBattery || drop.func_77973_b() == CyberwareContent.bodyPart); ++count) {
                    int random = this.field_70170_p.field_73012_v.nextInt(allWares.size());
                    drop = ItemStack.func_77944_b((ItemStack)((ItemStack)allWares.get(random)));
                    drop = CyberwareAPI.sanitize(drop);
                    drop = CyberwareAPI.getCyberware(drop).setQuality(drop, CyberwareAPI.QUALITY_SCAVENGED);
                    drop.field_77994_a = 1;
                }
                if (count < 50) {
                    this.func_70099_a(drop, 0.0f);
                }
            }
        }
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        if (CyberwareConfig.KATANA && !CyberwareConfig.NO_CLOTHES && this.func_184582_a(EntityEquipmentSlot.MAINHAND) != null && this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() == Items.field_151040_l) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(CyberwareContent.katana));
            this.func_184642_a(EntityEquipmentSlot.MAINHAND, 0.0f);
        }
    }

    public boolean isBrute() {
        return (Integer)this.field_70180_af.func_187225_a(CYBER_VARIANT) == 1;
    }

    public boolean setBrute() {
        this.func_82227_f(false);
        this.field_70180_af.func_187227_b(CYBER_VARIANT, (Object)1);
        return !this.hasWare;
    }
}

