/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.common.network.CyberwarePacketHandler;
import flaxbeard.cyberware.common.network.UpdateConfigPacket;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CyberwareConfig {
    public static CyberwareConfig INSTANCE = new CyberwareConfig();
    public static float ENGINEERING_CHANCE = 15.0f;
    public static float SCANNER_CHANCE = 10.0f;
    public static float SCANNER_CHANCE_ADDL = 10.0f;
    public static int SCANNER_TIME = 24000;
    public static int ESSENCE = 100;
    public static int CRITICAL_ESSENCE = 25;
    public static float DROP_RARITY = 50.0f;
    public static int ZOMBIE_WEIGHT = 15;
    public static int ZOMBIE_MIN_PACK = 1;
    public static int ZOMBIE_MAX_PACK = 1;
    public static boolean NO_ZOMBIES = false;
    public static boolean NO_CLOTHES = false;
    public static int HUDR = 76;
    public static int HUDG = 255;
    public static int HUDB = 0;
    public static boolean ENABLE_FLOAT = false;
    public static float HUDLENS_FLOAT = 0.1f;
    public static float HUDJACK_FLOAT = 0.05f;
    public static boolean SURGERY_CRAFTING = false;
    private static String[][] defaultStartingItems;
    private static String[][] startingItems;
    private static ItemStack[][] startingStacks;
    public static boolean DEFAULT_DROP;
    public static boolean DEFAULT_KEEP;
    public static float DROP_CHANCE;
    public static boolean KATANA;
    public static boolean CLOTHES;
    public static boolean RENDER;
    public static int TESLA_PER_POWER;
    public static Configuration config;
    public static File configDirectory;
    private static final String C_MOBS = "Mobs";
    private static final String C_OTHER = "Other";
    private static final String C_HUD = "HUD";
    private static final String C_MACHINES = "Machines";
    private static final String C_ESSENCE = "Essence";
    private static final String C_GAMERULES = "Gamerules";

    public static void preInit(FMLPreInitializationEvent event) {
        configDirectory = event.getModConfigurationDirectory();
        config = new Configuration(new File(event.getModConfigurationDirectory(), "cyberware.cfg"));
        defaultStartingItems = new String[ICyberware.EnumSlot.values().length][0];
        startingItems = defaultStartingItems;
        startingStacks = new ItemStack[ICyberware.EnumSlot.values().length][10];
        int j = 0;
        for (int i = 0; i < ICyberware.EnumSlot.values().length; ++i) {
            if (ICyberware.EnumSlot.values()[i].hasEssential()) {
                if (ICyberware.EnumSlot.values()[i].isSided()) {
                    CyberwareConfig.defaultStartingItems[i] = new String[]{"cyberware:bodyPart 1 " + j, "cyberware:bodyPart 1 " + (j + 1)};
                    j += 2;
                    continue;
                }
                CyberwareConfig.defaultStartingItems[i] = new String[]{"cyberware:bodyPart 1 " + j};
                ++j;
                continue;
            }
            CyberwareConfig.defaultStartingItems[i] = new String[0];
        }
        CyberwareConfig.loadConfig();
        config.load();
        for (int index = 0; index < ICyberware.EnumSlot.values().length; ++index) {
            ICyberware.EnumSlot slot = ICyberware.EnumSlot.values()[index];
            CyberwareConfig.startingItems[index] = config.getStringList("Default augments for " + slot.getName() + " slot", "Defaults", defaultStartingItems[index], "Use format 'id amount metadata'");
        }
        config.save();
    }

    public static void loadConfig() {
        config.load();
        NO_ZOMBIES = config.getBoolean("Disable cyberzombies", C_MOBS, NO_ZOMBIES, "");
        ZOMBIE_WEIGHT = config.getInt("Spawning weight of Cyberzombies", C_MOBS, ZOMBIE_WEIGHT, 0, Integer.MAX_VALUE, "Vanilla Zombie = 100, Enderman = 10, Witch = 5");
        ZOMBIE_MIN_PACK = config.getInt("Minimum Cyberzombie pack size", C_MOBS, ZOMBIE_MIN_PACK, 0, Integer.MAX_VALUE, "Vanilla Zombie = 4, Enderman = 1, Witch = 1");
        ZOMBIE_MAX_PACK = config.getInt("Maximum Cyberzombie pack size", C_MOBS, ZOMBIE_MAX_PACK, 0, Integer.MAX_VALUE, "Vanilla Zombie = 4, Enderman = 4, Witch = 1");
        NO_CLOTHES = config.getBoolean("Prevent mobs from spawning with Cyberware clothing", C_MOBS, NO_CLOTHES, "");
        DROP_RARITY = config.getFloat("Percent chance a Cyberzombie drops an item", C_MOBS, DROP_RARITY, 0.0f, 100.0f, "");
        SURGERY_CRAFTING = config.getBoolean("Enable crafting recipe for Robosurgeon", C_OTHER, SURGERY_CRAFTING, "Normally only found in Nether fortresses");
        TESLA_PER_POWER = config.getInt("RF/Tesla per internal power unit", C_OTHER, TESLA_PER_POWER, 0, Integer.MAX_VALUE, "");
        ESSENCE = config.getInt("Maximum Essence", C_ESSENCE, ESSENCE, 0, Integer.MAX_VALUE, "");
        CRITICAL_ESSENCE = config.getInt("Critical Essence value, where rejection begins", C_ESSENCE, CRITICAL_ESSENCE, 0, Integer.MAX_VALUE, "");
        DEFAULT_DROP = config.getBoolean("Default for gamerule cyberware_dropCyberware", C_GAMERULES, DEFAULT_DROP, "Determines if players drop their Cyberware on death. Does not change settings on existing worlds, use /gamerule for that. Overridden if cyberware_keepCyberware is true");
        DEFAULT_KEEP = config.getBoolean("Default for gamerule cyberware_keepCyberware", C_GAMERULES, DEFAULT_KEEP, "Determines if players keep their Cyberware between lives. Does not change settings on existing worlds, use /gamerule for that.");
        DROP_CHANCE = config.getFloat("Chance of successful drop", C_GAMERULES, DROP_CHANCE, 0.0f, 100.0f, "If dropCyberware enabled, chance for a piece of Cyberware to successfuly drop instead of being destroyed.");
        ENGINEERING_CHANCE = config.getFloat("Chance of blueprint from Engineering Table", C_MACHINES, ENGINEERING_CHANCE, 0.0f, 100.0f, "");
        SCANNER_CHANCE = config.getFloat("Chance of blueprint from Scanner", C_MACHINES, SCANNER_CHANCE, 0.0f, 100.0f, "");
        SCANNER_CHANCE_ADDL = config.getFloat("Additive chance for Scanner per extra item", C_MACHINES, SCANNER_CHANCE_ADDL, 0.0f, 100.0f, "");
        SCANNER_TIME = config.getInt("Ticks taken per Scanner operation", C_MACHINES, SCANNER_TIME, 0, Integer.MAX_VALUE, "24000 is one Minecraft day, 1200 is one real-life minute");
        KATANA = config.getBoolean("Enable Katana", C_OTHER, KATANA, "");
        CLOTHES = config.getBoolean("Enable Trenchcoat, Mirrorshades, and Biker Jacket", C_OTHER, CLOTHES, "");
        RENDER = config.getBoolean("Enable changes to player model (missing skin, missing limbs, Cybernetic limbs)", C_OTHER, RENDER, "");
        ENABLE_FLOAT = config.getBoolean("Enable hudlens and hudjack float.", C_HUD, ENABLE_FLOAT, "Experimental, defaults to false.");
        HUDJACK_FLOAT = config.getFloat("Amount hudjack HUD will 'float' with movement. Set to 0 for no float.", C_HUD, HUDJACK_FLOAT, 0.0f, 100.0f, "");
        HUDLENS_FLOAT = config.getFloat("Amount hudlens HUD will 'float' with movement. Set to 0 for no float.", C_HUD, HUDLENS_FLOAT, 0.0f, 100.0f, "");
        config.save();
    }

    public static void postInit() {
        int index = 0;
        for (String[] itemSet : startingItems) {
            ICyberware.EnumSlot slot = ICyberware.EnumSlot.values()[index];
            if (itemSet.length > 10) {
                throw new RuntimeException("Cyberware configuration error! Too many items for slot " + slot.getName());
            }
            for (int i = 0; i < itemSet.length; ++i) {
                Item item;
                int number;
                int meta;
                String itemName;
                String itemEncoded = itemSet[i];
                String[] params = itemEncoded.split("\\s+");
                if (params.length == 1) {
                    itemName = params[0];
                    meta = 0;
                    number = 0;
                } else {
                    if (params.length == 3) {
                        itemName = params[0];
                        try {
                            meta = Integer.parseInt(params[2]);
                        }
                        catch (NumberFormatException e) {
                            throw new RuntimeException("Cyberware configuration error! Item " + (i + 1) + " for " + slot.getName() + " slot has invalid metadata: '" + params[2] + "'");
                        }
                        try {
                            number = Integer.parseInt(params[1]);
                        }
                        catch (NumberFormatException e) {
                            throw new RuntimeException("Cyberware configuration error! Item " + (i + 1) + " for " + slot.getName() + " slot has invalid number: '" + params[1] + "'");
                        }
                    }
                    throw new RuntimeException("Cyberware configuration error! Item " + (i + 1) + " for " + slot.getName() + " slot has too many arguments!");
                }
                try {
                    item = CommandBase.func_147179_f(null, (String)itemName);
                }
                catch (NumberInvalidException e) {
                    throw new RuntimeException("Cyberware configuration error! Item '" + (i + 1) + "' for " + slot.getName() + " slot has a nonexistant item: " + itemName);
                }
                ItemStack stack = new ItemStack(item, number, meta);
                if (!CyberwareAPI.isCyberware(stack)) {
                    throw new RuntimeException("Cyberware configuration error! " + itemName + " is not a valid piece of cyberware!");
                }
                if (CyberwareAPI.getCyberware(stack).getSlot(stack) != slot) {
                    throw new RuntimeException("Cyberware configuration error! " + itemEncoded + " will not fit in slot " + slot.getName());
                }
                CyberwareConfig.startingStacks[index][i] = stack;
            }
            ++index;
        }
    }

    public static ItemStack[] getStartingItems(ICyberware.EnumSlot slot) {
        return startingStacks[slot.ordinal()];
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K && !Minecraft.func_71410_x().func_147114_u().func_147298_b().func_150724_d()) {
            CyberwareConfig.loadConfig();
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            CyberwarePacketHandler.INSTANCE.sendTo((IMessage)new UpdateConfigPacket(), (EntityPlayerMP)player);
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("cyberware")) {
            CyberwareConfig.loadConfig();
        }
    }

    static {
        DEFAULT_DROP = false;
        DEFAULT_KEEP = false;
        DROP_CHANCE = 100.0f;
        KATANA = true;
        CLOTHES = true;
        RENDER = true;
        TESLA_PER_POWER = 1;
    }
}

