/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.command;

import com.github.lunatrius.core.handler.DelayedGuiDisplayTicker;
import com.github.lunatrius.ingameinfo.InGameInfoCore;
import com.github.lunatrius.ingameinfo.client.gui.tag.GuiTags;
import com.github.lunatrius.ingameinfo.handler.ConfigurationHandler;
import com.github.lunatrius.ingameinfo.handler.Ticker;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class InGameInfoCommand
extends CommandBase {
    public static final InGameInfoCommand INSTANCE = new InGameInfoCommand();
    private final InGameInfoCore core = InGameInfoCore.INSTANCE;

    private InGameInfoCommand() {
    }

    public String func_71517_b() {
        return "igi";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.ingameinfoxml.usage";
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return InGameInfoCommand.func_71530_a((String[])args, (String[])new String[]{"reload", "load", "save", "enable", "disable", "taglist"});
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("load")) {
                return InGameInfoCommand.func_175762_a((String[])args, this.getFilenames());
            }
            if (args[0].equalsIgnoreCase("save")) {
                return CommandBase.func_71530_a((String[])args, (String[])new String[]{"InGameInfo.xml", "InGameInfo.json", "InGameInfo.txt"});
            }
        }
        return null;
    }

    private List<String> getFilenames() {
        File[] files = this.core.getConfigDirectory().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("InGameInfo") && (name.endsWith(".xml") || name.endsWith(".json") || name.endsWith(".txt"));
            }
        });
        ArrayList<String> filenames = new ArrayList<String>();
        for (File file : files) {
            filenames.add(file.getName());
        }
        return filenames;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("reload")) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ingameinfoxml.reload", new Object[0]));
                ConfigurationHandler.reload();
                boolean success = this.core.reloadConfig();
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(success ? "commands.ingameinfoxml.success" : "commands.ingameinfoxml.failure", new Object[0]));
                return;
            }
            if (args[0].equalsIgnoreCase("load")) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ingameinfoxml.load", new Object[]{args[1]}));
                boolean success = this.core.loadConfig(args[1]);
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(success ? "commands.ingameinfoxml.success" : "commands.ingameinfoxml.failure", new Object[0]));
                if (success) {
                    ConfigurationHandler.setConfigName(args[1]);
                    ConfigurationHandler.save();
                }
                return;
            }
            if (args[0].equalsIgnoreCase("save")) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ingameinfoxml.save", new Object[]{args[1]}));
                boolean success = this.core.saveConfig(args[1]);
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(success ? "commands.ingameinfoxml.success" : "commands.ingameinfoxml.failure", new Object[0]));
                return;
            }
            if (args[0].equalsIgnoreCase("enable")) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ingameinfoxml.enable", new Object[0]));
                Ticker.enabled = true;
                return;
            }
            if (args[0].equalsIgnoreCase("disable")) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ingameinfoxml.disable", new Object[0]));
                Ticker.enabled = false;
                return;
            }
            if (args[0].equalsIgnoreCase("taglist")) {
                DelayedGuiDisplayTicker.create((GuiScreen)new GuiTags(), (int)10);
                return;
            }
        }
        throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
    }
}

