/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile.tesr;

import com.rwtema.extrautils2.tile.XUTile;
import com.rwtema.extrautils2.tile.tesr.ITESRHookSimple;
import com.rwtema.extrautils2.transfernodes.FacingHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface ITESREnchantment<T extends XUTile>
extends ITESRHookSimple<T> {
    public static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");

    public static void renderModel(List<BakedQuad> listQuads, BlockPos pos, int color, double dx, double dy, double dz) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        int j = listQuads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = listQuads.get(i);
            int[] data = Arrays.copyOf(bakedquad.func_178209_a(), 28);
            Vec3d[] vec3ds = new Vec3d[4];
            float cx = 0.0f;
            float cy = 0.0f;
            float cz = 0.0f;
            for (int k = 0; k < 4; ++k) {
                float x = Float.intBitsToFloat(data[k * 7]);
                cx += x / 4.0f;
                float y = Float.intBitsToFloat(data[k * 7 + 1]);
                cy += y / 4.0f;
                float z = Float.intBitsToFloat(data[k * 7 + 2]);
                cz += z / 4.0f;
                vec3ds[k] = new Vec3d((double)x, (double)y, (double)z);
            }
            Vec3d center = new Vec3d((double)cx, (double)cy, (double)cz);
            Vec3d a = null;
            for (int l = 0; l < 4 && (a = vec3ds[l].func_178788_d(center)).equals((Object)Vec3d.field_186680_a); ++l) {
                a = null;
            }
            if (a == null) continue;
            Vec3d b = null;
            for (int l = 1; l < 4 && ((b = vec3ds[l].func_178788_d(center)).equals((Object)Vec3d.field_186680_a) || b.func_72436_e(a) < 0.01); ++l) {
                b = null;
            }
            if (b == null) continue;
            Vec3d normal = a.func_72431_c(b).func_72432_b();
            float v = 0.00390625f;
            for (int k = 0; k < 4; ++k) {
                Vec3d offset = vec3ds[k].func_178788_d(center).func_72432_b();
                data[k * 7] = Float.floatToRawIntBits((float)((double)Float.intBitsToFloat(data[k * 7]) + (offset.field_72450_a + normal.field_72450_a) * (double)v));
                data[k * 7 + 1] = Float.floatToRawIntBits((float)((double)Float.intBitsToFloat(data[k * 7 + 1]) + (offset.field_72450_a + normal.field_72448_b) * (double)v));
                data[k * 7 + 2] = Float.floatToRawIntBits((float)((double)Float.intBitsToFloat(data[k * 7 + 2]) + (offset.field_72450_a + normal.field_72449_c) * (double)v));
            }
            vertexbuffer.func_178969_c(0.0, 0.0, 0.0);
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            vertexbuffer.func_178981_a(data);
            vertexbuffer.func_178968_d(color);
            vertexbuffer.func_178987_a(dx, dy, dz);
            vertexbuffer.func_178975_e((float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c);
            tessellator.func_78381_a();
            vertexbuffer.func_178969_c(0.0, 0.0, 0.0);
            GlStateManager.func_179137_b((double)-22.21232123, (double)0.0, (double)0.0);
            GlStateManager.func_179114_b((float)76.23451f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    default public boolean shouldShowEnchantment() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    default public void renderTileEntityAt(T tile, double x, double y, double z, float partialTicks, int destroyStage) {
        if (!this.shouldShowEnchantment()) {
            return;
        }
        ChunkCache world = MinecraftForgeClient.getRegionRenderCache((World)tile.func_145831_w(), (BlockPos)tile.func_174877_v());
        BlockPos pos = tile.func_174877_v();
        IBlockState state = world.func_180495_p(pos);
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        state = state.func_177230_c().getExtendedState(state, (IBlockAccess)world, pos);
        long positionRandom = MathHelper.func_180186_a((Vec3i)pos);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (EnumFacing enumFacing : FacingHelper.facingPlusNull) {
            quads.addAll(model.func_188616_a(state, enumFacing, positionRandom));
        }
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        textureManager.func_110577_a(RES_ITEM_GLINT);
        GlStateManager.func_179129_p();
        RenderHelper.func_74518_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179128_n((int)5890);
        int color = -2143236865;
        GlStateManager.func_179094_E();
        long systemTime = Minecraft.func_71386_F() + (long)(31232343 * System.identityHashCode(tile));
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f = (float)(systemTime % 3000L) / 3000.0f / 8.0f;
        GlStateManager.func_179109_b((float)f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        ITESREnchantment.renderModel(quads, pos, color, x, y, z);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f1 = (float)(systemTime % 4873L) / 4873.0f / 8.0f;
        GlStateManager.func_179109_b((float)(-f1), (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        ITESREnchantment.renderModel(quads, pos, color, x, y, z);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179121_F();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        textureManager.func_110577_a(TextureMap.field_110575_b);
        RenderHelper.func_74519_b();
    }
}

