/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.machine;

import cofh.api.energy.IEnergyHandler;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.rwtema.extrautils2.api.machine.IMachineRecipe;
import com.rwtema.extrautils2.api.machine.Machine;
import com.rwtema.extrautils2.api.machine.MachineRegistry;
import com.rwtema.extrautils2.api.machine.MachineSlot;
import com.rwtema.extrautils2.api.machine.MachineSlotFluid;
import com.rwtema.extrautils2.api.machine.MachineSlotItem;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.fluids.FluidTankBase;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicContainerTile;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.gui.backend.WidgetBase;
import com.rwtema.extrautils2.gui.backend.WidgetEnergyStorage;
import com.rwtema.extrautils2.gui.backend.WidgetFluidBase;
import com.rwtema.extrautils2.gui.backend.WidgetProgressArrowTimer;
import com.rwtema.extrautils2.gui.backend.WidgetSlotItemHandler;
import com.rwtema.extrautils2.itemhandler.ConcatItemHandler;
import com.rwtema.extrautils2.itemhandler.IItemHandlerModifiableCompat;
import com.rwtema.extrautils2.itemhandler.InventoryHelper;
import com.rwtema.extrautils2.itemhandler.ItemStackHandlerBase;
import com.rwtema.extrautils2.itemhandler.SingleStackHandlerUpgrades;
import com.rwtema.extrautils2.machine.BlockMachine;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.power.IPowerSubType;
import com.rwtema.extrautils2.power.PowerManager;
import com.rwtema.extrautils2.power.energy.XUEnergyStorage;
import com.rwtema.extrautils2.tile.RedstoneState;
import com.rwtema.extrautils2.tile.TileAdvInteractor;
import com.rwtema.extrautils2.tile.TilePower;
import com.rwtema.extrautils2.transfernodes.Upgrade;
import com.rwtema.extrautils2.utils.ItemStackNonNull;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import com.rwtema.extrautils2.utils.helpers.ColorHelper;
import gnu.trove.map.TObjectFloatMap;
import gnu.trove.map.TObjectIntMap;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerConcatenate;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.Validate;

public abstract class TileMachine
extends TilePower
implements ITickable,
IEnergyHandler,
IDynamicHandler,
IPowerSubType {
    public static final int SHAPE = 0;
    public SingleStackHandlerUpgrades upgrades = this.registerNBT("upgrades", new SingleStackHandlerUpgrades(EnumSet.of(Upgrade.SPEED)){

        @Override
        protected void onContentsChanged() {
            TileMachine.this.recalc = true;
            TileMachine.this.func_70296_d();
            PowerManager.instance.markDirty(TileMachine.this);
        }
    });
    public Map<MachineSlotFluid, FluidStack> fluidInputMap;
    public Map<MachineSlotItem, ItemStack> itemInputMap;
    public IMachineRecipe curRecipe;
    public int totalTime;
    public int energyOutput;
    public NBTSerializable.NBTEnum<RedstoneState> redstone_state = this.registerNBT("redstone", new NBTSerializable.NBTEnum<RedstoneState>(RedstoneState.OPERATE_ALWAYS));
    public NBTSerializable.NBTBoolean powered = this.registerNBT("powered", new NBTSerializable.NBTBoolean());
    public NBTSerializable.Int pulses = this.registerNBT("pulses", new NBTSerializable.Int());
    int trackEnergy;
    protected XUEnergyStorage storage = new XUEnergyStorage(Integer.MAX_VALUE){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (simulate) {
                return super.receiveEnergy(maxReceive, true);
            }
            int energy = super.receiveEnergy(maxReceive, false);
            TileMachine.this.trackEnergy += energy;
            return energy;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (simulate) {
                return super.extractEnergy(maxExtract, true);
            }
            int energy = super.extractEnergy(maxExtract, false);
            TileMachine.this.trackEnergy += energy;
            return energy;
        }
    };
    String type;
    ComponentHandler<ItemStack> savedItems = this.registerNBT("items", new ComponentHandler<ItemStack>(){

        @Override
        protected NBTTagCompound serialize(ItemStack value) {
            return value.serializeNBT();
        }

        @Override
        protected ItemStack deserialize(NBTTagCompound tag) {
            return StackHelper.loadFromNBT(tag);
        }
    });
    ComponentHandler<FluidStack> savedFluids = this.registerNBT("fluids", new ComponentHandler<FluidStack>(){

        @Override
        protected NBTTagCompound serialize(FluidStack value) {
            return value.writeToNBT(new NBTTagCompound());
        }

        @Override
        protected FluidStack deserialize(NBTTagCompound tag) {
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
        }
    });
    static final int ROLLBACK_INTERVAL = 20;
    Machine machine;
    int processTime;
    private boolean recalc = true;
    IFluidHandler fluidHandlerOutputs = new IFluidHandler(){
        FluidTankBase[] tanks;
        FluidHandlerConcatenate tankConcatenate;
        IFluidTankProperties[] properties;

        @Nonnull
        public IFluidHandler getTankConcatenate() {
            if (TileMachine.this.machine == null) {
                return EmptyFluidHandler.INSTANCE;
            }
            if (this.tankConcatenate == null) {
                this.tankConcatenate = new FluidHandlerConcatenate((IFluidHandler[])this.getTanks());
            }
            return this.tankConcatenate;
        }

        @Nonnull
        public FluidTankBase[] getTanks() {
            if (TileMachine.this.machine == null) {
                return new FluidTankBase[0];
            }
            if (this.tanks == null) {
                this.tanks = new FluidTankBase[TileMachine.this.machine.fluidOutputs.size()];
                ImmutableList<MachineSlotFluid> fluidOutputs = TileMachine.this.machine.fluidOutputs;
                for (int i = 0; i < fluidOutputs.size(); ++i) {
                    final MachineSlotFluid fluidOutput = (MachineSlotFluid)fluidOutputs.get(i);
                    this.tanks[i] = new FluidTankBase(){

                        @Override
                        @Nullable
                        public FluidStack getFluid() {
                            return (FluidStack)TileMachine.this.savedFluids.contents.get(fluidOutput.name);
                        }

                        @Override
                        public void setFluid(@Nullable FluidStack fluid) {
                            if (fluid != null) {
                                TileMachine.this.savedFluids.contents.put(fluidOutput.name, fluid);
                            } else {
                                TileMachine.this.savedFluids.contents.remove(fluidOutput.name);
                            }
                            TileMachine.this.recalc = true;
                        }

                        @Override
                        public int getCapacity() {
                            return fluidOutput.stackCapacity;
                        }

                        @Override
                        public boolean canFillFluidType(FluidStack fluid) {
                            return false;
                        }

                        @Override
                        public boolean canDrainFluidType(FluidStack fluid) {
                            return true;
                        }
                    };
                }
            }
            return this.tanks;
        }

        @Nonnull
        public IFluidTankProperties[] getTankProperties() {
            if (TileMachine.this.machine == null) {
                return new IFluidTankProperties[0];
            }
            if (this.properties == null) {
                this.properties = new IFluidTankProperties[TileMachine.this.machine.fluidOutputs.size()];
                FluidTankBase[] tanks = this.getTanks();
                for (int i = 0; i < tanks.length; ++i) {
                    this.properties[i] = tanks[i].getTankProperties()[0];
                }
            }
            return this.properties;
        }

        public int fill(FluidStack resource, boolean doFill) {
            return 0;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return this.getTankConcatenate().drain(resource, doDrain);
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return this.getTankConcatenate().drain(maxDrain, doDrain);
        }
    };
    IFluidHandler fluidHandlerInputs = new IFluidHandler(){
        FluidTankBase[] tanks;
        FluidHandlerConcatenate tankConcatenate;
        IFluidTankProperties[] properties;

        public IFluidHandler getTankConcatenate() {
            if (TileMachine.this.machine == null) {
                return EmptyFluidHandler.INSTANCE;
            }
            if (this.tankConcatenate == null) {
                this.tankConcatenate = new FluidHandlerConcatenate((IFluidHandler[])this.getTanks());
            }
            return this.tankConcatenate;
        }

        public FluidTankBase[] getTanks() {
            if (TileMachine.this.machine == null) {
                return new FluidTankBase[0];
            }
            if (this.tanks == null) {
                this.tanks = new FluidTankBase[TileMachine.this.machine.fluidInputs.size()];
                ImmutableList<MachineSlotFluid> fluidInputs = TileMachine.this.machine.fluidInputs;
                for (int i = 0; i < fluidInputs.size(); ++i) {
                    final MachineSlotFluid fluidInput = (MachineSlotFluid)fluidInputs.get(i);
                    final int finalI = i;
                    this.tanks[i] = new FluidTankBase(){

                        @Override
                        @Nullable
                        public FluidStack getFluid() {
                            return (FluidStack)TileMachine.this.savedFluids.contents.get(fluidInput.name);
                        }

                        @Override
                        public void setFluid(@Nullable FluidStack fluid) {
                            if (fluid != null) {
                                TileMachine.this.savedFluids.contents.put(fluidInput.name, fluid);
                            } else {
                                TileMachine.this.savedFluids.contents.remove(fluidInput.name);
                            }
                            TileMachine.this.recalc = true;
                        }

                        @Override
                        public int getCapacity() {
                            return fluidInput.stackCapacity;
                        }

                        @Override
                        public boolean canFillFluidType(FluidStack fluid) {
                            return fluidInput.matchesFluidInput(fluid) && TileMachine.this.isValidFluidInput(finalI, fluid);
                        }

                        @Override
                        public boolean canDrainFluidType(FluidStack fluid) {
                            return !fluidInput.matchesFluidInput(fluid) || !TileMachine.this.isValidFluidInput(finalI, fluid);
                        }
                    };
                }
            }
            return this.tanks;
        }

        @Nonnull
        public IFluidTankProperties[] getTankProperties() {
            if (TileMachine.this.machine == null) {
                return new IFluidTankProperties[0];
            }
            if (this.properties == null) {
                this.properties = new IFluidTankProperties[TileMachine.this.machine.fluidInputs.size()];
                ImmutableList<MachineSlotFluid> fluidInputs = TileMachine.this.machine.fluidInputs;
                FluidTankBase[] tanks = this.getTanks();
                for (int i = 0; i < fluidInputs.size(); ++i) {
                    this.properties[i] = tanks[i].getTankProperties()[0];
                }
            }
            return this.properties;
        }

        public int fill(FluidStack resource, boolean doFill) {
            return this.getTankConcatenate().fill(resource, doFill);
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return this.getTankConcatenate().drain(resource, doDrain);
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return this.getTankConcatenate().drain(maxDrain, doDrain);
        }
    };
    IItemHandlerModifiable itemHandlerOutputs = new ItemStackHandlerBase(){

        @Override
        @ItemStackNonNull
        public ItemStack getStack(int slot) {
            if (slot < 0) {
                return StackHelper.empty();
            }
            Machine machine = TileMachine.this.machine;
            if (machine == null || slot >= machine.itemOutputs.size()) {
                return StackHelper.empty();
            }
            MachineSlotItem slotItem = (MachineSlotItem)machine.itemOutputs.get(slot);
            String name = slotItem.name;
            return TileMachine.this.savedItems.contents.getOrDefault(name, StackHelper.empty());
        }

        @Override
        public void setStack(int slot, ItemStack stack) {
            if (slot < 0) {
                return;
            }
            Machine machine = TileMachine.this.machine;
            if (machine == null || slot >= machine.itemOutputs.size()) {
                return;
            }
            TileMachine.this.recalc = true;
            MachineSlotItem slotItem = (MachineSlotItem)machine.itemOutputs.get(slot);
            String name = slotItem.name;
            if (StackHelper.isNull(stack)) {
                TileMachine.this.savedItems.contents.remove(name);
            } else {
                TileMachine.this.savedItems.contents.put(name, stack);
            }
        }

        @Override
        protected void onContentsChanged(int slot) {
            TileMachine.this.func_70296_d();
            TileMachine.this.recalc = true;
        }

        @Override
        @ItemStackNonNull
        public ItemStack insertItem(int slot, @ItemStackNonNull ItemStack stack, boolean simulate) {
            return stack;
        }

        @Override
        public int getSlots() {
            Machine machine = TileMachine.this.machine;
            if (machine == null) {
                return 0;
            }
            return machine.itemOutputs.size();
        }
    };
    IItemHandlerModifiable itemHandlerInputs = new ItemStackHandlerBase(){

        @Override
        @ItemStackNonNull
        public ItemStack getStack(int slot) {
            if (slot < 0) {
                return StackHelper.empty();
            }
            Machine machine = TileMachine.this.machine;
            if (machine == null || slot >= machine.itemInputs.size()) {
                return StackHelper.empty();
            }
            MachineSlotItem slotItem = (MachineSlotItem)machine.itemInputs.get(slot);
            String name = slotItem.name;
            return TileMachine.this.savedItems.contents.getOrDefault(name, StackHelper.empty());
        }

        @Override
        public void setStack(int slot, ItemStack stack) {
            if (slot < 0) {
                return;
            }
            Machine machine = TileMachine.this.machine;
            if (machine == null || slot >= machine.itemInputs.size()) {
                return;
            }
            TileMachine.this.recalc = true;
            MachineSlotItem slotItem = (MachineSlotItem)machine.itemInputs.get(slot);
            String name = slotItem.name;
            if (StackHelper.isNull(stack)) {
                TileMachine.this.savedItems.contents.remove(name);
            } else {
                TileMachine.this.savedItems.contents.put(name, stack);
            }
        }

        @Override
        protected void onContentsChanged(int slot) {
            TileMachine.this.func_70296_d();
            TileMachine.this.recalc = true;
        }

        @Override
        public int getSlots() {
            Machine machine = TileMachine.this.machine;
            if (machine == null) {
                return 0;
            }
            return machine.itemInputs.size();
        }

        @Override
        protected int getStackLimit(int slot, ItemStack stack) {
            if (!TileMachine.this.isValidItemInput(slot, stack)) {
                return 0;
            }
            return Math.min(((MachineSlotItem)TileMachine.this.machine.itemInputs.get((int)slot)).stackCapacity, stack.func_77976_d());
        }
    };
    private IItemHandler itemHandlerPublic = ConcatItemHandler.concatNonNull(new IItemHandler[]{new IItemHandlerModifiableCompat(){

        @Override
        public void setStackInSlot(int slot, @ItemStackNonNull ItemStack stack) {
            TileMachine.this.itemHandlerInputs.setStackInSlot(slot, stack);
            TileMachine.this.recalc = true;
        }

        @Override
        public int getSlots() {
            return TileMachine.this.itemHandlerInputs.getSlots();
        }

        @Override
        @ItemStackNonNull
        public ItemStack getStackInSlot(int slot) {
            return TileMachine.this.itemHandlerInputs.getStackInSlot(slot);
        }

        @Override
        @ItemStackNonNull
        public ItemStack insertItem(int slot, @ItemStackNonNull ItemStack stack, boolean simulate) {
            if (!simulate) {
                TileMachine.this.recalc = true;
            }
            return TileMachine.this.itemHandlerInputs.insertItem(slot, stack, simulate);
        }

        @Override
        @ItemStackNonNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack stack;
            if (amount == 0) {
                return StackHelper.empty();
            }
            if (!simulate) {
                TileMachine.this.recalc = true;
            }
            if (StackHelper.isNull(stack = TileMachine.this.itemHandlerInputs.getStackInSlot(slot)) || TileMachine.this.isValidItemInput(slot, stack)) {
                return StackHelper.empty();
            }
            return TileMachine.this.itemHandlerInputs.extractItem(slot, amount, simulate);
        }
    }, this.itemHandlerOutputs});
    private IFluidHandler fluidHandlerPublic = new FluidHandlerConcatenate(new IFluidHandler[]{this.fluidHandlerInputs, this.fluidHandlerOutputs});
    private boolean processing;
    private int processingCooldown = 0;

    @Override
    public void onNeighborBlockChange(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        boolean newPower;
        boolean wasPowered = this.powered.value;
        boolean bl = newPower = worldIn.func_175687_A(pos) > 0;
        if (newPower != wasPowered) {
            this.powered.value = newPower;
            if (newPower && this.redstone_state.value == RedstoneState.OPERATE_REDSTONE_PULSE) {
                ++this.pulses.value;
            }
        }
    }

    @Override
    @Nullable
    public IFluidHandler getFluidHandler(EnumFacing facing) {
        return this.fluidHandlerPublic;
    }

    @Override
    public IItemHandler getItemHandler(EnumFacing facing) {
        return this.itemHandlerPublic;
    }

    public boolean isValidFluidInput(int slot, FluidStack stack) {
        if (this.machine == null || slot >= this.machine.fluidInputs.size()) {
            return false;
        }
        MachineSlotFluid slotFluid = (MachineSlotFluid)this.machine.fluidInputs.get(slot);
        this.buildInputMaps();
        for (IMachineRecipe recipe : this.machine.recipes_registry) {
            if (!recipe.allowInputFluid(slotFluid, stack, this.itemInputMap, this.fluidInputMap)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidItemInput(int slot, ItemStack stack) {
        if (this.machine == null || slot >= this.machine.itemInputs.size()) {
            return false;
        }
        MachineSlotItem slotItem = (MachineSlotItem)this.machine.itemInputs.get(slot);
        this.buildInputMaps();
        for (IMachineRecipe recipe : this.machine.recipes_registry) {
            if (!recipe.allowInputItem(slotItem, stack, this.itemInputMap, this.fluidInputMap)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack, XUBlock xuBlock) {
        super.onBlockPlacedBy(worldIn, pos, state, placer, stack, xuBlock);
        this.type = "blank";
        if (StackHelper.isNonNull(stack) && stack.func_77942_o()) {
            this.type = ((NBTTagCompound)Validate.notNull((Object)stack.func_77978_p())).func_74779_i("Type");
        }
        this.machine = MachineRegistry.getMachine(this.type);
        this.storage.setCapacity(this.machine == null ? 0 : this.machine.energyBufferSize);
        this.storage.setMaxTransfer(this.machine == null ? 0 : this.machine.energyBufferSize);
    }

    @Override
    public void addToDescriptionPacket(XUPacketBuffer packet) {
        packet.writeString(this.type);
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @Override
    public void handleDescriptionPacket(XUPacketBuffer packet) {
        String s = packet.readString();
        if (this.type == null || !this.type.equals(s)) {
            this.type = s;
            this.machine = MachineRegistry.getMachine(this.type);
            this.field_145850_b.func_147458_c(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound nbt = super.func_189515_b(compound);
        if (this.type != null) {
            nbt.func_74778_a("Type", this.type);
        }
        nbt.func_74768_a("Energy", this.storage.getEnergyStored());
        nbt.func_74768_a("ProcessTime", this.processTime);
        nbt.func_74757_a("Processing", this.processing);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        this.storage.setCapacity(Integer.MAX_VALUE);
        super.func_145839_a(nbt);
        this.type = nbt.func_74779_i("Type");
        this.machine = MachineRegistry.getMachine(this.type);
        this.storage.setCapacity(this.machine == null ? 0 : this.machine.energyBufferSize);
        this.storage.setCapacity(this.machine == null ? 0 : this.machine.energyBufferSize);
        this.storage.setEnergyStored(nbt.func_74762_e("Energy"));
        this.processTime = nbt.func_74762_e("ProcessTime");
        this.processing = nbt.func_74767_n("Processing");
    }

    public void setActive() {
        this.processingCooldown = 100;
        if (!this.processing) {
            this.field_145850_b.func_180501_a(this.field_174879_c, this.getBlockState().func_177226_a((IProperty)BlockMachine.ACTIVE, Boolean.valueOf(true)), 2);
        }
        this.processing = true;
    }

    public void setInactive() {
        this.processing = false;
    }

    public void func_73660_a() {
        Machine machine = this.machine;
        if (machine == null) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            machine.clientTick(this, (Boolean)this.getBlockState().func_177229_b((IProperty)BlockMachine.ACTIVE));
            return;
        }
        if (!this.processing && this.processingCooldown > 0) {
            --this.processingCooldown;
            if (this.processingCooldown == 0) {
                this.field_145850_b.func_180501_a(this.field_174879_c, this.getBlockState().func_177226_a((IProperty)BlockMachine.ACTIVE, Boolean.valueOf(false)), 2);
            }
        }
        this.process();
    }

    public abstract void process();

    public void processRecipeInput() {
        if (this.recalc) {
            this.recalc = false;
            this.buildInputMaps();
            IMachineRecipe prevRecipe = this.curRecipe;
            this.curRecipe = null;
            block0: for (IMachineRecipe recipe : this.machine.recipes_registry) {
                if (!recipe.matches(this.itemInputMap, this.fluidInputMap)) continue;
                Map<MachineSlotItem, ItemStack> itemOutputs = recipe.getItemOutputs(this.itemInputMap, this.fluidInputMap);
                Map<MachineSlotFluid, FluidStack> fluidOutputs = recipe.getFluidOutputs(this.itemInputMap, this.fluidInputMap);
                for (MachineSlot slot : this.machine.itemOutputs) {
                    ItemStack curStack;
                    ItemStack stack = itemOutputs.get(slot);
                    if (!StackHelper.isNonNull(stack) || !StackHelper.isNonNull(curStack = (ItemStack)this.savedItems.contents.get(slot.name)) || ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)curStack) && StackHelper.getStacksize(stack) + StackHelper.getStacksize(curStack) <= Math.min(slot.stackCapacity, stack.func_77976_d())) continue;
                    continue block0;
                }
                for (MachineSlot slot : this.machine.fluidOutputs) {
                    FluidStack fluidStack1;
                    FluidStack fluidStack = fluidOutputs.get(slot);
                    if (fluidStack == null || (fluidStack1 = (FluidStack)this.savedFluids.contents.get(((MachineSlotFluid)slot).name)) == null || fluidStack.isFluidEqual(fluidStack1) && fluidStack.amount + fluidStack1.amount <= ((MachineSlotFluid)slot).stackCapacity) continue;
                    continue block0;
                }
                this.curRecipe = recipe;
                break;
            }
            if (this.curRecipe == null || prevRecipe != this.curRecipe) {
                this.processTime = 0;
            }
        }
    }

    public void buildInputMaps() {
        ImmutableMap.Builder itemBuilder = ImmutableMap.builder();
        for (MachineSlotItem itemInput : this.machine.itemInputs) {
            ItemStack stack = (ItemStack)this.savedItems.contents.get(itemInput.name);
            if (!StackHelper.isNonNull(stack)) continue;
            itemBuilder.put((Object)itemInput, (Object)stack);
        }
        this.itemInputMap = itemBuilder.build();
        ImmutableMap.Builder fluidBuilder = ImmutableMap.builder();
        for (MachineSlotFluid fluidInput : this.machine.fluidInputs) {
            FluidStack stack = (FluidStack)this.savedFluids.contents.get(fluidInput.name);
            if (stack == null) continue;
            fluidBuilder.put((Object)fluidInput, (Object)stack);
        }
        this.fluidInputMap = fluidBuilder.build();
    }

    protected void consumeInputs() {
        ItemStack stack;
        int i;
        TObjectIntMap<MachineSlot> amountToConsume = this.curRecipe.getAmountToConsume(this.itemInputMap, this.fluidInputMap);
        Map<MachineSlotItem, ItemStack> itemOutputs = this.curRecipe.getItemOutputs(this.itemInputMap, this.fluidInputMap);
        Map<MachineSlotFluid, FluidStack> fluidOutputs = this.curRecipe.getFluidOutputs(this.itemInputMap, this.fluidInputMap);
        Map<MachineSlotItem, ItemStack> containerItems = this.curRecipe.getContainerItems(this.itemInputMap, this.fluidInputMap);
        TObjectFloatMap<MachineSlot> probabilityModifier = this.curRecipe.getProbabilityModifier(this.itemInputMap, this.fluidInputMap);
        for (MachineSlot slot : this.machine.itemInputs) {
            i = amountToConsume.get((Object)slot);
            if (i == 0 || StackHelper.isNull(stack = (ItemStack)this.savedItems.contents.get(slot.name))) continue;
            StackHelper.decrease(stack, i);
            if (StackHelper.getStacksize(stack) > 0) continue;
            this.savedItems.contents.put(slot.name, containerItems.get(slot));
        }
        for (MachineSlot slot : this.machine.fluidInputs) {
            i = amountToConsume.get((Object)slot);
            if (i == 0 || (stack = (FluidStack)this.savedFluids.contents.get(((MachineSlotFluid)slot).name)) == null) continue;
            stack.amount -= i;
            if (stack.amount > 0) continue;
            this.savedFluids.contents.put(((MachineSlotFluid)slot).name, null);
        }
        for (MachineSlot slot : this.machine.itemOutputs) {
            ItemStack stack2 = itemOutputs.get(slot);
            if (StackHelper.isNull(stack2)) continue;
            if (probabilityModifier != null && probabilityModifier.containsKey((Object)slot)) {
                float v = probabilityModifier.get((Object)slot);
                int n = StackHelper.getStacksize(stack2);
                for (int i2 = 0; i2 < n; ++i2) {
                    if (!(this.field_145850_b.field_73012_v.nextFloat() > v)) continue;
                    StackHelper.decrease(stack2);
                }
            }
            if (StackHelper.isEmpty(stack2)) continue;
            ItemStack itemStack = (ItemStack)this.savedItems.contents.get(slot.name);
            if (StackHelper.isNull(itemStack)) {
                itemStack = stack2.func_77946_l();
                this.savedItems.contents.put(slot.name, itemStack);
            } else {
                StackHelper.increase(itemStack, StackHelper.getStacksize(stack2));
            }
            StackHelper.setStackSize(itemStack, Math.min(StackHelper.getStacksize(itemStack), Math.min(itemStack.func_77976_d(), slot.stackCapacity)));
        }
        for (MachineSlot slot : this.machine.fluidOutputs) {
            FluidStack stack3 = fluidOutputs.get(slot);
            if (stack3 == null) continue;
            FluidStack fluidStack = (FluidStack)this.savedFluids.contents.get(((MachineSlotFluid)slot).name);
            if (fluidStack == null) {
                fluidStack = stack3.copy();
                this.savedFluids.contents.put(((MachineSlotFluid)slot).name, fluidStack);
            } else {
                fluidStack.amount += stack3.amount;
            }
            fluidStack.amount = Math.min(fluidStack.amount, ((MachineSlotFluid)slot).stackCapacity);
        }
        this.recalc = true;
    }

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        if (this.machine == null) {
            return null;
        }
        return new ContainerMachine(this, player);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public Optional<ItemStack> getPickBlock(EntityPlayer player, RayTraceResult target) {
        return Optional.of(((BlockMachine)XU2Entries.machineEntry.value).createStack(this.machine));
    }

    @Override
    public void onPowerChanged() {
    }

    @Override
    protected Iterable<ItemStack> getDropHandler() {
        return Iterables.concat(InventoryHelper.getItemHandlerIterator(this.itemHandlerPublic), InventoryHelper.getItemHandlerIterator((IItemHandler)this.upgrades));
    }

    @Override
    public float getPower() {
        int level = this.upgrades.getLevel(Upgrade.SPEED);
        if (level == 0) {
            return Float.NaN;
        }
        return Upgrade.SPEED.getPowerUse(level);
    }

    @Override
    @Nullable
    public abstract IEnergyStorage getEnergyHandler(EnumFacing var1);

    @Override
    public Collection<ResourceLocation> getTypes() {
        if (this.machine == null) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)this.machine.location);
    }

    public boolean isProcessing() {
        return this.processing || this.processingCooldown > 90;
    }

    public abstract class ComponentHandler<T>
    implements INBTSerializable<NBTTagCompound> {
        public HashMap<String, T> contents = new HashMap();

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            for (Map.Entry<String, T> entry2 : this.contents.entrySet()) {
                T value = entry2.getValue();
                if (value == null) continue;
                tag.func_74782_a(entry2.getKey(), (NBTBase)this.serialize(value));
            }
            return tag;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.contents.clear();
            for (String s : nbt.func_150296_c()) {
                this.contents.put(s, this.deserialize(nbt.func_74775_l(s)));
            }
        }

        protected abstract NBTTagCompound serialize(T var1);

        protected abstract T deserialize(NBTTagCompound var1);
    }

    public static class ContainerMachine
    extends DynamicContainerTile {
        protected final EntityPlayer player;
        public TileMachine machine;

        public ContainerMachine(final TileMachine machine, EntityPlayer player) {
            super(machine);
            this.player = player;
            this.addWidget(new WidgetBase(0, 16, 50, 50){

                @Override
                public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
                    this.x = (width - this.w) / 2;
                    manager.func_110577_a(TextureMap.field_110575_b);
                    GlStateManager.func_179147_l();
                    Machine machine1 = machine.machine;
                    int color = machine1.color;
                    GlStateManager.func_179131_c((float)ColorHelper.getRF(color), (float)ColorHelper.getGF(color), (float)ColorHelper.getBF(color), (float)1.0f);
                    gui.func_175175_a(guiLeft + this.x, guiTop + this.y, Textures.getSprite(machine1.textureTop != null ? machine1.textureTop : "extrautils2:machine/machine_base"), this.w, this.h);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    String tex = (Boolean)machine.getBlockState().func_177229_b((IProperty)BlockMachine.ACTIVE) != false ? machine1.frontTextureActive : machine1.frontTexture;
                    gui.func_175175_a(guiLeft + this.x, guiTop + this.y, Textures.getSprite(tex), this.w, this.h);
                    manager.func_110577_a(DynamicContainer.texBackground);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
                    gui.func_73729_b(guiLeft + this.x, guiTop + this.y, 128 - this.w / 2, 128 - this.h / 2, this.w, this.h);
                }
            });
            this.addTitle(BlockMachine.getDisplayName(machine.machine), false);
            int w = (machine.itemHandlerInputs.getSlots() + machine.machine.fluidInputs.size() + machine.itemHandlerOutputs.getSlots() + machine.machine.fluidOutputs.size()) * 22 + 4 + 22;
            int x = Math.max(4, 85 - w / 2);
            int y = 32;
            for (final MachineSlotFluid slotFluid : machine.machine.fluidInputs) {
                WidgetFluidBase fluidTank = new WidgetFluidBase(x, y + 9 - WidgetFluidBase.uh[0] / 2, 0){

                    @Override
                    protected int getCapacity() {
                        return slotFluid.stackCapacity;
                    }

                    @Override
                    protected FluidStack getCurrentFluid() {
                        return (FluidStack)machine.savedFluids.contents.get(slotFluid.name);
                    }
                };
                this.addWidget(fluidTank);
                x += fluidTank.getW() + 4;
            }
            for (int i = 0; i < machine.itemHandlerInputs.getSlots(); ++i) {
                this.addWidget(new WidgetSlotItemHandler((IItemHandler)machine.itemHandlerInputs, i, x, y));
                x += 22;
            }
            WidgetProgressArrowTimer arrowTimer = new WidgetProgressArrowTimer(x, y){

                @Override
                protected float getTime() {
                    return (float)machine.processTime / (float)(1 + machine.upgrades.getLevel(Upgrade.SPEED));
                }

                @Override
                protected float getMaxTime() {
                    if (!machine.active) {
                        return -1.0f;
                    }
                    return (float)machine.totalTime / (float)(1 + machine.upgrades.getLevel(Upgrade.SPEED));
                }

                @Override
                public List<String> getErrorMessage() {
                    return ImmutableList.of((Object)Lang.translate("Grid is overloaded"));
                }
            };
            this.addWidget(arrowTimer);
            this.addWidget(arrowTimer.getJEIWidget("xu2_machine_" + machine.machine.name));
            x += 26;
            for (int i = 0; i < machine.itemHandlerOutputs.getSlots(); ++i) {
                this.addWidget(new WidgetSlotItemHandler((IItemHandler)machine.itemHandlerOutputs, i, x, y));
                x += 18;
                x += 4;
            }
            for (final MachineSlotFluid slotFluid : machine.machine.fluidOutputs) {
                WidgetFluidBase fluidTank = new WidgetFluidBase(x, y + 9 - WidgetFluidBase.uh[0] / 2, 0){

                    @Override
                    protected int getCapacity() {
                        return slotFluid.stackCapacity;
                    }

                    @Override
                    protected FluidStack getCurrentFluid() {
                        return (FluidStack)machine.savedFluids.contents.get(slotFluid.name);
                    }
                };
                this.addWidget(fluidTank);
                x += fluidTank.getW() + 4;
            }
            this.crop(4);
            if (this.width < 170) {
                this.width = 170;
            }
            this.addWidget(new WidgetEnergyStorage(this.width - 24, y - 16, (IEnergyStorage)machine.storage));
            this.crop(4);
            this.addWidget(machine.upgrades.getSpeedUpgradeSlot(4, y - 16));
            this.addWidget(TileAdvInteractor.getRSWidget(4, y - 16 + 19, machine.redstone_state, machine.pulses));
            this.cropAndAddPlayerSlots(player.field_71071_by);
            this.validate();
            this.machine = machine;
        }
    }
}

