/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.rwtema.extrautils2.backend.PropertyEnumSimple;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.XUBlockConnectedTextureBase;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.entries.IItemStackMaker;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.blocks.BlockDecorativeGlass;
import com.rwtema.extrautils2.crafting.CraftingHelper;
import com.rwtema.extrautils2.items.ItemIngredients;
import com.rwtema.extrautils2.textures.ConnectedTexture;
import com.rwtema.extrautils2.textures.ISolidWorldTexture;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockIneffableGlass
extends XUBlockConnectedTextureBase {
    public static final PropertyEnumSimple<DecorStates> decor = new PropertyEnumSimple<DecorStates>(DecorStates.class);

    public BlockIneffableGlass() {
        super(Material.field_151592_s);
    }

    public boolean func_149751_l(IBlockState state) {
        return ((DecorStates)((Object)state.func_177229_b(BlockIneffableGlass.decor))).opacity == 0;
    }

    public float func_185485_f(IBlockState state) {
        return this.func_149751_l(state) ? 1.0f : 0.2f;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, @Nonnull IBlockState state, EntityPlayer player) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerTextures() {
        for (DecorStates decorState : DecorStates.values()) {
            decorState.tex = new ConnectedTexture("strange_glass_" + decorState.toString(), this.xuBlockState.defaultState.func_177226_a((IProperty)decor, (Comparable)((Object)decorState)), this);
        }
    }

    @Override
    @Nonnull
    protected XUBlockStateCreator createBlockState() {
        return new XUBlockStateCreator((XUBlock)this, false, new IProperty[]{decor});
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    public boolean canRenderInLayer(IBlockState state, @Nonnull BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT || layer == BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149637_q(IBlockState state) {
        return super.func_149637_q(state);
    }

    @Override
    public boolean func_149721_r(IBlockState state) {
        return super.func_149721_r(state);
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return super.isNormalCube(state, world, pos);
    }

    public boolean func_185481_k(IBlockState state) {
        return super.func_185481_k(state);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ISolidWorldTexture getConnectedTexture(IBlockState state, EnumFacing side) {
        return ((DecorStates)((Object)state.func_177229_b(BlockIneffableGlass.decor))).tex;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state.func_177230_c() != this) {
            return 0;
        }
        return ((DecorStates)((Object)state.func_177229_b(BlockIneffableGlass.decor))).opacity;
    }

    public int getLightValue(@Nonnull IBlockState state, IBlockAccess world, @Nonnull BlockPos pos) {
        if (state.func_177230_c() != this) {
            return 0;
        }
        return ((DecorStates)((Object)state.func_177229_b(BlockIneffableGlass.decor))).light_level;
    }

    @Override
    public BlockRenderLayer renderLayer(IBlockState state) {
        return ((DecorStates)((Object)state.func_177229_b(BlockIneffableGlass.decor))).layer;
    }

    @Override
    public void addCollisionBoxToListBase(IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB entityBox, @Nonnull List<AxisAlignedBB> collidingBoxes, Entity entityIn) {
        if (!((DecorStates)((Object)state.func_177229_b(decor))).shouldAllowPassage(entityIn)) {
            BlockIneffableGlass.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)Block.field_185505_j);
        }
    }

    @Override
    public boolean isDoubleSided(IBlockState state) {
        return true;
    }

    @Override
    protected BoxModel createBaseModel() {
        return new BoxModel(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public static enum DecorStates implements IItemStackMaker
    {
        normal{

            @Override
            public boolean shouldAllowPassage(Entity entityIn) {
                return DecorStates.isNotSneakingPlayer(entityIn);
            }

            @Override
            public void addRecipes() {
                CraftingHelper.addShaped(this.newStack(8), "ggg", "gmg", "ggg", Character.valueOf('g'), "blockGlass", Character.valueOf('m'), ItemIngredients.Type.MOON_STONE);
            }
        }
        ,
        reverse{

            @Override
            public boolean shouldAllowPassage(Entity entityIn) {
                return !DecorStates.isNotSneakingPlayer(entityIn);
            }

            @Override
            public void addRecipes() {
                CraftingHelper.addShapeless(this.newStack(1), normal.newStack(), Blocks.field_150429_aA);
            }
        }
        ,
        clear{

            @Override
            public boolean shouldAllowPassage(Entity entityIn) {
                return DecorStates.isNotSneakingPlayer(entityIn);
            }

            @Override
            public void addRecipes() {
                CraftingHelper.addShaped(this.newStack(8), "ggg", "gmg", "ggg", Character.valueOf('g'), BlockDecorativeGlass.DecorStates.glass, Character.valueOf('m'), ItemIngredients.Type.MOON_STONE);
            }
        }
        ,
        dark{
            {
                this.layer = BlockRenderLayer.TRANSLUCENT;
                this.opacity = 255;
            }

            @Override
            public boolean shouldAllowPassage(Entity entityIn) {
                return DecorStates.isNotSneakingPlayer(entityIn);
            }

            @Override
            public void addRecipes() {
                CraftingHelper.addShaped(this.newStack(8), "ggg", "gmg", "ggg", Character.valueOf('g'), BlockDecorativeGlass.DecorStates.darkglass, Character.valueOf('m'), ItemIngredients.Type.MOON_STONE);
            }
        };

        public int opacity;
        @SideOnly(value=Side.CLIENT)
        public ISolidWorldTexture tex;
        public int light_level = 0;
        BlockRenderLayer layer = BlockRenderLayer.CUTOUT;

        private static boolean isNotSneakingPlayer(Entity entityIn) {
            return entityIn != null && !entityIn.func_70093_af() && entityIn instanceof EntityPlayer;
        }

        public ItemStack newStack(int amount) {
            return XU2Entries.strangeGlass.newStack(amount, new Object[]{decor, this});
        }

        @Override
        public ItemStack newStack() {
            return this.newStack(1);
        }

        public abstract boolean shouldAllowPassage(Entity var1);

        public abstract void addRecipes();
    }
}

