/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.api.machine;

import com.google.common.collect.ImmutableMap;
import com.rwtema.extrautils2.api.machine.MachineSlot;
import com.rwtema.extrautils2.api.machine.MachineSlotFluid;
import com.rwtema.extrautils2.api.machine.MachineSlotItem;
import com.rwtema.extrautils2.compatibility.StackHelper;
import gnu.trove.map.TObjectFloatMap;
import gnu.trove.map.TObjectIntMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public interface IMachineRecipe {
    public static Map<MachineSlotItem, ItemStack> getVanillaContainerItems(Map<MachineSlotItem, ItemStack> inputItems) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<MachineSlotItem, ItemStack> entry2 : inputItems.entrySet()) {
            ItemStack container = ForgeHooks.getContainerItem((ItemStack)entry2.getValue());
            if (!StackHelper.isNonNull(container)) continue;
            builder.put((Object)entry2.getKey(), (Object)container);
        }
        return builder.build();
    }

    public List<Pair<Map<MachineSlotItem, List<ItemStack>>, Map<MachineSlotFluid, List<FluidStack>>>> getJEIInputItemExamples();

    public boolean allowInputItem(MachineSlotItem var1, ItemStack var2, Map<MachineSlotItem, ItemStack> var3, Map<MachineSlotFluid, FluidStack> var4);

    public boolean allowInputFluid(MachineSlotFluid var1, FluidStack var2, Map<MachineSlotItem, ItemStack> var3, Map<MachineSlotFluid, FluidStack> var4);

    public boolean matches(Map<MachineSlotItem, ItemStack> var1, Map<MachineSlotFluid, FluidStack> var2);

    public Map<MachineSlotItem, ItemStack> getItemOutputs(Map<MachineSlotItem, ItemStack> var1, Map<MachineSlotFluid, FluidStack> var2);

    public Map<MachineSlotFluid, FluidStack> getFluidOutputs(Map<MachineSlotItem, ItemStack> var1, Map<MachineSlotFluid, FluidStack> var2);

    public int getEnergyOutput(Map<MachineSlotItem, ItemStack> var1, Map<MachineSlotFluid, FluidStack> var2);

    public int getProcessingTime(Map<MachineSlotItem, ItemStack> var1, Map<MachineSlotFluid, FluidStack> var2);

    default public float getEnergyRate(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        return (float)this.getEnergyOutput(inputItems, inputFluids) / (float)this.getProcessingTime(inputItems, inputFluids);
    }

    public TObjectIntMap<MachineSlot> getAmountToConsume(Map<MachineSlotItem, ItemStack> var1, Map<MachineSlotFluid, FluidStack> var2);

    default public Map<MachineSlotItem, ItemStack> getContainerItems(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        HashMap<MachineSlotItem, ItemStack> map = new HashMap<MachineSlotItem, ItemStack>();
        for (Map.Entry<MachineSlotItem, ItemStack> entry2 : inputItems.entrySet()) {
            map.put(entry2.getKey(), ForgeHooks.getContainerItem((ItemStack)entry2.getValue()));
        }
        return map;
    }

    @Nullable
    default public TObjectFloatMap<MachineSlot> getProbabilityModifier(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        return null;
    }
}

