/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.achievements;

import com.google.common.collect.HashMultimap;
import com.rwtema.extrautils2.backend.entries.IItemStackMaker;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.items.ItemIngredients;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.LogHelper;
import com.rwtema.extrautils2.utils.datastructures.ItemRef;
import gnu.trove.TIntCollection;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraftforge.common.AchievementPage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.toposort.TopologicalSort;
import net.minecraftforge.fml.relauncher.Side;

public class AchievementHelper {
    private static HashMultimap<ItemRef, XUAchievement> dropMap = HashMultimap.create();
    private static HashMultimap<XUAchievement, XUAchievement> achievementChildren = HashMultimap.create();
    private static AchievementPage page;
    private static List<Achievement> achievements;
    private static HashMap<IItemStackMaker, XUAchievement> map;
    private static boolean built;
    private static HashSet<String> names;

    public static XUAchievement addAchievement(String name, String description, @Nonnull IItemStackMaker entry2, @Nullable IItemStackMaker parent) {
        if (!names.add(name)) {
            throw new RuntimeException("Duplicate Name " + name);
        }
        XUAchievement achievement = new XUAchievement(name, description, entry2, parent);
        map.put(entry2, achievement);
        return achievement;
    }

    public static void bake() {
        if (page == null) {
            page = new AchievementPage("ExtraUtils 2", new Achievement[0]);
            AchievementPage.registerAchievementPage((AchievementPage)page);
            achievements = page.getAchievements();
        } else {
            achievements.clear();
            achievementChildren.clear();
            dropMap.clear();
        }
        TopologicalSort.DirectedGraph graph = new TopologicalSort.DirectedGraph();
        for (XUAchievement xuAchievement : map.values()) {
            graph.addNode((Object)xuAchievement);
        }
        for (XUAchievement xuAchievement : map.values()) {
            if (xuAchievement.parent == null) {
                achievementChildren.put(null, (Object)xuAchievement);
                continue;
            }
            xuAchievement.achParent = map.get(xuAchievement.parent);
            achievementChildren.put((Object)xuAchievement.achParent, (Object)xuAchievement);
            if (xuAchievement.achParent != null) {
                graph.addEdge((Object)xuAchievement.achParent, (Object)xuAchievement);
                continue;
            }
            xuAchievement.achParent = null;
        }
        List sort = TopologicalSort.topologicalSort((TopologicalSort.DirectedGraph)graph);
        new Layout().buildTree();
        for (int i = 1; i < sort.size(); ++i) {
            XUAchievement a = (XUAchievement)sort.get(i);
            for (int j = 0; j < i; ++j) {
                XUAchievement b = (XUAchievement)sort.get(j);
                if (a == b || a.x != b.x || a.y != b.y) continue;
                LogHelper.info(a + " " + b, new Object[0]);
                throw new RuntimeException("Overlay Error\n " + a + "\n " + b);
            }
        }
        int xc = 0;
        int yc = 0;
        for (XUAchievement xuAchievement : sort) {
            xc += xuAchievement.x;
            yc += xuAchievement.y;
        }
        xc /= sort.size();
        yc /= sort.size();
        for (XUAchievement xuAchievement : sort) {
            String key = Lang.stripText(xuAchievement.name);
            String achKey = "achievement.xu2." + key;
            Lang.translate(achKey, xuAchievement.name);
            Lang.translate(achKey + ".desc", xuAchievement.description);
            Achievement parentAch = xuAchievement.achParent != null ? xuAchievement.achParent.achievement : null;
            ItemStack stack = xuAchievement.entry.newStack();
            if (StackHelper.isNull(stack)) {
                stack = ItemIngredients.Type.SYMBOL_NOCRAFT.newStack();
            } else {
                dropMap.put((Object)ItemRef.wrap(stack), (Object)xuAchievement);
                if (stack.func_77952_i() == Short.MAX_VALUE) {
                    stack.func_77964_b(0);
                }
            }
            int y = xuAchievement.x - xc;
            int x = xuAchievement.y - yc;
            Achievement achievement = new Achievement("achievement.xu2." + key, "xu2." + key, x, y, stack, parentAch);
            if (!built) {
                achievement.func_75971_g();
            }
            xuAchievement.achievement = achievement;
            achievements.add(achievement);
        }
        if (!built) {
            MinecraftForge.EVENT_BUS.register(new Object(){

                @SubscribeEvent
                public void onTick(TickEvent.PlayerTickEvent event) {
                    if (event.side == Side.SERVER && event.player.func_130014_f_().func_82737_E() % 40L == 0L) {
                        InventoryPlayer inventory = event.player.field_71071_by;
                        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                            ItemStack stackInSlot = inventory.func_70301_a(i);
                            if (!StackHelper.isNonNull(stackInSlot)) continue;
                            AchievementHelper.checkForPotentialAwards(event.player, stackInSlot);
                        }
                    }
                }

                @SubscribeEvent
                public void onPickup(PlayerEvent.ItemPickupEvent event) {
                    EntityItem pickedUp = event.pickedUp;
                    if (pickedUp == null) {
                        return;
                    }
                    AchievementHelper.checkForPotentialAwards(event.player, pickedUp.func_92059_d());
                }

                @SubscribeEvent
                public void onSmelt(PlayerEvent.ItemSmeltedEvent event) {
                    AchievementHelper.checkForPotentialAwards(event.player, event.smelting);
                }

                @SubscribeEvent
                public void onCraft(PlayerEvent.ItemCraftedEvent event) {
                    AchievementHelper.checkForPotentialAwards(event.player, event.crafting);
                }
            });
        }
        built = true;
    }

    public static void checkForPotentialAwards(EntityPlayer player, ItemStack stack) {
        if (StackHelper.isNull(stack) || player == null) {
            return;
        }
        Set set = dropMap.get((Object)ItemRef.wrap(stack));
        if (!set.isEmpty()) {
            for (XUAchievement achievement : set) {
                player.func_71029_a((StatBase)achievement.achievement);
            }
        }
    }

    static {
        map = new HashMap();
        built = false;
        names = new HashSet();
    }

    private static class Layout {
        private Layout() {
        }

        public void buildTree() {
            TreeNode treeNode = new TreeNode(achievementChildren.get(null));
            treeNode.buildDepth();
            treeNode.assignValues(0, 0);
        }

        private static class TreeNode {
            public XUAchievement xuAchievement;
            public TIntArrayList minPoints = new TIntArrayList();
            public TIntArrayList maxPoints = new TIntArrayList();
            int shift;
            ArrayList<TreeNode> children = new ArrayList();

            public TreeNode(Collection<XUAchievement> xuChildren) {
                ArrayList<XUAchievement> list = new ArrayList<XUAchievement>(xuChildren);
                Collections.shuffle(list);
                for (XUAchievement achievement : list) {
                    this.children.add(new TreeNode(achievement));
                }
            }

            public TreeNode(XUAchievement xuAchievement) {
                this.xuAchievement = xuAchievement;
                ArrayList list = new ArrayList(achievementChildren.get((Object)xuAchievement));
                int n = list.size();
                if (n != 0) {
                    if (n == 1) {
                        this.children.add(new TreeNode(new TreeNode((XUAchievement)list.get(0))));
                    } else {
                        Collections.shuffle(list);
                        for (int i = 0; i < list.size(); ++i) {
                            int k = Math.min(i, list.size() - 1 - i);
                            XUAchievement achievement = (XUAchievement)list.get(i);
                            this.children.add(TreeNode.linkedChain(new TreeNode(achievement), k));
                        }
                    }
                }
            }

            public TreeNode(TreeNode child) {
                this.children.add(child);
            }

            public static TreeNode linkedChain(TreeNode child, int chain_length) {
                if (chain_length == 0) {
                    return child;
                }
                return new TreeNode(TreeNode.linkedChain(child, chain_length - 1));
            }

            void buildDepth() {
                int n = this.children.size();
                if (n == 0) {
                    this.minPoints.add(0);
                    this.maxPoints.add(0);
                } else if (n == 1) {
                    TreeNode child = this.children.get(0);
                    child.buildDepth();
                    this.minPoints.add(0);
                    this.maxPoints.add(0);
                    child.shift = 0;
                    this.minPoints.addAll((TIntCollection)child.minPoints);
                    this.maxPoints.addAll((TIntCollection)child.maxPoints);
                } else {
                    int midPoint;
                    int maxDepth = 0;
                    for (TreeNode child : this.children) {
                        child.buildDepth();
                        maxDepth = Math.max(Math.max(maxDepth, child.minPoints.size()), child.maxPoints.size());
                    }
                    int maxShift = 0;
                    for (int i = 1; i < n; ++i) {
                        Iterator<TreeNode> curChild = this.children.get(i);
                        ((TreeNode)((Object)curChild)).shift = maxShift;
                        block2: while (true) {
                            ++((TreeNode)((Object)curChild)).shift;
                            for (int j = i - 1; j >= 0; --j) {
                                if (this.overlaps(this.children.get(j), (TreeNode)((Object)curChild))) continue block2;
                            }
                            break;
                        }
                        maxShift = ((TreeNode)((Object)curChild)).shift;
                    }
                    if (maxShift & true) {
                        midPoint = maxShift >> 1;
                        for (TreeNode child : this.children) {
                            if (child.shift <= midPoint) continue;
                            ++child.shift;
                        }
                        ++maxShift;
                    }
                    midPoint = maxShift >> 1;
                    for (TreeNode child : this.children) {
                        child.shift -= midPoint;
                    }
                    this.minPoints.add(this.children.get((int)0).shift);
                    this.maxPoints.add(this.children.get((int)(n - 1)).shift);
                    for (int i = 0; i < maxDepth; ++i) {
                        this.minPoints.add(0);
                        this.maxPoints.add(0);
                    }
                    for (TreeNode child : this.children) {
                        int x;
                        int i;
                        for (i = 0; i < child.minPoints.size(); ++i) {
                            x = child.shift + child.minPoints.get(i);
                            if (this.minPoints.get(i + 1) <= x) continue;
                            this.minPoints.set(i + 1, x);
                        }
                        for (i = 0; i < child.maxPoints.size(); ++i) {
                            x = child.shift + child.maxPoints.get(i);
                            if (this.maxPoints.get(i + 1) >= x) continue;
                            this.maxPoints.set(i + 1, x);
                        }
                    }
                }
            }

            public boolean overlaps(TreeNode left, TreeNode right) {
                int size = Math.min(left.maxPoints.size(), right.minPoints.size());
                for (int i = 0; i < size; ++i) {
                    int l_max = left.shift + left.maxPoints.get(i);
                    int r_min = right.shift + right.minPoints.get(i);
                    if (r_min > l_max) continue;
                    return true;
                }
                return false;
            }

            public void assignValues(int x, int y) {
                if (this.xuAchievement != null) {
                    this.xuAchievement.x = x;
                    this.xuAchievement.y = y;
                }
                for (TreeNode child : this.children) {
                    child.assignValues(x + child.shift, y + 1);
                }
            }
        }
    }

    public static class XUAchievement {
        public Achievement achievement;
        public String name;
        public String description;
        @Nonnull
        public IItemStackMaker entry;
        @Nullable
        public IItemStackMaker parent;
        public XUAchievement achParent;
        int x;
        int y;

        public XUAchievement(String name, String description, @Nonnull IItemStackMaker entry2, @Nullable IItemStackMaker parent) {
            this.name = name;
            this.description = description;
            this.entry = entry2;
            this.parent = parent;
        }

        public String toString() {
            return "XUAchievement{" + this.name + '}';
        }
    }
}

