/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons;

import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import io.github.drmanganese.topaddons.addons.AddonBlank;
import io.github.drmanganese.topaddons.api.TOPAddon;
import java.util.ArrayList;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.config.Config;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

@TOPAddon(dependency="StorageDrawers")
public class AddonStorageDrawers
extends AddonBlank {
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        if (world.func_175625_s(data.getPos()) instanceof TileEntityDrawers) {
            TileEntityDrawers tile = (TileEntityDrawers)world.func_175625_s(data.getPos());
            if (tile.isShrouded()) {
                probeInfo.text(TextStyleClass.LABEL + "{*topaddons.storage_drawers:shrouded*}");
                return;
            }
            if (mode == ProbeMode.EXTENDED) {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (int i = 0; i < tile.getDrawerCount(); ++i) {
                    ItemStack stack = tile.getDrawer(i).getStoredItemCopy();
                    if (stack == null) continue;
                    stacks.add(stack);
                }
                if (!stacks.isEmpty()) {
                    IProbeInfo vertical = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(Integer.valueOf(Config.chestContentsBorderColor)).spacing(0));
                    for (ItemStack stack : stacks) {
                        if (tile.isVending()) {
                            ItemStack infiStack = ItemStack.func_77944_b((ItemStack)stack);
                            infiStack.field_77994_a = 1;
                            vertical.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(infiStack).vertical(probeInfo.defaultLayoutStyle().spacing(0)).text(stack.func_82833_r()).text(TextStyleClass.INFOIMP + "[\u221e]");
                            continue;
                        }
                        int mss = stack.func_77976_d();
                        int r = stack.field_77994_a % mss;
                        int q = (stack.field_77994_a - r) / mss;
                        vertical.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(stack).vertical(probeInfo.defaultLayoutStyle().spacing(0)).text(stack.func_82833_r()).text(TextStyleClass.LABEL + "[" + (stack.field_77994_a >= mss ? q + "x" + mss + " + " : "") + r + "]");
                    }
                }
                AddonStorageDrawers.textPrefixed(probeInfo, "{*topaddons.storagedrawers:stack_limit*}", tile.isUnlimited() ? "\u221e" : tile.getDrawerCapacity() * tile.getEffectiveStorageMultiplier() + " (x" + tile.getEffectiveStorageMultiplier() + ")");
                if (tile.getOwner() != null && tile.getOwner().compareTo(player.func_110124_au()) != 0) {
                    probeInfo.text(TextStyleClass.ERROR + "{*storagedrawers.waila.protected*}");
                }
            }
        }
    }

    @Override
    public void getProbeConfig(IProbeConfig config, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        if (world.func_175625_s(data.getPos()) instanceof TileEntityDrawers) {
            if (player.func_70093_af()) {
                config.showChestContents(IProbeConfig.ConfigMode.NOT);
            } else {
                config.showChestContents(IProbeConfig.ConfigMode.EXTENDED);
            }
        }
    }
}

