/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons;

import com.infinityraider.agricraft.api.v1.misc.IAgriDisplayable;
import com.infinityraider.agricraft.tiles.TileEntityCrop;
import io.github.drmanganese.topaddons.addons.AddonBlank;
import io.github.drmanganese.topaddons.api.TOPAddon;
import java.util.ArrayList;
import java.util.List;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

@TOPAddon(dependency="agricraft")
public class AddonAgriCraft
extends AddonBlank {
    private boolean extendedMode = true;

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity tileEntity = world.func_175625_s(data.getPos());
        if (tileEntity instanceof TileEntityCrop) {
            ArrayList<String> info = new ArrayList<String>();
            ((IAgriDisplayable)tileEntity).addDisplayInfo(info::add);
            List<String> revisedInfo = this.getModeAppropriateData(info, mode);
            for (String line : revisedInfo) {
                probeInfo.text(line);
            }
        }
    }

    @Override
    public void updateConfigs(Configuration config) {
        this.extendedMode = config.get("agricraft", "extendedMode", true, "Only show breeding stages in extended mode.").setLanguageKey("topaddons.config:agricraft_extended_mode").getBoolean();
    }

    private List<String> getModeAppropriateData(List<String> info, ProbeMode mode) {
        int i;
        ArrayList<String> revisedList = new ArrayList<String>();
        if (info.size() == 2) {
            revisedList.add(this.formatText(info.get(0)));
            revisedList.add(this.formatText(info.get(1)));
        }
        if (info.size() == 5) {
            for (i = 0; i < info.size(); ++i) {
                if (i == 3 && mode == ProbeMode.NORMAL && this.extendedMode) continue;
                revisedList.add(this.formatText(info.get(i)));
            }
        }
        if (info.size() == 7) {
            for (i = 0; i < info.size(); ++i) {
                if ((i == 3 || i == 4 || i == 5) && mode == ProbeMode.NORMAL && this.extendedMode) continue;
                revisedList.add(this.formatText(info.get(i)));
            }
        }
        return revisedList;
    }

    private String formatText(String line) {
        String[] text = line.split(":");
        if (text.length == 2) {
            return TextFormatting.GREEN + text[0] + ":" + TextFormatting.RESET + text[1];
        }
        return line;
    }
}

