/*
 * Decompiled with CFR 0.152.
 */
package mod.upcraftlp.worldlimiter.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Scanner;
import mod.upcraftlp.worldlimiter.init.ModConfig;
import mod.upcraftlp.worldlimiter.util.SysUtils;

public class ModUpdate {
    private static String UPDATE_URL = "https://raw.githubusercontent.com/UpcraftLP/WorldLimiterMod-1.10.2/master/Version.txt";
    private static boolean newVersionAvailable = false;
    private static String latest = "1.0.2";

    public static void init() {
        if (!ModConfig.enableUpdateChecker) {
            return;
        }
        SysUtils.println("checking for updates...");
        new Thread("Update-Checkerworldlimiter"){

            @Override
            public void run() {
                try {
                    URL url = new URL(UPDATE_URL);
                    Scanner scanner = new Scanner(url.openStream());
                    while (scanner.hasNextLine()) {
                        String contentString = scanner.nextLine();
                        String[] content = contentString.split("-");
                        if (!content[0].equals("1.10.2")) continue;
                        latest = content[1];
                        break;
                    }
                    scanner.close();
                }
                catch (MalformedURLException e) {
                    SysUtils.println("URL ERROR: MALFORMED URL");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!latest.equals("1.0.2")) {
                    ModUpdate.setNewVersionAvailable();
                }
            }
        }.start();
    }

    private static synchronized void setNewVersionAvailable() {
        newVersionAvailable = true;
        SysUtils.println("New Version available: " + latest);
        SysUtils.println("download it here: http://www.minecraftforum.net/forums/mapping-and-modding/minecraft-mods/2729513");
    }

    public static synchronized boolean isNewVersionAvailable() {
        return newVersionAvailable;
    }

    public static synchronized String getLatest() {
        return latest;
    }
}

