/*
 * Decompiled with CFR 0.152.
 */
package mod.upcraftlp.worldlimiter.init;

import java.util.Iterator;
import mod.upcraftlp.worldlimiter.init.ModConfig;
import mod.upcraftlp.worldlimiter.util.SysUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class WorldBorderEvents {
    private static int border = 0;
    private static int notRange;
    private static boolean showNotification;

    public static void init() {
        border = ModConfig.maxWorldSize;
        showNotification = ModConfig.enableNotification;
        notRange = ModConfig.notificationRange;
        if (border > 0) {
            MinecraftForge.EVENT_BUS.register((Object)new WorldBorderEvents());
        }
    }

    private void notifyPlayer(EntityPlayer player) {
        if (player.func_184216_O() != null) {
            for (String tag : player.func_184216_O()) {
                if (!tag.equals("closeToBorder")) continue;
                return;
            }
        }
        player.func_146105_b((ITextComponent)new TextComponentString("You're close to the world border, expect teleporting"));
        player.func_184216_O().add("closeToBorder");
    }

    public static void worldBorder(FMLServerStartedEvent event) {
        WorldServer[] worlds;
        if (border == 0) {
            return;
        }
        for (WorldServer worldServer : worlds = FMLCommonHandler.instance().getMinecraftServerInstance().func_184102_h().field_71305_c) {
            if (worldServer.field_73011_w.getDimension() != 0) continue;
            int wBorder = border * 2 + 1;
            worldServer.func_175723_af().func_177725_a(wBorder);
            worldServer.func_175723_af().func_177739_c(0.0, 0.0);
            worldServer.func_175723_af().func_177747_c(notRange);
            SysUtils.printlineFML("Successfully set world border for dimension 0 to " + worldServer.func_175723_af().func_177741_h() / 2.0 + " Blocks.");
        }
    }

    @SubscribeEvent
    public void notifyPlayers(TickEvent.PlayerTickEvent event) {
        if (!showNotification || event.side == Side.CLIENT || event.player == null) {
            return;
        }
        EntityPlayer player = event.player;
        if (player.field_70170_p.field_73011_w.getDimension() != 0) {
            return;
        }
        if (player.field_70165_t > (double)(border - notRange)) {
            this.notifyPlayer(player);
            return;
        }
        if (player.field_70165_t < (double)(-border + notRange)) {
            this.notifyPlayer(player);
            return;
        }
        if (player.field_70161_v > (double)(border - notRange)) {
            this.notifyPlayer(player);
            return;
        }
        if (player.field_70161_v < (double)(-border + notRange)) {
            this.notifyPlayer(player);
            return;
        }
        if (player.func_184216_O() != null) {
            Iterator i = player.func_184216_O().iterator();
            while (i.hasNext()) {
                String tag = (String)i.next();
                if (!tag.equals("closeToBorder")) continue;
                i.remove();
            }
        }
    }

    @SubscribeEvent
    public void teleportEntities(LivingEvent.LivingUpdateEvent event) {
        Entity entity = event.getEntity();
        World world = entity.field_70170_p;
        if (world.field_72995_K || world.field_73011_w.getDimension() != 0) {
            return;
        }
        if (entity.field_70165_t > (double)border) {
            BlockPos newPos = new BlockPos((double)(-border + notRange) + 5.0, entity.field_70163_u, entity.field_70161_v);
            if (!world.func_175623_d(newPos) || !world.func_175623_d(newPos.func_177984_a())) {
                newPos = world.func_175672_r(newPos).func_177984_a();
            }
            entity.func_70634_a((double)newPos.func_177958_n(), (double)newPos.func_177956_o(), (double)newPos.func_177952_p());
            if (entity.func_184188_bt() != null) {
                for (Entity passenger : entity.func_184188_bt()) {
                    world.func_72870_g(passenger);
                    if (!(passenger instanceof EntityPlayer)) continue;
                    EntityPlayer player = (EntityPlayer)passenger;
                    player.func_146105_b((ITextComponent)new TextComponentString("Please get off your mount to update your position."));
                }
            }
            return;
        }
        if (entity.field_70165_t < (double)(-border)) {
            BlockPos newPos = new BlockPos((double)(border - notRange) - 5.0, entity.field_70163_u, entity.field_70161_v);
            if (!world.func_175623_d(newPos) || !world.func_175623_d(newPos.func_177984_a())) {
                newPos = world.func_175672_r(newPos).func_177984_a();
            }
            entity.func_70634_a((double)newPos.func_177958_n(), (double)newPos.func_177956_o(), (double)newPos.func_177952_p());
            if (entity.func_184188_bt() != null) {
                for (Entity passenger : entity.func_184188_bt()) {
                    world.func_72870_g(passenger);
                    if (!(passenger instanceof EntityPlayer)) continue;
                    EntityPlayer player = (EntityPlayer)passenger;
                    player.func_146105_b((ITextComponent)new TextComponentString("Please get off your mount to update your position."));
                }
            }
            return;
        }
        if (entity.field_70161_v > (double)border) {
            BlockPos newPos = new BlockPos(entity.field_70165_t, entity.field_70163_u, (double)(-border + notRange) + 5.0);
            if (!world.func_175623_d(newPos) || !world.func_175623_d(newPos.func_177984_a())) {
                newPos = world.func_175672_r(newPos).func_177984_a();
            }
            entity.func_70634_a((double)newPos.func_177958_n(), (double)newPos.func_177956_o(), (double)newPos.func_177952_p());
            if (entity.func_184188_bt() != null) {
                for (Entity passenger : entity.func_184188_bt()) {
                    world.func_72870_g(passenger);
                    if (!(passenger instanceof EntityPlayer)) continue;
                    EntityPlayer player = (EntityPlayer)passenger;
                    player.func_146105_b((ITextComponent)new TextComponentString("Please get off your mount to update your position."));
                }
            }
            return;
        }
        if (entity.field_70161_v < (double)(-border)) {
            BlockPos newPos = new BlockPos(entity.field_70165_t, entity.field_70163_u, (double)(border - notRange) - 5.0);
            if (!world.func_175623_d(newPos) || !world.func_175623_d(newPos.func_177984_a())) {
                newPos = world.func_175672_r(newPos).func_177984_a();
            }
            entity.func_70634_a((double)newPos.func_177958_n(), (double)newPos.func_177956_o(), (double)newPos.func_177952_p());
            if (entity.func_184188_bt() != null) {
                for (Entity passenger : entity.func_184188_bt()) {
                    world.func_72870_g(passenger);
                    if (!(passenger instanceof EntityPlayer)) continue;
                    EntityPlayer player = (EntityPlayer)passenger;
                    player.func_146105_b((ITextComponent)new TextComponentString("Please get off your mount to update your position."));
                }
            }
            return;
        }
    }
}

