/*
 * Decompiled with CFR 0.152.
 */
package com.theundertaker11.geneticsreborn.api.capability.genes;

import com.theundertaker11.geneticsreborn.api.capability.genes.EnumGenes;
import com.theundertaker11.geneticsreborn.api.capability.genes.IGenes;
import com.theundertaker11.geneticsreborn.util.ModUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class Genes
implements IGenes {
    public static final int TotalNumberOfGenes = EnumGenes.values().length;
    private List<EnumGenes> EnumGenesList = new ArrayList<EnumGenes>();

    @Override
    public void addGene(EnumGenes gene) {
        if (!this.EnumGenesList.contains((Object)gene)) {
            this.EnumGenesList.add(gene);
        }
    }

    @Override
    public void removeGene(EnumGenes gene) {
        if (this.EnumGenesList.contains((Object)gene)) {
            this.EnumGenesList.remove((Object)gene);
        }
    }

    @Override
    public boolean hasGene(EnumGenes gene) {
        return this.EnumGenesList.contains((Object)gene);
    }

    @Override
    public List<EnumGenes> getGeneList() {
        return this.EnumGenesList;
    }

    @Override
    public void setGeneList(List<EnumGenes> list) {
        this.EnumGenesList = list;
    }

    @Override
    public void removeAllGenes() {
        this.EnumGenesList = new ArrayList<EnumGenes>();
    }

    @Override
    public void addAllGenes() {
        this.EnumGenesList = new ArrayList<EnumGenes>(Arrays.asList(EnumGenes.values()));
    }

    @Override
    public int getGeneNumber() {
        return this.EnumGenesList.size();
    }

    public static EnumGenes getGeneFromString(String nbtstring) {
        if ("Null".equals(nbtstring)) {
            return null;
        }
        ArrayList<EnumGenes> allGenes = new ArrayList<EnumGenes>(Arrays.asList(EnumGenes.values()));
        for (int i = 0; i < allGenes.size(); ++i) {
            String genename = allGenes.get(i).toString();
            if (!nbtstring.equals("GeneticsReborn" + genename)) continue;
            return allGenes.get(i);
        }
        return null;
    }

    public static ItemStack setNBTStringsFromGenes(ItemStack stack, EntityLivingBase entityLiving) {
        if (ModUtils.getIGenes(entityLiving) == null) {
            return stack;
        }
        NBTTagCompound tag = ModUtils.getTagCompound(stack);
        IGenes genes = ModUtils.getIGenes(entityLiving);
        List<EnumGenes> genelist = genes.getGeneList();
        for (int i = 0; i < genes.getGeneNumber(); ++i) {
            String genename = genelist.get(i).toString();
            tag.func_74778_a(Integer.toString(i), "GeneticsReborn" + genename);
        }
        return stack;
    }
}

