/*
 * Decompiled with CFR 0.152.
 */
package cyano.basemetals.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class VillagerTradeHelper {
    private static final ResourceLocation[] professionList = new ResourceLocation[]{new ResourceLocation("minecraft:farmer"), new ResourceLocation("minecraft:librarian"), new ResourceLocation("minecraft:priest"), new ResourceLocation("minecraft:smith"), new ResourceLocation("minecraft:butcher")};

    public static void insertTrades(int professionID, int careerID, int tradeLevel, EntityVillager.ITradeList ... trades) throws NoSuchFieldException, IllegalAccessException {
        ResourceLocation profession = professionList[professionID];
        VillagerTradeHelper.insertTrades(profession, careerID, tradeLevel, trades);
    }

    public static void insertTrades(ResourceLocation profession, int careerID, int tradeLevel, EntityVillager.ITradeList ... trades) {
        for (EntityVillager.ITradeList trade : trades) {
            ((VillagerRegistry.VillagerProfession)VillagerRegistry.instance().getRegistry().getValue(profession)).getCareer(careerID - 1).addTrade(tradeLevel, new EntityVillager.ITradeList[]{trade});
        }
    }

    public static void appendToMultidimensionalArray(Object append, Object array, int ... indices) {
        VillagerTradeHelper.appendToMultidimensionalArray(Arrays.asList(append).toArray(), array, indices);
    }

    public static void appendToMultidimensionalArray(Object[] append, Object array, int ... indices) {
        Object prevArray = null;
        int i = 0;
        while (i < indices.length) {
            int index = indices[i];
            prevArray = array;
            array = Array.get(array, index);
            if (++i >= indices.length) continue;
            int nextIndex = indices[i];
            if (Array.getLength(array) > nextIndex) continue;
            Object pad = array.getClass().getComponentType().isArray() ? Array.newInstance(array.getClass().getComponentType().getComponentType(), 0) : null;
            Object newArray = VillagerTradeHelper.expandArray(array, nextIndex + 1, pad);
            Array.set(prevArray, index, newArray);
            array = newArray;
        }
        Class<?> aType = array.getClass().getComponentType();
        if (!aType.isAssignableFrom(append.getClass().getComponentType())) {
            throw new IllegalArgumentException("Class type " + append.getClass().getComponentType().getCanonicalName() + " cannot be appended to " + aType.getCanonicalName() + " array");
        }
        Object newArray = VillagerTradeHelper.expandArray(array, Array.getLength(array) + append.length, null);
        System.arraycopy(append, 0, newArray, Array.getLength(array), append.length);
        Array.set(prevArray, indices[indices.length - 1], newArray);
    }

    public static Object expandArray(Object array, int newSize, Object fill) {
        Object newArray = Array.newInstance(array.getClass().getComponentType(), newSize);
        if (Array.getLength(array) == 0) {
            return newArray;
        }
        System.arraycopy(array, 0, newArray, 0, Array.getLength(array));
        for (int i = Array.getLength(array); i < newSize; ++i) {
            Array.set(newArray, i, fill);
        }
        return newArray;
    }

    public static void unlockPrivateFinalField(Field v) throws NoSuchFieldException, IllegalAccessException {
        v.setAccessible(true);
        Field modField = Field.class.getDeclaredField("modifiers");
        modField.setAccessible(true);
        modField.setInt(v, v.getModifiers() & 0xFFFFFFEF);
    }

    public static Field getTradeArrayFromClass(Class c) {
        for (Field f : c.getDeclaredFields()) {
            if (!f.getType().isArray() || !f.getType().getComponentType().isArray() || !f.getType().getComponentType().getComponentType().isArray() || !f.getType().getComponentType().getComponentType().getComponentType().isArray() || !f.getType().getComponentType().getComponentType().getComponentType().getComponentType().isAssignableFrom(EntityVillager.ITradeList.class)) continue;
            return f;
        }
        return null;
    }
}

