/*
 * Decompiled with CFR 0.152.
 */
package cyano.basemetals.items;

import cyano.basemetals.init.Achievements;
import cyano.basemetals.init.Items;
import cyano.basemetals.init.Materials;
import cyano.basemetals.items.MetalToolEffects;
import cyano.basemetals.material.IMetalObject;
import cyano.basemetals.material.MetalMaterial;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemMetalArmor
extends ItemArmor
implements IMetalObject {
    private static final ResourceLocation speedPotionKey = new ResourceLocation("speed");
    private static final ResourceLocation jumpPotionKey = new ResourceLocation("jump_boost");
    private static final ResourceLocation slowPotionKey = new ResourceLocation("slowness");
    private static final ResourceLocation protectionPotionKey = new ResourceLocation("resistance");
    private static final ResourceLocation waterBreathingPotionKey = new ResourceLocation("water_breathing");
    private static final ResourceLocation waterBuffPotionKey = new ResourceLocation("resistance");
    private static final ResourceLocation fatiguePotionKey = new ResourceLocation("mining_fatigue");
    private static final ResourceLocation fireproofPotionKey = new ResourceLocation("fire_resistance");
    protected final String customTexture;
    protected final MetalMaterial metal;
    protected final String repairOreDictName;
    private static final int UPDATE_INTERVAL = 11;
    private static final int EFFECT_DURATION = 45;
    private static final Map<EntityPlayer, AtomicLong> playerUpdateTimestampMap = new HashMap<EntityPlayer, AtomicLong>();
    private static final Map<EntityPlayer, AtomicInteger> playerUpdateCountMap = new HashMap<EntityPlayer, AtomicInteger>();
    private static final Map<EntityPlayer, AtomicInteger> starsteelUpdateCache = new HashMap<EntityPlayer, AtomicInteger>();
    private static final Map<EntityPlayer, AtomicInteger> adamantineUpdateCache = new HashMap<EntityPlayer, AtomicInteger>();
    private static final Map<EntityPlayer, AtomicInteger> leadUpdateCache = new HashMap<EntityPlayer, AtomicInteger>();

    protected ItemMetalArmor(MetalMaterial metal, ItemArmor.ArmorMaterial armorMat, int renderIndex, EntityEquipmentSlot slot) {
        super(armorMat, renderIndex, slot);
        this.metal = metal;
        this.repairOreDictName = "ingot" + metal.getCapitalizedName();
        this.customTexture = "basemetals:textures/models/armor/" + metal.getName() + "_layer_" + (slot == EntityEquipmentSlot.LEGS ? 2 : 1) + ".png";
    }

    public void onArmorTick(World w, EntityPlayer player, ItemStack armor) {
        if (!playerUpdateTimestampMap.containsKey(player)) {
            playerUpdateTimestampMap.put(player, new AtomicLong(0L));
            playerUpdateCountMap.put(player, new AtomicInteger(0));
            return;
        }
        if (!w.field_72995_K && w.func_82737_E() > playerUpdateTimestampMap.get(player).get()) {
            playerUpdateTimestampMap.get(player).set(w.func_82737_E() + 11L);
            int updateCount = playerUpdateCountMap.get(player).getAndIncrement();
            for (int i = 0; i < 4; ++i) {
                if (player.field_71071_by.field_70460_b[i] == null || !(player.field_71071_by.field_70460_b[i].func_77973_b() instanceof ItemMetalArmor)) continue;
                this.doArmorUpdate(w, player, player.field_71071_by.field_70460_b[i], updateCount);
            }
        }
    }

    protected void doArmorUpdate(World w, EntityPlayer player, ItemStack armor, int i) {
        if (armor == null) {
            return;
        }
        if (armor.func_77973_b() == null) {
            return;
        }
        if (player == null) {
            return;
        }
        Item armorItem = armor.func_77973_b();
        if (i % 2 == 0) {
            if (((ItemMetalArmor)armorItem).metal.equals(Materials.starsteel)) {
                if (!starsteelUpdateCache.containsKey(player)) {
                    starsteelUpdateCache.put(player, new AtomicInteger(0));
                }
                starsteelUpdateCache.get(player).incrementAndGet();
                if (armorItem == Items.starsteel_boots) {
                    player.func_71064_a((StatBase)Achievements.moon_boots, 1);
                }
            }
            if (((ItemMetalArmor)armorItem).metal.equals(Materials.lead)) {
                if (!leadUpdateCache.containsKey(player)) {
                    leadUpdateCache.put(player, new AtomicInteger(0));
                }
                leadUpdateCache.get(player).incrementAndGet();
            }
            if (((ItemMetalArmor)armorItem).metal.equals(Materials.adamantine)) {
                if (!adamantineUpdateCache.containsKey(player)) {
                    adamantineUpdateCache.put(player, new AtomicInteger(0));
                }
                adamantineUpdateCache.get(player).incrementAndGet();
            }
        } else {
            int level;
            int level2;
            int num;
            if (starsteelUpdateCache.containsKey(player) && (num = starsteelUpdateCache.get(player).getAndSet(0)) != 0) {
                PotionEffect jumpBoost = new PotionEffect((Potion)Potion.field_188414_b.func_82594_a((Object)jumpPotionKey), 45, num - 1, false, false);
                player.func_70690_d(jumpBoost);
                if (num > 1) {
                    PotionEffect speedBoost = new PotionEffect((Potion)Potion.field_188414_b.func_82594_a((Object)speedPotionKey), 45, num - 2, false, false);
                    player.func_70690_d(speedBoost);
                }
            }
            if (leadUpdateCache.containsKey(player) && (level2 = leadUpdateCache.get(player).getAndSet(0) / 2) != 0 && level2 > 0) {
                PotionEffect speedLoss = new PotionEffect((Potion)Potion.field_188414_b.func_82594_a((Object)slowPotionKey), 45, level2 - 1, false, false);
                player.func_70690_d(speedLoss);
            }
            if (adamantineUpdateCache.containsKey(player) && (level = (num = adamantineUpdateCache.get(player).getAndSet(0)) / 2) != 0) {
                if (level > 0) {
                    PotionEffect protection = new PotionEffect((Potion)Potion.field_188414_b.func_82594_a((Object)protectionPotionKey), 45, level - 1, false, false);
                    player.func_70690_d(protection);
                }
                if (num == 4) {
                    player.func_71064_a((StatBase)Achievements.juggernaut, 1);
                }
            }
            if (armorItem == Items.coldiron_helmet && player.field_71071_by.field_70460_b[2] != null && player.field_71071_by.field_70460_b[2].func_77973_b() == Items.coldiron_chestplate && player.field_71071_by.field_70460_b[1] != null && player.field_71071_by.field_70460_b[1].func_77973_b() == Items.coldiron_leggings && player.field_71071_by.field_70460_b[0] != null && player.field_71071_by.field_70460_b[0].func_77973_b() == Items.coldiron_boots) {
                PotionEffect fireProtection = new PotionEffect((Potion)Potion.field_188414_b.func_82594_a((Object)fireproofPotionKey), 45, 0, false, false);
                player.func_70690_d(fireProtection);
                if (player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() == Items.coldiron_sword) {
                    player.func_71064_a((StatBase)Achievements.demon_slayer, 1);
                }
            }
            if (armorItem == Items.mithril_helmet && player.field_71071_by.field_70460_b[2] != null && player.field_71071_by.field_70460_b[2].func_77973_b() == Items.mithril_chestplate && player.field_71071_by.field_70460_b[1] != null && player.field_71071_by.field_70460_b[1].func_77973_b() == Items.mithril_leggings && player.field_71071_by.field_70460_b[0] != null && player.field_71071_by.field_70460_b[0].func_77973_b() == Items.mithril_boots) {
                LinkedList<Potion> removeList = new LinkedList<Potion>();
                for (PotionEffect pe : player.func_70651_bq()) {
                    Potion p = pe.func_188419_a();
                    if (!p.func_76398_f()) continue;
                    removeList.add(p);
                }
                for (Potion p : removeList) {
                    player.func_184589_d(p);
                }
                if (player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() == Items.mithril_sword) {
                    player.func_71064_a((StatBase)Achievements.angel_of_death, 1);
                }
            }
            if (armorItem == Items.aquarium_helmet && player.field_70163_u > 0.0 && player.field_70163_u < 255.0 && player.field_71071_by.field_70460_b[2] != null && player.field_71071_by.field_70460_b[2].func_77973_b() == Items.aquarium_chestplate && player.field_71071_by.field_70460_b[1] != null && player.field_71071_by.field_70460_b[1].func_77973_b() == Items.aquarium_leggings && player.field_71071_by.field_70460_b[0] != null && player.field_71071_by.field_70460_b[0].func_77973_b() == Items.aquarium_boots) {
                Block b1 = w.func_180495_p(new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v)).func_177230_c();
                Block b2 = w.func_180495_p(new BlockPos(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v)).func_177230_c();
                if (b1 == Blocks.field_150355_j && b2 == Blocks.field_150355_j) {
                    PotionEffect waterBreathing = new PotionEffect((Potion)Potion.field_188414_b.func_82594_a((Object)waterBreathingPotionKey), 45, 0, false, false);
                    player.func_70690_d(waterBreathing);
                    PotionEffect protection = new PotionEffect((Potion)Potion.field_188414_b.func_82594_a((Object)waterBuffPotionKey), 45, 0, false, false);
                    player.func_70690_d(protection);
                    player.func_184589_d((Potion)Potion.field_188414_b.func_82594_a((Object)fatiguePotionKey));
                    player.func_71064_a((StatBase)Achievements.scuba_diver, 1);
                }
            }
        }
    }

    public static ItemMetalArmor createHelmet(MetalMaterial metal) {
        ItemArmor.ArmorMaterial material = Materials.getArmorMaterialFor(metal);
        if (material == null) {
            FMLLog.severe((String)("Failed to load armor material enum for " + metal), (Object[])new Object[0]);
        }
        return new ItemMetalArmor(metal, material, material.ordinal(), EntityEquipmentSlot.HEAD);
    }

    public static ItemMetalArmor createChestplate(MetalMaterial metal) {
        ItemArmor.ArmorMaterial material = Materials.getArmorMaterialFor(metal);
        if (material == null) {
            FMLLog.severe((String)("Failed to load armor material enum for " + metal), (Object[])new Object[0]);
        }
        return new ItemMetalArmor(metal, material, material.ordinal(), EntityEquipmentSlot.CHEST);
    }

    public static ItemMetalArmor createLeggings(MetalMaterial metal) {
        ItemArmor.ArmorMaterial material = Materials.getArmorMaterialFor(metal);
        if (material == null) {
            FMLLog.severe((String)("Failed to load armor material enum for " + metal), (Object[])new Object[0]);
        }
        return new ItemMetalArmor(metal, material, material.ordinal(), EntityEquipmentSlot.LEGS);
    }

    public static ItemMetalArmor createBoots(MetalMaterial metal) {
        ItemArmor.ArmorMaterial material = Materials.getArmorMaterialFor(metal);
        if (material == null) {
            FMLLog.severe((String)("Failed to load armor material enum for " + metal), (Object[])new Object[0]);
        }
        return new ItemMetalArmor(metal, material, material.ordinal(), EntityEquipmentSlot.FEET);
    }

    public void func_77622_d(ItemStack item, World world, EntityPlayer crafter) {
        super.func_77622_d(item, world, crafter);
        this.extraEffectsOnCrafting(item, world, crafter);
    }

    public void extraEffectsOnCrafting(ItemStack item, World world, EntityPlayer crafter) {
    }

    public boolean func_82789_a(ItemStack srcItemStack, ItemStack repairMaterial) {
        List acceptableItems = OreDictionary.getOres((String)this.repairOreDictName);
        for (ItemStack i : acceptableItems) {
            if (!ItemStack.func_179545_c((ItemStack)i, (ItemStack)repairMaterial)) continue;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity e, EntityEquipmentSlot slot, String layer) {
        return this.customTexture;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean b) {
        super.func_77624_a(stack, player, list, b);
        MetalToolEffects.addArmorSpecialPropertiesToolTip(this.metal, list);
    }

    @Override
    public MetalMaterial getMetalMaterial() {
        return this.metal;
    }
}

