/*
 * Decompiled with CFR 0.152.
 */
package cyano.basemetals.init;

import cyano.basemetals.init.Items;
import cyano.basemetals.init.Materials;
import cyano.basemetals.items.ItemMetalCrackHammer;
import cyano.basemetals.items.ItemMetalIngot;
import cyano.basemetals.material.MetalMaterial;
import cyano.basemetals.util.VillagerTradeHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public abstract class VillagerTrades {
    public static final int TRADES_PER_LEVEL = 4;
    private static boolean initDone = false;

    public static void init() {
        if (initDone) {
            return;
        }
        Materials.init();
        Items.init();
        int size = Materials.getAllMetals().size();
        HashMap allArmors = new HashMap(size);
        HashMap allHammers = new HashMap(size);
        HashMap allSwords = new HashMap(size);
        HashMap allHoes = new HashMap(size);
        HashMap allAxes = new HashMap(size);
        HashMap allPickAxes = new HashMap(size);
        HashMap allShovels = new HashMap(size);
        HashMap allIngots = new HashMap(size);
        HashMap tradeLevelMap = new HashMap();
        Items.getItemsByMetal().entrySet().stream().forEach(e -> {
            MetalMaterial m = (MetalMaterial)e.getKey();
            if (m == null) {
                return;
            }
            for (Item i : (List)e.getValue()) {
                if (i instanceof ItemArmor) {
                    allArmors.computeIfAbsent(m, g -> new ArrayList()).add(i);
                    continue;
                }
                if (i instanceof ItemMetalCrackHammer) {
                    allHammers.put(m, i);
                    continue;
                }
                if (i instanceof ItemSword) {
                    allSwords.put(m, i);
                    continue;
                }
                if (i instanceof ItemHoe) {
                    allHoes.put(m, i);
                    continue;
                }
                if (i instanceof ItemAxe) {
                    allAxes.put(m, i);
                    continue;
                }
                if (i instanceof ItemPickaxe) {
                    allPickAxes.put(m, i);
                    continue;
                }
                if (i instanceof ItemSpade) {
                    allShovels.put(m, i);
                    continue;
                }
                if (!(i instanceof ItemMetalIngot)) continue;
                allIngots.put(m, i);
            }
        });
        HashMap<Integer, List> tradesTable = new HashMap<Integer, List>();
        for (MetalMaterial m : Materials.getAllMetals()) {
            float value = m.hardness + m.strength + m.magicAffinity + (float)m.getToolHarvestLevel();
            if (m.isRare) continue;
            int emeraldPurch = VillagerTrades.emeraldPurchaseValue(value);
            int emeraldSale = VillagerTrades.emeraldSaleValue(value);
            int tradeLevel = VillagerTrades.tradeLevel(value);
            if (emeraldPurch > 64 || emeraldSale > 64) continue;
            int armorsmith = 0x30100 | tradeLevel;
            int weaponsmith = 0x30200 | tradeLevel;
            int toolsmith = 0x30300 | tradeLevel;
            if (allIngots.containsKey(m)) {
                EntityVillager.ITradeList[] ingotTrades = VillagerTrades.makeTradePalette(VillagerTrades.makePurchasePalette(emeraldPurch, 12, (Item)allIngots.get(m)), VillagerTrades.makeSalePalette(emeraldSale, 12, (Item)allIngots.get(m)));
                tradesTable.computeIfAbsent(armorsmith, key -> new ArrayList()).addAll(Arrays.asList(ingotTrades));
                tradesTable.computeIfAbsent(weaponsmith, key -> new ArrayList()).addAll(Arrays.asList(ingotTrades));
                tradesTable.computeIfAbsent(toolsmith, key -> new ArrayList()).addAll(Arrays.asList(ingotTrades));
            }
            if (allHammers.containsKey(m) && allPickAxes.containsKey(m) && allAxes.containsKey(m) && allShovels.containsKey(m) && allHoes.containsKey(m)) {
                tradesTable.computeIfAbsent(toolsmith, key -> new ArrayList()).addAll(Arrays.asList(VillagerTrades.makeTradePalette(new EntityVillager.ITradeList[][]{VillagerTrades.makePurchasePalette(emeraldPurch, 1, (Item)allPickAxes.get(m), (Item)allAxes.get(m), (Item)allShovels.get(m), (Item)allHoes.get(m))})));
                tradesTable.computeIfAbsent(0x30300 | tradeLevel + 1, key -> new ArrayList()).addAll(Arrays.asList(VillagerTrades.makeTradePalette(new EntityVillager.ITradeList[][]{VillagerTrades.makePurchasePalette(emeraldPurch, 1, (Item)allHammers.get(m))})));
            }
            if (allSwords.containsKey(m)) {
                tradesTable.computeIfAbsent(weaponsmith, key -> new ArrayList()).addAll(Arrays.asList(VillagerTrades.makeTradePalette(new EntityVillager.ITradeList[][]{VillagerTrades.makePurchasePalette(emeraldPurch + (int)(m.getBaseAttackDamage() / 2.0f) - 1, 1, (Item)allSwords.get(m))})));
            }
            if (allArmors.containsKey(m)) {
                tradesTable.computeIfAbsent(armorsmith, key -> new ArrayList()).addAll(Arrays.asList(VillagerTrades.makeTradePalette(new EntityVillager.ITradeList[][]{VillagerTrades.makePurchasePalette(emeraldPurch + (int)(m.hardness / 2.0f), 1, ((List)allArmors.get(m)).toArray(new Item[0]))})));
            }
            if (!(m.magicAffinity > 5.0f)) continue;
            if (allHammers.containsKey(m)) {
                tradesTable.computeIfAbsent(0x30300 | tradeLevel + 2, key -> new ArrayList()).addAll(Arrays.asList(new EntityVillager.ListEnchantedItemForEmeralds((Item)allHammers.get(m), new EntityVillager.PriceInfo(emeraldPurch + 7, emeraldPurch + 12))));
            }
            if (allPickAxes.containsKey(m)) {
                tradesTable.computeIfAbsent(0x30300 | tradeLevel + 1, key -> new ArrayList()).addAll(Arrays.asList(new EntityVillager.ListEnchantedItemForEmeralds((Item)allPickAxes.get(m), new EntityVillager.PriceInfo(emeraldPurch + 7, emeraldPurch + 12))));
            }
            if (allArmors.containsKey(m)) {
                for (int i = 0; i < ((List)allArmors.get(m)).size(); ++i) {
                    tradesTable.computeIfAbsent(0x30100 | tradeLevel + 1, key -> new ArrayList()).addAll(Arrays.asList(new EntityVillager.ListEnchantedItemForEmeralds((Item)((List)allArmors.get(m)).get(i), new EntityVillager.PriceInfo(emeraldPurch + 7 + (int)(m.hardness / 2.0f), emeraldPurch + 12 + (int)(m.hardness / 2.0f)))));
                }
            }
            if (!allSwords.containsKey(m)) continue;
            tradesTable.computeIfAbsent(0x30200 | tradeLevel + 1, key -> new ArrayList()).addAll(Arrays.asList(new EntityVillager.ListEnchantedItemForEmeralds((Item)allSwords.get(m), new EntityVillager.PriceInfo(emeraldPurch + 7 + (int)(m.getBaseAttackDamage() / 2.0f) - 1, emeraldPurch + 12 + (int)(m.getBaseAttackDamage() / 2.0f) - 1))));
        }
        tradesTable.computeIfAbsent(196865, key -> new ArrayList()).addAll(Arrays.asList(VillagerTrades.makePurchasePalette(1, 10, Items.carbon_powder)));
        tradesTable.computeIfAbsent(197121, key -> new ArrayList()).addAll(Arrays.asList(VillagerTrades.makePurchasePalette(1, 10, Items.carbon_powder)));
        tradesTable.computeIfAbsent(197377, key -> new ArrayList()).addAll(Arrays.asList(VillagerTrades.makePurchasePalette(1, 10, Items.carbon_powder)));
        for (Integer k : tradesTable.keySet()) {
            List trades = (List)tradesTable.get(k);
            int profession = k >> 16 & 0xFF;
            int career = k >> 8 & 0xFF;
            int level = k & 0xFF;
            try {
                VillagerTradeHelper.insertTrades(profession, career, level, new MultiTradeGenerator(4, trades));
            }
            catch (IllegalAccessException | NoSuchFieldException ex) {
                FMLLog.log((Level)Level.ERROR, (Throwable)ex, (String)"Java Reflection Exception", (Object[])new Object[0]);
            }
        }
        initDone = true;
    }

    private static int emeraldPurchaseValue(float value) {
        return Math.max(1, (int)(value * 0.2f));
    }

    private static int emeraldSaleValue(float value) {
        return Math.max(1, VillagerTrades.emeraldPurchaseValue(value) / 3);
    }

    private static int tradeLevel(float value) {
        return Math.max(1, Math.min(4, (int)(value * 0.1f)));
    }

    private static int fluctuation(int baseValue) {
        if (baseValue <= 1) {
            return 0;
        }
        return Math.max(2, baseValue / 4);
    }

    private static EntityVillager.ITradeList[] makePurchasePalette(int emeraldPrice, int stackSize, Item ... items) {
        EntityVillager.ITradeList[] trades = new EntityVillager.ITradeList[items.length];
        for (int i = 0; i < items.length; ++i) {
            Item item = items[i];
            trades[i] = new SimpleTrade(new ItemStack(net.minecraft.init.Items.field_151166_bC, emeraldPrice, 0), VillagerTrades.fluctuation(emeraldPrice), null, 0, new ItemStack(item, stackSize, 0), 0);
        }
        return trades;
    }

    private static EntityVillager.ITradeList[] makeSalePalette(int emeraldValue, int stackSize, Item ... items) {
        EntityVillager.ITradeList[] trades = new EntityVillager.ITradeList[items.length];
        for (int i = 0; i < items.length; ++i) {
            Item item = items[i];
            trades[i] = new SimpleTrade(new ItemStack(item, stackSize, 0), VillagerTrades.fluctuation(stackSize), null, 0, new ItemStack(net.minecraft.init.Items.field_151166_bC, emeraldValue, 0), 0);
        }
        return trades;
    }

    private static EntityVillager.ITradeList[] makeTradePalette(EntityVillager.ITradeList[] ... list) {
        if (list.length == 1) {
            return list[0];
        }
        int totalsize = 0;
        for (EntityVillager.ITradeList[] e : list) {
            totalsize += e.length;
        }
        EntityVillager.ITradeList[] concat = new EntityVillager.ITradeList[totalsize];
        int index = 0;
        int element = 0;
        while (index < totalsize) {
            System.arraycopy(list[element], 0, concat, index, list[element].length);
            index += list[element].length;
            ++element;
        }
        return concat;
    }

    public static class SimpleTrade
    implements EntityVillager.ITradeList {
        private final ItemStack input1;
        private final int maxInputMarkup1;
        private final ItemStack input2;
        private final int maxInputMarkup2;
        private final ItemStack output;
        private final int maxOutputMarkup;
        private final int maxTrades;
        private final int maxTradeVariation;

        public String toString() {
            return this.input1 + " + " + this.input2 + " => " + this.output;
        }

        public SimpleTrade(ItemStack in1, int variation1, ItemStack in2, int variation2, ItemStack out, int variationOut, int numberTrades, int tradeNumberVariation) {
            this.input1 = in1;
            this.maxInputMarkup1 = variation1;
            this.input2 = in2;
            this.maxInputMarkup2 = variation2;
            this.output = out;
            this.maxOutputMarkup = variationOut;
            this.maxTrades = numberTrades;
            this.maxTradeVariation = tradeNumberVariation;
        }

        public SimpleTrade(ItemStack in1, int v1, ItemStack in2, int v2, ItemStack out, int vout) {
            this(in1, v1, in2, v2, out, vout, -1, -1);
        }

        public SimpleTrade(ItemStack in1, int v1, ItemStack out, int vout) {
            this(in1, v1, null, 0, out, vout, -1, -1);
        }

        public SimpleTrade(ItemStack in1, ItemStack out) {
            this(in1, 0, null, 0, out, 0, -1, -1);
        }

        public void func_179401_a(MerchantRecipeList recipeList, Random random) {
            int numTrades = -1;
            if (this.maxTrades > 0) {
                numTrades = this.maxTradeVariation > 0 ? Math.max(1, this.maxTrades + random.nextInt(this.maxTradeVariation) - this.maxTradeVariation / 2) : this.maxTrades;
            }
            ItemStack in1 = this.input1.func_77946_l();
            if (this.maxInputMarkup1 > 0) {
                in1.field_77994_a += random.nextInt(this.maxInputMarkup1);
            }
            ItemStack in2 = null;
            if (this.input2 != null && this.input2.func_77973_b() != null) {
                in2 = this.input2.func_77946_l();
                if (this.maxInputMarkup2 > 0) {
                    in2.field_77994_a += random.nextInt(this.maxInputMarkup2);
                }
            }
            ItemStack out = this.output.func_77946_l();
            if (this.maxOutputMarkup > 0) {
                out.field_77994_a += random.nextInt(this.maxOutputMarkup);
            }
            if (numTrades > 0) {
                recipeList.add((Object)new MerchantRecipe(in1, in2, out, 0, numTrades));
            } else {
                recipeList.add((Object)new MerchantRecipe(in1, in2, out));
            }
        }
    }

    public static class MultiTradeGenerator
    implements EntityVillager.ITradeList {
        private final int numberOfTrades;
        private final EntityVillager.ITradeList[] trades;

        public MultiTradeGenerator(int tradeCount, List<EntityVillager.ITradeList> tradePalette) {
            this.numberOfTrades = Math.min(tradeCount, tradePalette.size());
            this.trades = tradePalette.toArray(new EntityVillager.ITradeList[tradePalette.size()]);
        }

        public void func_179401_a(MerchantRecipeList recipeList, Random random) {
            for (int n = 0; n < this.numberOfTrades; ++n) {
                this.trades[random.nextInt(this.trades.length)].func_179401_a(recipeList, random);
            }
        }

        public String toString() {
            return MultiTradeGenerator.class.getSimpleName() + ": " + this.numberOfTrades + " trades chosen from " + Arrays.toString(this.trades);
        }
    }
}

