/*
 * Decompiled with CFR 0.152.
 */
package cyano.basemetals.init;

import cyano.basemetals.material.AdamantineMaterial;
import cyano.basemetals.material.LeadMaterial;
import cyano.basemetals.material.MetalMaterial;
import cyano.basemetals.material.StarSteelMaterial;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.FMLLog;

public abstract class Materials {
    private static Map<String, MetalMaterial> allMaterials = new HashMap<String, MetalMaterial>();
    private static Map<MetalMaterial, ItemArmor.ArmorMaterial> armorMaterialMap = new HashMap<MetalMaterial, ItemArmor.ArmorMaterial>();
    private static Map<MetalMaterial, Item.ToolMaterial> toolMaterialMap = new HashMap<MetalMaterial, Item.ToolMaterial>();
    public static MetalMaterial copper;
    public static MetalMaterial silver;
    public static MetalMaterial tin;
    public static MetalMaterial lead;
    public static MetalMaterial nickel;
    public static MetalMaterial bronze;
    public static MetalMaterial brass;
    public static MetalMaterial steel;
    public static MetalMaterial invar;
    public static MetalMaterial electrum;
    public static MetalMaterial coldiron;
    public static MetalMaterial mithril;
    public static MetalMaterial adamantine;
    public static MetalMaterial starsteel;
    public static MetalMaterial zinc;
    public static MetalMaterial aquarium;
    public static MetalMaterial cupronickel;
    public static MetalMaterial platinum;
    public static MetalMaterial vanilla_wood;
    public static MetalMaterial vanilla_stone;
    public static MetalMaterial vanilla_iron;
    public static MetalMaterial vanilla_gold;
    public static MetalMaterial vanilla_diamond;
    private static boolean initDone;

    public static void init() {
        if (initDone) {
            return;
        }
        vanilla_wood = Materials.addMaterial("wood", 2.0, 2.0, 6.0);
        vanilla_stone = Materials.addMaterial("stone", 5.0, 4.0, 2.0);
        vanilla_iron = Materials.addMaterial("iron", 8.0, 8.0, 4.5);
        vanilla_gold = Materials.addMaterial("gold", 1.0, 1.0, 10.0);
        vanilla_diamond = Materials.addMaterial("diamond", 10.0, 15.0, 4.0);
        copper = Materials.addMaterial("copper", 4.0, 4.0, 5.0);
        silver = Materials.addMaterial("silver", 5.0, 4.0, 6.0);
        tin = Materials.addMaterial("tin", 3.0, 1.0, 2.0);
        lead = new LeadMaterial("lead", 1.0f, 1.0f, 1.0f);
        Materials.registerMaterial(lead.getName(), lead);
        nickel = Materials.addMaterial("nickel", 4.0, 4.0, 7.0);
        zinc = Materials.addMaterial("zinc", 1.0, 1.0, 1.0);
        bronze = Materials.addMaterial("bronze", 8.0, 4.0, 4.5);
        brass = Materials.addMaterial("brass", 3.5, 3.0, 9.0);
        steel = Materials.addMaterial("steel", 8.0, 15.0, 2.0);
        invar = Materials.addMaterial("invar", 9.0, 10.0, 3.0);
        electrum = Materials.addMaterial("electrum", 5.0, 4.0, 10.0);
        coldiron = Materials.addMaterial("coldiron", 7.0, 7.0, 7.0);
        mithril = Materials.addMaterial("mithril", 9.0, 9.0, 9.0);
        adamantine = new AdamantineMaterial("adamantine", 12.0f, 100.0f, 0.0f);
        Materials.registerMaterial(adamantine.getName(), adamantine);
        starsteel = new StarSteelMaterial("starsteel", 10.0f, 25.0f, 12.0f);
        Materials.registerMaterial(starsteel.getName(), starsteel);
        aquarium = Materials.addMaterial("aquarium", 4.0, 10.0, 15.0);
        cupronickel = Materials.addMaterial("cupronickel", 6.0, 6.0, 6.0);
        platinum = Materials.addRareMaterial("platinum", 3.0, 5.0, 15.0);
        initDone = true;
    }

    private static MetalMaterial addMaterial(String name, double hardness, double strength, double magic) {
        MetalMaterial m = new MetalMaterial(name, (float)hardness, (float)strength, (float)magic);
        Materials.registerMaterial(name, m);
        return m;
    }

    private static MetalMaterial addRareMaterial(String name, double hardness, double strength, double magic) {
        MetalMaterial m = new MetalMaterial(name, (float)hardness, (float)strength, (float)magic, true);
        Materials.registerMaterial(name, m);
        return m;
    }

    protected static void registerMaterial(String name, MetalMaterial m) {
        allMaterials.put(name, m);
        String enumName = m.getEnumName();
        String texName = m.getName();
        int[] protection = m.getDamageReductionArray();
        int durability = m.getArmorMaxDamageFactor();
        ItemArmor.ArmorMaterial am = EnumHelper.addArmorMaterial((String)enumName, (String)texName, (int)durability, (int[])protection, (int)m.getEnchantability(), (SoundEvent)SoundEvents.field_187725_r, (float)(m.hardness > 10.0f ? (int)(m.hardness / 5.0f) : 0));
        if (am == null) {
            FMLLog.severe((String)("Failed to create armor material enum for " + m), (Object[])new Object[0]);
        }
        armorMaterialMap.put(m, am);
        FMLLog.info((String)("Created armor material enum " + am), (Object[])new Object[0]);
        Item.ToolMaterial tm = EnumHelper.addToolMaterial((String)enumName, (int)m.getToolHarvestLevel(), (int)m.getToolDurability(), (float)m.getToolEfficiency(), (float)m.getBaseAttackDamage(), (int)m.getEnchantability());
        if (tm == null) {
            FMLLog.severe((String)("Failed to create tool material enum for " + m), (Object[])new Object[0]);
        }
        toolMaterialMap.put(m, tm);
        FMLLog.info((String)("Created tool material enum " + tm), (Object[])new Object[0]);
    }

    public static ItemArmor.ArmorMaterial getArmorMaterialFor(MetalMaterial m) {
        return armorMaterialMap.get(m);
    }

    public static Item.ToolMaterial getToolMaterialFor(MetalMaterial m) {
        return toolMaterialMap.get(m);
    }

    public static Collection<MetalMaterial> getAllMetals() {
        return allMaterials.values();
    }

    public static MetalMaterial getMetalByName(String metalName) {
        return allMaterials.get(metalName);
    }

    static {
        initDone = false;
    }
}

