/*
 * Decompiled with CFR 0.152.
 */
package cyano.basemetals.init;

import cyano.basemetals.blocks.BlockMetalBars;
import cyano.basemetals.blocks.BlockMetalBlock;
import cyano.basemetals.blocks.BlockMetalDoor;
import cyano.basemetals.blocks.BlockMetalOre;
import cyano.basemetals.blocks.BlockMetalPlate;
import cyano.basemetals.blocks.BlockMetalTrapDoor;
import cyano.basemetals.blocks.InteractiveFluidBlock;
import cyano.basemetals.init.Blocks;
import cyano.basemetals.init.ItemGroups;
import cyano.basemetals.init.Materials;
import cyano.basemetals.items.GenericMetalItem;
import cyano.basemetals.items.ItemMetalArmor;
import cyano.basemetals.items.ItemMetalAxe;
import cyano.basemetals.items.ItemMetalBlend;
import cyano.basemetals.items.ItemMetalCrackHammer;
import cyano.basemetals.items.ItemMetalDoor;
import cyano.basemetals.items.ItemMetalHoe;
import cyano.basemetals.items.ItemMetalIngot;
import cyano.basemetals.items.ItemMetalNugget;
import cyano.basemetals.items.ItemMetalPickaxe;
import cyano.basemetals.items.ItemMetalPowder;
import cyano.basemetals.items.ItemMetalShovel;
import cyano.basemetals.items.ItemMetalSword;
import cyano.basemetals.material.IMetalObject;
import cyano.basemetals.material.MetalMaterial;
import cyano.basemetals.registry.IOreDictionaryEntry;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockDoor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public abstract class Items {
    private static Map<Item, String> itemRegistry = new HashMap<Item, String>();
    private static Map<String, Item> allItems = new HashMap<String, Item>();
    private static Map<MetalMaterial, List<Item>> itemsByMetal = new HashMap<MetalMaterial, List<Item>>();
    private static Map<BlockDoor, Item> doorMap = new HashMap<BlockDoor, Item>();
    private static Map<Class, Integer> classSortingValues = new HashMap<Class, Integer>();
    private static Map<MetalMaterial, Integer> materialSortingValues = new HashMap<MetalMaterial, Integer>();
    public static Item adamantine_axe;
    public static Item adamantine_boots;
    public static Item adamantine_chestplate;
    public static Item adamantine_crackhammer;
    public static Item adamantine_door;
    public static Item adamantine_helmet;
    public static Item adamantine_hoe;
    public static Item adamantine_ingot;
    public static Item adamantine_leggings;
    public static Item adamantine_nugget;
    public static Item adamantine_pickaxe;
    public static Item adamantine_powder;
    public static Item adamantine_shovel;
    public static Item adamantine_sword;
    public static Item adamantine_rod;
    public static Item adamantine_gear;
    public static Item aquarium_axe;
    public static Item aquarium_blend;
    public static Item aquarium_boots;
    public static Item aquarium_chestplate;
    public static Item aquarium_crackhammer;
    public static Item aquarium_door;
    public static Item aquarium_helmet;
    public static Item aquarium_hoe;
    public static Item aquarium_ingot;
    public static Item aquarium_leggings;
    public static Item aquarium_nugget;
    public static Item aquarium_pickaxe;
    public static Item aquarium_powder;
    public static Item aquarium_shovel;
    public static Item aquarium_sword;
    public static Item aquarium_rod;
    public static Item brass_axe;
    public static Item brass_blend;
    public static Item brass_boots;
    public static Item brass_chestplate;
    public static Item brass_crackhammer;
    public static Item brass_door;
    public static Item brass_helmet;
    public static Item brass_hoe;
    public static Item brass_ingot;
    public static Item brass_leggings;
    public static Item brass_nugget;
    public static Item brass_pickaxe;
    public static Item brass_powder;
    public static Item brass_shovel;
    public static Item brass_sword;
    public static Item brass_rod;
    public static Item bronze_axe;
    public static Item bronze_blend;
    public static Item bronze_boots;
    public static Item bronze_chestplate;
    public static Item bronze_crackhammer;
    public static Item bronze_door;
    public static Item bronze_helmet;
    public static Item bronze_hoe;
    public static Item bronze_ingot;
    public static Item bronze_leggings;
    public static Item bronze_nugget;
    public static Item bronze_pickaxe;
    public static Item bronze_powder;
    public static Item bronze_shovel;
    public static Item bronze_sword;
    public static Item bronze_rod;
    public static Item bronze_gear;
    public static Item carbon_powder;
    public static Item coldiron_axe;
    public static Item coldiron_boots;
    public static Item coldiron_chestplate;
    public static Item coldiron_crackhammer;
    public static Item coldiron_door;
    public static Item coldiron_helmet;
    public static Item coldiron_hoe;
    public static Item coldiron_ingot;
    public static Item coldiron_leggings;
    public static Item coldiron_nugget;
    public static Item coldiron_pickaxe;
    public static Item coldiron_powder;
    public static Item coldiron_shovel;
    public static Item coldiron_sword;
    public static Item coldiron_rod;
    public static Item coldiron_gear;
    public static Item copper_axe;
    public static Item copper_boots;
    public static Item copper_chestplate;
    public static Item copper_crackhammer;
    public static Item copper_door;
    public static Item copper_helmet;
    public static Item copper_hoe;
    public static Item copper_ingot;
    public static Item copper_leggings;
    public static Item copper_nugget;
    public static Item copper_pickaxe;
    public static Item copper_powder;
    public static Item copper_shovel;
    public static Item copper_sword;
    public static Item copper_rod;
    public static Item cupronickel_axe;
    public static Item cupronickel_boots;
    public static Item cupronickel_blend;
    public static Item cupronickel_chestplate;
    public static Item cupronickel_crackhammer;
    public static Item cupronickel_door;
    public static Item cupronickel_helmet;
    public static Item cupronickel_hoe;
    public static Item cupronickel_ingot;
    public static Item cupronickel_leggings;
    public static Item cupronickel_nugget;
    public static Item cupronickel_pickaxe;
    public static Item cupronickel_powder;
    public static Item cupronickel_shovel;
    public static Item cupronickel_sword;
    public static Item cupronickel_rod;
    public static Item cupronickel_gear;
    public static Item diamond_crackhammer;
    public static Item electrum_axe;
    public static Item electrum_blend;
    public static Item electrum_boots;
    public static Item electrum_chestplate;
    public static Item electrum_crackhammer;
    public static Item electrum_door;
    public static Item electrum_helmet;
    public static Item electrum_hoe;
    public static Item electrum_ingot;
    public static Item electrum_leggings;
    public static Item electrum_nugget;
    public static Item electrum_pickaxe;
    public static Item electrum_powder;
    public static Item electrum_shovel;
    public static Item electrum_sword;
    public static Item electrum_rod;
    public static Item gold_crackhammer;
    public static Item gold_powder;
    public static Item gold_rod;
    public static Item invar_axe;
    public static Item invar_blend;
    public static Item invar_boots;
    public static Item invar_chestplate;
    public static Item invar_crackhammer;
    public static Item invar_door;
    public static Item invar_helmet;
    public static Item invar_hoe;
    public static Item invar_ingot;
    public static Item invar_leggings;
    public static Item invar_nugget;
    public static Item invar_pickaxe;
    public static Item invar_powder;
    public static Item invar_shovel;
    public static Item invar_sword;
    public static Item invar_rod;
    public static Item invar_gear;
    public static Item iron_crackhammer;
    public static Item iron_nugget;
    public static Item iron_powder;
    public static Item iron_rod;
    public static Item iron_gear;
    public static Item lead_axe;
    public static Item lead_boots;
    public static Item lead_chestplate;
    public static Item lead_crackhammer;
    public static Item lead_door;
    public static Item lead_helmet;
    public static Item lead_hoe;
    public static Item lead_ingot;
    public static Item lead_leggings;
    public static Item lead_nugget;
    public static Item lead_pickaxe;
    public static Item lead_powder;
    public static Item lead_shovel;
    public static Item lead_sword;
    public static Item lead_rod;
    public static Item mercury_ingot;
    public static Item mercury_powder;
    public static Item mithril_axe;
    public static Item mithril_blend;
    public static Item mithril_boots;
    public static Item mithril_chestplate;
    public static Item mithril_crackhammer;
    public static Item mithril_door;
    public static Item mithril_helmet;
    public static Item mithril_hoe;
    public static Item mithril_ingot;
    public static Item mithril_leggings;
    public static Item mithril_nugget;
    public static Item mithril_pickaxe;
    public static Item mithril_powder;
    public static Item mithril_shovel;
    public static Item mithril_sword;
    public static Item mithril_rod;
    public static Item mithril_gear;
    public static Item nickel_axe;
    public static Item nickel_boots;
    public static Item nickel_chestplate;
    public static Item nickel_crackhammer;
    public static Item nickel_door;
    public static Item nickel_helmet;
    public static Item nickel_hoe;
    public static Item nickel_ingot;
    public static Item nickel_leggings;
    public static Item nickel_nugget;
    public static Item nickel_pickaxe;
    public static Item nickel_powder;
    public static Item nickel_shovel;
    public static Item nickel_sword;
    public static Item nickel_rod;
    public static Item platinum_axe;
    public static Item platinum_boots;
    public static Item platinum_chestplate;
    public static Item platinum_crackhammer;
    public static Item platinum_door;
    public static Item platinum_helmet;
    public static Item platinum_hoe;
    public static Item platinum_ingot;
    public static Item platinum_leggings;
    public static Item platinum_nugget;
    public static Item platinum_pickaxe;
    public static Item platinum_powder;
    public static Item platinum_shovel;
    public static Item platinum_sword;
    public static Item platinum_rod;
    public static Item silver_axe;
    public static Item silver_boots;
    public static Item silver_chestplate;
    public static Item silver_crackhammer;
    public static Item silver_door;
    public static Item silver_helmet;
    public static Item silver_hoe;
    public static Item silver_ingot;
    public static Item silver_leggings;
    public static Item silver_nugget;
    public static Item silver_pickaxe;
    public static Item silver_powder;
    public static Item silver_shovel;
    public static Item silver_sword;
    public static Item silver_rod;
    public static Item starsteel_axe;
    public static Item starsteel_boots;
    public static Item starsteel_chestplate;
    public static Item starsteel_crackhammer;
    public static Item starsteel_door;
    public static Item starsteel_helmet;
    public static Item starsteel_hoe;
    public static Item starsteel_ingot;
    public static Item starsteel_leggings;
    public static Item starsteel_nugget;
    public static Item starsteel_pickaxe;
    public static Item starsteel_powder;
    public static Item starsteel_shovel;
    public static Item starsteel_sword;
    public static Item starsteel_rod;
    public static Item starsteel_gear;
    public static Item steel_axe;
    public static Item steel_blend;
    public static Item steel_boots;
    public static Item steel_chestplate;
    public static Item steel_crackhammer;
    public static Item steel_door;
    public static Item steel_helmet;
    public static Item steel_hoe;
    public static Item steel_ingot;
    public static Item steel_leggings;
    public static Item steel_nugget;
    public static Item steel_pickaxe;
    public static Item steel_powder;
    public static Item steel_shovel;
    public static Item steel_sword;
    public static Item steel_rod;
    public static Item steel_gear;
    public static Item stone_crackhammer;
    public static Item tin_axe;
    public static Item tin_boots;
    public static Item tin_chestplate;
    public static Item tin_crackhammer;
    public static Item tin_door;
    public static Item tin_helmet;
    public static Item tin_hoe;
    public static Item tin_ingot;
    public static Item tin_leggings;
    public static Item tin_nugget;
    public static Item tin_pickaxe;
    public static Item tin_powder;
    public static Item tin_shovel;
    public static Item tin_sword;
    public static Item tin_rod;
    public static Item wood_crackhammer;
    public static Item zinc_ingot;
    public static Item zinc_nugget;
    public static Item zinc_powder;
    public static Item zinc_rod;
    private static boolean initDone;

    public static Item getItemByName(String name) {
        return allItems.get(name);
    }

    public static String getNameOfItem(Item i) {
        return itemRegistry.get(i);
    }

    public static Map<MetalMaterial, List<Item>> getItemsByMetal() {
        return Collections.unmodifiableMap(itemsByMetal);
    }

    public static Item getDoorItemForBlock(BlockMetalDoor b) {
        return doorMap.get(b);
    }

    public static void init() {
        if (initDone) {
            return;
        }
        Blocks.init();
        try {
            Items.expandCombatArrays(ItemAxe.class);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            FMLLog.severe((String)"Error modifying item classes: %s", (Object[])new Object[]{ex});
        }
        adamantine_axe = Items.create_axe(Materials.adamantine);
        adamantine_boots = Items.create_boots(Materials.adamantine);
        adamantine_chestplate = Items.create_chestplate(Materials.adamantine);
        adamantine_crackhammer = Items.create_crackhammer(Materials.adamantine);
        adamantine_door = Items.create_door(Materials.adamantine, Blocks.adamantine_door);
        adamantine_helmet = Items.create_helmet(Materials.adamantine);
        adamantine_hoe = Items.create_hoe(Materials.adamantine);
        adamantine_ingot = Items.create_ingot(Materials.adamantine);
        adamantine_leggings = Items.create_leggings(Materials.adamantine);
        adamantine_nugget = Items.create_nugget(Materials.adamantine);
        adamantine_pickaxe = Items.create_pickaxe(Materials.adamantine);
        adamantine_powder = Items.create_powder(Materials.adamantine);
        adamantine_shovel = Items.create_shovel(Materials.adamantine);
        adamantine_sword = Items.create_sword(Materials.adamantine);
        adamantine_rod = Items.create_rod(Materials.adamantine);
        adamantine_gear = Items.create_gear(Materials.adamantine);
        aquarium_axe = Items.create_axe(Materials.aquarium);
        aquarium_blend = Items.create_blend(Materials.aquarium);
        aquarium_boots = Items.create_boots(Materials.aquarium);
        aquarium_chestplate = Items.create_chestplate(Materials.aquarium);
        aquarium_crackhammer = Items.create_crackhammer(Materials.aquarium);
        aquarium_door = Items.create_door(Materials.aquarium, Blocks.aquarium_door);
        aquarium_helmet = Items.create_helmet(Materials.aquarium);
        aquarium_hoe = Items.create_hoe(Materials.aquarium);
        aquarium_ingot = Items.create_ingot(Materials.aquarium);
        aquarium_leggings = Items.create_leggings(Materials.aquarium);
        aquarium_nugget = Items.create_nugget(Materials.aquarium);
        aquarium_pickaxe = Items.create_pickaxe(Materials.aquarium);
        aquarium_powder = Items.create_powder(Materials.aquarium);
        aquarium_shovel = Items.create_shovel(Materials.aquarium);
        aquarium_sword = Items.create_sword(Materials.aquarium);
        aquarium_rod = Items.create_rod(Materials.aquarium);
        brass_axe = Items.create_axe(Materials.brass);
        brass_blend = Items.create_blend(Materials.brass);
        brass_boots = Items.create_boots(Materials.brass);
        brass_chestplate = Items.create_chestplate(Materials.brass);
        brass_crackhammer = Items.create_crackhammer(Materials.brass);
        brass_door = Items.create_door(Materials.brass, Blocks.brass_door);
        brass_helmet = Items.create_helmet(Materials.brass);
        brass_hoe = Items.create_hoe(Materials.brass);
        brass_ingot = Items.create_ingot(Materials.brass);
        brass_leggings = Items.create_leggings(Materials.brass);
        brass_nugget = Items.create_nugget(Materials.brass);
        brass_pickaxe = Items.create_pickaxe(Materials.brass);
        brass_powder = Items.create_powder(Materials.brass);
        brass_shovel = Items.create_shovel(Materials.brass);
        brass_sword = Items.create_sword(Materials.brass);
        brass_rod = Items.create_rod(Materials.brass);
        bronze_axe = Items.create_axe(Materials.bronze);
        bronze_blend = Items.create_blend(Materials.bronze);
        bronze_boots = Items.create_boots(Materials.bronze);
        bronze_chestplate = Items.create_chestplate(Materials.bronze);
        bronze_crackhammer = Items.create_crackhammer(Materials.bronze);
        bronze_door = Items.create_door(Materials.bronze, Blocks.bronze_door);
        bronze_helmet = Items.create_helmet(Materials.bronze);
        bronze_hoe = Items.create_hoe(Materials.bronze);
        bronze_ingot = Items.create_ingot(Materials.bronze);
        bronze_leggings = Items.create_leggings(Materials.bronze);
        bronze_nugget = Items.create_nugget(Materials.bronze);
        bronze_pickaxe = Items.create_pickaxe(Materials.bronze);
        bronze_powder = Items.create_powder(Materials.bronze);
        bronze_shovel = Items.create_shovel(Materials.bronze);
        bronze_sword = Items.create_sword(Materials.bronze);
        bronze_rod = Items.create_rod(Materials.bronze);
        bronze_gear = Items.create_gear(Materials.bronze);
        carbon_powder = ((Item)new Item().setRegistryName("basemetals", "carbon_powder")).func_77655_b("basemetals.carbon_powder").func_77637_a(ItemGroups.tab_items);
        GameRegistry.register((IForgeRegistryEntry)carbon_powder);
        itemRegistry.put(carbon_powder, "carbon_powder");
        OreDictionary.registerOre((String)"dustCoal", (Item)carbon_powder);
        OreDictionary.registerOre((String)"dustCarbon", (Item)carbon_powder);
        coldiron_axe = Items.create_axe(Materials.coldiron);
        coldiron_boots = Items.create_boots(Materials.coldiron);
        coldiron_chestplate = Items.create_chestplate(Materials.coldiron);
        coldiron_crackhammer = Items.create_crackhammer(Materials.coldiron);
        coldiron_door = Items.create_door(Materials.coldiron, Blocks.coldiron_door);
        coldiron_helmet = Items.create_helmet(Materials.coldiron);
        coldiron_hoe = Items.create_hoe(Materials.coldiron);
        coldiron_ingot = Items.create_ingot(Materials.coldiron);
        coldiron_leggings = Items.create_leggings(Materials.coldiron);
        coldiron_nugget = Items.create_nugget(Materials.coldiron);
        coldiron_pickaxe = Items.create_pickaxe(Materials.coldiron);
        coldiron_powder = Items.create_powder(Materials.coldiron);
        coldiron_shovel = Items.create_shovel(Materials.coldiron);
        coldiron_sword = Items.create_sword(Materials.coldiron);
        coldiron_rod = Items.create_rod(Materials.coldiron);
        coldiron_gear = Items.create_gear(Materials.coldiron);
        copper_axe = Items.create_axe(Materials.copper);
        copper_boots = Items.create_boots(Materials.copper);
        copper_chestplate = Items.create_chestplate(Materials.copper);
        copper_crackhammer = Items.create_crackhammer(Materials.copper);
        copper_door = Items.create_door(Materials.copper, Blocks.copper_door);
        copper_helmet = Items.create_helmet(Materials.copper);
        copper_hoe = Items.create_hoe(Materials.copper);
        copper_ingot = Items.create_ingot(Materials.copper);
        copper_leggings = Items.create_leggings(Materials.copper);
        copper_nugget = Items.create_nugget(Materials.copper);
        copper_pickaxe = Items.create_pickaxe(Materials.copper);
        copper_powder = Items.create_powder(Materials.copper);
        copper_shovel = Items.create_shovel(Materials.copper);
        copper_sword = Items.create_sword(Materials.copper);
        copper_rod = Items.create_rod(Materials.copper);
        cupronickel_axe = Items.create_axe(Materials.cupronickel);
        cupronickel_blend = Items.create_blend(Materials.cupronickel);
        cupronickel_boots = Items.create_boots(Materials.cupronickel);
        cupronickel_chestplate = Items.create_chestplate(Materials.cupronickel);
        cupronickel_crackhammer = Items.create_crackhammer(Materials.cupronickel);
        cupronickel_door = Items.create_door(Materials.cupronickel, Blocks.cupronickel_door);
        cupronickel_helmet = Items.create_helmet(Materials.cupronickel);
        cupronickel_hoe = Items.create_hoe(Materials.cupronickel);
        cupronickel_ingot = Items.create_ingot(Materials.cupronickel);
        cupronickel_leggings = Items.create_leggings(Materials.cupronickel);
        cupronickel_nugget = Items.create_nugget(Materials.cupronickel);
        cupronickel_pickaxe = Items.create_pickaxe(Materials.cupronickel);
        cupronickel_powder = Items.create_powder(Materials.cupronickel);
        cupronickel_shovel = Items.create_shovel(Materials.cupronickel);
        cupronickel_sword = Items.create_sword(Materials.cupronickel);
        cupronickel_rod = Items.create_rod(Materials.cupronickel);
        cupronickel_gear = Items.create_gear(Materials.cupronickel);
        diamond_crackhammer = Items.create_crackhammer(Materials.vanilla_diamond);
        electrum_axe = Items.create_axe(Materials.electrum);
        electrum_blend = Items.create_blend(Materials.electrum);
        electrum_boots = Items.create_boots(Materials.electrum);
        electrum_chestplate = Items.create_chestplate(Materials.electrum);
        electrum_crackhammer = Items.create_crackhammer(Materials.electrum);
        electrum_door = Items.create_door(Materials.electrum, Blocks.electrum_door);
        electrum_helmet = Items.create_helmet(Materials.electrum);
        electrum_hoe = Items.create_hoe(Materials.electrum);
        electrum_ingot = Items.create_ingot(Materials.electrum);
        electrum_leggings = Items.create_leggings(Materials.electrum);
        electrum_nugget = Items.create_nugget(Materials.electrum);
        electrum_pickaxe = Items.create_pickaxe(Materials.electrum);
        electrum_powder = Items.create_powder(Materials.electrum);
        electrum_shovel = Items.create_shovel(Materials.electrum);
        electrum_sword = Items.create_sword(Materials.electrum);
        electrum_rod = Items.create_rod(Materials.electrum);
        gold_powder = Items.create_powder(Materials.vanilla_gold);
        gold_rod = Items.create_rod(Materials.vanilla_gold);
        gold_crackhammer = Items.create_crackhammer(Materials.vanilla_gold);
        invar_axe = Items.create_axe(Materials.invar);
        invar_blend = Items.create_blend(Materials.invar);
        invar_boots = Items.create_boots(Materials.invar);
        invar_chestplate = Items.create_chestplate(Materials.invar);
        invar_crackhammer = Items.create_crackhammer(Materials.invar);
        invar_door = Items.create_door(Materials.invar, Blocks.invar_door);
        invar_helmet = Items.create_helmet(Materials.invar);
        invar_hoe = Items.create_hoe(Materials.invar);
        invar_ingot = Items.create_ingot(Materials.invar);
        invar_leggings = Items.create_leggings(Materials.invar);
        invar_nugget = Items.create_nugget(Materials.invar);
        invar_pickaxe = Items.create_pickaxe(Materials.invar);
        invar_powder = Items.create_powder(Materials.invar);
        invar_shovel = Items.create_shovel(Materials.invar);
        invar_sword = Items.create_sword(Materials.invar);
        invar_rod = Items.create_rod(Materials.invar);
        invar_gear = Items.create_gear(Materials.invar);
        iron_crackhammer = Items.create_crackhammer(Materials.vanilla_iron);
        iron_nugget = Items.create_nugget(Materials.vanilla_iron);
        iron_powder = Items.create_powder(Materials.vanilla_iron);
        iron_rod = Items.create_rod(Materials.vanilla_iron);
        iron_gear = Items.create_gear(Materials.vanilla_iron);
        lead_axe = Items.create_axe(Materials.lead);
        lead_boots = Items.create_boots(Materials.lead);
        lead_chestplate = Items.create_chestplate(Materials.lead);
        lead_crackhammer = Items.create_crackhammer(Materials.lead);
        lead_door = Items.create_door(Materials.lead, Blocks.lead_door);
        lead_helmet = Items.create_helmet(Materials.lead);
        lead_hoe = Items.create_hoe(Materials.lead);
        lead_ingot = Items.create_ingot(Materials.lead);
        lead_leggings = Items.create_leggings(Materials.lead);
        lead_nugget = Items.create_nugget(Materials.lead);
        lead_pickaxe = Items.create_pickaxe(Materials.lead);
        lead_powder = Items.create_powder(Materials.lead);
        lead_shovel = Items.create_shovel(Materials.lead);
        lead_sword = Items.create_sword(Materials.lead);
        lead_rod = Items.create_rod(Materials.lead);
        platinum_axe = Items.create_axe(Materials.platinum);
        platinum_boots = Items.create_boots(Materials.platinum);
        platinum_chestplate = Items.create_chestplate(Materials.platinum);
        platinum_crackhammer = Items.create_crackhammer(Materials.platinum);
        platinum_door = Items.create_door(Materials.platinum, Blocks.platinum_door);
        platinum_helmet = Items.create_helmet(Materials.platinum);
        platinum_hoe = Items.create_hoe(Materials.platinum);
        platinum_ingot = Items.create_ingot(Materials.platinum);
        platinum_leggings = Items.create_leggings(Materials.platinum);
        platinum_nugget = Items.create_nugget(Materials.platinum);
        platinum_pickaxe = Items.create_pickaxe(Materials.platinum);
        platinum_powder = Items.create_powder(Materials.platinum);
        platinum_shovel = Items.create_shovel(Materials.platinum);
        platinum_sword = Items.create_sword(Materials.platinum);
        platinum_rod = Items.create_rod(Materials.platinum);
        stone_crackhammer = Items.create_crackhammer(Materials.vanilla_stone);
        wood_crackhammer = Items.create_crackhammer(Materials.vanilla_wood);
        mercury_ingot = ((Item)new Item().setRegistryName("basemetals", "mercury_ingot")).func_77655_b("basemetals.mercury_ingot").func_77637_a(ItemGroups.tab_items);
        GameRegistry.register((IForgeRegistryEntry)mercury_ingot);
        itemRegistry.put(mercury_ingot, "mercury_ingot");
        OreDictionary.registerOre((String)"ingotMercury", (Item)mercury_ingot);
        OreDictionary.registerOre((String)"quicksilver", (Item)mercury_ingot);
        mercury_powder = ((Item)new Item().setRegistryName("basemetals", "mercury_powder")).func_77655_b("basemetals.mercury_powder").func_77637_a(ItemGroups.tab_items);
        GameRegistry.register((IForgeRegistryEntry)mercury_powder);
        itemRegistry.put(mercury_powder, "mercury_powder");
        OreDictionary.registerOre((String)"dustMercury", (Item)mercury_powder);
        mithril_axe = Items.create_axe(Materials.mithril);
        mithril_blend = Items.create_blend(Materials.mithril);
        mithril_boots = Items.create_boots(Materials.mithril);
        mithril_chestplate = Items.create_chestplate(Materials.mithril);
        mithril_crackhammer = Items.create_crackhammer(Materials.mithril);
        mithril_door = Items.create_door(Materials.mithril, Blocks.mithril_door);
        mithril_helmet = Items.create_helmet(Materials.mithril);
        mithril_hoe = Items.create_hoe(Materials.mithril);
        mithril_ingot = Items.create_ingot(Materials.mithril);
        mithril_leggings = Items.create_leggings(Materials.mithril);
        mithril_nugget = Items.create_nugget(Materials.mithril);
        mithril_pickaxe = Items.create_pickaxe(Materials.mithril);
        mithril_powder = Items.create_powder(Materials.mithril);
        mithril_shovel = Items.create_shovel(Materials.mithril);
        mithril_sword = Items.create_sword(Materials.mithril);
        mithril_rod = Items.create_rod(Materials.mithril);
        mithril_gear = Items.create_gear(Materials.mithril);
        nickel_axe = Items.create_axe(Materials.nickel);
        nickel_boots = Items.create_boots(Materials.nickel);
        nickel_chestplate = Items.create_chestplate(Materials.nickel);
        nickel_crackhammer = Items.create_crackhammer(Materials.nickel);
        nickel_door = Items.create_door(Materials.nickel, Blocks.nickel_door);
        nickel_helmet = Items.create_helmet(Materials.nickel);
        nickel_hoe = Items.create_hoe(Materials.nickel);
        nickel_ingot = Items.create_ingot(Materials.nickel);
        nickel_leggings = Items.create_leggings(Materials.nickel);
        nickel_nugget = Items.create_nugget(Materials.nickel);
        nickel_pickaxe = Items.create_pickaxe(Materials.nickel);
        nickel_powder = Items.create_powder(Materials.nickel);
        nickel_shovel = Items.create_shovel(Materials.nickel);
        nickel_sword = Items.create_sword(Materials.nickel);
        nickel_rod = Items.create_rod(Materials.nickel);
        silver_axe = Items.create_axe(Materials.silver);
        silver_boots = Items.create_boots(Materials.silver);
        silver_chestplate = Items.create_chestplate(Materials.silver);
        silver_crackhammer = Items.create_crackhammer(Materials.silver);
        silver_door = Items.create_door(Materials.silver, Blocks.silver_door);
        silver_helmet = Items.create_helmet(Materials.silver);
        silver_hoe = Items.create_hoe(Materials.silver);
        silver_ingot = Items.create_ingot(Materials.silver);
        silver_leggings = Items.create_leggings(Materials.silver);
        silver_nugget = Items.create_nugget(Materials.silver);
        silver_pickaxe = Items.create_pickaxe(Materials.silver);
        silver_powder = Items.create_powder(Materials.silver);
        silver_shovel = Items.create_shovel(Materials.silver);
        silver_sword = Items.create_sword(Materials.silver);
        silver_rod = Items.create_rod(Materials.silver);
        starsteel_axe = Items.create_axe(Materials.starsteel);
        starsteel_boots = Items.create_boots(Materials.starsteel);
        starsteel_chestplate = Items.create_chestplate(Materials.starsteel);
        starsteel_crackhammer = Items.create_crackhammer(Materials.starsteel);
        starsteel_door = Items.create_door(Materials.starsteel, Blocks.starsteel_door);
        starsteel_helmet = Items.create_helmet(Materials.starsteel);
        starsteel_hoe = Items.create_hoe(Materials.starsteel);
        starsteel_ingot = Items.create_ingot(Materials.starsteel);
        starsteel_leggings = Items.create_leggings(Materials.starsteel);
        starsteel_nugget = Items.create_nugget(Materials.starsteel);
        starsteel_pickaxe = Items.create_pickaxe(Materials.starsteel);
        starsteel_powder = Items.create_powder(Materials.starsteel);
        starsteel_shovel = Items.create_shovel(Materials.starsteel);
        starsteel_sword = Items.create_sword(Materials.starsteel);
        starsteel_rod = Items.create_rod(Materials.starsteel);
        starsteel_gear = Items.create_gear(Materials.starsteel);
        steel_axe = Items.create_axe(Materials.steel);
        steel_blend = Items.create_blend(Materials.steel);
        steel_boots = Items.create_boots(Materials.steel);
        steel_chestplate = Items.create_chestplate(Materials.steel);
        steel_crackhammer = Items.create_crackhammer(Materials.steel);
        steel_door = Items.create_door(Materials.steel, Blocks.steel_door);
        steel_helmet = Items.create_helmet(Materials.steel);
        steel_hoe = Items.create_hoe(Materials.steel);
        steel_ingot = Items.create_ingot(Materials.steel);
        steel_leggings = Items.create_leggings(Materials.steel);
        steel_nugget = Items.create_nugget(Materials.steel);
        steel_pickaxe = Items.create_pickaxe(Materials.steel);
        steel_powder = Items.create_powder(Materials.steel);
        steel_shovel = Items.create_shovel(Materials.steel);
        steel_sword = Items.create_sword(Materials.steel);
        steel_rod = Items.create_rod(Materials.steel);
        steel_gear = Items.create_gear(Materials.steel);
        tin_axe = Items.create_axe(Materials.tin);
        tin_boots = Items.create_boots(Materials.tin);
        tin_chestplate = Items.create_chestplate(Materials.tin);
        tin_crackhammer = Items.create_crackhammer(Materials.tin);
        tin_door = Items.create_door(Materials.tin, Blocks.tin_door);
        tin_helmet = Items.create_helmet(Materials.tin);
        tin_hoe = Items.create_hoe(Materials.tin);
        tin_ingot = Items.create_ingot(Materials.tin);
        tin_leggings = Items.create_leggings(Materials.tin);
        tin_nugget = Items.create_nugget(Materials.tin);
        tin_pickaxe = Items.create_pickaxe(Materials.tin);
        tin_powder = Items.create_powder(Materials.tin);
        tin_shovel = Items.create_shovel(Materials.tin);
        tin_sword = Items.create_sword(Materials.tin);
        tin_rod = Items.create_rod(Materials.tin);
        zinc_ingot = Items.create_ingot(Materials.zinc);
        zinc_nugget = Items.create_nugget(Materials.zinc);
        zinc_powder = Items.create_powder(Materials.zinc);
        zinc_rod = Items.create_rod(Materials.zinc);
        for (Item i : itemRegistry.keySet()) {
            allItems.put(itemRegistry.get(i), i);
            if (!(i instanceof IOreDictionaryEntry)) continue;
            OreDictionary.registerOre((String)((IOreDictionaryEntry)i).getOreDictionaryName(), (Item)i);
        }
        int ss = 0;
        classSortingValues.put(BlockMetalOre.class, ++ss * 10000);
        classSortingValues.put(BlockMetalBlock.class, ++ss * 10000);
        classSortingValues.put(BlockMetalPlate.class, ++ss * 10000);
        classSortingValues.put(BlockMetalBars.class, ++ss * 10000);
        classSortingValues.put(BlockMetalDoor.class, ++ss * 10000);
        classSortingValues.put(BlockMetalTrapDoor.class, ++ss * 10000);
        classSortingValues.put(InteractiveFluidBlock.class, ++ss * 10000);
        classSortingValues.put(ItemMetalIngot.class, ++ss * 10000);
        classSortingValues.put(ItemMetalNugget.class, ++ss * 10000);
        classSortingValues.put(ItemMetalPowder.class, ++ss * 10000);
        classSortingValues.put(ItemMetalBlend.class, classSortingValues.get(ItemMetalPowder.class));
        classSortingValues.put(ItemMetalCrackHammer.class, ++ss * 10000);
        classSortingValues.put(ItemMetalPickaxe.class, ++ss * 10000);
        classSortingValues.put(ItemMetalShovel.class, ++ss * 10000);
        classSortingValues.put(ItemMetalAxe.class, ++ss * 10000);
        classSortingValues.put(ItemMetalHoe.class, ++ss * 10000);
        classSortingValues.put(ItemMetalSword.class, ++ss * 10000);
        classSortingValues.put(ItemMetalArmor.class, ++ss * 10000);
        classSortingValues.put(GenericMetalItem.class, ++ss * 10000);
        classSortingValues.put(ItemMetalDoor.class, classSortingValues.get(BlockMetalDoor.class));
        ArrayList<MetalMaterial> metlist = new ArrayList<MetalMaterial>(Materials.getAllMetals().size());
        metlist.addAll(Materials.getAllMetals());
        metlist.sort((a, b) -> a.getName().compareToIgnoreCase(b.getName()));
        for (int i = 0; i < metlist.size(); ++i) {
            materialSortingValues.put((MetalMaterial)metlist.get(i), i * 100);
        }
        initDone = true;
    }

    private static Item registerItem(Item item, String name, MetalMaterial metal, CreativeTabs tab) {
        item.setRegistryName("basemetals", name);
        item.func_77655_b("basemetals." + name);
        GameRegistry.register((IForgeRegistryEntry)item);
        itemRegistry.put(item, name);
        if (tab != null) {
            item.func_77637_a(tab);
        }
        if (metal != null) {
            itemsByMetal.computeIfAbsent(metal, g -> new ArrayList());
            itemsByMetal.get(metal).add(item);
        }
        return item;
    }

    private static Item create_ingot(MetalMaterial metal) {
        return Items.registerItem(new ItemMetalIngot(metal), metal.getName() + "_ingot", metal, ItemGroups.tab_items);
    }

    private static Item create_nugget(MetalMaterial metal) {
        return Items.registerItem(new ItemMetalNugget(metal), metal.getName() + "_nugget", metal, ItemGroups.tab_items);
    }

    private static Item create_powder(MetalMaterial metal) {
        return Items.registerItem(new ItemMetalPowder(metal), metal.getName() + "_powder", metal, ItemGroups.tab_items);
    }

    private static Item create_blend(MetalMaterial metal) {
        return Items.registerItem(new ItemMetalBlend(metal), metal.getName() + "_blend", metal, ItemGroups.tab_items);
    }

    private static Item create_rod(MetalMaterial metal) {
        return Items.registerItem(new GenericMetalItem(metal), metal.getName() + "_rod", metal, ItemGroups.tab_items);
    }

    private static Item create_gear(MetalMaterial metal) {
        Item i = Items.registerItem(new GenericMetalItem(metal), metal.getName() + "_gear", metal, ItemGroups.tab_items);
        OreDictionary.registerOre((String)("gear" + metal.getCapitalizedName()), (Item)i);
        return i;
    }

    private static Item create_axe(MetalMaterial metal) {
        return Items.registerItem((Item)new ItemMetalAxe(metal), metal.getName() + "_axe", metal, ItemGroups.tab_tools);
    }

    private static Item create_crackhammer(MetalMaterial metal) {
        return Items.registerItem((Item)new ItemMetalCrackHammer(metal), metal.getName() + "_crackhammer", metal, ItemGroups.tab_tools);
    }

    private static Item create_hoe(MetalMaterial metal) {
        return Items.registerItem((Item)new ItemMetalHoe(metal), metal.getName() + "_hoe", metal, ItemGroups.tab_tools);
    }

    private static Item create_pickaxe(MetalMaterial metal) {
        return Items.registerItem((Item)new ItemMetalPickaxe(metal), metal.getName() + "_pickaxe", metal, ItemGroups.tab_tools);
    }

    private static Item create_shovel(MetalMaterial metal) {
        return Items.registerItem((Item)new ItemMetalShovel(metal), metal.getName() + "_shovel", metal, ItemGroups.tab_tools);
    }

    private static Item create_sword(MetalMaterial metal) {
        return Items.registerItem((Item)new ItemMetalSword(metal), metal.getName() + "_sword", metal, ItemGroups.tab_tools);
    }

    private static Item create_helmet(MetalMaterial metal) {
        return Items.registerItem((Item)ItemMetalArmor.createHelmet(metal), metal.getName() + "_helmet", metal, ItemGroups.tab_tools);
    }

    private static Item create_chestplate(MetalMaterial metal) {
        return Items.registerItem((Item)ItemMetalArmor.createChestplate(metal), metal.getName() + "_chestplate", metal, ItemGroups.tab_tools);
    }

    private static Item create_leggings(MetalMaterial metal) {
        return Items.registerItem((Item)ItemMetalArmor.createLeggings(metal), metal.getName() + "_leggings", metal, ItemGroups.tab_tools);
    }

    private static Item create_boots(MetalMaterial metal) {
        return Items.registerItem((Item)ItemMetalArmor.createBoots(metal), metal.getName() + "_boots", metal, ItemGroups.tab_tools);
    }

    private static Item create_door(MetalMaterial metal, BlockDoor door) {
        ItemMetalDoor item = new ItemMetalDoor(door, metal);
        Items.registerItem((Item)item, metal.getName() + "_door_item", metal, ItemGroups.tab_blocks);
        item.func_77655_b("basemetals." + metal.getName() + "_door");
        doorMap.put(door, (Item)item);
        return item;
    }

    private static void expandCombatArrays(Class itemClass) throws IllegalAccessException, NoSuchFieldException {
        Field[] fields;
        int expandedSize = 256;
        for (Field f : fields = itemClass.getDeclaredFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !f.getType().isArray() || !f.getType().getComponentType().equals(Float.TYPE)) continue;
            FMLLog.info((String)"%s: Expanding array variable %s.%s to size %s", (Object[])new Object[]{Thread.currentThread().getStackTrace()[0], itemClass.getSimpleName(), f.getName(), 256});
            f.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(f, f.getModifiers() & 0xFFFFFFEF);
            float[] newArray = new float[256];
            Arrays.fill(newArray, 0.0f);
            System.arraycopy(f.get(null), 0, newArray, 0, Array.getLength(f.get(null)));
            f.set(null, newArray);
        }
    }

    public static int getSortingValue(ItemStack a) {
        int classVal = 990000;
        int metalVal = 9900;
        if (a.func_77973_b() instanceof ItemBlock && ((ItemBlock)a.func_77973_b()).func_179223_d() instanceof IMetalObject) {
            classVal = classSortingValues.computeIfAbsent(((ItemBlock)a.func_77973_b()).func_179223_d().getClass(), c -> 990000);
            metalVal = materialSortingValues.computeIfAbsent(((IMetalObject)((ItemBlock)a.func_77973_b()).func_179223_d()).getMetalMaterial(), m -> 9900);
        } else if (a.func_77973_b() instanceof IMetalObject) {
            classVal = classSortingValues.computeIfAbsent(a.func_77973_b().getClass(), c -> 990000);
            metalVal = materialSortingValues.computeIfAbsent(((IMetalObject)a.func_77973_b()).getMetalMaterial(), m -> 9900);
        }
        return classVal + metalVal + a.func_77960_j() % 100;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemRenders(FMLInitializationEvent event) {
        for (Item i : itemRegistry.keySet()) {
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(i, 0, new ModelResourceLocation("basemetals:" + itemRegistry.get(i), "inventory"));
        }
    }

    static {
        initDone = false;
    }
}

