/*
 * Decompiled with CFR 0.152.
 */
package cyano.basemetals.init;

import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FunctionalCreativeTab
extends CreativeTabs {
    private final Supplier<Item> itemSupplier;
    private final Comparator<ItemStack> itemSortingAlgorithm;
    private final boolean searchable;

    public FunctionalCreativeTab(String unlocalizedName, boolean searchable, Supplier<Item> itemSupplier, final BiFunction<ItemStack, ItemStack, Integer> itemSortingAlgorithm) {
        super(unlocalizedName);
        this.itemSupplier = itemSupplier;
        this.itemSortingAlgorithm = new Comparator<ItemStack>(){

            @Override
            public int compare(ItemStack o1, ItemStack o2) {
                return (Integer)itemSortingAlgorithm.apply(o1, o2);
            }
        };
        this.searchable = searchable;
        if (searchable) {
            this.func_78025_a("item_search.png");
        }
    }

    public boolean hasSearchBar() {
        return this.searchable;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_78018_a(List<ItemStack> itemList) {
        super.func_78018_a(itemList);
        itemList.sort(this.itemSortingAlgorithm);
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_78016_d() {
        return this.itemSupplier.get();
    }
}

