/*
 * Decompiled with CFR 0.152.
 */
package cyano.basemetals.blocks;

import cyano.basemetals.material.IMetalObject;
import cyano.basemetals.material.MetalMaterial;
import cyano.basemetals.registry.IOreDictionaryEntry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMetalPlate
extends Block
implements IOreDictionaryEntry,
IMetalObject {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    final MetalMaterial metal;
    private static final float thickness = 0.0625f;
    private static final AxisAlignedBB[] BOXES = new AxisAlignedBB[EnumFacing.values().length];

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public BlockMetalPlate(MetalMaterial metal) {
        super(Material.field_151573_f);
        this.field_149762_H = SoundType.field_185852_e;
        this.metal = metal;
        this.field_149782_v = metal.getMetalBlockHardness();
        this.field_149781_w = metal.getBlastResistance();
        this.setHarvestLevel("pickaxe", metal.getRequiredHarvestLevel());
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.field_149783_u = true;
    }

    public boolean func_149662_c(IBlockState bs) {
        return false;
    }

    public boolean func_149686_d(IBlockState bs) {
        return false;
    }

    public IBlockState func_180642_a(World w, BlockPos coord, EnumFacing face, float partialX, float partialY, float partialZ, int i, EntityLivingBase placer) {
        boolean upOrLeft;
        EnumFacing.Axis rightRotationAxis;
        EnumFacing.Axis upRotationAxis;
        float right;
        float up;
        IBlockState defaultState = this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)face);
        switch (face) {
            case UP: {
                up = partialZ - 0.5f;
                right = partialX - 0.5f;
                upRotationAxis = EnumFacing.Axis.X;
                rightRotationAxis = EnumFacing.Axis.Z;
                break;
            }
            case EAST: {
                up = partialY - 0.5f;
                right = partialZ - 0.5f;
                upRotationAxis = EnumFacing.Axis.Z;
                rightRotationAxis = EnumFacing.Axis.Y;
                break;
            }
            case SOUTH: {
                up = 0.5f - partialY;
                right = 0.5f - partialX;
                upRotationAxis = EnumFacing.Axis.X;
                rightRotationAxis = EnumFacing.Axis.Y;
                break;
            }
            case DOWN: {
                up = 0.5f - partialZ;
                right = 0.5f - partialX;
                upRotationAxis = EnumFacing.Axis.X;
                rightRotationAxis = EnumFacing.Axis.Z;
                break;
            }
            case WEST: {
                up = 0.5f - partialY;
                right = 0.5f - partialZ;
                upRotationAxis = EnumFacing.Axis.Z;
                rightRotationAxis = EnumFacing.Axis.Y;
                break;
            }
            case NORTH: {
                up = partialY - 0.5f;
                right = partialX - 0.5f;
                upRotationAxis = EnumFacing.Axis.X;
                rightRotationAxis = EnumFacing.Axis.Y;
                break;
            }
            default: {
                return defaultState;
            }
        }
        if (Math.abs(up) < 0.25f && Math.abs(right) < 0.25f) {
            return defaultState;
        }
        boolean upOrRight = up + right > 0.0f;
        boolean bl = upOrLeft = up - right > 0.0f;
        if (upOrRight) {
            if (upOrLeft) {
                return defaultState.func_177226_a((IProperty)FACING, (Comparable)face.func_176732_a(upRotationAxis));
            }
            return defaultState.func_177226_a((IProperty)FACING, (Comparable)face.func_176732_a(rightRotationAxis).func_176734_d());
        }
        if (upOrLeft) {
            return defaultState.func_177226_a((IProperty)FACING, (Comparable)face.func_176732_a(rightRotationAxis));
        }
        return defaultState.func_177226_a((IProperty)FACING, (Comparable)face.func_176732_a(upRotationAxis).func_176734_d());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState bs) {
        int i = ((EnumFacing)bs.func_177229_b((IProperty)FACING)).func_176745_a();
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public AxisAlignedBB func_185496_a(IBlockState bs, IBlockAccess world, BlockPos coord) {
        EnumFacing orientation = (EnumFacing)bs.func_177229_b((IProperty)FACING);
        return BOXES[orientation.ordinal()];
    }

    public void func_185477_a(IBlockState bs, World world, BlockPos coord, AxisAlignedBB box, List<AxisAlignedBB> collisionBoxList, Entity entity) {
        EnumFacing orientation = (EnumFacing)world.func_180495_p(coord).func_177229_b((IProperty)FACING);
        Block.func_185492_a((BlockPos)coord, (AxisAlignedBB)box, collisionBoxList, (AxisAlignedBB)BOXES[orientation.ordinal()]);
    }

    @Override
    public String getOreDictionaryName() {
        return "plate" + this.metal.getCapitalizedName();
    }

    @Override
    public MetalMaterial getMetalMaterial() {
        return this.metal;
    }

    static {
        for (int i = 0; i < EnumFacing.values().length; ++i) {
            EnumFacing orientation = EnumFacing.values()[i];
            float x1 = 0.0f;
            float x2 = 1.0f;
            float y1 = 0.0f;
            float y2 = 1.0f;
            float z1 = 0.0f;
            float z2 = 1.0f;
            switch (orientation) {
                case DOWN: {
                    y1 = 0.9375f;
                    break;
                }
                case SOUTH: {
                    z2 = 0.0625f;
                    break;
                }
                case NORTH: {
                    z1 = 0.9375f;
                    break;
                }
                case EAST: {
                    x2 = 0.0625f;
                    break;
                }
                case WEST: {
                    x1 = 0.9375f;
                    break;
                }
                default: {
                    y2 = 0.0625f;
                }
            }
            BlockMetalPlate.BOXES[orientation.ordinal()] = new AxisAlignedBB((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
        }
    }
}

