/*
 * Decompiled with CFR 0.152.
 */
package cyano.basemetals;

import cyano.basemetals.init.Achievements;
import cyano.basemetals.init.Blocks;
import cyano.basemetals.init.DungeonLoot;
import cyano.basemetals.init.Entities;
import cyano.basemetals.init.Fluids;
import cyano.basemetals.init.ItemGroups;
import cyano.basemetals.init.Items;
import cyano.basemetals.init.Materials;
import cyano.basemetals.init.Recipes;
import cyano.basemetals.init.VillagerTrades;
import cyano.basemetals.init.WorldGen;
import cyano.basemetals.registry.CrusherRecipeRegistry;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.MissingModsException;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;

@Mod(modid="basemetals", name="Base Metals", version="2.4.0", acceptedMinecraftVersions="[1.10.2,)")
public class BaseMetals {
    public static BaseMetals INSTANCE = null;
    public static final String MODID = "basemetals";
    public static final String NAME = "Base Metals";
    public static final String VERSION = "2.4.0";
    public static boolean enforceHardness;
    public static boolean strongHammers;
    public static boolean disableAllHammers;
    public static List<String> userCrusherRecipes;
    public static Path oreSpawnFolder;
    public static boolean autoDetectRecipes;
    public static boolean requireOreSpawn;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        INSTANCE = this;
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        disableAllHammers = config.getBoolean("disable_crack_hammer", "options", disableAllHammers, "If true, then the crack hammer cannot be crafted.");
        enforceHardness = config.getBoolean("enforce_hardness", "options", enforceHardness, "If true, then the crack hammer cannot crush ingots into powders if that \ncrackhammer is not hard enough to crush the ingot's ore.");
        strongHammers = config.getBoolean("strong_hammers", "options", strongHammers, "If true, then the crack hammer can crush ingots/ores that a pickaxe of the same \nmaterial can harvest. If false, then your crack hammer must be made of a harder \nmaterial than the ore you are crushing.");
        autoDetectRecipes = config.getBoolean("automatic_recipes", "options", autoDetectRecipes, "If true, then Base Metals will scan the Ore Dictionary to automatically add a \nCrack Hammer recipe for every material that has an ore, dust, and ingot.");
        requireOreSpawn = config.getBoolean("using_orespawn", "options", requireOreSpawn, "If false, then Base Metals will not require DrCyano's Ore Spawn mod. \nSet to false if using another mod to manually handle ore generation.");
        ConfigCategory userRecipeCat = config.getCategory("hammer recipes");
        userRecipeCat.setComment("This section allows you to add your own recipes for the Crack Hammer (and other rock \ncrushers). Recipes are specified in semicolon (;) delimited lists of formulas in the \nformat modid:name#y->x*modid:name#y, where x is the number of items in a stack and y \nis the metadata value. Note that both x and y are optional, so you can use the \nformula modid:name->modid:name for most items/blocks. \n\nAll properties in this section will be parsed for formulas, regardless their name. \nThis lets you organize your recipe lists for easier reading.");
        if (userRecipeCat.keySet().size() == 0) {
            Property prop = new Property("custom", "", Property.Type.STRING);
            prop.setComment("Example: minecraft:stained_glass#11->minecraft:dye#4; minecraft:wool->4*minecraft:string");
            userRecipeCat.put("custom", prop);
        }
        for (Property p : userRecipeCat.values()) {
            String[] recipes;
            for (String r : recipes = p.getString().split(";")) {
                String recipe = r.trim();
                if (recipe.isEmpty()) continue;
                if (!recipe.contains("->")) {
                    throw new IllegalArgumentException("Malformed hammer recipe expression '" + recipe + "'. Should be in format 'modid:itemname->modid:itemname'");
                }
                userCrusherRecipes.add(recipe);
            }
        }
        config.save();
        if (requireOreSpawn) {
            if (!Loader.isModLoaded((String)"orespawn")) {
                HashSet<DefaultArtifactVersion> orespawnMod = new HashSet<DefaultArtifactVersion>();
                orespawnMod.add(new DefaultArtifactVersion("1.0.0"));
                throw new MissingModsException(orespawnMod, "orespawn", "DrCyano's Ore Spawn Mod");
            }
            oreSpawnFolder = Paths.get(event.getSuggestedConfigurationFile().toPath().getParent().toString(), "orespawn");
            Path oreSpawnFile = Paths.get(oreSpawnFolder.toString(), "basemetals.json");
            if (!Files.exists(oreSpawnFile, new LinkOption[0])) {
                try {
                    Files.createDirectories(oreSpawnFile.getParent(), new FileAttribute[0]);
                    Files.write(oreSpawnFile, Arrays.asList("{\n\t\"dimensions\":[\n\t\t{\n\t\t\t\"dimension\":\"+\",\n\t\t\t\"__comment\":\"dimension 0 for overworld, -1 for the nether, 1 for the end, other numbers for dimensions added by other mods, and + for any dimension not already described by this file.\",\n\t\t\t\"ores\":[\n\t\t\t\t{\n\t\t\t\t\t\"__comment\":\"These settings are roughly equivalent to the parameters of the CUSTOM world json: blockID = the unlocalized name of a block in the format 'ModID:blockName',blockMeta = the meta data value for the block (optional),size = number of blocks to spawn per ore deposit, variation = vary the size of deposits by +/- this amount, frequency = number of deposits per chunk (can be less than 1, e.g. 0.5 for 1 deposit every 2 chunks), minHeight = minimum spawn height, maxHeight = maximum spawn height, biomes = array of biomes to spawn this ore in (if empty or absent, the ore will spawn in all biomes). Note that the size values in the Minecraft CUSTOM world json do not represent the actual number of blocks spawned, where-as the size value here does represent actual number of blocks. \",\n\t\t\t\t\t\"blockID\":\"basemetals:copper_ore\",\n\t\t\t\t\t\"size\":8,\n\t\t\t\t\t\"variation\":4,\n\t\t\t\t\t\"frequency\":10,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":96\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"basemetals:silver_ore\",\n\t\t\t\t\t\"size\":8,\n\t\t\t\t\t\"variation\":4,\n\t\t\t\t\t\"frequency\":4,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":32\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"basemetals:tin_ore\",\n\t\t\t\t\t\"size\":8,\n\t\t\t\t\t\"variation\":4,\n\t\t\t\t\t\"frequency\":10,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":128\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"basemetals:lead_ore\",\n\t\t\t\t\t\"size\":8,\n\t\t\t\t\t\"variation\":4,\n\t\t\t\t\t\"frequency\":5,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":64\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"basemetals:zinc_ore\",\n\t\t\t\t\t\"size\":8,\n\t\t\t\t\t\"variation\":4,\n\t\t\t\t\t\"frequency\":5,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":96\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"basemetals:mercury_ore\",\n\t\t\t\t\t\"size\":8,\n\t\t\t\t\t\"variation\":4,\n\t\t\t\t\t\"frequency\":3,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":32\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"basemetals:nickel_ore\",\n\t\t\t\t\t\"size\":8,\n\t\t\t\t\t\"variation\":4,\n\t\t\t\t\t\"frequency\":1,\n\t\t\t\t\t\"minHeight\":32,\n\t\t\t\t\t\"maxHeight\":96\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"basemetals:platinum_ore\",\n\t\t\t\t\t\"size\":8,\n\t\t\t\t\t\"variation\":4,\n\t\t\t\t\t\"frequency\":0.125,\n\t\t\t\t\t\"minHeight\":1,\n\t\t\t\t\t\"maxHeight\":32\n\t\t\t\t}\n\t\t\t]\n\t\t},\n\t\t{\n\t\t\t\"dimension\":-1,\n\t\t\t\"__comment\":\"the nether\",\n\t\t\t\"ores\":[\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"basemetals:coldiron_ore\",\n\t\t\t\t\t\"size\":8,\n\t\t\t\t\t\"variation\":4,\n\t\t\t\t\t\"frequency\":5,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":128\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"basemetals:adamantine_ore\",\n\t\t\t\t\t\"size\":8,\n\t\t\t\t\t\"variation\":4,\n\t\t\t\t\t\"frequency\":2,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":128\n\t\t\t\t}\n\t\t\t]\n\t\t},\n\t\t{\n\t\t\t\"dimension\":1,\n\t\t\t\"__comment\":\"the end\",\n\t\t\t\"ores\":[\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"basemetals:starsteel_ore\",\n\t\t\t\t\t\"size\":8,\n\t\t\t\t\t\"variation\":4,\n\t\t\t\t\t\"frequency\":5,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":255\n\t\t\t\t}\n\t\t\t]\n\t\t}\n\t]\n}".split("\n")), Charset.forName("UTF-8"), new OpenOption[0]);
                }
                catch (IOException e) {
                    FMLLog.severe((String)("basemetals: Error: Failed to write file " + oreSpawnFile), (Object[])new Object[0]);
                }
            }
        }
        Fluids.init();
        Materials.init();
        ItemGroups.init();
        Blocks.init();
        Items.init();
        VillagerTrades.init();
        Path ALTPath = Paths.get(event.getSuggestedConfigurationFile().getParent(), "additional-loot-tables");
        Path myLootFolder = ALTPath.resolve(MODID);
        if (Files.notExists(myLootFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(myLootFolder.resolve("chests"), new FileAttribute[0]);
                Files.write(myLootFolder.resolve("chests").resolve("abandoned_mineshaft.json"), Arrays.asList("{\n    \"pools\": [\n        {\n            \"__comment\":\"25% chance per roll of common metal ingots\",\n            \"rolls\": {\n                \"min\": 1,\n                \"max\": 4\n            },\n            \"bonus_rolls\":1,\n            \"entries\": [\n                {\n                    \"type\": \"empty\",\n                    \"weight\": 63\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 6\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 6\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:lead_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 6\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:zinc_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 6\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 6\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:brass_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 6\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 6\n                            }\n                        }\n                    ]\n                }\n            ]\n        },\n        {\n            \"__comment\":\"25% chance of a common-metal tool\",\n            \"rolls\": 1,\n            \"entries\": [\n                {\n                    \"type\": \"empty\",\n                    \"weight\": 450\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:iron_crackhammer\",\n                    \"weight\": 3\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_crackhammer\",\n                    \"weight\": 3\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_crackhammer\",\n                    \"weight\": 3\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_crackhammer\",\n                    \"weight\": 3\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_crackhammer\",\n                    \"weight\": 3\n                }\n            ]\n        }\n    ]\n}"), new OpenOption[0]);
                Files.write(myLootFolder.resolve("chests").resolve("desert_pyramid.json"), Arrays.asList("{\n    \"pools\": [\n        {\n            \"__comment\":\"25% chance of an uncommon metal tool\",\n            \"rolls\": 1,\n            \"entries\": [\n                {\n                    \"type\": \"empty\",\n                    \"weight\": 900\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_axe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_boots\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_chestplate\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_helmet\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_hoe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_leggings\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_pickaxe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_shovel\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_sword\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:iron_crackhammer\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_axe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_boots\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_chestplate\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_helmet\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_hoe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_leggings\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_pickaxe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_shovel\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_sword\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_crackhammer\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_axe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_boots\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_chestplate\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_helmet\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_hoe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_leggings\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_pickaxe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_shovel\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_sword\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_crackhammer\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_crackhammer\",\n                    \"weight\": 3\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_crackhammer\",\n                    \"weight\": 3\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_crackhammer\",\n                    \"weight\": 3\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_crackhammer\",\n                    \"weight\": 3\n                }\n            ]\n        },\n        {\n            \"__comment\":\"20% chance per roll of uncommon metal ingots\",\n            \"rolls\": {\n                \"min\": 1,\n                \"max\": 2\n            },\n            \"bonus_rolls\":1,\n            \"entries\": [\n                {\n                    \"type\": \"empty\",\n                    \"weight\": 72\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:gold_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 4\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:silver_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 6\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:nickel_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 4\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:electrum_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 4\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 3,\n                                \"max\": 12\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 4\n                            }\n                        }\n                    ]\n                }\n            ]\n        }\n    ]\n}"), new OpenOption[0]);
                Files.write(myLootFolder.resolve("chests").resolve("end_city_treasure.json"), Arrays.asList("{\n    \"pools\": [\n        {\n            \"__comment\":\"25% chance of a rare metal tool\",\n            \"rolls\": 1,\n            \"entries\": [\n                {\n                    \"type\": \"empty\",\n                    \"weight\": 540\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_axe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_boots\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_chestplate\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_helmet\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_hoe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_leggings\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_pickaxe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_shovel\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_sword\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_crackhammer\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_axe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_boots\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_chestplate\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_helmet\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_hoe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_leggings\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_pickaxe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_shovel\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_sword\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_crackhammer\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_axe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_boots\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_chestplate\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_helmet\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_hoe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_leggings\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_pickaxe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_shovel\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_sword\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_crackhammer\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_axe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_boots\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_chestplate\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_helmet\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_hoe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_leggings\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_pickaxe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_shovel\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_sword\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_crackhammer\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 20,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:adamantine_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:adamantine_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:adamantine_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:adamantine_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:adamantine_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:adamantine_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:adamantine_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:adamantine_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:adamantine_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:adamantine_crackhammer\",\n                    \"weight\": 3\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:starsteel_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:starsteel_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:starsteel_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:starsteel_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:starsteel_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:starsteel_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:starsteel_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:starsteel_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:starsteel_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:starsteel_crackhammer\",\n                    \"weight\": 3\n                }\n            ]\n        },\n        {\n            \"__comment\":\"25% chance of rare metal ingots\",\n            \"rolls\": 1,\n            \"entries\": [\n                {\n                    \"type\": \"empty\",\n                    \"weight\": 300\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_ingot\",\n                    \"weight\": 40,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 4\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_ingot\",\n                    \"weight\": 25,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 4\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_ingot\",\n                    \"weight\": 20,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 4\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:platinum_ingot\",\n                    \"weight\": 10,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 6\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:adamantine_ingot\",\n                    \"weight\": 10,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 4\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:starsteel_ingot\",\n                    \"weight\": 5,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 4\n                            }\n                        }\n                    ]\n                }\n            ]\n        }\n    ]\n}"), new OpenOption[0]);
                Files.write(myLootFolder.resolve("chests").resolve("jungle_temple.json"), Arrays.asList("{\n    \"pools\": [\n        {\n            \"__comment\":\"25% chance of an uncommon metal tool\",\n            \"rolls\": 1,\n            \"entries\": [\n                {\n                    \"type\": \"empty\",\n                    \"weight\": 900\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_axe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_boots\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_chestplate\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_helmet\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_hoe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_leggings\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_pickaxe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_shovel\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_sword\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:iron_crackhammer\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_axe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_boots\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_chestplate\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_helmet\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_hoe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_leggings\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_pickaxe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_shovel\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_sword\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_crackhammer\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_axe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_boots\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_chestplate\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_helmet\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_hoe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_leggings\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_pickaxe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_shovel\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_sword\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_crackhammer\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_crackhammer\",\n                    \"weight\": 3\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_crackhammer\",\n                    \"weight\": 3\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_crackhammer\",\n                    \"weight\": 3\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_crackhammer\",\n                    \"weight\": 3\n                }\n            ]\n        },\n        {\n            \"__comment\":\"20% chance per roll of uncommon metal ingots\",\n            \"rolls\": {\n                \"min\": 1,\n                \"max\": 2\n            },\n            \"bonus_rolls\":1,\n            \"entries\": [\n                {\n                    \"type\": \"empty\",\n                    \"weight\": 72\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:gold_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 4\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:silver_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 6\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:nickel_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 4\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:electrum_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 4\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 3,\n                                \"max\": 12\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 4\n                            }\n                        }\n                    ]\n                }\n            ]\n        }\n    ]\n}"), new OpenOption[0]);
                Files.write(myLootFolder.resolve("chests").resolve("nether_bridge.json"), Arrays.asList("{\n    \"pools\": [\n        {\n            \"__comment\":\"25% chance of an uncommon metal tool\",\n            \"rolls\": 1,\n            \"entries\": [\n                {\n                    \"type\": \"empty\",\n                    \"weight\": 900\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_axe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_boots\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_chestplate\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_helmet\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_hoe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_leggings\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_pickaxe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_shovel\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_sword\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:iron_crackhammer\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_axe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_boots\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_chestplate\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_helmet\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_hoe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_leggings\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_pickaxe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_shovel\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_sword\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_crackhammer\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_axe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_boots\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_chestplate\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_helmet\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_hoe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_leggings\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_pickaxe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_shovel\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_sword\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_crackhammer\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_crackhammer\",\n                    \"weight\": 3\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_crackhammer\",\n                    \"weight\": 3\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_crackhammer\",\n                    \"weight\": 3\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_crackhammer\",\n                    \"weight\": 3\n                }\n            ]\n        },\n        {\n            \"__comment\":\"25% chance of rare metal ingots\",\n            \"rolls\": 1,\n            \"entries\": [\n                {\n                    \"type\": \"empty\",\n                    \"weight\": 300\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_ingot\",\n                    \"weight\": 40,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 4\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_ingot\",\n                    \"weight\": 25,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 4\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_ingot\",\n                    \"weight\": 20,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 4\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:platinum_ingot\",\n                    \"weight\": 10,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 6\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:adamantine_ingot\",\n                    \"weight\": 10,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 4\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:starsteel_ingot\",\n                    \"weight\": 5,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 4\n                            }\n                        }\n                    ]\n                }\n            ]\n        }\n    ]\n}"), new OpenOption[0]);
                Files.write(myLootFolder.resolve("chests").resolve("simple_dungeon.json"), Arrays.asList("{\n    \"pools\": [\n        {\n            \"__comment\":\"25% chance of an uncommon metal tool\",\n            \"rolls\": 1,\n            \"entries\": [\n                {\n                    \"type\": \"empty\",\n                    \"weight\": 900\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_axe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_boots\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_chestplate\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_helmet\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_hoe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_leggings\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_pickaxe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_shovel\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_sword\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:iron_crackhammer\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_axe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_boots\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_chestplate\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_helmet\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_hoe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_leggings\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_pickaxe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_shovel\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_sword\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_crackhammer\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_axe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_boots\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_chestplate\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_helmet\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_hoe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_leggings\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_pickaxe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_shovel\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_sword\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_crackhammer\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_crackhammer\",\n                    \"weight\": 3\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_crackhammer\",\n                    \"weight\": 3\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_crackhammer\",\n                    \"weight\": 3\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_crackhammer\",\n                    \"weight\": 3\n                }\n            ]\n        },\n        {\n            \"__comment\":\"10% chance per roll of uncommon metal ingots\",\n            \"rolls\": {\n                \"min\": 1,\n                \"max\": 2\n            },\n            \"bonus_rolls\":1,\n            \"entries\": [\n                {\n                    \"type\": \"empty\",\n                    \"weight\": 162\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:gold_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 4\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:silver_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 6\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:nickel_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 4\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:electrum_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 4\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 3,\n                                \"max\": 12\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 4\n                            }\n                        }\n                    ]\n                }\n            ]\n        }\n    ]\n}"), new OpenOption[0]);
                Files.write(myLootFolder.resolve("chests").resolve("spawn_bonus_chest.json"), Arrays.asList("{\n    \"pools\": [\n        {\n            \"__comment\":\"100% chance of one common-metal tool\",\n            \"rolls\": 1,\n            \"entries\": [\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:iron_crackhammer\",\n                    \"weight\": 3\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_crackhammer\",\n                    \"weight\": 3\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_crackhammer\",\n                    \"weight\": 3\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_crackhammer\",\n                    \"weight\": 3\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_crackhammer\",\n                    \"weight\": 3\n                }\n            ]\n        }\n    ]\n}"), new OpenOption[0]);
                Files.write(myLootFolder.resolve("chests").resolve("stronghold_corridor.json"), Arrays.asList("{\n    \"pools\": [\n        {\n            \"__comment\":\"25% chance of an uncommon metal tool\",\n            \"rolls\": 1,\n            \"entries\": [\n                {\n                    \"type\": \"empty\",\n                    \"weight\": 900\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_axe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_boots\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_chestplate\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_helmet\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_hoe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_leggings\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_pickaxe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_shovel\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_sword\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:iron_crackhammer\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_axe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_boots\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_chestplate\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_helmet\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_hoe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_leggings\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_pickaxe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_shovel\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_sword\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_crackhammer\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_axe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_boots\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_chestplate\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_helmet\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_hoe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_leggings\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_pickaxe\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_shovel\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_sword\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_crackhammer\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"minecraft:enchant_with_levels\",\n                            \"levels\": 10,\n                            \"treasure\": true\n                        }\n                    ]\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_crackhammer\",\n                    \"weight\": 3\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_crackhammer\",\n                    \"weight\": 3\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_crackhammer\",\n                    \"weight\": 3\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_crackhammer\",\n                    \"weight\": 3\n                }\n            ]\n        },\n        {\n            \"__comment\":\"25% chance of rare metal ingots\",\n            \"rolls\": 1,\n            \"entries\": [\n                {\n                    \"type\": \"empty\",\n                    \"weight\": 300\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:coldiron_ingot\",\n                    \"weight\": 40,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 4\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:aquarium_ingot\",\n                    \"weight\": 25,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 4\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:mithril_ingot\",\n                    \"weight\": 20,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 4\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:platinum_ingot\",\n                    \"weight\": 10,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 6\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:adamantine_ingot\",\n                    \"weight\": 10,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 4\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:starsteel_ingot\",\n                    \"weight\": 5,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 4\n                            }\n                        }\n                    ]\n                }\n            ]\n        }\n    ]\n}"), new OpenOption[0]);
                Files.write(myLootFolder.resolve("chests").resolve("stronghold_crossing.json"), Arrays.asList("{\n    \"pools\": [\n        {\n            \"__comment\":\"25% chance of a common-metal tool\",\n            \"rolls\": 1,\n            \"entries\": [\n                {\n                    \"type\": \"empty\",\n                    \"weight\": 450\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:iron_crackhammer\",\n                    \"weight\": 3\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_crackhammer\",\n                    \"weight\": 3\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_crackhammer\",\n                    \"weight\": 3\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_crackhammer\",\n                    \"weight\": 3\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_crackhammer\",\n                    \"weight\": 3\n                }\n            ]\n        },\n        {\n            \"__comment\":\"10% chance per roll of uncommon metal ingots\",\n            \"rolls\": {\n                \"min\": 1,\n                \"max\": 2\n            },\n            \"bonus_rolls\":1,\n            \"entries\": [\n                {\n                    \"type\": \"empty\",\n                    \"weight\": 162\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:gold_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 4\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:silver_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 6\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:nickel_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 4\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:electrum_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 4\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 3,\n                                \"max\": 12\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:invar_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 4\n                            }\n                        }\n                    ]\n                }\n            ]\n        }\n    ]\n}"), new OpenOption[0]);
                Files.write(myLootFolder.resolve("chests").resolve("village_blacksmith.json"), Arrays.asList("{\n    \"pools\": [\n        {\n            \"__comment\":\"25% chance of a common-metal tool\",\n            \"rolls\": 1,\n            \"entries\": [\n                {\n                    \"type\": \"empty\",\n                    \"weight\": 450\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:iron_crackhammer\",\n                    \"weight\": 3\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_crackhammer\",\n                    \"weight\": 3\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_crackhammer\",\n                    \"weight\": 3\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_crackhammer\",\n                    \"weight\": 3\n                },\n                \n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_axe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_boots\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_chestplate\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_helmet\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_hoe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_leggings\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_pickaxe\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_shovel\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_sword\",\n                    \"weight\": 3\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:steel_crackhammer\",\n                    \"weight\": 3\n                }\n            ]\n        },\n        {\n            \"__comment\":\"10% chance per roll of common metal ingots\",\n            \"rolls\": {\n                \"min\": 1,\n                \"max\": 4\n            },\n            \"bonus_rolls\":1,\n            \"entries\": [\n                {\n                    \"type\": \"empty\",\n                    \"weight\": 189\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"minecraft:iron_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 6\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:tin_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 6\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:lead_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 6\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:zinc_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 6\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:copper_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 6\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:brass_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 6\n                            }\n                        }\n                    ]\n                },\n                {\n                    \"type\": \"item\",\n                    \"name\": \"basemetals:bronze_ingot\",\n                    \"weight\": 3,\n                    \"functions\": [\n                        {\n                            \"function\": \"set_count\",\n                            \"count\": {\n                                \"min\": 1,\n                                \"max\": 6\n                            }\n                        }\n                    ]\n                }\n            ]\n        }\n    ]\n}"), new OpenOption[0]);
            }
            catch (IOException ex) {
                FMLLog.log((Level)Level.ERROR, (Throwable)ex, (String)"%s: Failed to extract additional loot tables", (Object[])new Object[]{MODID});
            }
        }
        if (event.getSide() == Side.CLIENT) {
            this.clientPreInit(event);
        }
        if (event.getSide() == Side.SERVER) {
            this.serverPreInit(event);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void clientPreInit(FMLPreInitializationEvent event) {
        Fluids.bakeModels(MODID);
    }

    @SideOnly(value=Side.SERVER)
    private void serverPreInit(FMLPreInitializationEvent event) {
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Recipes.init();
        DungeonLoot.init();
        Entities.init();
        Achievements.init();
        if (event.getSide() == Side.CLIENT) {
            this.clientInit(event);
        }
        if (event.getSide() == Side.SERVER) {
            this.serverInit(event);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void clientInit(FMLInitializationEvent event) {
        Items.registerItemRenders(event);
        Blocks.registerItemRenders(event);
    }

    @SideOnly(value=Side.SERVER)
    private void serverInit(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        WorldGen.init();
        for (String recipe : userCrusherRecipes) {
            FMLLog.info((String)("basemetals: adding custom crusher recipe '" + recipe + "'"), (Object[])new Object[0]);
            int i = recipe.indexOf("->");
            String inputStr = recipe.substring(0, i);
            String outputStr = recipe.substring(i + 2, recipe.length());
            ItemStack input = BaseMetals.parseStringAsItemStack(inputStr, true);
            ItemStack output = BaseMetals.parseStringAsItemStack(outputStr, false);
            if (input == null || output == null) {
                FMLLog.severe((String)("Failed to add recipe formula '" + recipe + "' because the blocks/items could not be found"), (Object[])new Object[0]);
                continue;
            }
            CrusherRecipeRegistry.addNewCrusherRecipe(input, output);
        }
        if (autoDetectRecipes) {
            HashSet<String> dictionary = new HashSet<String>();
            dictionary.addAll(Arrays.asList(OreDictionary.getOreNames()));
            for (String entry : dictionary) {
                if (entry.contains("Mercury") || !entry.startsWith("dust")) continue;
                String X = entry.substring("dust".length());
                String dustX = entry;
                String ingotX = "ingot".concat(X);
                String oreX = "ore".concat(X);
                if (!dictionary.contains(oreX) || !dictionary.contains(ingotX) || OreDictionary.getOres((String)dustX).isEmpty()) continue;
                ItemStack dustX1 = ((ItemStack)OreDictionary.getOres((String)dustX).get(0)).func_77946_l();
                dustX1.field_77994_a = 1;
                ItemStack dustX2 = dustX1.func_77946_l();
                dustX2.field_77994_a = 2;
                List oreBlocks = OreDictionary.getOres((String)oreX);
                boolean alreadyHasOreRecipe = true;
                for (ItemStack i : oreBlocks) {
                    alreadyHasOreRecipe = alreadyHasOreRecipe && CrusherRecipeRegistry.getInstance().getRecipeForInputItem(i) != null;
                }
                List ingotStacks = OreDictionary.getOres((String)ingotX);
                boolean alreadyHasIngotRecipe = true;
                for (ItemStack i : ingotStacks) {
                    alreadyHasIngotRecipe = alreadyHasIngotRecipe && CrusherRecipeRegistry.getInstance().getRecipeForInputItem(i) != null;
                }
                if (!alreadyHasOreRecipe) {
                    FMLLog.info((String)"basemetals: automatically adding custom crusher recipe \"%s\" -> %s", (Object[])new Object[]{oreX, dustX2});
                    CrusherRecipeRegistry.addNewCrusherRecipe(oreX, dustX2);
                }
                if (alreadyHasIngotRecipe) continue;
                FMLLog.info((String)"basemetals: automatically adding custom crusher recipe \"%s\" -> %s", (Object[])new Object[]{ingotX, dustX1});
                CrusherRecipeRegistry.addNewCrusherRecipe(ingotX, dustX1);
            }
        }
        if (event.getSide() == Side.CLIENT) {
            this.clientPostInit(event);
        }
        if (event.getSide() == Side.SERVER) {
            this.serverPostInit(event);
        }
        CrusherRecipeRegistry.getInstance().clearCache();
    }

    @SideOnly(value=Side.CLIENT)
    private void clientPostInit(FMLPostInitializationEvent event) {
    }

    @SideOnly(value=Side.SERVER)
    private void serverPostInit(FMLPostInitializationEvent event) {
    }

    public static ItemStack parseStringAsItemStack(String str, boolean allowWildcard) {
        String id;
        str = str.trim();
        int count = 1;
        int meta = allowWildcard ? Short.MAX_VALUE : 0;
        int nameStart = 0;
        int nameEnd = str.length();
        if (str.contains("*")) {
            count = Integer.parseInt(str.substring(0, str.indexOf("*")).trim());
            nameStart = str.indexOf("*") + 1;
        }
        if (str.contains("#")) {
            meta = Integer.parseInt(str.substring(str.indexOf("#") + 1, str.length()).trim());
            nameEnd = str.indexOf("#");
        }
        if (Block.func_149684_b((String)(id = str.substring(nameStart, nameEnd).trim())) != null) {
            return new ItemStack(Block.func_149684_b((String)id), count, meta);
        }
        if (Item.func_111206_d((String)id) != null) {
            return new ItemStack(Item.func_111206_d((String)id), count, meta);
        }
        FMLLog.severe((String)("Failed to find item or block for ID '" + id + "'"), (Object[])new Object[0]);
        return null;
    }

    static {
        FluidRegistry.enableUniversalBucket();
        enforceHardness = true;
        strongHammers = true;
        disableAllHammers = false;
        userCrusherRecipes = new ArrayList<String>();
        oreSpawnFolder = null;
        autoDetectRecipes = true;
        requireOreSpawn = true;
    }
}

