/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class IEFluid
extends Fluid {
    public static final DataSerializer<Optional<FluidStack>> OPTIONAL_FLUID_STACK = new DataSerializer<Optional<FluidStack>>(){

        public void write(PacketBuffer buf, Optional<FluidStack> value) {
            buf.writeBoolean(value.isPresent());
            FluidStack fs = (FluidStack)value.orNull();
            if (fs != null) {
                buf.func_150786_a(fs.writeToNBT(new NBTTagCompound()));
            }
        }

        public Optional<FluidStack> read(PacketBuffer buf) throws IOException {
            FluidStack fs = !buf.readBoolean() ? null : FluidStack.loadFluidStackFromNBT((NBTTagCompound)buf.func_150793_b());
            return Optional.fromNullable((Object)fs);
        }

        public DataParameter<Optional<FluidStack>> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }
    };

    public IEFluid(String fluidName, ResourceLocation still, ResourceLocation flowing) {
        super(fluidName, still, flowing);
    }

    @SideOnly(value=Side.CLIENT)
    public void addTooltipInfo(FluidStack fluidStack, @Nullable EntityPlayer player, List<String> tooltip) {
    }

    public static class FluidPotion
    extends IEFluid {
        public FluidPotion(String fluidName, ResourceLocation still, ResourceLocation flowing) {
            super(fluidName, still, flowing);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addTooltipInfo(FluidStack fluidStack, @Nullable EntityPlayer player, List<String> tooltip) {
            if (fluidStack != null && fluidStack.tag != null) {
                List effects = PotionUtils.func_185185_a((NBTTagCompound)fluidStack.tag);
                if (effects.isEmpty()) {
                    tooltip.add(TextFormatting.GRAY + I18n.func_74838_a((String)"effect.none").trim());
                } else {
                    for (PotionEffect potioneffect : effects) {
                        String s1 = I18n.func_74838_a((String)potioneffect.func_76453_d()).trim();
                        Potion potion = potioneffect.func_188419_a();
                        if (potioneffect.func_76458_c() > 0) {
                            s1 = s1 + " " + I18n.func_74838_a((String)("potion.potency." + potioneffect.func_76458_c())).trim();
                        }
                        if (potioneffect.func_76459_b() > 20) {
                            s1 = s1 + " (" + Potion.func_188410_a((PotionEffect)potioneffect, (float)1.0f) + ")";
                        }
                        if (potion.func_76398_f()) {
                            tooltip.add(TextFormatting.RED + s1);
                            continue;
                        }
                        tooltip.add(TextFormatting.BLUE + s1);
                    }
                }
            }
        }

        public String getLocalizedName(FluidStack stack) {
            if (stack == null || stack.tag == null) {
                return super.getLocalizedName(stack);
            }
            return I18n.func_74838_a((String)PotionUtils.func_185187_c((NBTTagCompound)stack.tag).func_185174_b("potion.effect."));
        }

        public int getColor(FluidStack stack) {
            if (stack == null || stack.tag != null) {
                return 0xFF000000 | PotionUtils.func_185181_a((Collection)PotionUtils.func_185185_a((NBTTagCompound)stack.tag));
            }
            return -16776961;
        }
    }
}

