/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.tool.BelljarHandler;
import blusunrize.immersiveengineering.api.tool.IConfigurableTool;
import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.api.tool.IUpgrade;
import blusunrize.immersiveengineering.api.tool.IUpgradeableTool;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityModWorkbench;
import blusunrize.immersiveengineering.common.gui.ContainerArcFurnace;
import blusunrize.immersiveengineering.common.gui.ContainerAutoWorkbench;
import blusunrize.immersiveengineering.common.gui.ContainerBlastFurnace;
import blusunrize.immersiveengineering.common.gui.ContainerModWorkbench;
import blusunrize.immersiveengineering.common.items.ItemBullet;
import blusunrize.immersiveengineering.common.items.ItemEngineersBlueprint;
import blusunrize.immersiveengineering.common.util.IEAchievements;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public abstract class IESlot
extends Slot {
    final Container container;

    public IESlot(Container container, IInventory inv, int id, int x, int y) {
        super(inv, id, x, y);
        this.container = container;
    }

    public boolean func_75214_a(ItemStack itemStack) {
        return true;
    }

    public static interface ICallbackContainer {
        public boolean canInsert(ItemStack var1, int var2, Slot var3);

        public boolean canTake(ItemStack var1, int var2, Slot var3);
    }

    public static class ContainerCallback
    extends IESlot {
        public ContainerCallback(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            if (this.container instanceof ICallbackContainer) {
                return ((ICallbackContainer)this.container).canInsert(itemStack, this.field_75222_d, this);
            }
            return true;
        }

        public boolean func_82869_a(EntityPlayer player) {
            if (this.container instanceof ICallbackContainer) {
                return ((ICallbackContainer)this.container).canTake(this.func_75211_c(), this.field_75222_d, this);
            }
            return true;
        }
    }

    public static class Belljar
    extends IESlot {
        int type = 0;

        public Belljar(int type, Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
            this.type = type;
        }

        public int func_75219_a() {
            return this.type < 2 ? 1 : 64;
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            return itemStack != null && (this.type == 1 ? BelljarHandler.getHandler(itemStack) != null : this.type != 2 || BelljarHandler.getItemFertilizerHandler(itemStack) != null);
        }
    }

    public static class ArcElectrode
    extends IESlot {
        public ArcElectrode(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        public int func_75219_a() {
            return 1;
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            return itemStack != null && IEContent.itemGraphiteElectrode.equals(itemStack.func_77973_b());
        }
    }

    public static class ArcAdditive
    extends IESlot {
        public ArcAdditive(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            return itemStack != null && ArcFurnaceRecipe.isValidRecipeAdditive(itemStack);
        }
    }

    public static class ArcInput
    extends IESlot {
        public ArcInput(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            return itemStack != null && ArcFurnaceRecipe.isValidRecipeInput(itemStack);
        }
    }

    public static class BlueprintOutput
    extends IESlot {
        public BlueprintCraftingRecipe recipe;
        ItemStack upgradeableTool;

        public BlueprintOutput(Container container, IInventory inv, int id, int x, int y, ItemStack upgradeableTool, BlueprintCraftingRecipe recipe) {
            super(container, inv, id, x, y);
            this.upgradeableTool = upgradeableTool;
            this.recipe = recipe;
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            return false;
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_111238_b() {
            return this.func_75216_d();
        }

        public void func_82870_a(EntityPlayer player, ItemStack stack) {
            if (this.upgradeableTool != null && this.upgradeableTool.func_77973_b() instanceof ItemEngineersBlueprint) {
                ((ItemEngineersBlueprint)this.upgradeableTool.func_77973_b()).reduceInputs(this.recipe, this.upgradeableTool, stack, this.container);
            }
            if (this.container instanceof ContainerModWorkbench) {
                ((ContainerModWorkbench)this.container).rebindSlots();
                ((TileEntityModWorkbench)((ContainerModWorkbench)this.container).tile).func_70296_d();
            }
            block0: for (IEAchievements.AchievementIE achievement : IEAchievements.blueprintCraftingAchievements) {
                if (achievement.triggerItems != null && achievement.triggerItems.length > 0) {
                    for (ItemStack trigger : achievement.triggerItems) {
                        if (!ApiUtils.stackMatchesObject(stack, trigger, achievement.checkNBT && trigger.func_77942_o())) continue;
                        player.func_71029_a((StatBase)achievement);
                        continue block0;
                    }
                    continue;
                }
                if (!ApiUtils.stackMatchesObject(stack, achievement.field_75990_d, achievement.checkNBT && achievement.field_75990_d.func_77942_o())) continue;
                player.func_71029_a((StatBase)achievement);
            }
            this.field_75224_c.func_70296_d();
            super.func_82870_a(player, stack);
        }
    }

    public static class BlueprintInput
    extends IESlot {
        ItemStack upgradeableTool;

        public BlueprintInput(Container container, IInventory inv, int id, int x, int y, ItemStack upgradeableTool) {
            super(container, inv, id, x, y);
            this.upgradeableTool = upgradeableTool;
        }

        public void func_75218_e() {
            this.field_75224_c.func_70296_d();
            if (this.upgradeableTool != null && this.upgradeableTool.func_77973_b() instanceof ItemEngineersBlueprint) {
                ((ItemEngineersBlueprint)this.upgradeableTool.func_77973_b()).updateOutputs(this.upgradeableTool);
            }
            if (this.container instanceof ContainerModWorkbench) {
                ((ContainerModWorkbench)this.container).rebindSlots();
            }
            super.func_75218_e();
        }

        public int func_75219_a() {
            return 64;
        }
    }

    public static class ItemDisplay
    extends IESlot {
        public ItemDisplay(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            return false;
        }

        public boolean func_82869_a(EntityPlayer player) {
            return false;
        }
    }

    public static class Ghost
    extends IESlot {
        public Ghost(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        public void func_75215_d(ItemStack itemStack) {
            super.func_75215_d(itemStack);
        }

        public boolean func_82869_a(EntityPlayer player) {
            return false;
        }

        public int func_75219_a() {
            return 1;
        }
    }

    public static class AutoBlueprint
    extends IESlot {
        public AutoBlueprint(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            return itemStack != null && itemStack.func_77973_b() instanceof ItemEngineersBlueprint;
        }

        public int func_75219_a() {
            return 1;
        }

        public void func_75218_e() {
            super.func_75218_e();
            if (this.container instanceof ContainerAutoWorkbench) {
                ImmersiveEngineering.proxy.reInitGui();
            }
        }
    }

    public static class UpgradeableItem
    extends IESlot {
        int size;

        public UpgradeableItem(Container container, IInventory inv, int id, int x, int y, int size) {
            super(container, inv, id, x, y);
            this.size = size;
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            if (itemStack == null) {
                return false;
            }
            if (itemStack.func_77973_b() instanceof IUpgradeableTool) {
                return ((IUpgradeableTool)itemStack.func_77973_b()).canModify(itemStack);
            }
            if (itemStack.func_77973_b() instanceof IConfigurableTool) {
                return ((IConfigurableTool)itemStack.func_77973_b()).canConfigure(itemStack);
            }
            return false;
        }

        public int func_75219_a() {
            return this.size;
        }

        public void func_75218_e() {
            super.func_75218_e();
            if (this.container instanceof ContainerModWorkbench) {
                ((ContainerModWorkbench)this.container).rebindSlots();
            }
        }

        public boolean func_82869_a(EntityPlayer player) {
            return this.func_75211_c() == null || !(this.func_75211_c().func_77973_b() instanceof IUpgradeableTool) || ((IUpgradeableTool)this.func_75211_c().func_77973_b()).canTakeFromWorkbench(this.func_75211_c());
        }

        public void func_82870_a(EntityPlayer player, ItemStack stack) {
            super.func_82870_a(player, stack);
            if (stack != null && stack.func_77973_b() instanceof IUpgradeableTool) {
                ((IUpgradeableTool)stack.func_77973_b()).removeFromWorkbench(player, stack);
            }
        }
    }

    public static class Shader
    extends IESlot {
        ItemStack tool;

        public Shader(Container container, IInventory inv, int id, int x, int y, ItemStack tool) {
            super(container, inv, id, x, y);
            this.tool = tool;
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                this.setBackgroundName("immersiveengineering:items/shader_slot");
            }
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            if (itemStack == null || !(itemStack.func_77973_b() instanceof IShaderItem) || this.tool == null || !this.tool.hasCapability(CapabilityShader.SHADER_CAPABILITY, null)) {
                return false;
            }
            CapabilityShader.ShaderWrapper wrapper = (CapabilityShader.ShaderWrapper)this.tool.getCapability(CapabilityShader.SHADER_CAPABILITY, null);
            if (wrapper == null) {
                return false;
            }
            return ((IShaderItem)itemStack.func_77973_b()).getShaderCase(itemStack, this.tool, wrapper.getShaderType()) != null;
        }

        public int func_75219_a() {
            return 1;
        }
    }

    public static class Upgrades
    extends IESlot {
        ItemStack upgradeableTool;
        String type;
        boolean preventDoubles;

        public Upgrades(Container container, IInventory inv, int id, int x, int y, String type, ItemStack upgradeableTool, boolean preventDoubles) {
            super(container, inv, id, x, y);
            this.type = type;
            this.upgradeableTool = upgradeableTool;
            this.preventDoubles = preventDoubles;
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            if (this.preventDoubles) {
                for (Slot slot : this.container.field_75151_b) {
                    if (!(slot instanceof Upgrades) || !((Upgrades)slot).preventDoubles || !OreDictionary.itemMatches((ItemStack)slot.func_75211_c(), (ItemStack)itemStack, (boolean)true)) continue;
                    return false;
                }
            }
            return itemStack != null && itemStack.func_77973_b() instanceof IUpgrade && ((IUpgrade)itemStack.func_77973_b()).getUpgradeTypes(itemStack).contains(this.type) && ((IUpgrade)itemStack.func_77973_b()).canApplyUpgrades(this.upgradeableTool, itemStack);
        }

        public int func_75219_a() {
            return 64;
        }
    }

    public static class DrillHead
    extends IESlot {
        public DrillHead(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            return itemStack != null && itemStack.func_77973_b() instanceof IDrillHead;
        }

        public int func_75219_a() {
            return 1;
        }
    }

    public static class Bullet
    extends IESlot {
        int limit;

        public Bullet(Container container, IInventory inv, int id, int x, int y, int limit) {
            super(container, inv, id, x, y);
            this.limit = limit;
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            return itemStack != null && itemStack.func_77973_b() instanceof ItemBullet;
        }

        public int func_75219_a() {
            return this.limit;
        }
    }

    public static class BlastFuel
    extends IESlot {
        public BlastFuel(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            return BlastFurnaceRecipe.isValidBlastFuel(itemStack);
        }
    }

    public static class FluidContainer
    extends IESlot {
        boolean empty;

        public FluidContainer(Container container, IInventory inv, int id, int x, int y, boolean empty) {
            super(container, inv, id, x, y);
            this.empty = empty;
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            IFluidHandler handler = FluidUtil.getFluidHandler((ItemStack)itemStack);
            if (handler == null || handler.getTankProperties() == null) {
                return false;
            }
            IFluidTankProperties[] tank = handler.getTankProperties();
            if (tank == null || tank.length < 1 || tank[0] == null) {
                return false;
            }
            if (this.empty) {
                return tank[0].getContents() == null;
            }
            return tank[0].getContents() != null;
        }
    }

    public static class Output
    extends IESlot {
        public Output(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            return false;
        }

        public void func_82870_a(EntityPlayer player, ItemStack stack) {
            super.func_82870_a(player, stack);
            if (player != null && (this.container instanceof ContainerBlastFurnace || this.container instanceof ContainerArcFurnace) && ApiUtils.compareToOreName(stack, "ingotSteel")) {
                player.func_71029_a((StatBase)IEAchievements.makeSteel);
            }
        }
    }
}

