/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.BlockIEFluid;
import blusunrize.immersiveengineering.common.blocks.stone.BlockTypes_StoneDecoration;
import blusunrize.immersiveengineering.common.blocks.stone.BlockTypes_StoneDevices;
import blusunrize.immersiveengineering.common.util.IEPotions;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.Fluid;

public class BlockIEFluidConcrete
extends BlockIEFluid {
    public BlockIEFluidConcrete(String name, Fluid fluid, Material material) {
        super(name, fluid, material);
        this.setQuantaPerBlock(16);
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{LEVEL, IEProperties.INT_16}, (IUnlistedProperty[])FLUID_RENDER_PROPS.toArray((Object[])new IUnlistedProperty[0]));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        int adjacentSourceBlocks;
        if (!this.isSourceBlock((IBlockAccess)world, pos) && ForgeEventFactory.canCreateFluidSource((World)world, (BlockPos)pos, (IBlockState)state, (boolean)false) && (adjacentSourceBlocks = (this.isSourceBlock((IBlockAccess)world, pos.func_177978_c()) ? 1 : 0) + (this.isSourceBlock((IBlockAccess)world, pos.func_177968_d()) ? 1 : 0) + (this.isSourceBlock((IBlockAccess)world, pos.func_177974_f()) ? 1 : 0) + (this.isSourceBlock((IBlockAccess)world, pos.func_177976_e()) ? 1 : 0)) >= 2 && (world.func_180495_p(pos.func_177981_b(this.densityDir)).func_185904_a().func_76220_a() || this.isSourceBlock((IBlockAccess)world, pos.func_177981_b(this.densityDir)))) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(0)));
        }
        int level = (Integer)state.func_177229_b((IProperty)LEVEL);
        int timer = (Integer)state.func_177229_b((IProperty)IEProperties.INT_16);
        int quantaRemaining = this.quantaPerBlock - level;
        int expQuanta = -101;
        if (timer >= Math.min(14, quantaRemaining)) {
            IBlockState solidState = level >= 14 ? IEContent.blockStoneDevice.func_176203_a(BlockTypes_StoneDevices.CONCRETE_SHEET.getMeta()) : (level >= 10 ? IEContent.blockStoneDevice.func_176203_a(BlockTypes_StoneDevices.CONCRETE_QUARTER.getMeta()) : (level >= 6 ? IEContent.blockStoneDecorationSlabs.func_176203_a(BlockTypes_StoneDecoration.CONCRETE.getMeta()) : (level >= 2 ? IEContent.blockStoneDevice.func_176203_a(BlockTypes_StoneDevices.CONCRETE_THREEQUARTER.getMeta()) : IEContent.blockStoneDecoration.func_176203_a(BlockTypes_StoneDecoration.CONCRETE.getMeta()))));
            world.func_175656_a(pos, solidState);
            for (EntityLivingBase living : world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)))) {
                living.func_70690_d(new PotionEffect(IEPotions.concreteFeet, Integer.MAX_VALUE));
            }
            return;
        }
        state = state.func_177226_a((IProperty)IEProperties.INT_16, (Comparable)Integer.valueOf(Math.min(15, timer + 1)));
        world.func_175656_a(pos, state);
        if (quantaRemaining < this.quantaPerBlock) {
            if (world.func_180495_p(pos.func_177982_a(0, -this.densityDir, 0)).func_177230_c() == this || world.func_180495_p(pos.func_177982_a(-1, -this.densityDir, 0)).func_177230_c() == this || world.func_180495_p(pos.func_177982_a(1, -this.densityDir, 0)).func_177230_c() == this || world.func_180495_p(pos.func_177982_a(0, -this.densityDir, -1)).func_177230_c() == this || world.func_180495_p(pos.func_177982_a(0, -this.densityDir, 1)).func_177230_c() == this) {
                expQuanta = this.quantaPerBlock - 1;
            } else {
                int maxQuanta = -100;
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, pos.func_177982_a(-1, 0, 0), maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, pos.func_177982_a(1, 0, 0), maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, pos.func_177982_a(0, 0, -1), maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, pos.func_177982_a(0, 0, 1), maxQuanta);
                expQuanta = maxQuanta - 1;
            }
            int total = level;
            int blocks = 1;
            for (EnumFacing f : EnumFacing.field_176754_o) {
                IBlockState otherState = world.func_180495_p(pos.func_177972_a(f));
                if (otherState.func_177230_c() != this) continue;
                ++blocks;
                total += ((Integer)otherState.func_177229_b((IProperty)LEVEL)).intValue();
            }
            int newEvenQuanta = (int)Math.ceil((float)total / (float)blocks);
            for (EnumFacing f : EnumFacing.field_176754_o) {
                IBlockState otherState = world.func_180495_p(pos.func_177972_a(f));
                if (otherState.func_177230_c() != this) continue;
                world.func_175656_a(pos.func_177972_a(f), otherState.func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(newEvenQuanta)));
            }
            if (expQuanta != quantaRemaining) {
                quantaRemaining = expQuanta;
                if (expQuanta <= 0) {
                    world.func_175698_g(pos);
                } else {
                    world.func_180501_a(pos, state.func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(this.quantaPerBlock - expQuanta)), 2);
                    world.func_175684_a(pos, (Block)this, this.tickRate);
                    world.func_175685_c(pos, (Block)this);
                }
            }
        } else if (quantaRemaining >= this.quantaPerBlock) {
            world.func_180501_a(pos, this.func_176223_P(), 2);
        }
        if (this.canDisplace((IBlockAccess)world, pos.func_177981_b(this.densityDir))) {
            this.flowIntoBlockRet(world, pos.func_177981_b(this.densityDir), 1, timer);
            return;
        }
        int flowMeta = this.quantaPerBlock - quantaRemaining + 1;
        if (flowMeta >= this.quantaPerBlock) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)IEProperties.INT_16, (Comparable)Integer.valueOf(Math.min(15, timer + 1))));
            world.func_175684_a(pos, (Block)this, this.tickRate);
            return;
        }
        if (this.isSourceBlock((IBlockAccess)world, pos) || !this.isFlowingVertically((IBlockAccess)world, pos)) {
            if (world.func_180495_p(pos.func_177979_c(this.densityDir)).func_177230_c() == this) {
                flowMeta = 1;
            }
            boolean[] flowTo = this.getOptimalFlowDirections(world, pos);
            boolean hasFlown = false;
            if (flowTo[0]) {
                hasFlown |= this.flowIntoBlockRet(world, pos.func_177982_a(-1, 0, 0), flowMeta, timer);
            }
            if (flowTo[1]) {
                hasFlown |= this.flowIntoBlockRet(world, pos.func_177982_a(1, 0, 0), flowMeta, timer);
            }
            if (flowTo[2]) {
                hasFlown |= this.flowIntoBlockRet(world, pos.func_177982_a(0, 0, -1), flowMeta, timer);
            }
            if (flowTo[3]) {
                hasFlown |= this.flowIntoBlockRet(world, pos.func_177982_a(0, 0, 1), flowMeta, timer);
            }
            if (!hasFlown) {
                world.func_175656_a(pos, state.func_177226_a((IProperty)IEProperties.INT_16, (Comparable)Integer.valueOf(Math.min(15, timer + 1))));
                world.func_175684_a(pos, (Block)this, this.tickRate);
            }
        }
    }

    protected boolean flowIntoBlockRet(World world, BlockPos pos, int meta, int harden) {
        if (meta < 0) {
            return false;
        }
        if (this.displaceIfPossible(world, pos)) {
            world.func_180501_a(pos, this.func_176194_O().func_177621_b().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(meta)).func_177226_a((IProperty)IEProperties.INT_16, (Comparable)Integer.valueOf(harden)), 3);
            return true;
        }
        return false;
    }
}

