/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.mtlib.helpers;

import com.blamejared.mtlib.helpers.InputHelper;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class StackHelper {
    public static boolean areEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        return stack1.func_77969_a(stack2);
    }

    public static boolean areEqual(FluidStack stack1, FluidStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        return stack1.isFluidEqual(stack2);
    }

    public static boolean areEqualOrNull(ItemStack stack1, ItemStack stack2) {
        if (stack1 == stack2) {
            return true;
        }
        return StackHelper.areEqual(stack1, stack2);
    }

    public static boolean areEqualOrNull(FluidStack stack1, FluidStack stack2) {
        if (stack1 == stack2) {
            return true;
        }
        return StackHelper.areEqual(stack1, stack2);
    }

    public static boolean matches(IIngredient ingredient, IItemStack itemStack) {
        if (ingredient == null) {
            return false;
        }
        return ingredient.matches(itemStack);
    }

    public static boolean matches(IIngredient ingredient, IItemStack[] itemStack) {
        if (ingredient == null) {
            return false;
        }
        for (IItemStack stack : itemStack) {
            if (ingredient.matches(stack)) continue;
            return false;
        }
        return true;
    }

    public static boolean matches(IIngredient ingredient, ILiquidStack liquidStack) {
        if (ingredient == null) {
            return false;
        }
        if (ingredient.matches(liquidStack)) {
            return true;
        }
        if (ingredient.getLiquids() != null) {
            for (ILiquidStack liquid : ingredient.getLiquids()) {
                if (!InputHelper.toFluid(liquid).isFluidEqual(InputHelper.toFluid(liquidStack))) continue;
                return true;
            }
        }
        return false;
    }
}

