/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.net;

import com.feed_the_beast.ftbl.lib.net.MessageToClient;
import com.feed_the_beast.ftbl.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbu.FTBLibIntegration;
import com.feed_the_beast.ftbu.gui.GuiWarps;
import com.feed_the_beast.ftbu.net.FTBUNetHandler;
import com.feed_the_beast.ftbu.world.FTBUPlayerData;
import com.feed_the_beast.ftbu.world.FTBUUniverseData;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class MessageSendWarpList
extends MessageToClient<MessageSendWarpList> {
    private List<WarpItem> warps;

    public MessageSendWarpList() {
    }

    private static String command(EntityPlayerMP player, String name, String backup) {
        ICommand command = (ICommand)player.field_71133_b.func_71187_D().func_71555_a().get(name);
        return "/" + (command != null && command.func_184882_a(player.field_71133_b, (ICommandSender)player) ? name : backup);
    }

    public MessageSendWarpList(EntityPlayerMP player) {
        FTBUPlayerData playerData;
        this.warps = new ArrayList<WarpItem>();
        this.warps.add(new WarpItem("Spawn", MessageSendWarpList.command(player, "spawn", "ftb spawn"), 1));
        this.warps.add(new WarpItem("Back", MessageSendWarpList.command(player, "back", "ftb back"), 0));
        FTBUUniverseData universeData = FTBUUniverseData.get();
        if (universeData != null) {
            String cmd = MessageSendWarpList.command(player, "warp", "ftb warp") + " ";
            for (String s : universeData.listWarps()) {
                this.warps.add(new WarpItem(s, cmd + s, 2));
            }
        }
        if ((playerData = FTBUPlayerData.get(FTBLibIntegration.API.getUniverse().getPlayer((Object)player))) != null) {
            String cmd = MessageSendWarpList.command(player, "home", "ftb home") + " ";
            for (String s : playerData.listHomes()) {
                this.warps.add(new WarpItem(s, cmd + s, 3));
            }
        }
    }

    public NetworkWrapper getWrapper() {
        return FTBUNetHandler.NET;
    }

    public void fromBytes(ByteBuf io) {
        int s = io.readUnsignedShort();
        this.warps = new ArrayList<WarpItem>(s);
        while (--s >= 0) {
            String n = ByteBufUtils.readUTF8String((ByteBuf)io);
            String c = ByteBufUtils.readUTF8String((ByteBuf)io);
            this.warps.add(new WarpItem(n, c, io.readByte()));
        }
    }

    public void toBytes(ByteBuf io) {
        io.writeShort(this.warps.size());
        for (WarpItem w : this.warps) {
            ByteBufUtils.writeUTF8String((ByteBuf)io, (String)w.name);
            ByteBufUtils.writeUTF8String((ByteBuf)io, (String)w.cmd);
            io.writeByte((int)w.type);
        }
    }

    public void onMessage(MessageSendWarpList m, EntityPlayer player) {
        if (GuiWarps.INSTANCE != null) {
            GuiWarps.INSTANCE.setData(m.warps);
        }
    }

    public static class WarpItem
    implements Comparable<WarpItem> {
        public static final byte TYPE_SPECIAL_IN = 0;
        public static final byte TYPE_SPECIAL_OUT = 1;
        public static final byte TYPE_WARP = 2;
        public static final byte TYPE_HOME = 3;
        public static final WarpItem CANCEL = new WarpItem("Cancel", "", 0);
        public final String name;
        public final String cmd;
        public final byte type;

        private WarpItem(String n, String c, byte t) {
            this.name = n;
            this.cmd = c;
            this.type = t;
        }

        public boolean isSpecial() {
            return this.type == 0 || this.type == 1;
        }

        public boolean innerCircle() {
            return this.type == 0 || this.type == 3;
        }

        @Override
        public int compareTo(WarpItem o) {
            return this.name.compareToIgnoreCase(o.name);
        }
    }
}

