/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.cmd;

import com.feed_the_beast.ftbl.lib.cmd.CmdBase;
import com.feed_the_beast.ftbl.lib.cmd.CmdTreeBase;
import com.feed_the_beast.ftbl.lib.internal.FTBLibLang;
import com.feed_the_beast.ftbl.lib.util.InvUtils;
import com.feed_the_beast.ftbl.lib.util.LMUtils;
import com.feed_the_beast.ftbl.lib.util.NBTUtils;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.feed_the_beast.ftbu.cmd.InvSeeInventory;
import java.io.File;
import java.util.UUID;
import javax.annotation.Nullable;
import mcjty.lib.tools.ItemStackTools;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;

public class CmdInv
extends CmdTreeBase {
    public CmdInv() {
        super("inv");
        this.addSubcommand((ICommand)new CmdView());
        this.addSubcommand((ICommand)new CmdSave());
        this.addSubcommand((ICommand)new CmdLoad());
    }

    public static class CmdList
    extends CmdBase {
        public CmdList() {
            super("list", CmdBase.Level.OP);
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        }
    }

    public static class CmdLoad
    extends CmdBase {
        public CmdLoad() {
            super("load", CmdBase.Level.OP);
        }

        public boolean func_82358_a(String[] args, int i) {
            return i == 0;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            CmdLoad.checkArgs((String[])args, (int)2, (String)"<player> <id>");
            EntityPlayerMP ep = CmdLoad.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
            File file = new File(LMUtils.folderLocal, "ftbu/playerinvs/" + StringUtils.fromUUID((UUID)ep.func_146103_bH().getId()) + "_" + args[1].toLowerCase() + ".dat");
            try {
                NBTTagCompound tag = NBTUtils.readTag((File)file);
                CmdLoad.readItemsFromNBT((IInventory)ep.field_71071_by, tag, "Inventory");
                IInventory baubles = InvUtils.getBaubles((EntityPlayer)ep);
                if (baubles != null) {
                    CmdLoad.readItemsFromNBT(baubles, tag, "Baubles");
                }
            }
            catch (Exception e) {
                if (LMUtils.DEV_ENV) {
                    e.printStackTrace();
                }
                throw FTBLibLang.RAW.commandError(new Object[]{"Failed to load inventory! " + e});
            }
        }

        private static void readItemsFromNBT(@Nullable IInventory inv, NBTTagCompound compound, String s) {
            if (inv == null) {
                return;
            }
            NBTTagList nbttaglist = compound.func_150295_c(s, 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                int j = nbttagcompound.func_74762_e("Slot");
                if (j < 0 || j >= inv.func_70302_i_()) continue;
                inv.func_70299_a(j, ItemStackTools.loadFromNBT((NBTTagCompound)nbttagcompound));
            }
        }
    }

    public static class CmdSave
    extends CmdBase {
        public CmdSave() {
            super("save", CmdBase.Level.OP);
        }

        public boolean func_82358_a(String[] args, int i) {
            return i == 0;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            CmdSave.checkArgs((String[])args, (int)2, (String)"<player> <id>");
            EntityPlayerMP ep = CmdSave.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
            File file = new File(LMUtils.folderLocal, "ftbu/playerinvs/" + StringUtils.fromUUID((UUID)ep.func_146103_bH().getId()) + "_" + args[1].toLowerCase() + ".dat");
            try {
                NBTTagCompound tag = new NBTTagCompound();
                CmdSave.writeItemsToNBT((IInventory)ep.field_71071_by, tag, "Inventory");
                IInventory baubles = InvUtils.getBaubles((EntityPlayer)ep);
                if (baubles != null) {
                    CmdSave.writeItemsToNBT(baubles, tag, "Baubles");
                }
                NBTUtils.writeTag((File)file, (NBTTagCompound)tag);
            }
            catch (Exception e) {
                if (LMUtils.DEV_ENV) {
                    e.printStackTrace();
                }
                throw FTBLibLang.RAW.commandError(new Object[]{"Failed to save inventory! " + e});
            }
        }

        private static void writeItemsToNBT(IInventory inv, NBTTagCompound compound, String s) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack is = inv.func_70301_a(i);
                if (ItemStackTools.isEmpty((ItemStack)is)) continue;
                NBTTagCompound nbttagcompound = is.serializeNBT();
                nbttagcompound.func_74768_a("Slot", i);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound);
            }
            compound.func_74782_a(s, (NBTBase)nbttaglist);
        }
    }

    public static class CmdView
    extends CmdBase {
        public CmdView() {
            super("view", CmdBase.Level.OP);
        }

        public boolean func_82358_a(String[] args, int i) {
            return i == 0;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            CmdView.checkArgs((String[])args, (int)1, (String)"<player>");
            EntityPlayerMP ep0 = CmdView.func_71521_c((ICommandSender)sender);
            EntityPlayerMP ep = CmdView.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
            ep0.func_71007_a((IInventory)new InvSeeInventory(ep));
        }
    }
}

