/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.api_impl;

import com.feed_the_beast.ftbu.FTBU;
import com.feed_the_beast.ftbu.FTBUFinals;
import com.feed_the_beast.ftbu.api.chunks.IClaimedChunk;
import com.feed_the_beast.ftbu.api_impl.ChunkUpgrade;
import com.feed_the_beast.ftbu.api_impl.ClaimedChunkStorage;
import com.feed_the_beast.ftbu.config.FTBUConfigWorld;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;

public enum LoadedChunkStorage implements ForgeChunkManager.LoadingCallback,
ForgeChunkManager.OrderedLoadingCallback
{
    INSTANCE;

    private static final TIntObjectHashMap<ForgeChunkManager.Ticket> TICKET_CONTAINERS;

    public void init() {
        if (!ForgeChunkManager.getConfig().hasCategory("ftbu")) {
            ForgeChunkManager.getConfig().get("ftbu", "maximumTicketCount", 100).setMinValue(0);
            ForgeChunkManager.getConfig().get("ftbu", "maximumChunksPerTicket", 1000000).setMinValue(0);
            ForgeChunkManager.getConfig().save();
        }
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)FTBU.INST, (ForgeChunkManager.LoadingCallback)this);
    }

    public void clear() {
        TICKET_CONTAINERS.clear();
    }

    @Nullable
    private ForgeChunkManager.Ticket request(int dimID, boolean createNew) {
        WorldServer world;
        ForgeChunkManager.Ticket ticket = (ForgeChunkManager.Ticket)TICKET_CONTAINERS.get(dimID);
        if (ticket == null && createNew && (world = DimensionManager.getWorld((int)dimID)) != null) {
            ticket = ForgeChunkManager.requestTicket((Object)FTBU.INST, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            TICKET_CONTAINERS.put(dimID, (Object)ticket);
        }
        return ticket;
    }

    public List<ForgeChunkManager.Ticket> ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world, int maxTicketCount) {
        return Collections.emptyList();
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        int dim = world.field_73011_w.getDimension();
        FTBUFinals.LOGGER.info("Loaded chunks " + dim);
        ForgeChunkManager.Ticket ticket = (ForgeChunkManager.Ticket)TICKET_CONTAINERS.get(dim);
        if (ticket != null && ticket.world != null && ticket.getModId() != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        } else if (ticket != null) {
            FTBUFinals.LOGGER.warn("Damaged ticket found: " + ticket + ", world:" + ticket.world + ", modID:" + ticket.getModId());
        }
        TICKET_CONTAINERS.remove(dim);
        if (tickets.size() == 1) {
            TICKET_CONTAINERS.put(dim, (Object)tickets.get(0));
            this.checkDimension(world.field_73011_w.getDimension());
        } else if (tickets.size() > 1) {
            FTBUFinals.LOGGER.warn("There was an error while loading tickets! Releasing all [" + tickets.size() + "]!");
            new ArrayList<ForgeChunkManager.Ticket>(tickets).forEach(ForgeChunkManager::releaseTicket);
        }
    }

    public void checkAll() {
        for (IClaimedChunk chunk : ClaimedChunkStorage.INSTANCE.getChunks(null)) {
            this.checkChunk(chunk, null);
        }
    }

    public void checkDimension(int dim) {
        ForgeChunkManager.Ticket ticket = this.request(dim, false);
        for (IClaimedChunk chunk : ClaimedChunkStorage.INSTANCE.getChunks(null)) {
            if (chunk.getPos().dim != dim) continue;
            this.checkChunk(chunk, ticket);
        }
    }

    public void checkChunk(IClaimedChunk chunk, @Nullable ForgeChunkManager.Ticket ticket) {
        boolean force = chunk.hasUpgrade(ChunkUpgrade.SHOULD_FORCE);
        if (force != chunk.hasUpgrade(ChunkUpgrade.FORCED)) {
            chunk.setHasUpgrade(ChunkUpgrade.FORCED, force);
            if (ticket == null) {
                ticket = this.request(chunk.getPos().dim, force);
            }
            if (ticket != null) {
                ChunkPos pos = chunk.getPos().getChunkPos();
                if (force) {
                    if (!ticket.getChunkList().contains((Object)pos)) {
                        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)pos);
                        if (FTBUConfigWorld.LOG_CHUNKLOADING.getBoolean()) {
                            FTBUFinals.LOGGER.info("Chunkloader forced " + chunk.getPos() + " by " + chunk.getOwner());
                        }
                    }
                } else if (ticket.getChunkList().contains((Object)pos) && ticket.world != null) {
                    ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)pos);
                    if (FTBUConfigWorld.LOG_CHUNKLOADING.getBoolean()) {
                        FTBUFinals.LOGGER.info("Chunkloader unforced " + chunk.getPos() + " by " + chunk.getOwner());
                    }
                }
            }
        }
    }

    static {
        TICKET_CONTAINERS = new TIntObjectHashMap();
    }
}

