/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mercurius.binding;

import com.google.common.collect.Maps;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.mercurius.Config;
import net.minecraftforge.mercurius.GlobalConfig;
import net.minecraftforge.mercurius.IMinecraftBinding;
import net.minecraftforge.mercurius.ModInfo;
import net.minecraftforge.mercurius.binding.StatsCollectionEvent;
import net.minecraftforge.mercurius.helpers.DataHelper;
import net.minecraftforge.mercurius.utils.Commands;
import net.minecraftforge.mercurius.utils.FieldUtils;

abstract class CommonBinding
implements IMinecraftBinding {
    protected File cfgDir;
    Configuration global = null;
    Configuration local = null;
    protected String sessionIDClient = DataHelper.CreateID();
    protected String sessionIDServer = DataHelper.CreateID();

    protected CommonBinding(File cfgDir) {
        this.cfgDir = cfgDir;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public String getMCVersion() {
        return Loader.instance().getMCVersionString();
    }

    @Override
    public String getModPack() {
        String branding = (String)Loader.instance().getFMLBrandingProperties().get("fmlbranding");
        return branding == null ? "Vanilla" : branding;
    }

    @Override
    public Map<String, Map<String, Object>> gatherModData(Commands cmd) {
        StatsCollectionEvent event = new StatsCollectionEvent(cmd);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.data;
    }

    @Override
    public Map<String, ModInfo> gatherMods() {
        HashMap mods = Maps.newHashMap();
        for (ModContainer mod : Loader.instance().getModList()) {
            ModInfo info = new ModInfo();
            info.version = mod.getVersion();
            info.enabled = Loader.instance().getActiveModList().contains(mod);
            mods.put(mod.getModId(), info);
        }
        return mods;
    }

    public void onConfigChange(ConfigChangedEvent e) {
        if (e.getModID().equals("mercurius")) {
            this.loadConfig();
        }
    }

    @Override
    public void loadConfig() {
        this.global = this.createConfig(new File(this.cfgDir.getParent(), "/local/local_mercurius.cfg"), GlobalConfig.class);
        this.local = this.createConfig(new File(this.cfgDir, "/Mercurius.cfg"), Config.class);
        this.global.save();
        this.local.save();
    }

    private Configuration createConfig(File file, Class<?> cls) {
        Configuration cfg = new Configuration(file);
        cfg.load();
        String category = "general";
        for (Field f : cls.getDeclaredFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !Modifier.isPublic(f.getModifiers())) continue;
            this.createConfig(category, cfg, f.getType(), f, null);
        }
        return cfg;
    }

    private void createConfig(String category, Configuration cfg, Class<?> ftype, Field f, Object instance) {
        Property prop = null;
        String comment = null;
        String langKey = "mercurius." + category + "." + f.getName().toLowerCase(Locale.ENGLISH);
        int min = -1;
        int max = -1;
        if (ftype == Boolean.TYPE) {
            prop = cfg.get(category, f.getName(), FieldUtils.getBoolean(instance, f), comment);
            FieldUtils.set(instance, f, prop.getBoolean());
        } else if (ftype == boolean[].class) {
            prop = cfg.get(category, f.getName(), (boolean[])FieldUtils.getObject(instance, f), comment);
            FieldUtils.set(instance, f, prop.getBooleanList());
        } else if (ftype == Byte.TYPE) {
            prop = cfg.get(category, f.getName(), (int)FieldUtils.getByte(instance, f), comment, -128, 127);
            FieldUtils.set(instance, f, (byte)prop.getInt());
        } else if (ftype == Character.TYPE) {
            prop = cfg.get(category, f.getName(), (int)FieldUtils.getChar(instance, f), comment, 0, 65535);
            FieldUtils.set(instance, f, Character.valueOf((char)prop.getInt()));
        } else if (ftype == Double.TYPE) {
            prop = cfg.get(category, f.getName(), FieldUtils.getDouble(instance, f), comment, Double.MIN_VALUE, Double.MAX_VALUE);
            FieldUtils.set(instance, f, prop.getDouble());
        } else if (ftype == Float.TYPE) {
            prop = cfg.get(category, f.getName(), (double)FieldUtils.getFloat(instance, f), comment, (double)1.4E-45f, 3.4028234663852886E38);
            FieldUtils.set(instance, f, Float.valueOf((float)prop.getDouble()));
        } else if (ftype == Integer.TYPE) {
            prop = cfg.get(category, f.getName(), FieldUtils.getInt(instance, f), comment, Integer.MIN_VALUE, Integer.MAX_VALUE);
            FieldUtils.set(instance, f, prop.getInt());
        } else if (ftype == Long.TYPE) {
            prop = cfg.get(category, f.getName(), (double)FieldUtils.getLong(instance, f), comment, -9.223372036854776E18, 9.223372036854776E18);
            FieldUtils.set(instance, f, prop.getLong());
        } else if (ftype == Short.TYPE) {
            prop = cfg.get(category, f.getName(), (int)FieldUtils.getShort(instance, f), comment, Short.MIN_VALUE, Short.MAX_VALUE);
            FieldUtils.set(instance, f, (short)prop.getInt());
        } else if (ftype == String.class) {
            prop = cfg.get(category, f.getName(), (String)FieldUtils.getObject(instance, f), comment);
            FieldUtils.set(instance, f, prop.getString());
        } else if (ftype == Map.class) {
            String sub = category + "." + f.getName().toLowerCase(Locale.ENGLISH);
            Map m = (Map)FieldUtils.getObject(instance, f);
            ParameterizedType type = (ParameterizedType)f.getGenericType();
            Type mtype = type.getActualTypeArguments()[1];
            cfg.getCategory(sub).setComment(comment);
            for (Map.Entry e : m.entrySet()) {
                if (mtype == Boolean.class) {
                    prop = cfg.get(sub, (String)e.getKey(), ((Boolean)e.getValue()).booleanValue(), null);
                } else if (mtype == boolean[].class) {
                    prop = cfg.get(sub, (String)e.getKey(), (boolean[])e.getValue(), null);
                } else if (mtype == Byte.class) {
                    prop = cfg.get(sub, (String)e.getKey(), (int)((Byte)e.getValue()).byteValue(), null, -128, 127);
                } else if (mtype == Character.class) {
                    prop = cfg.get(sub, (String)e.getKey(), (int)((Character)e.getValue()).charValue(), null, 0, 65535);
                } else if (mtype == Double.class) {
                    prop = cfg.get(sub, (String)e.getKey(), ((Double)e.getValue()).doubleValue(), null, Double.MIN_VALUE, Double.MAX_VALUE);
                } else if (mtype == Float.class) {
                    prop = cfg.get(sub, (String)e.getKey(), (double)((Float)e.getValue()).floatValue(), null, (double)1.4E-45f, 3.4028234663852886E38);
                } else if (mtype == Integer.class) {
                    prop = cfg.get(sub, (String)e.getKey(), ((Integer)e.getValue()).intValue(), null, Integer.MIN_VALUE, Integer.MAX_VALUE);
                } else if (mtype == Long.class) {
                    prop = cfg.get(sub, (String)e.getKey(), (double)((Long)e.getValue()).longValue(), null, -9.223372036854776E18, 9.223372036854776E18);
                } else if (mtype == Short.class) {
                    prop = cfg.get(sub, (String)e.getKey(), (int)((Short)e.getValue()).shortValue(), null, Short.MIN_VALUE, Short.MAX_VALUE);
                } else if (mtype == String.class) {
                    prop = cfg.get(sub, (String)e.getKey(), (String)FieldUtils.getObject(instance, f), null);
                } else {
                    throw new RuntimeException("Unknown type in map! " + f.getDeclaringClass() + "/" + f.getName() + " " + mtype);
                }
                prop.setLanguageKey(langKey + "." + ((String)e.getKey()).toLowerCase(Locale.ENGLISH));
            }
            prop = null;
        } else if (ftype.getSuperclass() == Object.class) {
            String sub = category + "." + f.getName().toLowerCase(Locale.ENGLISH);
            Object sinst = FieldUtils.getObject(instance, f);
            for (Field sf : ftype.getDeclaredFields()) {
                if (!Modifier.isPublic(sf.getModifiers())) continue;
                this.createConfig(sub, cfg, sf.getType(), sf, sinst);
            }
        } else {
            throw new RuntimeException("Unknown type in config! " + f.getDeclaringClass() + "/" + f.getName() + " " + ftype);
        }
        if (prop != null) {
            prop.setLanguageKey(langKey);
            if (min != -1) {
                prop.setMinValue(min);
            }
            if (max != -1) {
                prop.setMaxValue(max);
            }
        }
    }
}

