/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.client.render;

import mob_grinding_utils.MobGrindingUtils;
import mob_grinding_utils.blocks.BlockSaw;
import mob_grinding_utils.models.ModelSawBase;
import mob_grinding_utils.models.ModelSawBlade;
import mob_grinding_utils.tile.TileEntitySaw;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileEntitySawRenderer
extends TileEntitySpecialRenderer<TileEntitySaw> {
    private static final ResourceLocation BASE_TEXTURE = new ResourceLocation("mob_grinding_utils:textures/tiles/saw_base.png");
    private static final ResourceLocation BLADE_TEXTURE = new ResourceLocation("mob_grinding_utils:textures/tiles/saw_blade.png");
    private final ModelSawBase saw_base = new ModelSawBase();
    private final ModelSawBlade saw_blade = new ModelSawBlade();

    public void renderTile(TileEntitySaw tile, double x, double y, double z, float partialTick, int destroyStage) {
        IBlockState state = tile.func_145831_w().func_180495_p(tile.func_174877_v());
        if (state == null || state.func_177230_c() != MobGrindingUtils.SAW) {
            return;
        }
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockSaw.field_176387_N);
        this.func_147499_a(BASE_TEXTURE);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        switch (facing) {
            case UP: {
                GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case DOWN: {
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case NORTH: {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
        GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.0f);
        this.saw_base.render();
        GlStateManager.func_179094_E();
        float ticks = (float)tile.animationTicks + (float)(tile.animationTicks - tile.prevAnimationTicks) * partialTick;
        GlStateManager.func_179114_b((float)ticks, (float)0.0f, (float)1.0f, (float)0.0f);
        this.saw_base.renderAxle();
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.saw_base.renderMace();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)165.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.saw_base.renderMace();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)285.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.saw_base.renderMace();
        GlStateManager.func_179121_F();
        this.func_147499_a(BLADE_TEXTURE);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)-0.16f);
        GlStateManager.func_179114_b((float)8.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.saw_blade.render();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.16f);
        GlStateManager.func_179114_b((float)-8.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.saw_blade.render();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)-0.2f, (float)-0.16f);
        GlStateManager.func_179114_b((float)8.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.saw_blade.render();
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    public void renderTileEntityAt(TileEntitySaw te, double x, double y, double z, float partialTicks, int destroyStage) {
        if (te == null || !te.func_145830_o()) {
            this.renderTileAsItem(x, y, z);
            return;
        }
        this.renderTile(te, x, y, z, partialTicks, destroyStage);
    }

    private void renderTileAsItem(double x, double y, double z) {
        GlStateManager.func_179094_E();
        this.func_147499_a(BASE_TEXTURE);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        this.saw_base.render();
        this.saw_base.renderAxle();
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.saw_base.renderMace();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)165.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.saw_base.renderMace();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)285.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.saw_base.renderMace();
        GlStateManager.func_179121_F();
        this.func_147499_a(BLADE_TEXTURE);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)-0.16f);
        GlStateManager.func_179114_b((float)8.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.saw_blade.render();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.16f);
        GlStateManager.func_179114_b((float)-8.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.saw_blade.render();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)-0.2f, (float)-0.16f);
        GlStateManager.func_179114_b((float)8.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.saw_blade.render();
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }
}

