/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.init;

import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.mods.adhooks.Hook;
import com.endertech.minecraft.mods.adhooks.Launcher;
import com.endertech.minecraft.mods.adhooks.Rope;
import com.endertech.minecraft.mods.adhooks.init.Main;
import java.nio.file.Path;

public enum HookType {
    PUDGE(4.0f, 0.0f, 100, 0.7f, 20, 3.0f, 0.0f, -4259840),
    SPEAR(2.5f, 2.0f, 60, 0.6f, 40, 4.0f, 0.5f, -1090519040),
    WEB(1.0f, 0.0f, 80, 0.8f, 30, 6.0f, 0.95f, -1);

    public final Hook hook;
    public final Rope rope;
    public final Launcher launcher;

    private HookType(float hookStrength, float hookDamage, int durability, float reelingSpeed, int ropeMaxLength, float ropeWidth, float ropeElasticity, int ropeColorARGB) {
        Main mod = Main.instance;
        Path configDir = mod.getConfig().getConfigDir();
        UnitConfig hookConfig = new UnitConfig(configDir, "hooks", this.name());
        this.hook = new Hook(mod, hookConfig, this, hookStrength, hookDamage, hookStrength);
        UnitConfig launcherConfig = new UnitConfig(configDir, "launchers", this.name());
        this.rope = new Rope((ForgeConfig)launcherConfig, ropeMaxLength, ropeWidth, ropeElasticity, ColorARGB.from((int)ropeColorARGB));
        float boostStrength = 1.0f;
        this.launcher = new Launcher(mod, this.name(), launcherConfig, this.hook, durability, reelingSpeed, boostStrength);
        hookConfig.save();
        launcherConfig.save();
    }
}

