/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.epicsiegemod.handlers.entities;

import funwayguy.epicsiegemod.ai.ESM_EntityAIAttackMelee;
import funwayguy.epicsiegemod.capabilities.modified.CapabilityModifiedHandler;
import funwayguy.epicsiegemod.capabilities.modified.IModifiedHandler;
import funwayguy.epicsiegemod.core.ESM_Settings;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAttackRangedBow;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.SkeletonType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SkeletonHandler {
    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        IModifiedHandler handler;
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (!(event.getEntity() instanceof EntitySkeleton) && !(event.getEntity() instanceof EntityTippedArrow)) {
            return;
        }
        if (event.getEntity().hasCapability(CapabilityModifiedHandler.MODIFIED_HANDLER_CAPABILITY, null)) {
            handler = (IModifiedHandler)event.getEntity().getCapability(CapabilityModifiedHandler.MODIFIED_HANDLER_CAPABILITY, null);
            if (handler.isModified()) {
                return;
            }
        } else {
            return;
        }
        handler.setModified(true);
        if (event.getEntity() instanceof EntitySkeleton) {
            EntitySkeleton skeleton = (EntitySkeleton)event.getEntity();
            if (skeleton.func_70681_au().nextInt(100) < ESM_Settings.WitherSkeletonRarity) {
                EntityAIBase remAI = null;
                for (EntityAITasks.EntityAITaskEntry task : skeleton.field_70715_bh.field_75782_a) {
                    if (task.field_75733_a instanceof EntityAIAttackMelee || task.field_75733_a instanceof ESM_EntityAIAttackMelee) {
                        remAI = task.field_75733_a;
                        break;
                    }
                    if (!(task.field_75733_a instanceof EntityAIAttackRangedBow)) continue;
                    remAI = task.field_75733_a;
                    break;
                }
                if (remAI != null) {
                    skeleton.field_70715_bh.func_85156_a(remAI);
                }
                skeleton.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)skeleton, 1.2, false));
                skeleton.func_189768_a(SkeletonType.WITHER);
                skeleton.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151052_q));
                skeleton.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
            }
        } else if (event.getEntity().getClass() == EntityTippedArrow.class) {
            EntityLiving shooter;
            EntityLivingBase target;
            EntityTippedArrow arrow = (EntityTippedArrow)event.getEntity();
            if (arrow.field_70250_c instanceof EntityLiving && !(arrow.field_70250_c instanceof EntityPlayer) && (target = (shooter = (EntityLiving)arrow.field_70250_c).func_70638_az()) != null) {
                SkeletonHandler.replaceArrowAttack(shooter, target, arrow.func_70242_d(), PotionUtils.func_185187_c((NBTTagCompound)arrow.func_189511_e(new NBTTagCompound())));
                arrow.func_70106_y();
                event.setCanceled(true);
                return;
            }
        }
    }

    public static void replaceArrowAttack(EntityLiving shooter, EntityLivingBase targetEntity, double par2, PotionType potions) {
        EntityTippedArrow entityarrow = new EntityTippedArrow(shooter.field_70170_p, (EntityLivingBase)shooter);
        ItemStack itemTip = new ItemStack(Items.field_185167_i);
        PotionUtils.func_185188_a((ItemStack)itemTip, (PotionType)potions);
        entityarrow.func_184555_a(itemTip);
        double targetDist = shooter.func_70011_f(targetEntity.field_70165_t + (targetEntity.field_70165_t - targetEntity.field_70142_S), targetEntity.func_174813_aQ().field_72338_b, targetEntity.field_70161_v + (targetEntity.field_70161_v - targetEntity.field_70136_U));
        float fireSpeed = (float)(1.3E-4 * targetDist * targetDist + 0.02 * targetDist + 1.25);
        double d0 = targetEntity.field_70165_t + (targetEntity.field_70165_t - targetEntity.field_70142_S) * (targetDist / (double)fireSpeed) - shooter.field_70165_t;
        double d1 = targetEntity.func_174813_aQ().field_72338_b + (double)(targetEntity.field_70131_O / 3.0f) - entityarrow.field_70163_u;
        double d2 = targetEntity.field_70161_v + (targetEntity.field_70161_v - targetEntity.field_70136_U) * (targetDist / (double)fireSpeed) - shooter.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        if (d3 >= 1.0E-7) {
            float f4 = (float)d3 * 0.2f;
            entityarrow.func_70186_c(d0, d1 + (double)f4, d2, fireSpeed, (float)ESM_Settings.SkeletonAccuracy);
        }
        int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)shooter.func_184586_b(EnumHand.MAIN_HAND));
        int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)shooter.func_184586_b(EnumHand.MAIN_HAND));
        entityarrow.func_70239_b(par2);
        if (i > 0) {
            entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)i * 0.5 + 0.5);
        }
        if (j > 0) {
            entityarrow.func_70240_a(j);
        }
        if (shooter.func_70027_ad() || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)shooter.func_184586_b(EnumHand.MAIN_HAND)) > 0 || shooter instanceof EntitySkeleton && ((EntitySkeleton)shooter).func_189771_df() == SkeletonType.WITHER) {
            entityarrow.func_70015_d(100);
        }
        shooter.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (shooter.func_70681_au().nextFloat() * 0.4f + 0.8f));
        IModifiedHandler modHandler = (IModifiedHandler)entityarrow.getCapability(CapabilityModifiedHandler.MODIFIED_HANDLER_CAPABILITY, null);
        if (modHandler != null) {
            modHandler.setModified(true);
        }
        shooter.field_70170_p.func_72838_d((Entity)entityarrow);
    }
}

