/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.epicsiegemod.handlers.entities;

import funwayguy.epicsiegemod.capabilities.modified.CapabilityModifiedHandler;
import funwayguy.epicsiegemod.capabilities.modified.IModifiedHandler;
import funwayguy.epicsiegemod.core.DimSettings;
import funwayguy.epicsiegemod.core.ESM;
import funwayguy.epicsiegemod.core.ESM_Settings;
import java.io.File;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GeneralEntityHandler {
    private final ResourceLocation DIM_MODIFIER = new ResourceLocation("epicsiegemod", "general_spawn");
    private UUID attMod1 = UUID.fromString("74dcd479-97f3-4a04-b84a-0ffab0863a4f");
    private UUID attMod2 = UUID.fromString("2e1a9c33-bbd9-4daf-a723-e598e41ddeb9");
    private UUID attMod3 = UUID.fromString("7dd7b301-055b-4bf1-b94a-2a47a6338ca1");
    private UUID attMod4 = UUID.fromString("321eab99-4946-4375-a693-c0dce3706b6d");
    private static float curBossMod = 0.0f;
    private File worldDir = null;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K || event.getEntity().field_70128_L || event.isCanceled()) {
            return;
        }
        if (event.getEntity() instanceof EntityMob && !ESM_Settings.AIExempt.contains(EntityList.func_75621_b((Entity)event.getEntity()))) {
            EntityLivingBase entityLiving = (EntityLivingBase)event.getEntity();
            IModifiedHandler modHandler = (IModifiedHandler)entityLiving.getCapability(CapabilityModifiedHandler.MODIFIED_HANDLER_CAPABILITY, null);
            DimSettings dimSet = ESM_Settings.dimSettings.get(event.getWorld().field_73011_w.getDimension());
            if (modHandler == null) {
                return;
            }
            if (dimSet == null && curBossMod > 0.0f && ESM_Settings.bossModifier != 0.0f) {
                dimSet = new DimSettings(1.0, 1.0, 1.0, 1.0);
            }
            if (dimSet != null && !modHandler.getModificationData(this.DIM_MODIFIER).func_74767_n("hasModifiers")) {
                if (entityLiving.func_110148_a(SharedMonsterAttributes.field_111267_a) != null) {
                    entityLiving.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier(this.attMod1, "ESM_TWEAK_1", dimSet.hpMult + (double)curBossMod, 1));
                    entityLiving.func_70606_j(entityLiving.func_110138_aP());
                }
                if (entityLiving.func_110148_a(SharedMonsterAttributes.field_111263_d) != null) {
                    entityLiving.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(new AttributeModifier(this.attMod2, "ESM_TWEAK_2", dimSet.spdMult + (double)curBossMod, 1));
                }
                if (entityLiving.func_110148_a(SharedMonsterAttributes.field_111264_e) != null) {
                    entityLiving.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(new AttributeModifier(this.attMod3, "ESM_TWEAK_3", dimSet.dmgMult + (double)curBossMod, 1));
                }
                if (entityLiving.func_110148_a(SharedMonsterAttributes.field_111266_c) != null) {
                    entityLiving.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111121_a(new AttributeModifier(this.attMod4, "ESM_TWEAK_4", dimSet.dmgMult + (double)curBossMod, 1));
                }
                modHandler.getModificationData(this.DIM_MODIFIER).func_74757_a("hasModifiers", true);
            }
            if (!modHandler.getModificationData(this.DIM_MODIFIER).func_74767_n("checkMobBomb") && (ESM_Settings.MobBombAll || ESM_Settings.MobBombs.contains(EntityList.func_75621_b((Entity)entityLiving))) && entityLiving.func_184188_bt().size() == 0 && entityLiving.func_184187_bx() == null && entityLiving.field_70170_p.field_72996_f.size() < 512) {
                if (ESM_Settings.MobBombRarity <= 0 || entityLiving.func_70681_au().nextInt(ESM_Settings.MobBombRarity) == 0) {
                    EntityCreeper passenger = new EntityCreeper(entityLiving.field_70170_p);
                    IModifiedHandler passHandler = (IModifiedHandler)passenger.getCapability(CapabilityModifiedHandler.MODIFIED_HANDLER_CAPABILITY, null);
                    if (passHandler != null) {
                        passHandler.getModificationData(this.DIM_MODIFIER).func_74757_a("checkMobBomb", true);
                    }
                    passenger.func_70012_b(entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, entityLiving.field_70177_z, 0.0f);
                    if (passenger instanceof EntityLiving) {
                        passenger.func_180482_a(entityLiving.field_70170_p.func_175649_E(new BlockPos((Entity)entityLiving)), (IEntityLivingData)null);
                    }
                    entityLiving.field_70170_p.func_72838_d((Entity)passenger);
                    passenger.func_184220_m((Entity)entityLiving);
                }
                modHandler.getModificationData(this.DIM_MODIFIER).func_74757_a("checkMobBomb", true);
            } else {
                modHandler.getModificationData(this.DIM_MODIFIER).func_74757_a("checkMobBomb", true);
            }
        }
    }

    @SubscribeEvent
    public void onEntityKilled(LivingDeathEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K || event.getEntity().func_184222_aU()) {
            return;
        }
        curBossMod += ESM_Settings.bossModifier;
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld().field_72995_K || this.worldDir != null) {
            return;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server.func_71278_l()) {
            this.worldDir = ESM.proxy.isClient() ? server.func_71209_f("saves/" + server.func_71270_I()) : server.func_71209_f(server.func_71270_I());
            try {
                NBTTagCompound wmTag = CompressedStreamTools.func_74797_a((File)new File(this.worldDir, "ESM.dat"));
                curBossMod = wmTag != null ? wmTag.func_74760_g("BossModifier") : 0.0f;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (!server.func_71278_l()) {
            curBossMod = 0.0f;
            this.worldDir = null;
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        if (event.getWorld().field_72995_K || this.worldDir == null) {
            return;
        }
        try {
            NBTTagCompound wmTag = new NBTTagCompound();
            wmTag.func_74776_a("BossModifier", curBossMod);
            CompressedStreamTools.func_74795_b((NBTTagCompound)wmTag, (File)new File(this.worldDir, "ESM.dat"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

