/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.epicsiegemod.handlers.entities;

import funwayguy.epicsiegemod.capabilities.modified.CapabilityModifiedHandler;
import funwayguy.epicsiegemod.capabilities.modified.IModifiedHandler;
import funwayguy.epicsiegemod.client.ESMSounds;
import funwayguy.epicsiegemod.core.ESM;
import funwayguy.epicsiegemod.core.ESM_Settings;
import funwayguy.epicsiegemod.handlers.MainHandler;
import java.lang.reflect.Field;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Level;

public class CreeperHandler {
    private static Field f_isFlaming = null;
    private static Field f_explosionSize = null;
    private static Field f_POWERED = null;

    @SubscribeEvent
    public void onSpawn(EntityJoinWorldEvent event) {
        IModifiedHandler handler;
        if (event.getWorld().field_72995_K || !(event.getEntity() instanceof EntityCreeper)) {
            return;
        }
        if (event.getEntity().hasCapability(CapabilityModifiedHandler.MODIFIED_HANDLER_CAPABILITY, null)) {
            handler = (IModifiedHandler)event.getEntity().getCapability(CapabilityModifiedHandler.MODIFIED_HANDLER_CAPABILITY, null);
            if (handler.isModified()) {
                return;
            }
        } else {
            return;
        }
        handler.setModified(true);
        EntityCreeper creeper = (EntityCreeper)event.getEntity();
        if (event.getWorld().field_73012_v.nextInt(100) < ESM_Settings.CreeperPoweredRarity) {
            try {
                creeper.func_184212_Q().func_187227_b((DataParameter)f_POWERED.get(creeper), (Object)true);
            }
            catch (Exception e) {
                ESM.logger.log(Level.ERROR, "Unable to set creeper powered state", (Throwable)e);
            }
        }
    }

    @SubscribeEvent
    public void onExplode(ExplosionEvent.Start event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        EntityLivingBase entity = event.getExplosion().func_94613_c();
        if (entity instanceof EntityCreeper && f_isFlaming != null) {
            if (ESM_Settings.CreeperNapalm) {
                try {
                    f_isFlaming.set(event.getExplosion(), true);
                }
                catch (Exception e) {
                    ESM.logger.log(Level.ERROR, "Failed to set creeper blast to flaming", (Throwable)e);
                }
            }
            if (ESM_Settings.CenaCreeperRarity > 0 && entity.func_95999_t().equalsIgnoreCase("John Cena")) {
                try {
                    f_explosionSize.set(event.getExplosion(), Float.valueOf(f_explosionSize.getFloat(event.getExplosion()) * 3.0f));
                }
                catch (Exception e) {
                    ESM.logger.log(Level.ERROR, "John Cena misfired", (Throwable)e);
                }
                Vec3d vec = event.getExplosion().getPosition();
                event.getWorld().func_184133_a(null, new BlockPos(vec), ESMSounds.sndCenaEnd, SoundCategory.HOSTILE, 1.0f, 1.0f);
            }
        }
    }

    static {
        try {
            f_isFlaming = Explosion.class.getDeclaredField("field_77286_a");
            f_explosionSize = Explosion.class.getDeclaredField("field_77280_f");
            f_POWERED = EntityCreeper.class.getDeclaredField("field_184714_b");
            MainHandler.f_modifiers.set(f_explosionSize, f_explosionSize.getModifiers() & 0xFFFFFFEF);
            f_isFlaming.setAccessible(true);
            f_explosionSize.setAccessible(true);
            f_POWERED.setAccessible(true);
        }
        catch (Exception e1) {
            try {
                f_isFlaming = Explosion.class.getDeclaredField("isFlaming");
                f_explosionSize = Explosion.class.getDeclaredField("explosionSize");
                f_POWERED = EntityCreeper.class.getDeclaredField("POWERED");
                MainHandler.f_modifiers.set(f_explosionSize, f_explosionSize.getModifiers() & 0xFFFFFFEF);
                f_isFlaming.setAccessible(true);
                f_explosionSize.setAccessible(true);
                f_POWERED.setAccessible(true);
            }
            catch (Exception e2) {
                ESM.logger.log(Level.ERROR, "Failed to set Creeper hooks", (Throwable)e2);
            }
        }
    }
}

