/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.epicsiegemod.handlers;

import funwayguy.epicsiegemod.ai.hooks.EntityAITasksProxy;
import funwayguy.epicsiegemod.ai.hooks.EntitySensesProxy;
import funwayguy.epicsiegemod.api.EsmTaskEvent;
import funwayguy.epicsiegemod.api.ITaskAddition;
import funwayguy.epicsiegemod.api.TaskRegistry;
import funwayguy.epicsiegemod.capabilities.combat.CapabilityAttackerHandler;
import funwayguy.epicsiegemod.capabilities.combat.IAttackerHandler;
import funwayguy.epicsiegemod.capabilities.combat.ProviderAttackerHandler;
import funwayguy.epicsiegemod.capabilities.modified.CapabilityModifiedHandler;
import funwayguy.epicsiegemod.capabilities.modified.ProviderModifiedHandler;
import funwayguy.epicsiegemod.core.ESM;
import funwayguy.epicsiegemod.core.ESM_Settings;
import funwayguy.epicsiegemod.handlers.ConfigHandler;
import java.lang.reflect.Field;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Level;

public class MainHandler {
    private static boolean hooksReady = false;
    public static Field f_modifiers;
    private static Field f_tasks;
    private static Field f_targetTasks;
    private static Field f_senses;
    private static Field f_navigator;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SubscribeEvent
    public void onEntityConstruct(EntityJoinWorldEvent event) {
        if (!hooksReady) {
            return;
        }
        if (event.getEntity() instanceof EntityLiving) {
            EntityLiving entityLiving = (EntityLiving)event.getEntity();
            if (!ESM_Settings.AIExempt.contains(EntityList.func_75621_b((Entity)entityLiving))) {
                try {
                    f_tasks.set(entityLiving, (Object)new EntityAITasksProxy(entityLiving, entityLiving.field_70714_bg));
                    f_targetTasks.set(entityLiving, (Object)new EntityAITasksProxy(entityLiving, entityLiving.field_70715_bh));
                    f_senses.set(entityLiving, (Object)new EntitySensesProxy(entityLiving));
                    if (entityLiving.func_70661_as().getClass() != PathNavigateGround.class) {
                        // empty if block
                    }
                }
                catch (Exception e) {
                    ESM.logger.log(Level.ERROR, "Unable to set AI hooks in " + entityLiving.func_70005_c_(), (Throwable)e);
                }
            }
            for (ITaskAddition add : TaskRegistry.INSTANCE.getAllAdditions()) {
                EntityAIBase entry;
                if (!add.isValid(entityLiving) || (entry = add.getAdditionalAI(entityLiving)) == null) continue;
                EsmTaskEvent.Addition taskEvent = new EsmTaskEvent.Addition(entityLiving, add);
                MinecraftForge.EVENT_BUS.post((Event)taskEvent);
                if (taskEvent.getResult() == Event.Result.DENY) continue;
                if (add.isTargetTask()) {
                    entityLiving.field_70715_bh.func_75776_a(add.getTaskPriority(entityLiving), entry);
                    continue;
                }
                entityLiving.field_70714_bg.func_75776_a(add.getTaskPriority(entityLiving), entry);
            }
            IAttributeInstance att = entityLiving.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111265_b);
            if (att != null && att.func_111125_b() < (double)ESM_Settings.Awareness) {
                att.func_111128_a((double)ESM_Settings.Awareness);
            }
        }
    }

    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityLiving) {
            event.addCapability(CapabilityAttackerHandler.ATTACKER_HANDLER_ID, (ICapabilityProvider)new ProviderAttackerHandler());
            event.addCapability(CapabilityModifiedHandler.MODIFIED_HANDLER_ID, (ICapabilityProvider)new ProviderModifiedHandler());
        } else if (((Entity)event.getObject()).getClass() == EntityTippedArrow.class || ((Entity)event.getObject()).getClass() == EntityPotion.class) {
            event.addCapability(CapabilityModifiedHandler.MODIFIED_HANDLER_ID, (ICapabilityProvider)new ProviderModifiedHandler());
        }
    }

    @SubscribeEvent
    public void onTargetSet(LivingSetAttackTargetEvent event) {
        if (event.getTarget() != null && event.getEntityLiving() instanceof EntityLiving && event.getTarget().hasCapability(CapabilityAttackerHandler.ATTACKER_HANDLER_CAPABILITY, null)) {
            IAttackerHandler handler = (IAttackerHandler)event.getTarget().getCapability(CapabilityAttackerHandler.ATTACKER_HANDLER_CAPABILITY, null);
            handler.addAttacker(event.getTarget(), (EntityLiving)event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        if (event.getEntityLiving().field_70173_aa % 20 == 0 && event.getEntityLiving().hasCapability(CapabilityAttackerHandler.ATTACKER_HANDLER_CAPABILITY, null)) {
            IAttackerHandler handler = (IAttackerHandler)event.getEntityLiving().getCapability(CapabilityAttackerHandler.ATTACKER_HANDLER_CAPABILITY, null);
            handler.updateAttackers(event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent event) {
        if (event.getModID().equals("epicsiegemod")) {
            ConfigHandler.config.save();
            ConfigHandler.initConfigs();
        }
    }

    static {
        try {
            f_modifiers = Field.class.getDeclaredField("modifiers");
            f_modifiers.setAccessible(true);
        }
        catch (Exception e) {
            ESM.logger.log(Level.ERROR, "Unable to enable write access to variable modifiers", (Throwable)e);
        }
        try {
            f_tasks = EntityLiving.class.getDeclaredField("field_70714_bg");
            f_targetTasks = EntityLiving.class.getDeclaredField("field_70715_bh");
            f_senses = EntityLiving.class.getDeclaredField("field_70723_bA");
            f_navigator = EntityLiving.class.getDeclaredField("field_70699_by");
            f_modifiers.set(f_tasks, f_tasks.getModifiers() & 0xFFFFFFEF);
            f_modifiers.set(f_targetTasks, f_targetTasks.getModifiers() & 0xFFFFFFEF);
            f_tasks.setAccessible(true);
            f_targetTasks.setAccessible(true);
            f_senses.setAccessible(true);
            f_navigator.setAccessible(true);
            hooksReady = true;
        }
        catch (Exception e1) {
            try {
                f_tasks = EntityLiving.class.getDeclaredField("tasks");
                f_targetTasks = EntityLiving.class.getDeclaredField("targetTasks");
                f_senses = EntityLiving.class.getDeclaredField("senses");
                f_navigator = EntityLiving.class.getDeclaredField("navigator");
                f_modifiers.set(f_tasks, f_tasks.getModifiers() & 0xFFFFFFEF);
                f_modifiers.set(f_targetTasks, f_targetTasks.getModifiers() & 0xFFFFFFEF);
                f_tasks.setAccessible(true);
                f_targetTasks.setAccessible(true);
                f_senses.setAccessible(true);
                f_navigator.setAccessible(true);
                hooksReady = true;
            }
            catch (Exception e2) {
                ESM.logger.log(Level.ERROR, "Unable to enable write access to AI. Hooks disabled!", (Throwable)e2);
            }
        }
    }
}

