/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.epicsiegemod.ai.hooks;

import com.google.common.collect.Sets;
import funwayguy.epicsiegemod.core.ESM;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.BlockFluidBase;
import org.apache.logging.log4j.Level;

public class WalkNodeProcessorProxy
extends WalkNodeProcessor {
    private float avoidsWater;
    private static Method m_getFlow;

    public void func_186315_a(IBlockAccess sourceIn, EntityLiving mob) {
        super.func_186315_a(sourceIn, mob);
        this.avoidsWater = mob.func_184643_a(PathNodeType.WATER);
    }

    public void func_176163_a() {
        this.field_186326_b.func_184644_a(PathNodeType.WATER, this.avoidsWater);
        super.func_176163_a();
    }

    public PathPoint func_186318_b() {
        int i;
        if (this.func_186322_e() && this.field_186326_b.func_70090_H()) {
            i = (int)this.field_186326_b.func_174813_aQ().field_72338_b;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(MathHelper.func_76128_c((double)this.field_186326_b.field_70165_t), i, MathHelper.func_76128_c((double)this.field_186326_b.field_70161_v));
            Block block = this.field_176169_a.func_180495_p((BlockPos)blockpos$mutableblockpos).func_177230_c();
            while (block == Blocks.field_150358_i || block == Blocks.field_150355_j) {
                blockpos$mutableblockpos.func_181079_c(MathHelper.func_76128_c((double)this.field_186326_b.field_70165_t), ++i, MathHelper.func_76128_c((double)this.field_186326_b.field_70161_v));
                block = this.field_176169_a.func_180495_p((BlockPos)blockpos$mutableblockpos).func_177230_c();
            }
        } else if (this.field_186326_b.field_70122_E) {
            i = MathHelper.func_76128_c((double)(this.field_186326_b.func_174813_aQ().field_72338_b + 0.5));
        } else {
            BlockPos blockpos = new BlockPos((Entity)this.field_186326_b);
            while ((this.field_176169_a.func_180495_p(blockpos).func_185904_a() == Material.field_151579_a || this.field_176169_a.func_180495_p(blockpos).func_177230_c().func_176205_b(this.field_176169_a, blockpos)) && blockpos.func_177956_o() > 0) {
                blockpos = blockpos.func_177977_b();
            }
            i = blockpos.func_177984_a().func_177956_o();
        }
        BlockPos blockpos2 = new BlockPos((Entity)this.field_186326_b);
        PathNodeType pathnodetype1 = this.getPathNodeType(this.field_186326_b, blockpos2.func_177958_n(), i, blockpos2.func_177952_p());
        if (this.field_186326_b.func_184643_a(pathnodetype1) < 0.0f) {
            HashSet set = Sets.newHashSet();
            set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72340_a, (double)i, this.field_186326_b.func_174813_aQ().field_72339_c));
            set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72340_a, (double)i, this.field_186326_b.func_174813_aQ().field_72334_f));
            set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72336_d, (double)i, this.field_186326_b.func_174813_aQ().field_72339_c));
            set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72336_d, (double)i, this.field_186326_b.func_174813_aQ().field_72334_f));
            for (BlockPos blockpos1 : set) {
                PathNodeType pathnodetype = this.getPathNodeType(this.field_186326_b, blockpos1);
                if (!(this.field_186326_b.func_184643_a(pathnodetype) >= 0.0f)) continue;
                return this.func_176159_a(blockpos1.func_177958_n(), blockpos1.func_177956_o(), blockpos1.func_177952_p());
            }
        }
        return this.func_176159_a(blockpos2.func_177958_n(), i, blockpos2.func_177952_p());
    }

    public PathPoint func_186325_a(double x, double y, double z) {
        return this.func_176159_a(MathHelper.func_76128_c((double)(x - (double)(this.field_186326_b.field_70130_N / 2.0f))), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)(z - (double)(this.field_186326_b.field_70130_N / 2.0f))));
    }

    public int func_186320_a(PathPoint[] pathOptions, PathPoint currentPoint, PathPoint targetPoint, float maxDistance) {
        PathPoint pathpoint7;
        PathPoint pathpoint6;
        PathPoint pathpoint5;
        PathPoint pathpoint4;
        boolean flag3;
        int i = 0;
        int j = 0;
        PathNodeType pathnodetype = this.getPathNodeType(this.field_186326_b, currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c);
        if (this.field_186326_b.func_184643_a(pathnodetype) >= 0.0f) {
            j = MathHelper.func_76141_d((float)Math.max(1.0f, this.field_186326_b.field_70138_W));
        }
        BlockPos blockpos = new BlockPos(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c).func_177977_b();
        double d0 = (double)currentPoint.field_75837_b - (1.0 - this.field_176169_a.func_180495_p((BlockPos)blockpos).func_185900_c((IBlockAccess)this.field_176169_a, (BlockPos)blockpos).field_72337_e);
        PathPoint pathpoint = this.getSafePoint(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, j, d0, EnumFacing.SOUTH);
        PathPoint pathpoint1 = this.getSafePoint(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c, j, d0, EnumFacing.WEST);
        PathPoint pathpoint2 = this.getSafePoint(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c, j, d0, EnumFacing.EAST);
        PathPoint pathpoint3 = this.getSafePoint(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, j, d0, EnumFacing.NORTH);
        if (pathpoint != null && !pathpoint.field_75842_i && pathpoint.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint;
        }
        if (pathpoint1 != null && !pathpoint1.field_75842_i && pathpoint1.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint1;
        }
        if (pathpoint2 != null && !pathpoint2.field_75842_i && pathpoint2.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint2;
        }
        if (pathpoint3 != null && !pathpoint3.field_75842_i && pathpoint3.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint3;
        }
        boolean flag = pathpoint3 == null || pathpoint3.field_186287_m == PathNodeType.OPEN || pathpoint3.field_186286_l != 0.0f;
        boolean flag1 = pathpoint == null || pathpoint.field_186287_m == PathNodeType.OPEN || pathpoint.field_186286_l != 0.0f;
        boolean flag2 = pathpoint2 == null || pathpoint2.field_186287_m == PathNodeType.OPEN || pathpoint2.field_186286_l != 0.0f;
        boolean bl = flag3 = pathpoint1 == null || pathpoint1.field_186287_m == PathNodeType.OPEN || pathpoint1.field_186286_l != 0.0f;
        if (flag && flag3 && (pathpoint4 = this.getSafePoint(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, j, d0, EnumFacing.NORTH)) != null && !pathpoint4.field_75842_i && pathpoint4.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint4;
        }
        if (flag && flag2 && (pathpoint5 = this.getSafePoint(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, j, d0, EnumFacing.NORTH)) != null && !pathpoint5.field_75842_i && pathpoint5.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint5;
        }
        if (flag1 && flag3 && (pathpoint6 = this.getSafePoint(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, j, d0, EnumFacing.SOUTH)) != null && !pathpoint6.field_75842_i && pathpoint6.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint6;
        }
        if (flag1 && flag2 && (pathpoint7 = this.getSafePoint(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, j, d0, EnumFacing.SOUTH)) != null && !pathpoint7.field_75842_i && pathpoint7.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint7;
        }
        return i;
    }

    @Nullable
    private PathPoint getSafePoint(int x, int y, int z, int p_186332_4_, double p_186332_5_, EnumFacing facing) {
        PathPoint pathpoint = null;
        BlockPos blockpos = new BlockPos(x, y, z);
        BlockPos blockpos1 = blockpos.func_177977_b();
        IBlockState blockstate = this.field_176169_a.func_180495_p(blockpos);
        IBlockState blockstate1 = this.field_176169_a.func_180495_p(blockpos1);
        double d0 = (double)y - (1.0 - blockstate1.func_185900_c((IBlockAccess)this.field_176169_a, (BlockPos)blockpos1).field_72337_e);
        if (this.field_186326_b != null) {
            AxisAlignedBB bBounds = blockstate1.func_185890_d(this.field_186326_b.field_70170_p, blockpos);
            AxisAlignedBB bBounds1 = blockstate1.func_185890_d(this.field_186326_b.field_70170_p, blockpos1);
            if ((bBounds1 == null || bBounds1.field_72336_d - bBounds1.field_72340_a < 0.5 || bBounds1.field_72334_f - bBounds1.field_72339_c < 0.5) && (bBounds == null || bBounds.field_72336_d - bBounds1.field_72340_a < 0.5 || bBounds.field_72334_f - bBounds.field_72339_c < 0.5)) {
                return null;
            }
        }
        if (d0 - p_186332_5_ > 1.125) {
            return null;
        }
        PathNodeType pathnodetype = this.getPathNodeType(this.field_186326_b, x, y, z);
        if (pathnodetype == PathNodeType.BLOCKED && WalkNodeProcessorProxy.CanFit((Entity)this.field_186326_b, blockstate, blockpos)) {
            pathnodetype = PathNodeType.WALKABLE;
        } else if (blockstate instanceof BlockFluidBase && BlockFluidBase.getFlowDirection((IBlockAccess)this.field_176169_a, (BlockPos)blockpos) >= 0.0) {
            pathnodetype = PathNodeType.BLOCKED;
        } else if (blockstate.func_177230_c() instanceof BlockLiquid && m_getFlow != null) {
            try {
                Vec3d vec = (Vec3d)m_getFlow.invoke((Object)blockstate.func_177230_c(), this.field_176169_a, blockpos, blockstate);
                if (vec.field_72450_a != 0.0 || vec.field_72448_b != 0.0 || vec.field_72449_c != 0.0) {
                    pathnodetype = PathNodeType.BLOCKED;
                }
            }
            catch (Exception e) {
                ESM.logger.log(Level.ERROR, "Unable to pull liquid flow direction");
            }
        }
        float f = this.field_186326_b.func_184643_a(pathnodetype);
        double d1 = (double)this.field_186326_b.field_70130_N / 2.0;
        if (f >= 0.0f) {
            pathpoint = this.func_176159_a(x, y, z);
            pathpoint.field_186287_m = pathnodetype;
            pathpoint.field_186286_l = Math.max(pathpoint.field_186286_l, f);
        }
        if (pathnodetype == PathNodeType.WALKABLE) {
            return pathpoint;
        }
        if (pathpoint == null && p_186332_4_ > 0 && pathnodetype != PathNodeType.FENCE && pathnodetype != PathNodeType.TRAPDOOR && (pathpoint = this.getSafePoint(x, y + 1, z, p_186332_4_ - 1, p_186332_5_, facing)) != null && (pathpoint.field_186287_m == PathNodeType.OPEN || pathpoint.field_186287_m == PathNodeType.WALKABLE) && this.field_186326_b.field_70130_N < 1.0f) {
            double d2 = (double)(x - facing.func_82601_c()) + 0.5;
            double d3 = (double)(z - facing.func_82599_e()) + 0.5;
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(d2 - d1, (double)y + 0.001, d3 - d1, d2 + d1, (double)((float)y + this.field_186326_b.field_70131_O), d3 + d1);
            AxisAlignedBB axisalignedbb1 = blockstate.func_185900_c(this.field_176169_a, blockpos);
            AxisAlignedBB axisalignedbb2 = axisalignedbb.func_72321_a(0.0, axisalignedbb1.field_72337_e - 0.002, 0.0);
            if (this.field_186326_b.field_70170_p.func_184143_b(axisalignedbb2)) {
                pathpoint = null;
            }
        }
        if (pathnodetype == PathNodeType.OPEN) {
            PathNodeType pathnodetype1;
            AxisAlignedBB axisalignedbb3 = new AxisAlignedBB((double)x - d1 + 0.5, (double)y + 0.001, (double)z - d1 + 0.5, (double)x + d1 + 0.5, (double)((float)y + this.field_186326_b.field_70131_O), (double)z + d1 + 0.5);
            if (this.field_186326_b.field_70170_p.func_184143_b(axisalignedbb3)) {
                return null;
            }
            if (this.field_186326_b.field_70130_N >= 1.0f && (pathnodetype1 = this.getPathNodeType(this.field_186326_b, x, y - 1, z)) == PathNodeType.BLOCKED) {
                pathpoint = this.func_176159_a(x, y, z);
                pathpoint.field_186287_m = PathNodeType.WALKABLE;
                pathpoint.field_186286_l = Math.max(pathpoint.field_186286_l, f);
                return pathpoint;
            }
            int i = 0;
            while (y > 0 && pathnodetype == PathNodeType.OPEN) {
                --y;
                if (i++ >= this.field_186326_b.func_82143_as()) {
                    return null;
                }
                pathnodetype = this.getPathNodeType(this.field_186326_b, x, y, z);
                f = this.field_186326_b.func_184643_a(pathnodetype);
                if (pathnodetype != PathNodeType.OPEN && f >= 0.0f) {
                    pathpoint = this.func_176159_a(x, y, z);
                    pathpoint.field_186287_m = pathnodetype;
                    pathpoint.field_186286_l = Math.max(pathpoint.field_186286_l, f);
                    break;
                }
                if (!(f < 0.0f)) continue;
                return null;
            }
        }
        return pathpoint;
    }

    public static boolean CanFit(Entity entity, IBlockState state, BlockPos pos) {
        if (state == null || entity != null && state.func_185900_c((IBlockAccess)entity.field_70170_p, pos) == null) {
            return true;
        }
        if (entity == null || entity.func_174813_aQ() == null) {
            return false;
        }
        AxisAlignedBB eBounds = entity.func_174813_aQ();
        AxisAlignedBB bBounds = state.func_185900_c((IBlockAccess)entity.field_70170_p, pos);
        double BW = Math.max(bBounds.field_72336_d - bBounds.field_72340_a, bBounds.field_72334_f - bBounds.field_72339_c);
        double BH = bBounds.field_72337_e - bBounds.field_72338_b;
        double EW = Math.max(eBounds.field_72336_d - eBounds.field_72340_a, eBounds.field_72334_f - eBounds.field_72339_c);
        double EH = eBounds.field_72337_e - eBounds.field_72338_b;
        if (BW <= 0.0 || BH <= 0.0) {
            return true;
        }
        if (BW > 0.0 && EW >= 1.0) {
            return false;
        }
        return BW + EW % 1.0 <= 1.0 || BH <= 0.5 || BH + EH % 1.0 <= 1.0;
    }

    public PathNodeType func_186319_a(IBlockAccess blockaccessIn, int x, int y, int z, EntityLiving entitylivingIn, int xSize, int ySize, int zSize, boolean canBreakDoorsIn, boolean canEnterDoorsIn) {
        EnumSet<PathNodeType> enumset = EnumSet.noneOf(PathNodeType.class);
        PathNodeType pathnodetype = PathNodeType.BLOCKED;
        BlockPos blockpos = new BlockPos((Entity)entitylivingIn);
        for (int i = 0; i < xSize; ++i) {
            for (int j = 0; j < ySize; ++j) {
                for (int k = 0; k < zSize; ++k) {
                    int l = i + x;
                    int i1 = j + y;
                    int j1 = k + z;
                    PathNodeType pathnodetype1 = this.func_186330_a(blockaccessIn, l, i1, j1);
                    if (pathnodetype1 == PathNodeType.DOOR_WOOD_CLOSED && canBreakDoorsIn && canEnterDoorsIn) {
                        pathnodetype1 = PathNodeType.WALKABLE;
                    }
                    if (pathnodetype1 == PathNodeType.DOOR_OPEN && !canEnterDoorsIn) {
                        pathnodetype1 = PathNodeType.BLOCKED;
                    }
                    if (pathnodetype1 == PathNodeType.RAIL && !(blockaccessIn.func_180495_p(blockpos).func_177230_c() instanceof BlockRailBase) && !(blockaccessIn.func_180495_p(blockpos.func_177977_b()).func_177230_c() instanceof BlockRailBase)) {
                        pathnodetype1 = PathNodeType.FENCE;
                    }
                    if (i == 0 && j == 0 && k == 0) {
                        pathnodetype = pathnodetype1;
                    }
                    enumset.add(pathnodetype1);
                }
            }
        }
        if (enumset.contains(PathNodeType.FENCE)) {
            return PathNodeType.FENCE;
        }
        PathNodeType pathnodetype2 = PathNodeType.BLOCKED;
        for (PathNodeType pathnodetype3 : enumset) {
            if (entitylivingIn.func_184643_a(pathnodetype3) < 0.0f) {
                return pathnodetype3;
            }
            if (!(entitylivingIn.func_184643_a(pathnodetype3) >= entitylivingIn.func_184643_a(pathnodetype2))) continue;
            pathnodetype2 = pathnodetype3;
        }
        if (pathnodetype == PathNodeType.OPEN && entitylivingIn.func_184643_a(pathnodetype2) == 0.0f) {
            return PathNodeType.OPEN;
        }
        return pathnodetype2;
    }

    private PathNodeType getPathNodeType(EntityLiving entitylivingIn, BlockPos pos) {
        return this.getPathNodeType(entitylivingIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    private PathNodeType getPathNodeType(EntityLiving entitylivingIn, int x, int y, int z) {
        return this.func_186319_a(this.field_176169_a, x, y, z, entitylivingIn, this.field_176168_c, this.field_176165_d, this.field_176166_e, this.func_186324_d(), this.func_186323_c());
    }

    public PathNodeType func_186330_a(IBlockAccess accessIn, int x, int y, int z) {
        PathNodeType pathnodetype = this.getPathNodeTypeRaw(accessIn, x, y, z);
        if (pathnodetype == PathNodeType.OPEN && y >= 1) {
            Block block = accessIn.func_180495_p(new BlockPos(x, y - 1, z)).func_177230_c();
            PathNodeType pathnodetype1 = this.getPathNodeTypeRaw(accessIn, x, y - 1, z);
            PathNodeType pathNodeType = pathnodetype = pathnodetype1 != PathNodeType.WALKABLE && pathnodetype1 != PathNodeType.OPEN && pathnodetype1 != PathNodeType.WATER && pathnodetype1 != PathNodeType.LAVA ? PathNodeType.WALKABLE : PathNodeType.OPEN;
            if (pathnodetype1 == PathNodeType.DAMAGE_FIRE || block == Blocks.field_189877_df) {
                pathnodetype = PathNodeType.DAMAGE_FIRE;
            }
            if (pathnodetype1 == PathNodeType.DAMAGE_CACTUS) {
                pathnodetype = PathNodeType.DAMAGE_CACTUS;
            }
        }
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        if (pathnodetype == PathNodeType.WALKABLE) {
            for (int j = -1; j <= 1; ++j) {
                for (int i = -1; i <= 1; ++i) {
                    if (j == 0 && i == 0) continue;
                    Block block1 = accessIn.func_180495_p((BlockPos)blockpos$pooledmutableblockpos.func_181079_c(j + x, y, i + z)).func_177230_c();
                    if (block1 == Blocks.field_150434_aF) {
                        pathnodetype = PathNodeType.DANGER_CACTUS;
                        continue;
                    }
                    if (block1 != Blocks.field_150480_ab) continue;
                    pathnodetype = PathNodeType.DANGER_FIRE;
                }
            }
        }
        blockpos$pooledmutableblockpos.func_185344_t();
        return pathnodetype;
    }

    private PathNodeType getPathNodeTypeRaw(IBlockAccess p_189553_1_, int p_189553_2_, int p_189553_3_, int p_189553_4_) {
        BlockPos blockpos = new BlockPos(p_189553_2_, p_189553_3_, p_189553_4_);
        IBlockState iblockstate = p_189553_1_.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        Material material = iblockstate.func_185904_a();
        return material == Material.field_151579_a ? PathNodeType.OPEN : (block != Blocks.field_150415_aT && block != Blocks.field_180400_cw && block != Blocks.field_150392_bi ? (block == Blocks.field_150480_ab ? PathNodeType.DAMAGE_FIRE : (block == Blocks.field_150434_aF ? PathNodeType.DAMAGE_CACTUS : (block instanceof BlockDoor && material == Material.field_151575_d && !((Boolean)iblockstate.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue() ? PathNodeType.DOOR_WOOD_CLOSED : (block instanceof BlockDoor && material == Material.field_151573_f && !((Boolean)iblockstate.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue() ? PathNodeType.DOOR_IRON_CLOSED : (block instanceof BlockDoor && ((Boolean)iblockstate.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue() ? PathNodeType.DOOR_OPEN : (block instanceof BlockRailBase ? PathNodeType.RAIL : (!(block instanceof BlockFence || block instanceof BlockWall || block instanceof BlockFenceGate && !((Boolean)iblockstate.func_177229_b((IProperty)BlockFenceGate.field_176466_a)).booleanValue()) ? (material == Material.field_151586_h ? PathNodeType.WATER : (material == Material.field_151587_i ? PathNodeType.LAVA : (block.func_176205_b(p_189553_1_, blockpos) ? PathNodeType.OPEN : PathNodeType.BLOCKED))) : PathNodeType.FENCE))))))) : PathNodeType.TRAPDOOR);
    }

    static {
        try {
            m_getFlow = BlockLiquid.class.getDeclaredMethod("func_189543_a", IBlockAccess.class, BlockPos.class, IBlockState.class);
            m_getFlow.setAccessible(true);
        }
        catch (Exception e1) {
            try {
                m_getFlow = BlockLiquid.class.getDeclaredMethod("getFlow", IBlockAccess.class, BlockPos.class, IBlockState.class);
                m_getFlow.setAccessible(true);
            }
            catch (Exception e2) {
                ESM.logger.log(Level.ERROR, "Unable to hook into fluid flow direction", (Throwable)e2);
            }
        }
    }
}

