/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.literalascension.common.item;

import com.jamieswhiteshirt.literalascension.common.block.BlockClimbingRope;
import com.jamieswhiteshirt.literalascension.features.ClimbingRope;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JP\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0016J.\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lcom/jamieswhiteshirt/literalascension/common/item/ItemClimbingRope;", "Lnet/minecraft/item/Item;", "feature", "Lcom/jamieswhiteshirt/literalascension/features/ClimbingRope;", "(Lcom/jamieswhiteshirt/literalascension/features/ClimbingRope;)V", "getFeature", "()Lcom/jamieswhiteshirt/literalascension/features/ClimbingRope;", "onItemUse", "Lnet/minecraft/util/EnumActionResult;", "stack", "Lnet/minecraft/item/ItemStack;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "hand", "Lnet/minecraft/util/EnumHand;", "facing", "Lnet/minecraft/util/EnumFacing;", "hitX", "", "hitY", "hitZ", "tryPlaceBlock", "fromPos", "literal-ascension_main"})
public final class ItemClimbingRope
extends Item {
    @NotNull
    private final ClimbingRope feature;

    @NotNull
    public EnumActionResult func_180614_a(@NotNull ItemStack stack, @NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos, @NotNull EnumHand hand, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        Intrinsics.checkParameterIsNotNull((Object)facing, (String)"facing");
        if (stack.field_77994_a > 0) {
            IBlockState state = world.func_180495_p(pos);
            if (Intrinsics.areEqual((Object)state.func_177230_c(), (Object)this.feature.getBlock())) {
                EnumFacing enumFacing = (EnumFacing)state.func_177229_b((IProperty)BlockClimbingRope.Companion.getFACING());
                Intrinsics.checkExpressionValueIsNotNull((Object)enumFacing, (String)"state.getValue(BlockClimbingRope.FACING)");
                return this.tryPlaceBlock(stack, player, world, pos, enumFacing);
            }
            if (Intrinsics.areEqual((Object)facing, (Object)EnumFacing.UP) ^ true) {
                BlockPos blockPos = pos.func_177972_a(facing);
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos.offset(facing)");
                EnumFacing enumFacing = facing.func_176734_d();
                Intrinsics.checkExpressionValueIsNotNull((Object)enumFacing, (String)"facing.opposite");
                return this.tryPlaceBlock(stack, player, world, blockPos, enumFacing);
            }
        }
        return EnumActionResult.FAIL;
    }

    @NotNull
    public final EnumActionResult tryPlaceBlock(@NotNull ItemStack stack, @NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos fromPos, @NotNull EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)fromPos, (String)"fromPos");
        Intrinsics.checkParameterIsNotNull((Object)facing, (String)"facing");
        BlockPos.MutableBlockPos placePos = new BlockPos.MutableBlockPos(fromPos);
        while (this.feature.isMatchingBlock(world, (BlockPos)placePos, facing)) {
            BlockPos.MutableBlockPos mutableBlockPos = placePos;
            int n = mutableBlockPos.func_177956_o();
            mutableBlockPos.func_185336_p(n + -1);
        }
        if (this.feature.getBlock().func_176196_c(world, (BlockPos)placePos)) {
            IBlockState placeState = this.feature.getBlock().func_176223_P().func_177226_a((IProperty)BlockClimbingRope.Companion.getFACING(), (Comparable)facing);
            if (player.func_175151_a((BlockPos)placePos, facing, stack)) {
                BlockClimbingRope blockClimbingRope = this.feature.getBlock();
                IBlockState iBlockState = placeState;
                Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"placeState");
                if (blockClimbingRope.isAttached(iBlockState, world, (BlockPos)placePos) && world.func_175656_a((BlockPos)placePos, placeState)) {
                    SoundType soundType = this.feature.getBlock().getSoundType(placeState, world, (BlockPos)placePos, (Entity)player);
                    world.func_184133_a(player, fromPos, soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
                    ItemStack itemStack = stack;
                    itemStack.field_77994_a += -1;
                    int cfr_ignored_0 = itemStack.field_77994_a;
                    return EnumActionResult.SUCCESS;
                }
            }
        }
        return EnumActionResult.FAIL;
    }

    @NotNull
    public final ClimbingRope getFeature() {
        return this.feature;
    }

    public ItemClimbingRope(@NotNull ClimbingRope feature) {
        Intrinsics.checkParameterIsNotNull((Object)feature, (String)"feature");
        this.feature = feature;
    }
}

