/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import java.io.File;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.text.WordUtils;
import wanion.lib.module.AbstractModule;
import wanion.unidict.common.Reference;
import wanion.unidict.integration.AE2Integration;
import wanion.unidict.integration.AbstractIntegrationThread;
import wanion.unidict.integration.AbyssalCraftIntegration;
import wanion.unidict.integration.AdvancedRocketryIntegration;
import wanion.unidict.integration.AdvancedSolarPanelsIntegration;
import wanion.unidict.integration.BaseMetalsIntegration;
import wanion.unidict.integration.BloodMagicIntegration;
import wanion.unidict.integration.ChickensIntegration;
import wanion.unidict.integration.CraftingIntegration;
import wanion.unidict.integration.EmbersIntegration;
import wanion.unidict.integration.EnderIOIntegration;
import wanion.unidict.integration.ForestryIntegration;
import wanion.unidict.integration.FoundryIntegration;
import wanion.unidict.integration.FurnaceIntegration;
import wanion.unidict.integration.IC2Integration;
import wanion.unidict.integration.IEIntegration;
import wanion.unidict.integration.MekanismIntegration;
import wanion.unidict.integration.ModularMachinesIntegration;
import wanion.unidict.integration.RailcraftIntegration;
import wanion.unidict.integration.RefinedStorageIntegration;
import wanion.unidict.integration.TEIntegration;
import wanion.unidict.integration.TechRebornIntegration;
import wanion.unidict.integration.WaterPowerIntegration;

public final class IntegrationModule
extends AbstractModule {
    public IntegrationModule() {
        super("Integration", Class::newInstance);
    }

    protected void init() {
        Configuration config = new Configuration(new File("." + Reference.SLASH + "config" + Reference.SLASH + "unidict" + Reference.SLASH + "IntegrationModule.cfg"));
        for (Integration integration : Integration.values()) {
            if (!config.get("Integrations", WordUtils.capitalizeFully((String)integration.name().replace("_", " ")).replace(" ", ""), integration.enabledByDefault).getBoolean() || integration.modId != null && !Loader.isModLoaded((String)integration.modId) || !integration.canEnable()) continue;
            this.manager.add(integration.integrationClass);
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static enum Integration {
        CRAFTING(CraftingIntegration.class),
        FURNACE(FurnaceIntegration.class),
        ABYSSAL_CRAFT("abyssalcraft", AbyssalCraftIntegration.class),
        ADVANCED_ROCKETRY("advancedRocketry", AdvancedRocketryIntegration.class),
        ADVANCED_SOLAR_PANELS("advanced_solar_panels", AdvancedSolarPanelsIntegration.class, false),
        APPLIED_ENERGISTICS_2("appliedenergistics2", AE2Integration.class),
        BASE_METALS("basemetals", BaseMetalsIntegration.class),
        BLOOD_MAGIC("BloodMagic", BloodMagicIntegration.class),
        CHICKENS("chickens", ChickensIntegration.class),
        EMBERS("embers", EmbersIntegration.class),
        ENDER_IO("EnderIO", EnderIOIntegration.class),
        FORESTRY("forestry", ForestryIntegration.class),
        FOUNDRY("foundry", FoundryIntegration.class),
        INDUSTRIAL_CRAFT_2("IC2", IC2Integration.class, p -> !Loader.isModLoaded((String)"IC2-Classic-Spmod")),
        IMMERSIVE_ENGINEERING("immersiveengineering", IEIntegration.class),
        MEKANISM("Mekanism", MekanismIntegration.class),
        MODULAR_MACHINES("modularmachines", ModularMachinesIntegration.class),
        RAIL_CRAFT("Railcraft", RailcraftIntegration.class),
        REFINED_STORAGE("refinedstorage", RefinedStorageIntegration.class, false),
        TECH_REBORN("techreborn", TechRebornIntegration.class),
        THERMAL_EXPANSION("thermalexpansion", TEIntegration.class),
        WATER_POWER("waterpower", WaterPowerIntegration.class, false);

        private final String modId;
        private final Class<? extends AbstractIntegrationThread> integrationClass;
        private final boolean enabledByDefault;
        private final Predicate<Integration> integrationPredicate;

        private Integration(Class<? extends AbstractIntegrationThread> integrationClass) {
            this(null, integrationClass);
        }

        private Integration(String modId, Class<? extends AbstractIntegrationThread> integrationClass) {
            this(modId, integrationClass, true);
        }

        private Integration(@Nonnull String modId, Class<? extends AbstractIntegrationThread> integrationClass, Predicate<Integration> integrationPredicate) {
            this(modId, integrationClass, true, integrationPredicate);
        }

        private Integration(String modId, Class<? extends AbstractIntegrationThread> integrationClass, boolean enabledByDefault) {
            this(modId, integrationClass, enabledByDefault, p -> true);
        }

        private Integration(String modId, @Nonnull Class<? extends AbstractIntegrationThread> integrationClass, boolean enabledByDefault, Predicate<Integration> integrationPredicate) {
            this.modId = modId;
            this.integrationClass = integrationClass;
            this.enabledByDefault = enabledByDefault;
            this.integrationPredicate = integrationPredicate;
        }

        private boolean canEnable() {
            return this.integrationPredicate.test(this);
        }
    }
}

